<?
/**
 * @package PF
 * @author Akash Heimlich
 * @description This sets PF based on voltage
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function PF_install($val) {
        PF_enable();
        return 1;
    }
     
    function PF_uninstall() {
        setPackageStatus("PF",0);
        return 1;
    }
    
    function PF_enable() {
        setPackageStatus("PF",2);
        //addWidget("/package/PF.inc","PF",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function PF_disable() {
        setPackageStatus("PF",3);
        //addWidget("/package/PF.inc","PF",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function PF_init() {
        
        // load the test Value into the globals
        $_GLOBALS['pf_v_role']=ini_get("/config/PF.ini","config","v_role",0);
        $_GLOBALS['pf_v_nominal']=ini_get("/config/PF.ini","config","nominal_voltage",0);
    
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/PF.cgi?action=configure';
        $arr['title']='PF Control';
        $arr['icon']='icon-hdd';
        $arr['desc']='Dynamic PF Adjustment';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/PFAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/PFAjax.inc';

        // runs this file once a second
        if (file_exists('/package/PFSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/PFSec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/PFMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/PFMin.inc';
            
        // runs this file once a day
        if (file_exists('/package/PFDay.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/PFDay.inc';            
        return 1;
    }
    
    function PF_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="PFCtrl"; 
        $title='Configure Package PF';
        $config_file="/config/PF.ini";
        $config_section="config";

    
        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> 
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/">Home</a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi">Settings</a></li>
    <li class="breadcrumb-item active" aria-current="page">PF Control</li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-group"></i> Settings</h2>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> CLOSE</a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> APPLY</a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <h4>Test Widget<br>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<!-- VARIABLES -->
<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print(lang('NEED_REBOOT')); ?>';"></div>

<!-- LOAD YOUR CONFIG VALUES HERE -->
<div ng-init="v_role=<? print(ini_get($config_file,$config_section,"v_role",0)); ?>;">
<div ng-init="nominal_voltage=<? print(ini_get($config_file,$config_section,"nominal_voltage",0)); ?>;">

<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Settings</h5>
        <p class="card-text">    

          <div class="form-group">
            <label for="test_value">Nominal Voltage</label>
            <input type="text" class="form-control" id="nominal_voltage" ng-model="nominal_voltage" aria-describedby="testValueHelp" placeholder="Enter voltage">
            <small id="testValueHelp" class="form-text text-muted">Enter nominal grid voltage (i.e. 330000)</small>
          </div>
          <div class="form-group">
            <label for="test_radio">Grid Voltage Role</label>
            <select ng-model="v_role" name='test_radio' class="custom-select custom-select-sm">
            <? 
            $roles=ini_get_array("/config/roles.ini");
            //print_r($roles);
            for ($i=0;$i<$roles['roles']['num_roles'];$i++) { 
                print('<option value="'.$i.'">'.$roles['roles']['role'.$i].'</option>\r\n');
            }
            ?>
            </select>
            <small id="langH" class="form-text text-muted">Select an voltage role</small>
          </div>
        </p>
    </div>
</div>
<br/>

</form>
     <script>
     var app = angular.module('myApp', []);
     function PFCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";
    $scope.saveSettings=function() {
       post_data="v_role="+$scope.v_role;
       post_data+="&nominal_voltage="+$scope.nominal_voltage;
       post_config="PF.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
   }
    
  //poll();

</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>





