<?
/**
 * @package Alerts
 * @author Akash Heimlich
 * @description Create alerts based on inverter error codes
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function Alerts_install($val) {
        Alerts_enable();
        return 1;
    }
     
    function Alerts_uninstall() {
        setPackageStatus("Alerts",0);
        return 1;
    }
    
    function Alerts_enable() {
        setPackageStatus("Alerts",2);
        return 1;
    }
    
    function Alerts_disable() {
        setPackageStatus("Alerts",3);
        return 1;
    }
    
    /* this is called at system boot */
    function Alerts_init() {
        $_GLOBALS['alert_interval']=ini_get("/config/Alerts.ini","config","altert_interval",5);
        $_GLOBALS['alert_log_offline']=ini_get("/config/Alerts.ini","config","log_offline",15);

        $arr=array();
        $arr['script']='/package/Alerts.cgi?action=configure';
        $arr['title']='Alerts';
        $arr['icon']='icon-hdd';
        $arr['desc']='Alert Settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        // generate ajax data for front end processing
        if (file_exists('/package/alerts/AlertsAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/alerts/AlertsAjax.inc';

        // runs this file once a second
        if (file_exists('/package/alerts/AlertsSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/alerts/AlertsSec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/alerts/AlertsMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/alerts/AlertsMin.inc';
            
        // runs this file once a day
        if (file_exists('/package/alerts/AlertsDay.inc')) 
            $_GLOBALS['hooks']['day'][]='/package/alerts/AlertsDay.inc';            
            
        return 1;
    }
    
    function Alerts_configure() {
        
      include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="Alerts"; 
        $title='Configure Package Alerts';
        $config_file="alerts.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> 
        
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page">Alerts</li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-group"></i> Alerts</h2>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','user')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <a href="/package/alerts/Alerts_Quick_Start_Guide.pdf">Alerts Quick Start Guide</a>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<!-- VARIABLES -->
<div ng-init="alert_interval=<? print(ini_get("/config/".$config_file,$config_section,"inverval","1")); ?>;">
<div ng-init="log_level='<? print(ini_get("/config/".$config_file,$config_section,"log_level","")); ?>';">
<div ng-init="log_offline=<? print(ini_get("/config/".$config_file,$config_section,"log_offline",60)); ?>;">
<div ng-init="send_export=<? print(ini_get("/config/".$config_file,$config_section,"send_export",0)); ?>;">
<div ng-init="send_email=<? print(ini_get("/config/".$config_file,$config_section,"send_email",0)); ?>;">
<div ng-init="email_address='<? print(ini_get("/config/".$config_file,$config_section,"email_address",'')); ?>';">
<div ng-init="send_sms=<? print(ini_get("/config/".$config_file,$config_section,"send_sms",0)); ?>;">
<div ng-init="sms_number='<? print(ini_get("/config/".$config_file,$config_section,"sms_number","")); ?>';">
<div ng-init="send_mqtt=<? print(ini_get("/config/".$config_file,$config_section,"send_mqtt",0)); ?>;">
<div ng-init="mqtt_channel='<? print(ini_get("/config/".$config_file,$config_section,"mqtt_channel",'')); ?>';">
<div ng-init="mqtt_server=<? print(ini_get("/config/".$config_file,$config_section,"mqtt_server",0)); ?>;">
<div ng-init="mqtt_custom_formatter='<? print(ini_get("/config/".$config_file,$config_section,"mqtt_custom_formatter",'/package/alerts/alert_json.inc')); ?>';">

<div ng-init="alert_grid_fail=<? print(ini_get("/config/".$config_file,$config_section,"alert_grid_fail",0)); ?>;">
<div ng-init="alert_di_on=<? print(ini_get("/config/".$config_file,$config_section,"alert_di_on",0)); ?>;">
<div ng-init="alert_grid_return=<? print(ini_get("/config/".$config_file,$config_section,"alert_grid_return",0)); ?>;">
<div ng-init="alert_dg_on=<? print(ini_get("/config/".$config_file,$config_section,"alert_dg_on",0)); ?>;">
<div ng-init="alert_curtailing_start=<? print(ini_get("/config/".$config_file,$config_section,"alert_curtailing_start",0)); ?>;">
<div ng-init="alert_curtailing_stop=<? print(ini_get("/config/".$config_file,$config_section,"alert_curtailing_stop",0)); ?>;">


<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Notification Settings</h5>
        <p class="card-text">    

            <div class="form-group">
                <label for="send_export"><small class='text-muted'>Send Alerts via Wattmon EMS Cloud</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="send_export" id="enabled15" value="0">
                  <label class="form-check-label" for="enabled15">
                    &nbsp;Disabled
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="send_export" id="enabled16" value="1">
                  <label class="form-check-label" for="enabled16">
                    &nbsp;Enabled
                  </label>
                </div>  
                <small id="dnHelp" class="form-text text-muted">Include alerts while exporting data - processing will be as per the EMS server notification settings</small>
            </div>

          
           <div class="form-group">
                <label for="send_sms"><small class='text-muted'>Send SMS Alerts</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="send_sms" id="enabled3" value="0">
                  <label class="form-check-label" for="enabled3">
                    &nbsp;Disabled
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="send_sms" id="enabled4" value="1">
                  <label class="form-check-label" for="enabled4">
                    &nbsp;Enabled
                  </label>
                </div>  
                <small id="dnHelp" class="form-text text-muted">Send an SMS when an event occurs</small>
            </div>
            <div class="form-group" ng-show='send_sms==1'>
                <label for="sms_number">SMS Phone Number</label>
                <input class="form-control" type='text' ng-model="sms_number"  class='span12' name='sms_number' aria-describedby="bHelp" placeholder="SMS Number">
                <small id="bHelp" class="form-text text-muted">Enter your SMS Number to receive alerts if your device has a SIM integrated</small>
            </div>
          <div class="form-group">
                <label for="send_email"><small class='text-muted'>Send Email Alerts</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="send_email" id="enabled5" value="0">
                  <label class="form-check-label" for="enabled5">
                    &nbsp;Disabled
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="send_email" id="enabled6" value="1">
                  <label class="form-check-label" for="enabled6">
                    &nbsp;Enabled
                  </label>
                </div>  
                <small id="dnHelp" class="form-text text-muted">Send an Email when an event occurs</small>
            </div>
            <div class="form-group" ng-show='send_email==1'>
                <label for="email_address">Email address</label>
                <input class="form-control" type='text' ng-model="email_address"  class='span12' name='email_address' aria-describedby="bHelp" placeholder="Email address">
                <small id="bHelp" class="form-text text-muted">Enter an email address to receive alerts</small>
            </div>
            <div class="form-group">
                <label for="send_mqtt"><small class='text-muted'>Send MQTT Alerts</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="send_mqtt" id="enabled7" value="0">
                  <label class="form-check-label" for="enabled7">
                    &nbsp;Disabled
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="send_mqtt" id="enabled8" value="1">
                  <label class="form-check-label" for="enabled8">
                    &nbsp;Enabled
                  </label>
                </div>  
                <small id="dnHelp" class="form-text text-muted">Send an MQTT when an event occurs</small>
            </div>
          
            <div class="form-group" ng-show='send_mqtt==1'>
                <label for="mqtt_channel">MQTT Channel</label>
                <input class="form-control" type='text' ng-model="mqtt_channel"  class='span12' name='mqtt_channel' aria-describedby="bHelp" placeholder="MQTT channel">
                <small id="bHelp" class="form-text text-muted">Send an alert on an MQTT channel</small>
            </div>
            <div class="form-group" ng-show='send_mqtt==1'>
              <label for="mqtt_server">MQTT Server</label>
              <div class="form-check">
                <input class="form-check-input" type="radio" ng-model="mqtt_server" id="server1" value="0">
                <label class="form-check-label" for="server1">
                  &nbsp;Server 1
                </label>
              </div>
              <div class="form-check">
                <input class="form-check-input" type="radio" ng-model="mqtt_server" id="server2" value="1">
                <label class="form-check-label" for="server2">
                  &nbsp;Server 2
                </label>
              </div>
              <small id="serverHelp" class="form-text text-muted">Select the MQTT server to use</small>
            </div>
            <div class="form-group" ng-show='send_mqtt==1'>
              <label for="mqtt_custom_formatter">MQTT Format Script</label>
              <input class="form-control" type='text' ng-model="mqtt_custom_formatter" class='span12' name='mqtt_custom_formatter' aria-describedby="bHelp" placeholder="MQTT Format Script">
              <small id="bHelp" class="form-text text-muted">Enter a custom script for formatting MQTT messages - leave blank to ignore</small>
            </div>
         <div class="form-group">
            <label for="alert_interval">Min alert interval</label>
            <input type="number" class="form-control" ng_model="alert_interval" id="alert_interval" aria-describedby="userHelp2"  placeholder="Alert notify interval">
            <small id="userHelp2" class="form-text text-muted">Minimum interval between alerts in minutes</small>
         </div>
            
        </p>
    </div>
</div>

<br/>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Event Settings</h5>
        <p class="card-text">    

    
            <div class="mb-3 row"  >
    			<label for="log_offline" class="col-form-label col-sm-2 text-sm-end">Log when inverter offline</label>
    			 <div class="col-sm-10">
    				<input type="number" class="form-control" ng_model="log_offline" id="log_offline" aria-describedby="userHelp2"  placeholder="Offline notify interval">
                <small id="userHelp2" class="form-text text-muted">Log when inverter offline more than x minutes</small>
                </div>
            </div>
            
            <div class="mb-3 row">
              <label for="alert_grid_fail" class="col-form-label col-sm-2 text-sm-end">Alert on Grid Failure</label>
              <div class="col-sm-10">
              <select id="alert_grid_fail" ng-model='alert_grid_fail' required name='alert_grid_fail' class="form-control">
                <option value='0'>Disabled</option>
                <option value='1'>Enabled</option>
              </select>
              <small id="chanHelp" class="form-text text-muted"></small>
              </div>
            </div>
            <div class="mb-3 row">
              <label for="alert_curtailing_start" class="col-form-label col-sm-2 text-sm-end">Alert when curtailing inverter output</label>
              <div class="col-sm-10">
                <select id="alert_curtailing_start" ng-model='alert_curtailing_start' required name='alert_curtailing_start' class="form-control">
                  <option value='0'>Disabled</option>
                  <option value='1'>Enabled</option>
                </select>
                <small id="chanHelp" class="form-text text-muted"></small>
              </div>
            </div>

            <div class="mb-3 row">
              <label for="alert_curtailing_stop" class="col-form-label col-sm-2 text-sm-end">Alert when stopping inverter curtailment</label>
              <div class="col-sm-10">
                <select id="alert_curtailing_stop" ng-model='alert_curtailing_stop' required name='alert_curtailing_stop' class="form-control">
                  <option value='0'>Disabled</option>
                  <option value='1'>Enabled</option>
                </select>
                <small id="chanHelp" class="form-text text-muted"></small>
              </div>
            </div>
            <div class="mb-3 row">
              <label for="alert_grid_return" class="col-form-label col-sm-2 text-sm-end">Alert on Grid Power Returns</label>
              <div class="col-sm-10">
              <select id="alert_grid_return" ng-model='alert_grid_return' required name='alert_grid_return' class="form-control">
                <option value='0'>Disabled</option>
                <option value='1'>Enabled</option>
              </select>
              <small id="chanHelp" class="form-text text-muted"></small>
              </div>
            </div>

            <div class="mb-3 row">
              <label for="alert_dg_on" class="col-form-label col-sm-2 text-sm-end">Alert when Genset Switched On</label>
              <div class="col-sm-10">
              <select id="alert_dg_on" ng-model='alert_dg_on' required name='alert_dg_on' class="form-control">
                <option value='0'>Disabled</option>
                <option value='1'>Enabled</option>
              </select>
              <small id="chanHelp" class="form-text text-muted"></small>
              </div>
            </div>
            <div class="mb-3 row">
              <label for="alert_di_on" class="col-form-label col-sm-2 text-sm-end">Alert when digital input is turned on</label>
              <div class="col-sm-10">
                <select id="alert_di_on" ng-model='alert_di_on' required name='alert_di_on' class="form-control">
                  <option value='0'>Disabled</option>
                  <option value='1'>Enabled</option>
                </select>
                <small id="chanHelp" class="form-text text-muted"></small>
              </div>
            </div>

        </p>
    </div>
</div>

<br/>
            
</form>	
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function Alerts($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="log_level="+$scope.log_level;
       post_data+="&send_export="+$scope.send_export;
       
       post_data+="&send_sms="+$scope.send_sms;
       post_data+="&sms_number="+$scope.sms_number;

       post_data+="&send_email="+$scope.send_email;
      post_data+="&alert_grid_fail="+$scope.alert_grid_fail;
      post_data+="&alert_grid_return="+$scope.alert_grid_return;
      post_data+="&alert_dg_on="+$scope.alert_dg_on;
      post_data+="&alert_di_on="+$scope.alert_di_on;
      post_data+="&email_address="+btoa(encodeURIComponent($scope.email_address));
      
      post_data+="&send_mqtt="+$scope.send_mqtt;
      post_data+="&mqtt_channel="+btoa(encodeURIComponent($scope.mqtt_channel));
      post_data+="&mqtt_custom_formatter="+btoa(encodeURIComponent($scope.mqtt_custom_formatter));
      post_data+="&alert_interval="+$scope.alert_interval;
      post_data+="&mqtt_server="+$scope.mqtt_server;
      post_data+="&log_offline="+$scope.log_offline;
      post_data+="&check_power="+$scope.check_power;
      post_data+="&check_fs="+$scope.check_fs;
      post_data+="&check_ota="+$scope.check_ota;
      
      post_data+="&alert_curtailing_start="+$scope.alert_curtailing_start;
      post_data+="&alert_curtailing_stop="+$scope.alert_curtailing_stop;
      
      post_data+="&encoded_keys=email_address,mqtt_channel,mqtt_custom_formatter";
      post_config="Alerts.ini";
      post_section="config";
      
      $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
       .then(function (response) {
         var data = response.data; 
         $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
         $scope.errormsg=data.error;
         $scope.sysmsg=data.sysmsg;
         return data;
       }, function(reason) {
           $scope.errormsg="Error saving settings";
           $scope.successmsg="";
       });
       }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
       <?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>



