<?
/**
 * @package pyranometer
 * @author Akash Heimlich
 * @description This file is called every day
 */

log("[pyra2] Resetting day kwh fron ".$_GLOBALS['pyra2_day']." to 0");
$_GLOBALS['kWh_Potential_Day2']=0;
$prefix='';
if ($_SERVER['HW_PLATFORM']==11) {
    $prefix='0:';
}
if ($_SERVER['HW_PLATFORM']>=20)   // ULTRA
    $prefix=intval($_GLOBALS['log_drive']).':';    
    
mb_set_dev_var($_GLOBALS['pyra2_id'],'kWh_Day_Potential',$_GLOBALS['kWh_Potential_Day2']);

$month_irradiance = ini_get($prefix."/logs/Pyra2.ini","config","kWh_Month_Irradiance",0)+$_GLOBALS['pyra2_day'];
$life_irradiance = ini_get($prefix."/logs/Pyra2.ini","config","kWh_Lifetime_Irradiance",0)+$_GLOBALS['pyra2_day'];

$d=strftime("%d",time());
if ($d==1) {
    $month_irradiance=0;
    log("Resetting monthly irradiance2");
}
ini_set($prefix."/logs/Pyra2.ini","config","kWh_Month_Irradiance",$month_irradiance);
$_GLOBALS['kWh_Month_Irradiance2']=$month_irradiance/1000;
$_GLOBALS['pyra2_day']=0;
mb_set_dev_var($_GLOBALS['pyra2_id'],'kWh_Day_Irradiance',$_GLOBALS['pyra2_day']);
ini_set($prefix."/logs/Pyra2.ini","config","kWh_Day_Irradiance",$_GLOBALS['pyra2_day']);
ini_set($prefix."/logs/Pyra2.ini","config","kWh_Month_Irradiance",$month_irradiance);
ini_set($prefix."/logs/Pyra2.ini","config","kWh_Lifetime_Irradiance",$life_irradiance);
mb_set_dev_var($_GLOBALS['pyra2_id'],'roleval17',$month_irradiance/1000);
mb_set_dev_var($_GLOBALS['pyra2_id'],'roleval18',$life_irradiance/1000);

// set the daily inverter values  
if ($_GLOBALS['ez']['inv']) {
    if (!is_array($_GLOBALS['inv_kwh_midnight2']))
        $_GLOBALS['inv_kwh_midnight2']=array();
    for ($i=0;$i<sizeof($_GLOBALS['ez']['inv']);$i++) {
        $dev=mb_get_dev_by_id($_GLOBALS['ez']['inv'][$i]['id'],$_GLOBALS['ez']['inv'][$i]['bus']);
        
        $_GLOBALS['inv_kwh_midnight2'][$i]=$dev['roleval3']; // assume kWh is register 3
        $_GLOBALS['inv_kwh_today2'][$i]=0;
        
        if ($_GLOBALS['inv_kwh_midnight2'][$i]) 
            ini_set($prefix."/logs/Pyra2.ini","config","inv".$i,$_GLOBALS['inv_kwh_midnight2'][$i]);
    }
}

?>






