<?
/**
 * @package MQTT
 * @author Akash Heimlich
 * @description MQTT Message enpoint management
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function MQTT_install($val) {
        MQTT_enable();
        return 1;
    }
     
    function MQTT_uninstall() {
        setPackageStatus("MQTT",0);
        return 1;
    }
    
    function MQTT_enable() {
        setPackageStatus("MQTT",2);
        return 1;
    }
    
    function MQTT_disable() {
        setPackageStatus("MQTT",3);
        return 1;
    }
    
    function MQTT_status() {
        $mqtt_enabled=ini_get("/config/mqtt.ini","config","enabled",0);
        if (!$mqtt_enabled) {
            return "MQTT is not enabled.";
        }
        if ($_GLOBALS['mqtt_connected']) {
            return "MQTT is enabled and connected to the server";
        }
        return "MQTT is enabled but not connected to the server";
    }
    /* this is called at system boot */
    function MQTT_init() {
        
        $mqtt_enabled=ini_get("/config/mqtt.ini","config","enabled",0);
        $_GLOBALS['mqtt_debug']=ini_get("/config/mqtt.ini","config","debug",0);
        
        $_GLOBALS['publish_interval']=ini_get("/config/mqtt.ini","config","publish_interval",10);
        $_GLOBALS['publish_heartbeat']=ini_get("/config/mqtt.ini","config","publish_heartbeat",0);
        $_GLOBALS['publish_dev']=ini_get("/config/mqtt.ini","config","publish_dev","");
        $_GLOBALS['subscribe_dev']=ini_get("/config/mqtt.ini","config","subscribe_dev",-1);
		$_GLOBALS['subscribe_heartbeat']=ini_get("/config/mqtt.ini","config","subscribe_heartbeat",0);
		if ($_GLOBALS['subscribe_heartbeat']) {
			$_GLOBALS['subscribe_timeout_interval']=ini_get("/config/mqtt.ini","config","subscribe_timeout_interval",60);
			$_GLOBALS['subscribe_timeout_percent']=ini_get("/config/mqtt.ini","config","subscribe_timeout_percent",0);

		}

        
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/MQTT.cgi?action=configure';
        $arr['title']='MQTT';
        $arr['icon']='icon-hdd';
        $arr['desc']='MQTT settings';
        
		if (!$_GLOBALS['hooks']) 
			$_GLOBALS['hooks']=array();

		if (!$_GLOBALS['hooks']['menu']) 
			$_GLOBALS['hooks']['menu']=array();

		// add this to the sidebar

		$item=array();
		$item['link']='/package/MQTT.cgi?action=configure';
		$item['title']='Configure MQTT';
		$item['icon']='fa-handshake';
		$_GLOBALS['hooks']['menu']['mqtt']=$item;
		$a=array();

        $a['html']='<span data-bs-toggle="tooltip" data-bs-placement="bottom" title="MQTT connection active. Transmitted {{livedata.mqtt_tx}} messages. Received {{livedata.mqtt_rx}} messages.">'+
    '<i ng-show="livedata.mqtt==1" class="align-middle fas fa-handshake"></i></span>'+
    '<span data-bs-toggle="tooltip" data-bs-placement="bottom" title="Wattmon is not to connected on MQTT.">'+
    '<i ng-show="livedata.mqtt!=1" class="align-middle fas fa-hand-scissors"></i></span>';

        if (!is_array($_GLOBALS['hooks']['topbar']))
            $_GLOBALS['hooks']['topbar']=array();
            
        $_GLOBALS['hooks']['topbar']['mqtt']=$a;


		$item=array();
        $item['ajax']=0;
        $item['advanced']=1;
        $item['link']='javascript:show_mqtt_log(1)';
        $item['title']='Show MQTT Log';
        $_GLOBALS['hooks']['usermenu']['items'][]=$item;
        
         if (!is_array($_GLOBALS['hooks']['footer']))
            $_GLOBALS['hooks']['footer']=array();
        $_GLOBALS['hooks']['footer']['mqtt']='/package/mqtt/MQTTFooter.inc';   
        
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/mqtt/MQTTAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/mqtt/MQTTAjax.inc';

        // runs this file once a second
        if (file_exists('/package/mqtt/MQTTSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/mqtt/MQTTSec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/mqtt/MQTTMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/mqtt/MQTTMin.inc';
            
        // runs this file once a day
        if (file_exists('/package/mqtt/MQTTDay.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/mqtt/MQTTDay.inc';            
            
        if ($mqtt_enabled) {
            $_GLOBALS['subscribe_action']=ini_get("/config/mqtt.ini","config","subscribe_action",0);
            $_GLOBALS['publish_action']=ini_get("/config/mqtt.ini","config","publish_action",0);
            $_GLOBALS['publish_inactive']=ini_get("/config/mqtt.ini","config","publish_inactive",0);
            
            // channel to publish & subscribe to
            $_GLOBALS['mqtt_publish']=ini_get("/config/mqtt.ini","config","mqtt_publish","");
            $_GLOBALS['mqtt_subscribe']=ini_get("/config/mqtt.ini","config","mqtt_subscribe","");

            // ensure that our engine know when to reconnect
            
            register_callback("MQTT_CONNECTED","","/package/mqtt/cb_connected.cgi");
            register_callback("MQTT_DISCONNECTED","","/package/mqtt/cb_disconnected.cgi");
            
            if (($_GLOBALS['subscribe_action']==1) || ($_GLOBALS['subscribe_action']==2)) { // receipt of a message containing variables for syncing
                mqtt_subscribe($_GLOBALS['mqtt_subscribe'], "/package/mqtt/sub_vars.cgi");
            } else if ($_GLOBALS['subscribe_action']==3) {  // custom script
                mqtt_subscribe($_GLOBALS['mqtt_subscribe'], ini_get("/config/mqtt.ini","config","subscribe_script",""));
            } else if ($_GLOBALS['subscribe_action']==4) {  // device update
                mqtt_subscribe($_GLOBALS['mqtt_subscribe'], "/package/mqtt/sub_dev.cgi");
            }
            
            if (($_GLOBALS['publish_action']==1)|| ($_GLOBALS['publish_action']==2)) {
                log("pub action=".$_GLOBALS['publish_action']);
                $vars=ini_get("/config/mqtt.ini","config","publish_vars",'');
                if ($vars) {
                    $_GLOBALS['publish_vars']=array();
                    $var_items=explode($vars,',');
                    if (!is_array($var_items) || (sizeof($var_items)==0)) $var_items=array($vars);
                    for ($i=0;$i<sizeof($var_items);$i++) {
                        $item=array();
                        $item['value']=$_GLOBALS[$var_items[$i]];
                        $item['name']=$var_items[$i];
                        $_GLOBALS['publish_vars'][]=$item;
                    }
                }
            }
        }
        
        return 1;
    }
    
    function MQTT_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="MQTT"; 
        $config_file="mqtt.ini";
        $config_section="config";
        $rev=ini_get("/package/MQTT.ini","package","version","");
        $title='MQTT '.($rev).'<small> Configuration Settings</small>';
        $header_subtitle=MQTT_status();
        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> 
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<div class="row">

    <div class="col-md-12 col-xl-12">
        <div class="tab-content">
            <div class="tab-pane fade show active" id="account" role="tabpanel">        
            
            
                <div class="card">
                        <div class="card-body">
                            <div class="py-2 border-bottom d-lg-block">
									<div class="d-flex align-items-center py-1">
										<div class="flex-grow-1 ps-3">
											<h5>Configuration Options</h5>
										</div>
									</div>
								</div>
                        
                            <p class="card-text">

                            <div class="alert alert-success alert-dismissible" role="alert" ng-cloak ng-show="successmsg">
                                <div class="alert-message">
                                    {{successmsg}}
                                </div>

                            </div>
                            <div class="alert alert-danger alert-dismissible" role="alert" ng-cloak ng-show="errormsg">
                                <div class="alert-message">
                                    {{errormsg}}
                                </div>

                            </div>
     
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','deviceedit')) ?></div>

<form id="form" name="form" class="css-form">
<div ng-init="enabled=<? print(ini_get("/config/mqtt.ini","config","enabled",0)); ?>;"></div>

<div ng-init="mqtt_secure=<? print(ini_get("/config/mqtt.ini","config","mqtt_secure",0)); ?>;"></div>

<div ng-init="mqtt_port=<? print(ini_get("/config/mqtt.ini","config","mqtt_port",1883)); ?>;"></div>
<div ng-init="mqtt_server='<? print(ini_get("/config/mqtt.ini","config","mqtt_server","")); ?>';"></div>
<div ng-init="mqtt_user='<? print(ini_get("/config/mqtt.ini","config","mqtt_user","")); ?>';"></div>
<div ng-init="mqtt_password='<? print(ini_get("/config/mqtt.ini","config","mqtt_password","")); ?>';"></div>
<div ng-init="mqtt_subscribe='<? print(ini_get("/config/mqtt.ini","config","mqtt_subscribe","")); ?>';"></div>
<div ng-init="mqtt_publish='<? print(ini_get("/config/mqtt.ini","config","mqtt_publish","")); ?>';"></div>

<div ng-init="mqtt_cert='<? print(ini_get("/config/mqtt.ini","config","mqtt_cert","")); ?>';"></div>
<div ng-init="mqtt_private_key='<? print(ini_get("/config/mqtt.ini","config","mqtt_private_key","")); ?>';"></div>

<div ng-init="subscribe_script='<? print(ini_get("/config/mqtt.ini","config","subscribe_script","")); ?>';"></div>
<div ng-init="publish_vars='<? print(ini_get("/config/mqtt.ini","config","publish_vars","")); ?>';"></div>
<div ng-init="publish_action=<? print(ini_get("/config/mqtt.ini","config","publish_action",0)); ?>;"></div>
<div ng-init="subscribe_action=<? print(ini_get("/config/mqtt.ini","config","subscribe_action",0)); ?>;"></div>
<div ng-init="publish_dev='<? print(ini_get("/config/mqtt.ini","config","publish_dev","")); ?>';"></div>
<div ng-init="publish_inactive=<? print(ini_get("/config/mqtt.ini","config","publish_inactive",0)); ?>;"></div>
<div ng-init="publish_heartbeat=<? print(ini_get("/config/mqtt.ini","config","publish_heartbeat",0)); ?>;"></div>
<div ng-init="subscribe_dev=<? print(ini_get("/config/mqtt.ini","config","subscribe_dev",0)); ?>;"></div>
<div ng-init="subscribe_heartbeat=<? print(ini_get("/config/mqtt.ini","config","subscribe_heartbeat",0)); ?>;"></div>
<div ng-init="subscribe_timeout_interval=<? print(ini_get("/config/mqtt.ini","config","subscribe_timeout_interval",60)); ?>;"></div>
<div ng-init="subscribe_timeout_percent=<? print(ini_get("/config/mqtt.ini","config","subscribe_timeout_percent",100)); ?>;"></div>
<div ng-init="publish_interval=<? print(ini_get("/config/mqtt.ini","config","publish_interval",10)); ?>;"></div>
<div ng-init="debug=<? print(ini_get("/config/mqtt.ini","config","debug",0)); ?>;"></div>



                             <div class="mb-3 row">
                                <label for="enabled" class="col-form-label col-sm-2 text-sm-end pt-sm-0">MQTT Support</label>
                                <div class="col-sm-10">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" ng-model="enabled" id="exampleRadios2" value="0">
                                        <label class="form-check-label" for="exampleRadios2">
                                            &nbsp;<? print(lang('DISABLED','network3g')) ?>
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" ng-model="enabled" id="exampleRadios3" value="1">
                                        <label class="form-check-label" for="exampleRadios3">
                                            &nbsp;<? print(lang('ENABLED','network3g')) ?>
                                        </label>
                                    </div>
                                    <small id="ddHelp" class="form-text text-muted">MQTT engine status</small>
                                </div>
                            </div>
			                <div class="mb-3 row" ng-show='enabled==1'>
                                <label class="col-form-label col-sm-2 text-sm-end">MQTT Server</label>
                                <div class="col-sm-10">
                                    <input type='text' class="form-control" id="mqtt_server" ng-model="mqtt_server" aria-describedby="buserHelp" placeholder="MQTT Server">
                                <small id="buserHelp" class="form-text text-muted">MQTT Server host name</small>
                                <small ng-cloak class='text-danger' ng-show="form.mqtt_server.$invalid">Invalid server name</small>
                                </div>

                            </div>
                            <div class="mb-3 row" ng-show='enabled==1'>
                                <label class="col-form-label col-sm-2 text-sm-end">MQTT Port</label>
                                <div class="col-sm-10">
                                    <input type='text' class="form-control" id="mqtt_port" size='4' integer minval="10" maxval="65535" ng-model="mqtt_port" aria-describedby="buserHelp" placeholder="MQTT Port Number">
                                <div ng-cloak class='small text-danger' ng-show="form.mqtt_port.$invalid"><strong>Invalid Port Number</strong></div>
                                <small id="buserHelp" class="form-text text-muted">Enter Server Port number</small>
                                </div>

                            </div>
                            <div class="mb-3 row" ng-show='enabled==1'>
                                <label for="enabled" class="col-form-label col-sm-2 text-sm-end pt-sm-0">Use Encryption</label>
                                <div class="col-sm-10">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" ng-model="mqtt_secure" id="enabled3" value="0">
                                        <label class="form-check-label" for="enabled3">
                                            &nbsp;<? print(lang('DISABLED','network3g')) ?>
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" ng-model="mqtt_secure" id="enabled4" value="1">
                                        <label class="form-check-label" for="enabled4">
                                            &nbsp;<? print(lang('ENABLED','network3g')) ?>
                                        </label>
                                    </div>
                                    <small id="ddHelp" class="form-text text-muted">TLS Encryption status</small>
                                </div>
                            </div>
                            <div class="mb-3 row" ng-show='mqtt_secure==1 && enabled==1'>
                                <label class="col-form-label col-sm-2 text-sm-end">TLS Custom Cert File Path</label>
                                <div class="col-sm-10">
                                    <input type='text' class="form-control" id="mqtt_cert" ng-model="mqtt_cert" aria-describedby="buserHelp" placeholder="MQTT CERT file">
                                <small id="buserHelp" class="form-text text-muted">Custom .pem.crt /path/to/file (if any) for the certificate - leave blank if not required</small>
                                </div>
                            </div>
                            <div class="mb-3 row" ng-show='mqtt_secure==1 && enabled==1'>
                                <label class="col-form-label col-sm-2 text-sm-end">TLS Custom Cert File Path</label>
                                <div class="col-sm-10">
                                    <input type='text' class="form-control" id="mqtt_private_key" ng-model="mqtt_private_key" aria-describedby="buserHelp" placeholder="MQTT KEY file">
                                <small id="buserHelp" class="form-text text-muted">Custom .key /path/to/file (if any) for the private ke - leave blank if not required</small>
                                </div>
                            </div>
                            <div class="mb-3 row" ng-show='enabled==1'>
                                <label class="col-form-label col-sm-2 text-sm-end">MQTT Username</label>
                                <div class="col-sm-10">
                                    <input type='text' class="form-control" id="mqtt_user" ng-model="mqtt_user" aria-describedby="buserHelp" placeholder="MQTT Username">
                                     <small id="dnHelp" class="form-text text-muted">MQTT Username - leave blank if not required</small>
                                    <small ng-cloak class='text-danger' ng-show="form.mqtt_user.$invalid">Invalid user name</small>
                                </div>
                            </div>
                            <div class="mb-3 row" ng-show='enabled==1'>
                                <label class="col-form-label col-sm-2 text-sm-end">MQTT Username</label>
                                <div class="col-sm-10">
                                    <input type='password' class="form-control" id="mqtt_password" ng-model="mqtt_password" aria-describedby="buserHelp" placeholder="MQTT Password">
                                     <small id="dnHelp" class="form-text text-muted">MQTT Password - leave blank if not required</small>
                                    <small ng-cloak class='text-danger' ng-show="form.mqtt_password.$invalid">Invalid Password</small>
                                </div>
                            </div>
            	            <div class="mb-3 row" ng-show='enabled==1'>
                                <label for="debug" class="col-form-label col-sm-2 text-sm-end pt-sm-0">Debug Mode</label>
                                <div class="col-sm-10">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" ng-model="debug" id="debug1" value="0">
                                        <label class="form-check-label" for="debug1">
                                            &nbsp;<? print(lang('DISABLED','network3g')) ?>
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" ng-model="debug" id="debug2" value="1">
                                        <label class="form-check-label" for="debug2">
                                            &nbsp;<? print(lang('ENABLED','network3g')) ?>
                                        </label>
                                    </div>
                                    <small id="dnHelp" class="form-text text-muted">MQTT debug mode (to log file)</small>
                                </div>
                                
                            </div>
		
            
    
<br/>
<div class="card" ng-show='enabled==1'>
    <div class="card-body">
        <h5 class="card-title">MQTT Message Publishing</h5>
        <p class="card-text">
            <div class="mb-3 row">
				<label for="publish_action" class="col-form-label col-sm-2 text-sm-end">Publish Options</label>
				 <div class="col-sm-10">
    				<select id="publish_action" ng-model='publish_action' required name='publish_action' class="form-control">
    				    <option value='0'>Disabled</option>
	                    <option value='3'>Publish Device data</option>
                        <option value='1'>Publish variables on change</option>
    	                <option value='2'>Publish variables at interval</option>
    				</select>
    				<small id="chanHelp" class="form-text text-muted">Choose an option for MQTT publishing</small>
                </div>
            </div>
			<div class="mb-3 row" ng-show='publish_action>0'>
                <label class="col-form-label col-sm-2 text-sm-end">Publish Channel</label>
                <div class="col-sm-10">
                    <input type='text' class="form-control" id="mqtt_publish" ng-model="mqtt_publish" aria-describedby="buserHelp" placeholder="MQTT Publish Channel">
                    <small id="dnHelp" class="form-text text-muted">MQTT Channel</small>
                </div>
            </div>
            <div class="mb-3 row" ng-show='publish_action==1 || publish_action==2'>
                <label class="col-form-label col-sm-2 text-sm-end">Publish Variables</label>
                <div class="col-sm-10">
                    <input type='text' class="form-control" id="publish_vars" ng-model="publish_vars" aria-describedby="buserHelp" placeholder="MQTT Publish Variables">
                    <small id="dnHelp" class="form-text text-muted">Comma separated list of global variables to sync</small>
                </div>
            </div>
            <div class="mb-3 row" ng-show='publish_action==3'>
				<label for="publish_dev" class="col-form-label col-sm-2 text-sm-end">Device to sync</label>
				 <div class="col-sm-10">
				 <select id="publish_dev" data-ng-model="publish_dev" class='form-control select2'  data-ui-select2 multiple>
                    <option value="{{obj.device_id}}"  ng-selected='obj.sel=="selected"' data-ng-repeat="obj in deviceList">{{obj.device_name}}</option>
                </select>  
<!--	                 <select multiple='true' class='form-control select2' ng-init="publish_devices = deviceList[0].device_name" 
                        ng-model="publish_dev" 
                        ng-options="obj.device_id as (obj.device_name) for obj  in deviceList">

	            </select>-->
                <small id="chanHelp" class="form-text text-muted">Device to sync</small>
                </div>
            </div>
           
            <div class="mb-3 row" ng-show='publish_action>1'>
                <label class="col-form-label col-sm-2 text-sm-end">Publish interval in second</label>
                <div class="col-sm-10">
                    <input type='text' class="form-control" id="publish_interval" size='4' integer minval="1" maxval="65535" ng-model="publish_interval" aria-describedby="buserHelp" placeholder="MQTT publish interval">
                <small ng-cloak class='text-danger' ng-show="form.publish_interval.$invalid">Invalid interval</small>
                </div>
            </div>    
            <div class="mb-3 row"  ng-show='publish_action==3'>
				<label for="publish_inactive" class="col-form-label col-sm-2 text-sm-end">Publish Inactive Devices</label>
				 <div class="col-sm-10">
    				<select id="publish_inactive" ng-model='publish_inactive' required name='publish_inactive' class="form-control">
    				    <option value='0'>Disabled</option>
                        <option value='1'>Enabled</option>
    				</select>
    				<small id="chanHelp" class="form-text text-muted">Publish the device info when the device is inactive for 30s</small>
                </div>
            </div>
            <div class="mb-3 row"  ng-show='publish_action==3'>
				<label for="publish_heartbeat" class="col-form-label col-sm-2 text-sm-end">Publish Heartbeat</label>
				 <div class="col-sm-10">
    				<select id="publish_heartbeat" ng-model='publish_heartbeat' required name='publish_heartbeat' class="form-control">
    				    <option value='0'>Disabled</option>
                        <option value='1'>Enabled</option>
    				</select>
    				<small id="chanHelp" class="form-text text-muted">Publish heartbeat</small>
                </div>
            </div>
            
        </p>
    </div>
</div>
<br/>
<div class="card" ng-show='enabled==1'>
    <div class="card-body">
        <h5 class="card-title">MQTT Message Reception</h5>
        <p class="card-text">   
          <div class="mb-3 row">
				<label for="subscribe_action" class="col-form-label col-sm-2 text-sm-end">Receive Options</label>
				 <div class="col-sm-10">
    				<select id="subscribe_action" ng-model='subscribe_action' required name='subscribe_action' class="form-control">
    				    <option value='0'>Disabled</option>
    	                <option value='4'>Update virtual driver(s)</option>
    	                <option value='1'>Add received variables to globals (sync)</option>
    	                <option value='2'>Add received variables to globals (sync) and send ACK</option>
    	                <option value='3'>Execute a script</option>
    	               </select>
                    <small id="chanHelp" class="form-text text-muted">Choose an action to perform upon receipt of a message</small>
                </div>
            </div>
            
            <div class="mb-3 row"  ng-show='canShowDevice()'>
                <label for="subscribe_dev" class="col-form-label col-sm-2 text-sm-end">Device to update</label>
<div class="col-sm-10">
                <select ng-model="subscribe_dev"  required name='subscribe_dev' class="form-control">
	                <? $num_dev=mb_num_devices(); 
	                for ($i=0;$i<$num_dev;$i++) {
	                    $d=mb_get_dev_by_index($i);
	                    print("<option value=".$i.">".$d['name'].'</option>');
	                } 
	                ?>
	            </select>
                <small id="chanHelp" class="form-text text-muted">Device to sync</small>
                </div>
            </div>
            <div class="mb-3 row" ng-show='canShowDeviceHelp()'>
                <div class="col-sm-10">
                Since you have selected a wildcard channel (with #), the device name will be taken from the received MQTT channel name.  For example, if the channel is /test/# then when a message comes for /test/meter1 the meter1 device will be updated.
                This allows multiple devices to be updated from various locations.
                </div>
            </div>
            <div class="mb-3 row"  ng-show='subscribe_action==3'>
                <label class="col-form-label col-sm-2 text-sm-end" for="subscribe_script">Script path and name</label>
                <div class="col-sm-10">
                    <input type='text' class="form-control" id="subscribe_script" ng-model="subscribe_script" aria-describedby="buserHelp" placeholder="/path/to/script.cgi">
                    <small id="dnHelp" class="form-text text-muted">Enter the path to a valid script to call upon receipt of an MQTT message</small>
                </div>
            </div>
            <div class="mb-3 row"  ng-show='subscribe_action>0'>
                <label class="col-form-label col-sm-2 text-sm-end" for="mqtt_subscribe">Subscribe Channel</label>
                <div class="col-sm-10">
                    <input type='text' class="form-control" id="mqtt_subscribe" ng-model="mqtt_subscribe" aria-describedby="buserHelp" placeholder="MQTT Subscribe Channel">
                    <small id="dnHelp" class="form-text text-muted">MQTT Channel (you can use a # wildcard if you are receving multiple messages)</small>
                </div>
            </div>
			<div class="mb-3 row"  ng-show='subscribe_action==4'>
				<label for="subscribe_heartbeat" class="col-form-label col-sm-2 text-sm-end">Subscribe Heartbeat</label>
				 <div class="col-sm-10">
    				<select id="subscribe_heartbeat" ng-model='subscribe_heartbeat' required name='subscribe_heartbeat' class="form-control">
    				    <option value='0'>Disabled</option>
                        <option value='1'>Enabled</option>
    				</select>
    				<small id="chanHelp" class="form-text text-muted">Expect heartbeat signal</small>
                </div>
            </div>
			<div class="mb-3 row"  ng-show='subscribe_heartbeat==1'>
                <label class="col-form-label col-sm-2 text-sm-end" for="subscribe_timeout_interval">Heartbeat timeout</label>
                <div class="col-sm-10">
                    <input type='text' class="form-control" id="subscribe_timeout_interval" ng-model="subscribe_timeout_interval" aria-describedby="buserHelp" placeholder="Heartbeat timeout">
                    <small id="dnHelp" class="form-text text-muted">Interval in seconds for heartbeat timeout</small>
                </div>
            </div>
			<div class="mb-3 row"  ng-show='subscribe_heartbeat==1'>
                <label class="col-form-label col-sm-2 text-sm-end" for="subscribe_timeout_percent">Force inverter percent</label>
                <div class="col-sm-10">
                    <input type='text' class="form-control" id="subscribe_timeout_percent" ng-model="subscribe_timeout_percent" aria-describedby="buserHelp" placeholder="Inverter percent">
                    <small id="dnHelp" class="form-text text-muted">Force inverter percent to this value when no heartbeat is received</small>
                </div>
            </div>
	       
    	</p>
    </div>
    

</div>
 <div class="mb-3 row">
								<div class="col-sm-10 ms-sm-auto">
                                    <button class="btn btn-primary" ng-hide='loading==1'  ng-click="saveSettings()"><? print(lang('APPLY','deviceedit')) ?></button>
                                </div>
                            </div>
                            <div class="alert alert-success alert-dismissible" role="alert" ng-cloak ng-show="successmsg">
                                <div class="alert-message">
                                    {{successmsg}}
                                </div>

                            </div>
                            <div class="alert alert-danger alert-dismissible" role="alert" ng-cloak ng-show="errormsg">
                                <div class="alert-message">
                                    {{errormsg}}
                                </div>

                            </div>
<br/>        
	</p>
    </div>
</div>
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

document.addEventListener("DOMContentLoaded", function() {
			// Select2
			$(".select2").each(function() {
				$(this)
					.wrap("<div class=\"position-relative\"></div>")
					.select2({
						placeholder: "Select value",
						dropdownParent: $(this).parent()
					});
			});
});
</script>
 <?
        include("/app/footer.inc");?>
<script>
function MQTT($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.regexURL = $scope.regex = new RegExp('^((https?|ftp)://)?([a-z0-9]+[.])?[a-z0-9-]+([.][a-z]{1,4}){1,2}(/.*[?].*)?$', 'i');
   $scope.loading=0;
   $gscope=$scope;
   $scope.deviceList = [
   <? 
        $pubs=explode(ini_get("/config/mqtt.ini","config","publish_dev",""),",");
        
        $num_dev=mb_num_devices(); 
	                for ($i=0;$i<$num_dev;$i++) {
	                    $d=mb_get_dev_by_index($i);
	                    if ($i) print(",");
	                    $sel=0;
	                    
	                    for ($j=0;$j<sizeof($pubs);$j++) {
	                        
	                        if ($pubs[$j]==$i) $sel=1;
	                    }
	                    //print("sel=".$sel."\r\n");
	                    if ($sel) $sel="selected"; else $sel="";
	                    
	                    print("{\"sel\":\"".$sel."\",\"device_id\":".$i.",\"device_name\":\"".$d['name'].'"}');
	                } 
	               ?>
   ]

   $scope.canShowDevice=function() {
        if ($scope.subscribe_action==4) {
            if ($scope.mqtt_subscribe.indexOf('#') !== -1) {
                return false;
            }
            return true;
        } else return false;
   }
   
    $scope.canShowDeviceHelp=function() {
        if ($scope.subscribe_action==4) {
            if ($scope.mqtt_subscribe.indexOf('#') !== -1) {
                return true;
            }
            return false;
        } else return false;
   }
      $scope.$watch('publish_dev', function(asyncData) {
        if(angular.isDefined(asyncData)) {
            console.log($scope.publish_dev);
            console.log($scope.deviceList);
        }
      });
   $scope.saveSettings=function() {
   $scope.successmsg="";
   $scope.errormsg=""
    arr=$('#publish_dev').select2('data');
    publish_dev="";
    for (i=0;i<arr.length;i++) {
        for (j=0;j<$scope.deviceList.length;j++) {
            if (arr[i].text==$scope.deviceList[j].device_name)  {
                if (publish_dev.length>0) publish_dev=publish_dev+",";
                publish_dev=publish_dev+$scope.deviceList[j].device_id;
            }
                
        }
    }
    //console.log(publish_dev);
    //return;
       post_data="enabled="+$scope.enabled;
       post_data+="&mqtt_port="+$scope.mqtt_port;
       post_data+="&mqtt_secure="+$scope.mqtt_secure;
       post_data+="&mqtt_server="+$scope.mqtt_server;
       post_data+="&mqtt_user="+$scope.mqtt_user;
       post_data+="&mqtt_cert="+$scope.mqtt_cert;
       post_data+="&mqtt_private_key="+$scope.mqtt_private_key;
       post_data+="&mqtt_password="+btoa(encodeURIComponent($scope.mqtt_password));
       post_data+="&role="+$scope.role;
       post_data+="&debug="+$scope.debug;
       post_data+="&mqtt_subscribe="+$scope.mqtt_subscribe;
       post_data+="&mqtt_publish="+$scope.mqtt_publish;
       post_data+="&publish_action="+$scope.publish_action;
       post_data+="&subscribe_action="+$scope.subscribe_action;
       post_data+="&subscribe_script="+$scope.subscribe_script;
       post_data+="&subscribe_dev="+$scope.subscribe_dev;
       post_data+="&subscribe_heartbeat="+$scope.subscribe_heartbeat;
       post_data+="&subscribe_timeout_interval="+$scope.subscribe_timeout_interval;
       post_data+="&subscribe_timeout_percent="+$scope.subscribe_timeout_percent;
       post_data+="&publish_interval="+$scope.publish_interval;
       post_data+="&publish_inactive="+$scope.publish_inactive;
       post_data+="&publish_heartbeat="+$scope.publish_heartbeat;
       post_data+="&publish_dev="+publish_dev;
       post_data+="&publish_vars="+$scope.publish_vars;
       post_data+="&encoded_keys=mqtt_password";
       post_config="mqtt.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
       
}
   </script>
   
       
    <?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>












