<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/devices.cgi"><? print(lang('MODBUS_DEVICES','devicecalib')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('DEVICE_CALIBRATE','devicecalib')) ?></li>
  </ol>
</nav>
<div ng-init="device_index=<? print($_GET['device_idx']); ?>;"></div>
<!-- NAVBAR -->
<h4 ><i class="icon-cog"></i>&nbsp;<? print(lang('CONFIGURE_TITLE','deviceedit')) ?>&nbsp;<small> <? print(ini_get($info_ini,$info_section,'description')." (".$arr['device_type_id'].")"); ?></small></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/devices.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/deviceedit.cgi?device_idx=<? print($_GET['device_idx']); ?>'"><i class="icon-wrench"></i> <? print(lang('EDIT','devicecalib')) ?></a>
  </li>
 
  <li class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','devicecalib')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','devicecalib')) ?>
    <? print(lang('HELP2','devicecalib')) ?>
  </div>
</div>
<div class="row">

    <div class="col-md-12 col-xl-12">
        <div class="tab-content">
            <div class="tab-pane fade show active" id="account" role="tabpanel">        
            
         
                <div class="alert alert-success alert-dismissible" role="alert" ng-cloak ng-show="successmsg">
                    <div class="alert-message">
                        {{successmsg}}
                    </div>

                </div>
                <div class="alert alert-danger alert-dismissible" role="alert" ng-cloak ng-show="errormsg">
                    <div class="alert-message">
                        {{errormsg}}
                    </div>

                </div>

                <div class="card">
                  <div class="card-body">
                        <div class="py-2 border-bottom d-none d-lg-block">
                			<div class="d-flex align-items-center py-1">
                				<div class="flex-grow-1 ps-3">
                					<h5><? print(lang('CONFIGURE_TITLE','deviceedit')) ?>&nbsp;&nbsp;<small> <? print(ini_get($info_ini,$info_section,'description')." (".$arr['device_type_id'].")"); ?></small></h5>
                				</div>
                				<div>
                				    <button class="btn btn-primary btn-md me-1 px-3" onclick="document.location='/app/deviceedit.cgi?device_idx=<? print($_GET['device_idx']); ?>'" title="<? print(lang('EDIT','deviceedit')) ?>"><i class="feather-lg" data-feather="wrench"></i> <? print(lang('EDIT','devicecalib')) ?></button>  
                				</div>
                			</div>
                		</div>
            <form id="form" name="form" class="css-form">
                		
                        <p class="card-text">
                            <div ng-init="device_index=<? print($_GET['device_idx']); ?>;"></div>
                            <div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','devicecalib')) ?></div>
                        <div class="py-2 border-bottom d-none d-lg-block">
                			<div class="d-flex align-items-center py-1">
                				<div class="flex-grow-1 ps-3">
                					<h5>Input Voltage</h5>
                				</div>
                				<div>
                				    Voltage: {{roles[0]|number:3}} V  <i>Raw Value: {{rofields[30].value}}</i>
                				</div>
                			</div>
                		</div>
                            <div class="mb-3 row">
                                    <label class="col-form-label col-sm-2 text-sm-end" for="formVal">Voltage multiplier (Input Voltage)</label>    
                                    <div class="col-sm-10">
									<div class="input-group">
											<input type='text' ng-model="mul_v0" class="form-control" name="mul_v0"  required placeholder="Value">
											<button ng-click='setValue(0,0)' class="btn btn-secondary" type="button">Calibrate</button>
									</div>
                                        
                                    </div>
                            </div>
                            
                        <div class="py-2 border-bottom d-none d-lg-block">
                			<div class="d-flex align-items-center py-1">
                				<div class="flex-grow-1 ps-3">
                					<h5>Analog Channel 1</h5>
                				</div>
                				<div>
                				    Calibrated Value: {{roles[1]|number:3}} <span ng-show='chan0_mode==0'>Voltage: {{roles[2]|number:3}} V</span><span ng-show='chan0_mode==1'>Current: {{roles[3]|number:2}}mA</span> <i>Raw: {{rofields[8].value}}</i>
                				</div>
                			</div>
                		</div>
                		<br/>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Channel Mode</label>
                            <div class="col-sm-10">
                                <div class="form-check form-switch">
                            		    <input class="form-check-input" type="checkbox" id="chan0_mode" ng-model="chan0_mode" ng-true-value="1" ng-false-value="0">
                            		    <label class="form-check-label" for="chan0_mode"><span ng-show='chan0_mode==1'>Current (0-20 mA)</span><span ng-show='chan0_mode!=1'>Voltage (0-10V DC)</span></label>
                                </div>
                                <small id="dnHelp" class="form-text text-muted">Choose the channel operating mode</small>
                            </div>
                        </div>
                        <div class="mb-3 row" ng-show='chan0_mode==0'>
                            <label class="col-form-label col-sm-2 text-sm-end">Voltage Multiplier</label>
                            <div class="col-sm-10">
									<div class="input-group">
											<input type='text' ng-model="chan0_vmul" class="form-control" name="chan0_vmul"  required placeholder="Value">
											<button ng-click='setValue(1,0)' class="btn btn-secondary" type="button">Calibrate</button>
									</div>
                                
                            </div>
                        </div>
                        <div class="mb-3 row" ng-show='chan0_mode==1'>
                            <label class="col-form-label col-sm-2 text-sm-end">Current Multiplier</label>
                            <div class="col-sm-10">
									<div class="input-group">
											<input type='text' ng-model="chan0_amul" class="form-control" name="chan0_amul"  required placeholder="Value">
											<button ng-click='setValue(1,1)' class="btn btn-secondary" type="button">Calibrate</button>
									</div>
                                
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Input Range Min</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan0_range_min" class="form-control" name="chan0_range_min"  required placeholder="Value">
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Input Range Max</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan0_range_max" class="form-control" name="chan0_range_max"  required placeholder="Value">
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Sensor Range Min</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan0_sensor_min" class="form-control" name="chan0_sensor_min"  required placeholder="Value">
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Sensor Range Max</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan0_sensor_max" class="form-control" name="chan0_sensor_max"  required placeholder="Value">
                            </div>
                        </div>
                        
                        <div class="py-2 border-bottom d-none d-lg-block">
                			<div class="d-flex align-items-center py-1">
                				<div class="flex-grow-1 ps-3">
                					<h5>Analog Channel 2</h5>
                				</div>
                				<div>
                				    Calibrated Value: {{roles[4]|number:3}} <span ng-show='chan1_mode==0'>Voltage: {{roles[5]|number:3}} V</span><span ng-show='chan1_mode==1'>Current: {{roles[6]|number:2}}mA</span> <i>Raw: {{rofields[15].value}}</i>
                				</div>
                			</div>
                		</div>
                		<br/>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Channel Mode</label>
                            <div class="col-sm-10">
                                <div class="form-check form-switch">
                            		    <input class="form-check-input" type="checkbox" id="chan1_mode" ng-model="chan1_mode" ng-true-value="1" ng-false-value="0">
                            		    <label class="form-check-label" for="chan1_mode"><span ng-show='chan1_mode==1'>Current (0-20 mA)</span><span ng-show='chan1_mode!=1'>Voltage (0-10V DC)</span></label>
                                </div>
                                <small id="dnHelp" class="form-text text-muted">Choose the channel operating mode</small>
                            </div>
                        </div>
                        <div class="mb-3 row" ng-show='chan1_mode==0'>
                            <label class="col-form-label col-sm-2 text-sm-end">Voltage Multiplier</label>
                            <div class="col-sm-10">
									<div class="input-group">
											<input type='text' ng-model="chan1_vmul" class="form-control" name="chan1_vmul"  required placeholder="Value">
											<button ng-click='setValue(2,0)' class="btn btn-secondary" type="button">Calibrate</button>
									</div>
                                
                            </div>
                        </div>
                        <div class="mb-3 row" ng-show='chan1_mode==1'>
                            <label class="col-form-label col-sm-2 text-sm-end">Current Multiplier</label>
                            <div class="col-sm-10">
									<div class="input-group">
											<input type='text' ng-model="chan1_amul" class="form-control" name="chan1_amul"  required placeholder="Value">
											<button ng-click='setValue(2,1)' class="btn btn-secondary" type="button">Calibrate</button>
									</div>
                                
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Input Range Min</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan1_range_min" class="form-control" name="chan1_range_min"  required placeholder="Value">
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Input Range Max</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan1_range_max" class="form-control" name="chan1_range_max"  required placeholder="Value">
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Sensor Range Min</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan1_sensor_min" class="form-control" name="chan1_sensor_min"  required placeholder="Value">
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Sensor Range Max</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan1_sensor_max" class="form-control" name="chan1_sensor_max"  required placeholder="Value">
                            </div>
                        </div>

           
           <div class="py-2 border-bottom d-none d-lg-block">
                			<div class="d-flex align-items-center py-1">
                				<div class="flex-grow-1 ps-3">
                					<h5>Analog Channel 3</h5>
                				</div>
                				<div>
                				    Calibrated Value: {{roles[7]|number:3}} <span ng-show='chan2_mode==0'>Voltage: {{roles[8]|number:3}} V</span><span ng-show='chan2_mode==1'>Current: {{roles[9]|number:2}}mA</span> <i>Raw: {{rofields[22].value}}</i>
                				</div>
                			</div>
                		</div>
                		<br/>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Channel Mode</label>
                            <div class="col-sm-10">
                                <div class="form-check form-switch">
                            		    <input class="form-check-input" type="checkbox" id="chan2_mode" ng-model="chan2_mode" ng-true-value="1" ng-false-value="0">
                            		    <label class="form-check-label" for="chan2_mode"><span ng-show='chan2_mode==1'>Current (0-20 mA)</span><span ng-show='chan2_mode!=1'>Voltage (0-10V DC)</span></label>
                                </div>
                                <small id="dnHelp" class="form-text text-muted">Choose the channel operating mode</small>
                            </div>
                        </div>
                        <div class="mb-3 row" ng-show='chan2_mode==0'>
                            <label class="col-form-label col-sm-2 text-sm-end">Voltage Multiplier</label>
                            <div class="col-sm-10">
									<div class="input-group">
											<input type='text' ng-model="chan2_vmul" class="form-control" name="chan2_vmul"  required placeholder="Value">
											<button ng-click='setValue(3,0)' class="btn btn-secondary" type="button">Calibrate</button>
									</div>
                                
                            </div>
                        </div>
                        <div class="mb-3 row" ng-show='chan2_mode==1'>
                            <label class="col-form-label col-sm-2 text-sm-end">Current Multiplier</label>
                            <div class="col-sm-10">
									<div class="input-group">
											<input type='text' ng-model="chan2_amul" class="form-control" name="chan2_amul"  required placeholder="Value">
											<button ng-click='setValue(3,1)' class="btn btn-secondary" type="button">Calibrate</button>
									</div>
                                
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Input Range Min</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan2_range_min" class="form-control" name="chan2_range_min"  required placeholder="Value">
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Input Range Max</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan2_range_max" class="form-control" name="chan2_range_max"  required placeholder="Value">
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Sensor Range Min</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan2_sensor_min" class="form-control" name="chan2_sensor_min"  required placeholder="Value">
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Sensor Range Max</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan2_sensor_max" class="form-control" name="chan2_sensor_max"  required placeholder="Value">
                            </div>
                        </div>
           
            <div class="py-2 border-bottom d-none d-lg-block">
                			<div class="d-flex align-items-center py-1">
                				<div class="flex-grow-1 ps-3">
                					<h5>Analog Channel 4</h5>
                				</div>
                				<div>
                				    Calibrated Value: {{roles[10]|number:3}} <span ng-show='chan3_mode==0'>Voltage: {{roles[11]|number:3}} V</span><span ng-show='chan3_mode==1'>Current: {{roles[12]|number:2}}mA</span> <i>Raw: {{rofields[29].value}}</i>
                				</div>
                			</div>
                		</div>
                		<br/>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Channel Mode</label>
                            <div class="col-sm-10">
                                <div class="form-check form-switch">
                            		    <input class="form-check-input" type="checkbox" id="chan3_mode" ng-model="chan3_mode" ng-true-value="1" ng-false-value="0">
                            		    <label class="form-check-label" for="chan3_mode"><span ng-show='chan3_mode==1'>Current (0-20 mA)</span><span ng-show='chan3_mode!=1'>Voltage (0-10V DC)</span></label>
                                </div>
                                <small id="dnHelp" class="form-text text-muted">Choose the channel operating mode</small>
                            </div>
                        </div>
                        <div class="mb-3 row" ng-show='chan3_mode==0'>
                            <label class="col-form-label col-sm-2 text-sm-end">Voltage Multiplier</label>
                            <div class="col-sm-10">
									<div class="input-group">
											<input type='text' ng-model="chan3_vmul" class="form-control" name="chan3_vmul"  required placeholder="Value">
											<button ng-click='setValue(4,0)' class="btn btn-secondary" type="button">Calibrate</button>
									</div>
                                
                            </div>
                        </div>
                        <div class="mb-3 row" ng-show='chan3_mode==1'>
                            <label class="col-form-label col-sm-2 text-sm-end">Current Multiplier</label>
                            <div class="col-sm-10">
									<div class="input-group">
											<input type='text' ng-model="chan3_amul" class="form-control" name="chan3_amul"  required placeholder="Value">
											<button ng-click='setValue(4,1)' class="btn btn-secondary" type="button">Calibrate</button>
									</div>
                                
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Input Range Min</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan3_range_min" class="form-control" name="chan3_range_min"  required placeholder="Value">
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Input Range Max</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan3_range_max" class="form-control" name="chan3_range_max"  required placeholder="Value">
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Sensor Range Min</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan3_sensor_min" class="form-control" name="chan3_sensor_min"  required placeholder="Value">
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Sensor Range Max</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="chan3_sensor_max" class="form-control" name="chan3_sensor_max"  required placeholder="Value">
                            </div>
                        </div>
  <div class="py-2 border-bottom d-none d-lg-block">
                			<div class="d-flex align-items-center py-1">
                				<div class="flex-grow-1 ps-3">
                					<h5>Digital Inputs</h5>
                				</div>
                				<div>
                				    
                				</div>
                			</div>
                		</div>
                		<br/>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Digital Input 1 Mode</label>
                            <div class="col-sm-10">
                                <div class="form-check form-switch">
                            		    <input class="form-check-input" type="checkbox" id="counter0" ng-model="counter0" ng-true-value="1" ng-false-value="0">
                            		    <label class="form-check-label" for="counter0"><span ng-show='counter0!=0'>Counter Mode (Value: {{roles[21]|number:0}})</span><span ng-show='counter0==0'>Digital Input Mode (Value: {{roles[13]|number:0}})</span></label>
                                </div>
                                <small id="dnHelp" class="form-text text-muted">Choose the channel operating mode</small>
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Digital Input 2 Mode</label>
                            <div class="col-sm-10">
                                <div class="form-check form-switch">
                            		    <input class="form-check-input" type="checkbox" id="counter1" ng-model="counter1" ng-true-value="1" ng-false-value="0">
                            		    <label class="form-check-label" for="counter1"><span ng-show='counter1!=0'>Counter Mode (Value: {{roles[22]|number:0}})</span><span ng-show='counter1==0'>Digital Input Mode (Value: {{roles[14]|number:0}})</span></label>
                                </div>
                                <small id="dnHelp" class="form-text text-muted">Choose the channel operating mode</small>
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Digital Input 3 Mode</label>
                            <div class="col-sm-10">
                                <div class="form-check form-switch">
                            		    <input class="form-check-input" type="checkbox" id="counter2" ng-model="counter2" ng-true-value="1" ng-false-value="0">
                            		    <label class="form-check-label" for="counter2"><span ng-show='counter2!=0'>Counter Mode (Value: {{roles[23]|number:0}})</span><span ng-show='counter2==0'>Digital Input Mode (Value: {{roles[15]|number:0}})</span></label>
                                </div>
                                <small id="dnHelp" class="form-text text-muted">Choose the channel operating mode</small>
                            </div>
                        </div>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Digital Input 4 Mode</label>
                            <div class="col-sm-10">
                                <div class="form-check form-switch">
                            		    <input class="form-check-input" type="checkbox" id="counter3" ng-model="counter3" ng-true-value="1" ng-false-value="0">
                            		    <label class="form-check-label" for="counter3"><span ng-show='counter3!=0'>Counter Mode (Value: {{roles[24]|number:0}})</span><span ng-show='counter3==0'>Digital Input Mode (Value: {{roles[16]|number:0}})</span></label>
                                </div>
                                <small id="dnHelp" class="form-text text-muted">Choose the channel operating mode</small>
                            </div>
                        </div>
 <div class="py-2 border-bottom d-none d-lg-block">
                			<div class="d-flex align-items-center py-1">
                				<div class="flex-grow-1 ps-3">
                					<h5>Digital Outputs</h5>
                				</div>
                				<div>
                				    
                				</div>
                			</div>
                		</div>
                		<br/>
                        <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Digital Output 1</label>
                            <div class="col-sm-10">
                                {{roles[17]|number:0}}                   
                            </div>
                        </div>
                         <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Digital Output 2</label>
                            <div class="col-sm-10">
                                {{roles[18]|number:0}}                   
                            </div>
                        </div>
                         <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Digital Output 3</label>
                            <div class="col-sm-10">
                                {{roles[19]|number:0}}                   
                            </div>
                        </div>
                         <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Digital Output 4</label>
                            <div class="col-sm-10">
                                {{roles[20]|number:0}}                   
                            </div>
                        </div>
             <div class="mb-3 row">
								<div class="col-sm-10 ms-sm-auto">
                                    <button class="btn btn-primary" ng-click="saveSettings()"><? print(lang('APPLY','devicecalib')) ?></button>
                                </div>
                            </div>

<br/>
    
            </form>
        </p>
    </div>
</div>
</div>

<div class="modal fade" id="valueForm" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Calibration</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>{{question}}
                            <div class="mb-3 row">
                            <label class="col-form-label col-sm-2 text-sm-end">Value</label>
                            <div class="col-sm-10">
                                <input type='text' ng-model="form_value" class="form-control" name="form_value"  required placeholder="Value">
                            </div>
                        </div></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-primary" ng-click="doModal()">Continue</button>
                    </div>
                </div>
            </div>
        </div> 

    <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

function ieee754_to_int(f) {
    var buffer = new ArrayBuffer(4);
    var intView = new Int32Array(buffer);
    var floatView = new Float32Array(buffer);
    floatView[0] = f;
    return (intView[0]);
}

</script>
<? include("/app/footer.inc"); ?>

<script>

app.factory('dataService', function($http, $q,$timeout) {
  
  this.async = function(devid,all) {
    config = new Object();
    config.timeout=30000;
    config.method="GET";
    config.url='/app/devcalib_ajax.cgi?action=get'+(all?"all":"ro")+'&device_idx='+devid;
    //$http(timeout:8000});
//    return $http.get()
    
    return $http(config)
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
        //alert('Failed: ' + reason);
          // try again
    });
    
  };
  
  return this;
});

function makeUnsigned(intVal) {
    if (intVal<0) intVal = 65536-intVal;
    return intVal;
}
function ieee754_from_int(int1,int2) {
    var bytes = [ int1 >> 8, int1 & 0xFF, int2 >> 8, int2 & 0xFF ];
    var bits = (bytes[0] << 24) | (bytes[1] << 16) | (bytes[2] << 8) | (bytes[3]);
    var sign = ((bits >>> 31) == 0) ? 1.0 : -1.0;
    var e = ((bits >>> 23) & 0xff);
    var m = (e == 0) ? (bits & 0x7fffff) << 1 : (bits & 0x7fffff) | 0x800000;
    var f = sign * m * Math.pow(2, e - 150);
    return f;
}

function DeviceCalibCtrl(dataService,$scope, $timeout,$http) {
    
//app.controller('ItemListCtrl', function( dataService,$scope,$timeout) {
    
  var self = this;
  $scope.infomsg="";
  $scope.myFilter = function(user) {
   x= /^Raw(.)*$/.test(user.name);
   //alert(x);
   if (x) return 1;
   return 0;
  };
  
  $scope.setValue=function(idx,val_type) {
  console.log("SetValue called");
    $scope.selectedIdx=idx;
    $scope.val_type=val_type;
    if (val_type==0) {
        switch (idx) {
            case 0: $scope.form_value=$scope.roles[0];break;
            case 1: $scope.form_value=$scope.roles[2];break;
            case 2: $scope.form_value=$scope.roles[5];break;
            case 3: $scope.form_value=$scope.roles[8];break;
            case 4: $scope.form_value=$scope.roles[11];break;
        }
    } else {
        switch (idx) {
            case 1: $scope.form_value=$scope.roles[3];break;
            case 2: $scope.form_value=$scope.roles[6];break;
            case 3: $scope.form_value=$scope.roles[9];break;
            case 4: $scope.form_value=$scope.roles[12];break;
        }
    
    }
    $scope.question="Enter the "+(val_type==1?"current in mA":"voltage in V")+" on channel "+idx+" and enter it below:";
    $('#valueForm').modal('show');
  }
 
 $scope.doModal=function() {
      console.log("Channel "+$scope.selectedIdx+" type="+$scope.val_type+" Value is: "+$scope.form_value);
       if ($scope.val_type==0) {
            switch ($scope.selectedIdx) {
                case 0: $scope.mul_v0=$scope.form_value/$scope.rofields[30].value;break;
                case 1: $scope.chan0_vmul=$scope.form_value/$scope.rofields[8].value;break;
                case 2: $scope.chan1_vmul=$scope.form_value/$scope.rofields[15].value;break;
                case 3: $scope.chan2_vmul=$scope.form_value/$scope.rofields[22].value;break;
                case 4: $scope.chan3_vmul=$scope.form_value/$scope.rofields[29].value;break;
            }
        } else {
            switch ($scope.selectedIdx) {
                case 1: $scope.chan0_amul=$scope.form_value/$scope.rofields[8].value;break;
                case 2: $scope.chan1_amul=$scope.form_value/$scope.rofields[15].value;break;
                case 3: $scope.chan2_amul=$scope.form_value/$scope.rofields[22].value;break;
                case 4: $scope.chan3_amul=$scope.form_value/$scope.rofields[29].value;break;
            }
        
        }
        $('#valueForm').modal('hide');
  }  
  $scope.getClass=function() {
    if ($scope.form.$invalid) return "disabled";
    return "";
  }
  // get data once a second to update ro vars
  function poll() {
    $scope.asyncDataReg=dataService.async($scope.curDevIndex,(!$scope.rwfields || $scope.rwfields.length==0));
    $timeout(poll, 1500);
  }
  $timeout(poll, 2000);  // start after two seconds
  
  /*$scope.rwfields=[
            {fieldname:"rwvar1",name:"Current Offset",value:2048,original:2048,min:0,max:4096},
            {fieldname:"rwvar2",name:"Current Multiplier",value:1,original:1,min:0,max:10000},
            {fieldname:"rwvar3",name:"Current Divisor",value:1,min:1,original:1,max:10000}
            ];
            */
  
  $scope.$watch('asyncDataReg', function(asyncData) {
    if(angular.isDefined(asyncData)) {
        if (asyncData.rolenames) {
            $scope.rolenames=asyncData.rolenames;
        }
        if (asyncData.roles) {
            $scope.roles=asyncData.roles;
        }
        if (asyncData.rwvars) {
            //alert('got rwvars');
            console.log('got rwvars');
            $scope.rwfields = asyncData.rwvars;
            for (i=0;i<$scope.rwfields.length;i++) {
                $scope.rwfields[i].value=makeUnsigned($scope.rwfields[i].value);
            }
            $scope.mul_v0 = ieee754_from_int($scope.rwfields[1].value,$scope.rwfields[0].value);
            
            $scope.counter0=String($scope.rwfields[58].value>0?1:0);
            $scope.counter1=String($scope.rwfields[59].value>0?1:0);
            $scope.counter2=String($scope.rwfields[60].value>0?1:0);
            $scope.counter3=String($scope.rwfields[61].value>0?1:0);
            $scope.chan0_vmul = ieee754_from_int($scope.rwfields[4].value,$scope.rwfields[3].value);
            $scope.chan0_amul = ieee754_from_int($scope.rwfields[6].value,$scope.rwfields[5].value);
            $scope.chan0_mode = String($scope.rwfields[7].value);
            $scope.chan0_range_min = ieee754_from_int($scope.rwfields[9].value,$scope.rwfields[8].value);
            $scope.chan0_sensor_min = ieee754_from_int($scope.rwfields[11].value,$scope.rwfields[10].value);
            $scope.chan0_range_max = ieee754_from_int($scope.rwfields[13].value,$scope.rwfields[12].value);
            $scope.chan0_sensor_max = ieee754_from_int($scope.rwfields[15].value,$scope.rwfields[14].value);
            
            
            
            $scope.chan1_vmul = ieee754_from_int($scope.rwfields[18].value,$scope.rwfields[17].value);
            $scope.chan1_amul = ieee754_from_int($scope.rwfields[20].value,$scope.rwfields[19].value);
            $scope.chan1_mode = String($scope.rwfields[21].value);
            $scope.chan1_range_min = ieee754_from_int($scope.rwfields[23].value,$scope.rwfields[22].value);
            $scope.chan1_sensor_min = ieee754_from_int($scope.rwfields[25].value,$scope.rwfields[24].value);
            $scope.chan1_range_max = ieee754_from_int($scope.rwfields[27].value,$scope.rwfields[26].value);
            $scope.chan1_sensor_max = ieee754_from_int($scope.rwfields[29].value,$scope.rwfields[28].value);
            
            
            
            $scope.chan2_vmul = ieee754_from_int($scope.rwfields[32].value,$scope.rwfields[31].value);
            $scope.chan2_amul = ieee754_from_int($scope.rwfields[34].value,$scope.rwfields[33].value);
            $scope.chan2_mode = String($scope.rwfields[35].value);
            $scope.chan2_range_min = ieee754_from_int($scope.rwfields[37].value,$scope.rwfields[36].value);
            $scope.chan2_sensor_min = ieee754_from_int($scope.rwfields[39].value,$scope.rwfields[38].value);
            $scope.chan2_range_max = ieee754_from_int($scope.rwfields[41].value,$scope.rwfields[40].value);
            $scope.chan2_sensor_max = ieee754_from_int($scope.rwfields[43].value,$scope.rwfields[42].value);
            
            
            $scope.chan3_vmul = ieee754_from_int($scope.rwfields[46].value,$scope.rwfields[45].value);
            $scope.chan3_amul = ieee754_from_int($scope.rwfields[48].value,$scope.rwfields[47].value);
            $scope.chan3_mode = String($scope.rwfields[49].value);
            $scope.chan3_range_min = ieee754_from_int($scope.rwfields[51].value,$scope.rwfields[50].value);
            $scope.chan3_sensor_min = ieee754_from_int($scope.rwfields[53].value,$scope.rwfields[52].value);
            $scope.chan3_range_max = ieee754_from_int($scope.rwfields[55].value,$scope.rwfields[54].value);
            $scope.chan3_sensor_max = ieee754_from_int($scope.rwfields[57].value,$scope.rwfields[56].value);
            
            
            console.log($scope.mul_v0);
        }
        if (asyncData.rovars) {
            $scope.rofields = asyncData.rovars;
        }
        
    }
  });
  $scope.restoreDefaults=function() {
  
//      $scope.device_id=$scope.saved_device_id;
      $scope.infomsg="Default values loaded.  Settings will not be saved until you click <i>Update Settings</i>."
      
  }
  $scope.calibrateDevice=function () {
    document.location="/app/devcalib.cgi?device_idx="+$scope.device_index;
  }
  $scope.makeIdx=function(index) {
    return Math.floor(index/2);
  }
   $scope.saveSettings=function () {
      $scope.successmsg="";
      $scope.errormsg="";
      $scope.infomsg="";
      output="save=1";
      $scope.loading=1;
      //$scope.mul_v0 = ieee754_from_int($scope.rwfields[1].value,$scope.rwfields[0].value);
      
      tmp =ieee754_to_int($scope.mul_v0);
      $scope.rwfields[1].value = tmp >> 16;
      $scope.rwfields[0].value = tmp & 0xFFFF;

        // chan 1

      tmp =ieee754_to_int($scope.chan0_vmul);
      $scope.rwfields[4].value = tmp >> 16;
      $scope.rwfields[3].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan0_amul);
      $scope.rwfields[6].value = tmp >> 16;
      $scope.rwfields[5].value = tmp & 0xFFFF;
      $scope.rwfields[7].value = $scope.chan0_mode;
      tmp =ieee754_to_int($scope.chan0_range_min);
      $scope.rwfields[9].value = tmp >> 16;
      $scope.rwfields[8].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan0_sensor_min);
      $scope.rwfields[11].value = tmp >> 16;
      $scope.rwfields[10].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan0_range_max);
      $scope.rwfields[13].value = tmp >> 16;
      $scope.rwfields[12].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan0_sensor_max);
      $scope.rwfields[15].value = tmp >> 16;
      $scope.rwfields[14].value = tmp & 0xFFFF;
      


  // chan 2

      tmp =ieee754_to_int($scope.chan1_vmul);
      $scope.rwfields[18].value = tmp >> 16;
      $scope.rwfields[17].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan1_amul);
      $scope.rwfields[20].value = tmp >> 16;
      $scope.rwfields[19].value = tmp & 0xFFFF;
      $scope.rwfields[21].value = $scope.chan1_mode;
      tmp =ieee754_to_int($scope.chan1_range_min);
      $scope.rwfields[23].value = tmp >> 16;
      $scope.rwfields[22].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan1_sensor_min);
      $scope.rwfields[25].value = tmp >> 16;
      $scope.rwfields[24].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan1_range_max);
      $scope.rwfields[27].value = tmp >> 16;
      $scope.rwfields[26].value = tmp & 0xFFFF;
      
      tmp =ieee754_to_int($scope.chan1_sensor_max);
      console.log(tmp+" "+(tmp >> 16)+" "+(tmp & 0xFFFF));
      $scope.rwfields[29].value = tmp >> 16;
      $scope.rwfields[28].value = tmp & 0xFFFF;
      console.log($scope.rwfields[29].value+" "+$scope.rwfields[28].value);
      
      
       // chan 3

      tmp =ieee754_to_int($scope.chan2_vmul);
      $scope.rwfields[32].value = tmp >> 16;
      $scope.rwfields[31].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan2_amul);
      $scope.rwfields[34].value = tmp >> 16;
      $scope.rwfields[33].value = tmp & 0xFFFF;
      $scope.rwfields[35].value = $scope.chan2_mode;
      tmp =ieee754_to_int($scope.chan2_range_min);
      $scope.rwfields[37].value = tmp >> 16;
      $scope.rwfields[36].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan2_sensor_min);
      $scope.rwfields[39].value = tmp >> 16;
      $scope.rwfields[38].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan2_range_max);
      $scope.rwfields[41].value = tmp >> 16;
      $scope.rwfields[40].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan2_sensor_max);
      $scope.rwfields[43].value = tmp >> 16;
      $scope.rwfields[42].value = tmp & 0xFFFF;
      
      
       // chan 4

      tmp =ieee754_to_int($scope.chan3_vmul);
      $scope.rwfields[46].value = tmp >> 16;
      $scope.rwfields[45].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan3_amul);
      $scope.rwfields[48].value = tmp >> 16;
      $scope.rwfields[47].value = tmp & 0xFFFF;
      $scope.rwfields[49].value = $scope.chan3_mode;
      tmp =ieee754_to_int($scope.chan3_range_min);
      $scope.rwfields[51].value = tmp >> 16;
      $scope.rwfields[50].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan3_sensor_min);
      $scope.rwfields[53].value = tmp >> 16;
      $scope.rwfields[52].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan3_range_max);
      $scope.rwfields[55].value = tmp >> 16;
      $scope.rwfields[54].value = tmp & 0xFFFF;
      tmp =ieee754_to_int($scope.chan3_sensor_max);
      $scope.rwfields[57].value = tmp >> 16;
      $scope.rwfields[56].value = tmp & 0xFFFF;
      
      $scope.rwfields[58].value = $scope.counter0>0?16:0;
      $scope.rwfields[59].value = $scope.counter1>0?16:0;
      $scope.rwfields[60].value = $scope.counter2>0?16:0;
      $scope.rwfields[61].value = $scope.counter3>0?16:0;
      
      for (i=0;i<$scope.rwfields.length;i++) {
          //if ($scope.rwfields[i].original != $scope.rwfields[i].value) {
              output=output+"&"+$scope.rwfields[i].fieldname+"="+$scope.rwfields[i].value;
          //}
      }
      //alert(output);
//      $scope.form.$setPristine();
      $http.post('/app/devcalib_ajax.cgi?action=save&device_idx='+$scope.device_index,output)
        .then(function (response) {
        //alert(response.data);
          var data = response.data;
          //alert(data);
          $scope.loading=0;
          if (data.status)
            $scope.successmsg="Settings saved.";
          else {
            $scope.errormsg=data.error;
          }
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.loading=0;
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
   
  
  $scope.$watch('device_index', function(devindex) {
    
        $scope.asyncData=dataService.async(devindex,1)  
        $scope.curDevIndex=devindex;
        
  });
  //poll();
 }
</script>
