<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : about.cgi
 * 
 *  Description: About page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *			16/06/14    v1.1 - added net statistics
 * Ruchir Sharma        17/10/17    v1.2
 * Akash Heimlich       19/06/18    v2.0    WattmonOS 3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="NetworkCtrl"; 
$title='About';
include("/app/header.inc");
?>
<style type='text/css'>
.row-fluid {
    display: flex;
    flex-wrap: wrap;
    }
.span6 {
    width:50%;
    display:inline-block;
}
</style>
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','about')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-group"></i> <? print(lang('PAGE_TITLE','about')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','about')) ?></a>
  </li>

</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
     <div class="card card-body">
  <? print(lang('HELP1','about')) ?><br>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('SYSTEM_INFORMATION','about')) ?></h5>
        <p class="card-text">    
    <? 
    print("<div class='row'><div class='col-4'>Application</div><div class='col-8'>".$_GLOBALS['APP_INFO']."</div></div>");
    print("<h5>Memory</h5>");
if (($_SERVER['HW_PLATFORM']==8) ||($_SERVER['HW_PLATFORM']==9) ||($_SERVER['HW_PLATFORM']==10) || ($_SERVER['HW_PLATFORM']==11) || ($_SERVER['HW_PLATFORM']==12)) {
    print("<div class='row'><div class='col-4'>Total RAM</div><div class='col-8'>512000 bytes</div></div>");
} else if (($_SERVER['HW_PLATFORM']>=20)) {
    print("<div class='row'><div class='col-4'>Total RAM</div><div class='col-8'>32 MB</div></div>");
}
else {
    
    print("<div class='row'><div class='col-4'>Total RAM</div><div class='col-8'>128000 bytes</div></div>");
}
if (($_SERVER['HW_PLATFORM']>=20)) {
    print("<div class='row'><div class='col-4'>Available RAM</div><div class='col-8'>".intval(freemem()/1024)." KB</div></div>");
} else {
    print("<div class='row'><div class='col-4'>Available RAM</div><div class='col-8'>".freemem()." bytes</div></div>");
}
    print("<h5>SD Card</h5>");
    print("<div class='row'><div class='col-4'>Total Space</div><div class='col-8'>".intval(disk_total_space(0)/1024)." MB</div></div>");
    print("<div class='row'><div class='col-4'>Free Space</div><div class='col-8'>".intval(disk_free_space(0)/1024)." MB</div></div>");


    
if ($_SERVER['HW_PLATFORM']==11) {
        print("<h5>Internal Flash</h5>");
    print("<div class='row'><div class='col-4'>Total Space</div><div class='col-8'>".intval(disk_total_space(1))." KB</div></div>");
    print("<div class='row'><div class='col-4'>Free Space</div><div class='col-8'>".intval(disk_free_space(1))." KB</div></div>");

}
    print("<h5>Hardware</h5>");    
if (($_SERVER['HW_PLATFORM']==8) ||($_SERVER['HW_PLATFORM']==9) || ($_SERVER['HW_PLATFORM']==10)|| ($_SERVER['HW_PLATFORM']==11)|| ($_SERVER['HW_PLATFORM']==12)) {
    print("<div class='row'><div class='col-4'>Processor</div><div class='col-8'>PIC32MZ2048EFH064</div></div>");
} else if ($_SERVER['HW_PLATFORM']==12 ) {
    print("<div class='row'><div class='col-4'>Processor</div><div class='col-8'>ESP32</div></div>");
} else if ($_SERVER['HW_PLATFORM']>=20 ) {
    print("<div class='row'><div class='col-4'>Processor</div><div class='col-8'>PICMZ2064DAR176</div></div>");
} else {
    print("<div class='row'><div class='col-4'>Processor</div><div class='col-8'>PIC32MX795</div></div>");
}
print("<div class='row'><div class='col-4'>Ethernet MAC</div><div class='col-8'>".getmac()."</div></div>");

if (($_SERVER['HW_PLATFORM']==11)) {
    $wifi=getwifistat();
    print("<div class='row'><div class='col-4'>Wi-Fi MAC</div><div class='col-8'>".$wifi['mac']."</div></div>");
}

$net3g=get3gstat();

if ($net3g['imei']) {
    print("<div class='row'><div class='col-4'>IMEI</div><div class='col-8'>".$net3g['imei']."</div></div>");
}

?>
    </p>
    </div>
</div>
<br>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('FIRMWARE','about')) ?></h5>
        <p class="card-text">    
<?
    print(phpinfo()); 
?>
    </p>
    </div>
</div>

<br>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('NETWORK_STATS','about')) ?></h5>
        <p class="card-text">    
<pre>
<?

    $arr=netstat();
        print("ID ");
        printf("%4s","STA");
        print(" ");
        printf("%14s","IP");
        print(" ");
        printf("%50s","INFO");
        //print("  ");
        print("\r\n");
    
    for ($i=0;$i<$arr['max_http_connections'];$i++) {
        printf("%4d",$i);
        print(" ");
        printf("%4d",$arr['conn'.$i.'_stage']);
        print(" ");
        printf("%14s",$arr['conn'.$i.'_remote']);
        print(" ");
        //printf("%50s",$arr['conn'.$i.'_info']);
        $info=explode($arr['conn'.$i.'_info'],"|");
        //print_r($info);
        $s=explode($info[0],":");
        //print_r($s);
        if ($s[1]=='0') print("CL "); else print("OP ");
        $s=explode($info[1],":");
        if ($s[1]=='0') print("   "); else print("AB ");
        $s=explode($info[2],":");
        if ($s[1]=='0') print("   "); else print("PR ");
        $s=explode($info[4],":");
        printf("%30s",$s[1]);
        $s=explode($info[5],":"); // type
        printf("%3s",$s[1]);
        $s=explode($info[9],":"); // socket
        $type=intval($s[1]);
        if ($type==0) printf("+s","GET_DNS");
        if ($type==1) printf("+s","DNS RESOLVE");
        if ($type==2) printf("+s","GW_SEND_ARP");
        if ($type==3) printf("+s","GW_GET_ARP");
        if ($type==4) printf("+s","TCP_LISTEN");
        if ($type==5) printf("+s","TCP_SYN_SENT");
        if ($type==6) printf("+s","TCP_SYN_RCVD");
        if ($type==7) printf("+s","TCP_ESTABLISHED");
        if ($type==8) printf("+s","TCP_FIN_WAIT1");
        if ($type==9) printf("+s","TCP_FIN_WAIT2");
        if ($type==10) printf("+s","TCP_CLOSING");        
        if ($type==11) printf("+s","TCP_CLOSE_WAIT");
        if ($type==12) printf("+s","TCP_LAST_ACK");
        if ($type==13) printf("+s","TCP_CLOSED");
        if ($type==14) printf("+s","TCP_CLOSED_RES");

        print("\r\n");
    }    
    print("</pre>");
?>
    </p>
    </div>
</div>

<br>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('PROCESSES','about')) ?></h5>
        <p class="card-text">    
<pre>
<?
    $arr=process_list();
        print("PID ");
        printf("%30s","SCRIPT");
        print("  ");
        print("FLG ");
        print("  ");
        print("LINE ");
        print("  ");
        print("RUN MS");
        print("\r\n");
    
    //print($arr['filename']."\r\n");
    //print_r($arr);
    for ($i=0;$i<sizeof($arr);$i++) {
        $ms=microtime()-intval($arr[$i]['start']);
        printf("%04d",$arr[$i]['pid']);
        printf("%30s",$arr[$i]['script']);
        print("  ");
        printf("%04d",$arr[$i]['flags']);
        print("  ");
        printf("%04d",$arr[$i]['line']);
        print("   ");
        printf("%04d",$ms);
        print("\r\n");
    }
    
    ?></pre>
    </p>
    </div>
</div>
</form>
      
      
<script type='text/javascript'>
var app = angular.module('myApp', []);

/**
* Network controller object used by Angular.JS
* @param $scope Application scope
* @param $http  HTTP object used for ajax requests
*/
function NetworkCtrl($scope,$http) {
    var self = this;
    $scope.infomsg="";
    
    

    /**
    * Posts settings to networksave.cgi and processes the response
    */
    $scope.saveSettings=function () {
        $scope.successmsg="";
        $scope.errormsg="";
        $scope.infomsg="";
        $http.post('/app/configsave.cgi?config=3g.ini&section=3g',"apn="+$scope.apn+"&username="+$scope.username3g+"&password="+$scope.password3g)
        .then(function (response) {
          var data = response.data;      
          $scope.successmsg=(data.status==1)?"Saved Settings":"";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });

    }
}
</script>
<? include("/app/footer.inc"); ?>









