<div ng-controller='ChargeCtrl' ng-cloak>
<h3><img ng-src="{{solar_icon}}" ng-show="solar_icon"><img ng-src="{{grid_icon}}" ng-show="grid_icon"> Charge</h3>
<table class='table table-striped' ng-repeat='item in livedata.grp' ng-show='item.show == 1'>
    <tr ng-show='item.wd_in>0'><td>{{item.name}} In Today</td><td><strong>{{item.wd_in/1000|number:3}} kWh </strong></td></tr>
    <tr ng-show='item.c>0'><td>{{item.name}} Charge</td><td><strong>{{item.c|number:2}} A ({{item.w_in|number:0}} W)</strong></td></tr>
</table>    

<table class='table table-striped'>
    <tr ng-show="livedata.wind_speed>0"><td class='span4'>Wind Speed</td><td class='span8'><strong>{{livedata.wind_speed}} m/s</strong></td></tr>
</table>
</div>
<script>function ChargeCtrl($scope,$http) {
    $scope.solar_icon="";
    $scope.grid_icon="";
   
    
    $scope.calcWidth=function(barpos,perc) {
        perc=Number(perc);
        switch (barpos) {
            case 1: if (perc < 50) return perc; else return 50;
                    break;
            case 2: if (perc < 50) return 0; 
                    if (perc < 75) return (perc-50);
                    break;                    
            case 3: if (perc < 75) return 0; 
                    return (perc-75);
                    break;
                    
        }
        return 0;
    }
    
    $scope.$watch('livedata', function(liveData) {        
        if (liveData.solar_charge_current>0) {
            $scope.solar_icon="img/sun.png";
        } else $scope.solar_icon="";
        if (liveData.grid_charge_current>0) {
            $scope.grid_icon="img/plug.png";
        } else $scope.grid_icon="";
        
        $scope.liveData=liveData;
        if (!$scope.liveData) return;
        var st="";
       
        var containerElement = angular.element(document.getElementById('stateid'));
        
       containerElement.html('').append(st);
        
        
    });
}
</script>