<?
/**
 * @package WS102
 * @author Akash Heimlich
 * @description Wind Speed
 * @version 1.0
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function WS102_install($val) {
        WS102_enable();
        return 1;
    }
     
    function WS102_uninstall() {
        setPackageStatus("WS102",0);
        return 1;
    }
    
    function WS102_enable() {
        setPackageStatus("WS102",2);
        //addWidget("/package/WS102.inc","WS102",4,"icon-play",1,0); // enable
        
        $num_dev=mb_num_devices();
        $found_index=-1;
        $found_id=-1;
        for ($i=0; $i < $num_dev; $i++) {
            $dev=mb_get_dev_by_index($i);
            if ($dev['device_type_id']==8011) {
                $found_index=$i;
                $found_id=$dev['slave_id'];
            }
        }
        if ($found_index==-1) {
            $res=mb_add_dev(201,8011,"WS102",1000,1,100);
            if (!$res) {
                $_GLOBALS['ws_idx']=mb_num_devices()-1;
                $_GLOBALS['ws_id']=201;
            } else {
                log("Unable to add virtual device");
            }
        } else {
            $_GLOBALS['ws_idx']=$found_index;
            $_GLOBALS['ws_id']=$found_id;
            mb_set_dev_var($_GLOBALS['ws_id'],"status",1);
        }
        return 1;
    }
    
    function WS102_disable() {
        setPackageStatus("WS102",3);
        //addWidget("/package/WS102.inc","WS102",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function WS102_init() {
        $prefix='';
        if ($_SERVER['HW_PLATFORM']==11) {
            $prefix='0:';
        }
        if ($_SERVER['HW_PLATFORM']>=20)   // ULTRA
            $prefix=intval($_GLOBALS['log_drive']).':';  
        // load the test Value into the globals
        $_GLOBALS['ws_mul']=ini_get("/config/WS102.ini","config","ws_mul",600);
        // the role id if set will be used, otherwise the A3 input will be used.
        $_GLOBALS['ws_channel']=ini_get("/config/WS102.ini","config","ws_channel",1);
        
        $_GLOBALS['ws_raw']=ini_get($prefix."/logs/WS102.ini","config","ws_raw",0);
        $_GLOBALS['ws_mins']=ini_get($prefix."/logs/WS102.ini","config","ws_mins",0);
        $_GLOBALS['ws_rawtoday']=ini_get($prefix."/logs/WS102.ini","config","ws_rawtoday",0);
        
        $_GLOBALS['ws_total']=$_GLOBALS['ws_raw']*$_GLOBALS['ws_mul'];
        $_GLOBALS['ws_today']=$_GLOBALS['ws_raw_today']*$_GLOBALS['ws_mul'];
        
        if (!$arr['di'.$_GLOBALS['ws_channel'].'_counter_enabled']) {
                mb_set_dev_var($arr['name'],'di'.$_GLOBALS['ws_channel'].'_counter_enabled',16);
                //$err.="Counter 1 is disabled in hardware. ";
        }    
        $num_dev=mb_num_devices();
        $found_index=-1;
        $found_id=-1;
        for ($i=0; $i < $num_dev; $i++) {
            $dev=mb_get_dev_by_index($i);
            if ($dev['device_type_id']==8011) {
                $found_index=$i;
                $found_id=$dev['slave_id'];
            }
        }
        if ($found_index==-1) {
            $res=mb_add_dev(201,8011,"WS102",1000,1,100);
            if (!$res) {
                $_GLOBALS['ws_idx']=mb_num_devices()-1;
                $_GLOBALS['ws_id']=201;
            } else {
                log("Unable to add virtual device");
            }
        } else {
            $_GLOBALS['ws_idx']=$found_index;
            $_GLOBALS['ws_id']=$found_id;
            mb_set_dev_var($_GLOBALS['ws_id'],"status",1);
        }
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/WS102.cgi?action=configure';
        $arr['title']='WS102';
        $arr['icon']='icon-hdd';
        $arr['desc']='WS-102 Anemometer Settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/WS102Ajax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/WS102Ajax.inc';

        // runs this file once a second
        if (file_exists('/package/WS102Sec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/WS102Sec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/WS102Min.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/WS102Min.inc';
            
        // runs this file once a day
        if (file_exists('/package/WS102Day.inc')) 
            $_GLOBALS['hooks']['day'][]='/package/WS102Day.inc';            
        return 1;
    }
    
    function WS102_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="WS102"; 
        $title='Configure Package WS102';
        $config_file="WS102.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/pacman.cgi">Packages</a></li>
    <li class="breadcrumb-item active" aria-current="page">WS-102</li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-group"></i> WS-102 Anemometer Sensor</h2>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/pacman.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','user')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  The WS102 sensor needs to be connected to a pulse counting input (DI1-DI3) on the WattmonPRO or WattmonMEGA.  Select the channel used in the settings below.
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
			

        </div><!--/span-->
      </div><!--/row-->
      
<div ng-init="ws_mul=<? print(ini_get("/config/".$config_file,"config","ws_mul",0.9)); ?>;">
<div ng-init="ws_channel=<? print(ini_get("/config/".$config_file,"config","ws_channel",0)); ?>;">

<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Sensor Calibration</h5>
        <p class="card-text">    

          <div class="form-group">
            <label for="pyra_mul">Scale Factor</label>
            <input type="number" class="form-control" id="ws_mul" ng-model="ws_mul" aria-describedby="userHelp" placeholder="Enter scale factor">
            <small id="userHelp" class="form-text text-muted">The measured pulse rate will be multiplied by this to obtain the wind speed value</small>
          </div>
          <div class="form-group">
            <label for="pyra_role">Channel</label>
            <select ng-model="ws_channel" name='ws_channel' class="custom-select custom-select-sm">
                <option value="1">DI1</option>
                <option value="2">DI2</option>
                <option value="3">DI3</option>
            </select>
            <small id="langH" class="form-text text-muted">Select which digital input the sensor is wired to</small>
          </div>
        </p>
    </div>
</div>
<br/>

        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function WS102($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="ws_mul="+$scope.ws_mul+
                "&ws_channel="+$scope.ws_channel;
       post_config="WS102.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
       <?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>



