<?
/**
 * @package InvError
 * @author Akash Heimlich
 * @description Create alerts based on inverter error codes
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function InvError_install($val) {
        InvError_enable();
        return 1;
    }
     
    function InvError_uninstall() {
        setPackageStatus("InvError",0);
        return 1;
    }
    
    function InvError_enable() {
        setPackageStatus("InvError",2);
        return 1;
    }
    
    function InvError_disable() {
        setPackageStatus("InvError",3);
        return 1;
    }
    
    /* this is called at system boot */
    function InvError_init() {
        $_GLOBALS['inv_log_level']=ini_get("/config/InvError.ini","config","log_level",4);
        $_GLOBALS['inv_log_offline']=ini_get("/config/InvError.ini","config","log_offline",4);
          $arr=array();
        $arr['script']='/package/InvError.cgi?action=configure';
        $arr['title']='Inverter Error';
        $arr['icon']='icon-hdd';
        $arr['desc']='Inverter Error Alert Settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        // generate ajax data for front end processing
        if (file_exists('/package/InvErrorAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/InvErrorAjax.inc';

        // runs this file once a second
        if (file_exists('/package/InvErrorSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/InvErrorSec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/InvErrorMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/InvErrorMin.inc';
            
        // runs this file once a day
        if (file_exists('/package/InvErrorDay.inc')) 
            $_GLOBALS['hooks']['day'][]='/package/InvErrorDay.inc';            
            
        return 1;
    }
    
    function InvError_configure() {
        
      include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="InvError"; 
        $title='Configure Package InvError';
        $config_file="InvError.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> 
        
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page">Inverter Error</li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-group"></i> Inverter Error</h2>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','user')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<!-- VARIABLES -->
<div ng-init="log_level='<? print(ini_get("/config/".$config_file,$config_section,"log_level","")); ?>';">
<div ng-init="log_offline=<? print(ini_get("/config/".$config_file,$config_section,"log_offline",60)); ?>;">


<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('ADMIN_SETTINGS','user')) ?></h5>
        <p class="card-text">    

          <div class="form-group">
            <label for="log_level">Log level</label>
            <input type="text" class="form-control" id="log_level" ng-model="log_level" aria-describedby="userHelp" placeholder="Enter log level">
            <small id="userHelp" class="form-text text-muted">Log level (0=all, 1=warnings, 2=medium, 3=errors, 4=criticial, 5=none)</small>
          </div>
          <div class="form-group">
            <label for="log_offline">Log when offline</label>
            <input type="number" class="form-control" ng_model="log_offline" id="log_offline" aria-describedby="userHelp2"  placeholder="Offline notify interval">
            <small id="userHelp2" class="form-text text-muted">Log when inverter offline more than x minutes</small>
          </div>
        </p>
    </div>
</div>
<br/>
</form>	
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function InvError($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="log_level="+$scope.log_level;
       post_data+="&log_offline="+$scope.log_offline;
       post_config="InvError.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
       <?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>



