<?
/**
 * @package EmailReport
 * @author Akash Heimlich
 * @description This dummy widget shows the basic functionality of widgets and can be used as a starting point
 * for further development
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function EmailReport_install($val) {
        EmailReport_enable();
        return 1;
    }
     
    function EmailReport_uninstall() {
        setPackageStatus("EmailReport",0);
        return 1;
    }
    
    function EmailReport_enable() {
        setPackageStatus("EmailReport",2);
        
        ini_set("/config/uphp.ini","debug","call_depth",25);
        ini_set("/config/uphp.ini","debug","stack_size",5000);
        log("Updated uPHP setting for call depth and stack size");
        $_GLOBALS['need_reboot']=1;
        
        return 1;
    }
    
    function EmailReport_disable() {
        setPackageStatus("EmailReport",3);
//        addWidget("/package/EmailReport.inc","EmailReport",4,"icon-play",1,1); // disable
        return 1;
    }
    function EmailReport_preview() {
        $preview=1;
        include("/package/emailreport/EmailReportMin.inc");
        
    }
    function EmailReport_send() {
        $_GET['force']=1;
        include("/package/emailreport/EmailReportMin.inc");
        
    }
    /* this is called at system boot */
    function EmailReport_init() {
        
        // load the test Value into the globals
        $_GLOBALS['emailreport_minute']=ini_get("/config/EmailReport.ini","config","minute",18);
        $_GLOBALS['emailreport_hour']=ini_get("/config/EmailReport.ini","config","hour",30);
        
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/EmailReport.cgi?action=configure';
        $arr['title']='Email Report';
        $arr['icon']='icon-hdd';
        $arr['desc']='Report settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/emailreport/EmailReportAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/emailreport/EmailReportAjax.inc';

        // runs this file once a second
        if (file_exists('/package/emailreport/EmailReportSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/emailreport/EmailReportSec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/emailreport/EmailReportMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/emailreport/EmailReportMin.inc';
            
        // runs this file once a day
        if (file_exists('/package/emailreport/EmailReportDay.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/emailreport/EmailReportDay.inc';            
        return 1;
    }
    
    function EmailReport_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="EmailReport"; 
        $title='Configure Package EmailReport';
        $config_file="EmailReport.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> 
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page">Email Report</li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-group"></i>Email Report</h2>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="window.open('/package/EmailReport.cgi?action=preview','_blank');"><i class="icon-eye-open"></i> Preview</a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="window.open('/package/EmailReport.cgi?action=send','_blank');"><i class="icon-envelope"></i> Send Now</a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','user')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <h4>Daily Email Report</h4>Configure daily email sending options here.  Please note that email SMTP details are taken from the Email settings page in the Control Panel<br>
    All tags are enclosed in double curly braces { { and }}.<p>Tags:
    <table border=1>
    <tr><td><pre><strong>DATE('format','offset')</strong></pre></td><td>Get a formatted date.<br>Parameters:<p>
    <strong>format</strong> - php strftime compatible date time string<br>
    <strong>offset</strong> - optional offset from current day backwards in time '1 DAY','1 WEEK','2 DAYS'<br>
    </td>
    </tr>

    <tr><td><pre><strong>DIFF('role','period','offset',max)</strong></pre></td><td>Get the difference between start and end value.<br>Parameters:<p>
    <strong>role</strong> - string name of the data point(i.e. 'inverter1_kWh_Total_Active')<br>
    <strong>period</strong> - period for the data (between values).  Allowed are: x DAY(s), WEEK, MONTH, YEAR. i.e '1 DAY'<br>
    <strong>offset</strong> - offset from current day backwards in time '1 DAY','1 WEEK','2 DAYS'<br>
    <strong>max</strong> - maximum value for the result, if it is more the value will become 0<br>
    </td>
    </tr>
    <tr><td><pre><strong>FIRST('role','offset',max)</strong></pre></td><td>Get the first value for the date.<br>Parameters:<p>
    <strong>role</strong> - string name of the data point(i.e. 'inverter1_kWh_Total_Active')<br>
    <strong>offset</strong> - offset from current day backwards in time '1 DAY','1 WEEK','2 DAYS'<br>
    <strong>max</strong> - maximum value for the result, if it is more the value will become 0<br>
    </td>
    </tr>
    
    <tr><td><pre><strong>LAST('role','offset',max)</strong></pre></td><td>Get the last value for the date.<br>Parameters:<p>
    <strong>role</strong> - string name of the data point(i.e. 'inverter1_kWh_Total_Active')<br>
    <strong>offset</strong> - offset from current day backwards in time '1 DAY','1 WEEK','2 DAYS'<br>
    <strong>max</strong> - maximum value for the result, if it is more the value will become 0<br>
    </td>
    </tr>
    <tr><td><pre><strong>MBVAR('devicename','rolename')</strong></pre></td><td>Get a role value from a device.<br>Parameters:<p>
    <strong>devicename</strong> - string name of the device (i.e. 'meter1')<br>
    <strong>rolename</strong> - name of the role (i.e. 'serial')<br>
    </td>
    </tr>

    </table>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<!-- VARIABLES -->
<div ng-init="report_enabled=<? print(ini_get("/config/".$config_file,$config_section,"report_enabled","0")); ?>;">
<div ng-init="to='<? print(ini_get("/config/".$config_file,$config_section,"to","")); ?>';">
<div ng-init="title='<? print(ini_get("/config/".$config_file,$config_section,"title","")); ?>';">
<div ng-init="template='<? print(ini_get("/config/".$config_file,$config_section,"template","/packate/emailreport/template/default.txt")); ?>';">
<div ng-init="hour=<? $_GLOBALS['emailreport_minute']=ini_get("/config/EmailReport.ini","config","minute",18);
        $_GLOBALS['emailreport_hour']=ini_get("/config/EmailReport.ini","config","hour",30);
        print(ini_get("/config/".$config_file,$config_section,"hour","18")); ?>;">
<div ng-init="minute=<? print(ini_get("/config/".$config_file,$config_section,"minute","30")); ?>;">



<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Report Settings</h5>
        <p class="card-text">    
           <div class="form-group">
                <label for="report_enabled">Daily report status</label>
                <select ng-model="report_enabled" name='report_enabled' class="custom-select custom-select-sm">
                    <option value='0'>Disabled</option>
                    <option value='1'>Enabled</option>
                </select>
                <small id="langH" class="form-text text-muted"><? print(lang('KIOSK_HELP','user')) ?></small>
           </div>
          <div class="form-group">
            <label for="to">Recipient Email</label>
            <input type="text" class="form-control" id="to" ng-model="to" aria-describedby="userHelp" placeholder="Enter email">
            <small id="userHelp" class="form-text text-muted">Email address of recipient</small>
          </div>
          <div class="form-group">
            <label for="title">Report Title</label>
            <input type="text" class="form-control" id="title" ng-model="title" aria-describedby="userHelp" placeholder="Enter title">
            <small id="userHelp" class="form-text text-muted">Email report title</small>
          </div>
          <div class="form-group">
          
            <label for="ttemplateo">Template File</label>
            <div class="form-row" style='line-height:40px'>
                <div class="col-6">
                <input type="text" class="form-control" id="template" ng-model="template" aria-describedby="userHelp" placeholder="Enter filename">
                </div>
                <div class='col-1'>
                <a class="nav-link" ng-click='edit();'><i class="icon-eye-open"></i> Edit</a>
                </div>
                </div>
            <small id="userHelp" class="form-text text-muted">Full path and filename for report template</small>
          </div>
          <div class="form-group" >
                <label for="hour">Report Time</label>
                <div class="form-row" style='line-height:40px'>
                    <div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="hour" name='hour' min="0" max="23" integer required>
                    </div>:<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="minute" name='minute' min="0" max="59" integer required>
                    </div>
                    
              </div>
               <div ng-cloak class='small text-danger' ng-show="form.hour.$invalid || form.minute.$invalid"><strong>Enter a valid time</strong></div>
            <small id="dtHelp" class="form-text text-muted">Enter hour and minute for report to be sent</small>
          </div>
        </p>
    </div>
</div>

							  
</form>
			

        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function EmailReport($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.edit=function() {
        i=$scope.template.lastIndexOf('/')+1;
        dir=$scope.template.substr(0,i);
        fn=$scope.template.substr(i);
        window.open('/app/edit.cgi?dir='+dir+'&fn='+fn,'_blank');
   }
   $scope.saveSettings=function() {
       post_data="to="+$scope.to+
                "&title="+$scope.title+
                "&template="+$scope.template+
                "&hour="+$scope.hour+
                "&minute="+$scope.minute+
                "&report_enabled="+$scope.report_enabled;
       post_config="EmailReport.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>


