var graphinstanceid=0;
function GraphCtrl($scope) {
    $scope.graphArr=[]
    solar_charge_arr  = [];
    lastData=[];
    grid_charge_arr  = [];
    grid_discharge_arr  = [];
    scope=$scope;
    $scope.graphinstanceid="graph"+graphinstanceid++
    max=2;
    // Pre-pad the arrays with 250 null values
    for (var i=0; i<250; ++i) {
        solar_charge_arr.push(0);
        grid_charge_arr.push(0);
        grid_discharge_arr.push(0);
    }
    function getGraph(id, idx,d,w)
    {
       // alert('graph new');
        idx=Number(idx);
        // After creating the chart, store it on the global window object
        if (!scope.graphArr[idx]) {
            if (w!=null)
                b = new RGraph.Line(id, d, w);
            else b = new RGraph.Line(id, d);    
         
            b.Set('chart.yaxispos', 'right');
            b.Set('chart.xaxispos', 'center');
            
            b.Set('chart.title.yaxis.pos', 0.5);
            b.Set('chart.title.xaxis.pos', 0.5);
            b.Set('chart.xticks', 100);
            b.Set('chart.filled', true);
            //b.Set('chart.colors', ['black','gree','red']);
            b.Set('ymax', 30);
            b.Set('background.grid', false);
            b.Set('hmargin', 5);
            b.Set('ylabels', false);
            b.Set('noaxes', true);            
            var grad = b.context.createLinearGradient(0,0,0,250);
            if (idx==0) {
                b.Set('colors', ['green']);
                b.Set('chart.colors', ['black','green']);
                grad.addColorStop(0, '#00ff00');
                grad.addColorStop(0.9, 'rgba(0,0,0,0)');
                b.Set('chart.title.yaxis', 'Current (Amps)');
            } else {
                b.Set('colors', ['red']);
            
                grad.addColorStop(0, '#00ff00');//'#efefef');
                grad.addColorStop(0.9, 'rgba(0,0,0,0)');
            
            }

            b.Set('chart.fillstyle', [grad]);
            scope.graphArr.push(b);
        } else {
          //alert("got  graph");
        }

        return scope.graphArr[idx];
    }
    function updateGraph ()
    {
        //c=$(scope.$element).find(scope.graphinstanceid);
        //alert(c.length);
        RGraph.Clear(document.getElementById(scope.graphinstanceid));
        $scope.width=($("#"+scope.graphinstanceid).parent().innerWidth());
        $scope.height=200;//($("#"+scope.graphinstanceid).parent().innerHeight());

        var graph = getGraph(scope.graphinstanceid, 0, solar_charge_arr,grid_charge_arr);
        var graph2 = getGraph(scope.graphinstanceid, 1, grid_discharge_arr);
       // var graph2 = getGraph1('cvs', 1, d3, 1);
        //graph.Draw();
        graph.Set('chart.ymax', max);
        graph2.Set('chart.ymax', max);
        graph2.Draw();
        graph.Draw();
        if (solar_charge_arr.length > 250) {
            solar_charge_arr = RGraph.array_shift(solar_charge_arr);
        }
        if (grid_charge_arr.length > 250) {
            grid_charge_arr = RGraph.array_shift(grid_charge_arr);
        }
         if (grid_discharge_arr.length > 250) {
            grid_discharge_arr = RGraph.array_shift(grid_discharge_arr);
        }

        if (document.all && RGraph.isIE8()) {
            alert('[MSIE] Sorry, Internet Explorer 8 is not fast enough to support animated charts');
        } else {
            scope.graphArr[0].original_data[0] = solar_charge_arr;
            scope.graphArr[0].original_data[1] = grid_charge_arr;
           scope.graphArr[1].original_data[0] = grid_discharge_arr;
        }
    }

    // this is our updater function
    $scope.$watch('livedata', function(liveData) {        
        /**
        * IMPORTANT: Must convert the data (which is a string) to numbers
        */
        //alert("called for "+scope.graphinstanceid);
        if(angular.isDefined(liveData)) {
            solar_charge_current=Math.round(Number(liveData.solar_charge_current)*10)/10;
            grid_charge_current=Math.round(Number(liveData.grid_charge_current)*10)/10;
            grid_discharge_current=Math.round(Number(liveData.grid_discharge_current)*10)/10;
            
            if (solar_charge_current>max) max=Math.ceil(solar_charge_current);
            if (grid_charge_current>max) max=Math.ceil(grid_charge_current);
            if (grid_discharge_current>max) max=Math.ceil(grid_discharge_current);
            if (solar_charge_current+grid_charge_current > max) max=solar_charge_current+grid_charge_current;
            
            solar_charge_arr.push(solar_charge_current);
            grid_charge_arr.push(grid_charge_current);
            grid_discharge_arr.push(-grid_discharge_current);
            updateGraph();
        }
    });
    
    
}



