<?
/*************************************************************************
*
*  MQTT Master
*
*  Usage:  Call this from crontab once per second
*  "	*   *   *   *   /examples/mqtt/mqtt_master.cgi"
*  
* This will take the variables you define in the array below and transmit
* them across the serial RS-485 line so that the matching comm_slave.cgi
* can put them into the $_GLOBALS on that Wattmon.
* 
* Note:  You need to disable modbus polling on the wattmon in Control Panel
*       > Edit Communication Settings
*
* Author:  		Akash Heimlich
* Date: 		02/02/2018
* Revision:		1.0
*
*************************************************************************/

// Enter the variables you wish to push across to the other Wattmon device.
// These need to be in the $_GLOBALS[] array already or else a 0 value will
// be pushed.
include('/examples/mqtt/mqtt_common.inc');

$st="";
for ($i=0;$i<sizeof($variables);$i++) {
	$st.="<". $variables[$i]."=".$_GLOBALS[$variables[$i]] . ">";
}

if ($debug) {
    log("[mqtt] ".$mqtt_master_channel."Sending message ".$st);
    
}

if ($wait_reply) {
    
    $_GLOBALS['mqtt_reply_received']=0;
    $_GLOBALS['mqtt_reply_pending']=1;
    
    $_GLOBALS['mqtt_reply_count']=0;
}

 $_GLOBALS['mqtt_send_time']=microtime();
 
mqtt_publish($mqtt_master_channel,$st);

?>