<?
/*************************************************************************
*
*  MQTT Receive
*
* This gets called when the remote master sends data
*
* Author:  		Akash Heimlich
* Date: 		02/02/2018
* Revision:		1.0
*
*************************************************************************/

// Enter the variables you wish to push across to the other Wattmon device.
// These need to be in the $_GLOBALS[] array already or else a 0 value will
// be pushed.
include('/examples/mqtt/mqtt_common.inc');

$f = fopen("php://stdin","r");
$title=fgets($f); 
$result = fgets($f); // this should be OK if the client responded

if ($result) {
    if ($debug) {
        log("[mqtt] Message received successfully: ".$result);
    }
    
    $len=strlen($result);
    $idx=0;
    $in_key=0;
    $in_val=0;
    while ($len) {
    	$c=substr($result,$idx,1);
    	$idx++;
    	$len--;
    	if ($c=='<') {		// start of key/val pair
    		$in_key=1;
    		$in_val=0;
    		$key='';
    		$val='';
    	} else {
    
    		if ($c=='=') {		// start of key/val pair
    			$in_key=0;
    			$in_val=1;
    		} else {
    
    			if ($c=='>') {		// end of key/val pair
    				if (strlen($key) && $in_val) {
    					$_GLOBALS[$rcv_prefix.$key]=$val;
    					if ($debug) {
    						log("[mqtt] Add ".$rcv_prefix.$key."=".$value);
    					}
    				}
    				$in_key=0;
    				$in_val=0;
    				$key='';
    				$val='';
    			} else {	// just a regular character
    				if ($in_key) $key.=$c;
    				if ($in_val) $val.=$c;
    			}
    		}
    	}
    }

    if ($wait_reply) {
        
        if ($debug) {
            log("[mqtt] Sending OK to ".$mqtt_ack_channel);
        }
        mqtt_publish($mqtt_ack_channel,"OK");
        
    }
}


?>