<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : wifi.cgi
 * 
 *  Description: Wifi settings page 
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013-19 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       04/04/19    v1.0
 * Akash Heimlich       25/04/19    v1.1  
 ********************************************************************/

include("/app/config.inc");
$angular_controller="NetworkCtrl"; 
$title='Wi-Fi Settings';
include("/app/header.inc");
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','wifi')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-group"></i> <? print(lang('PAGE_TITLE','wifi')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','wifi')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked' ng-click="restoreDefaults()" ><i class="icon-cog"></i> <? print(lang('DEFAULTS','wifi')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-show='connect_mode<2' ng-click="scan()" ><i class="icon-cog"></i> <? print(lang('SCAN','wifi')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="restart()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('RESTART','wifi')) ?></a>
  </li>
  
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked' ng-click="saveSettings(0)" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('SAVE','wifi')) ?></a>
  </li>
  
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked' ng-click="saveSettings(1)" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('SAVE_APPLY','wifi')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  <? print(lang('HELP1','wifi')) ?><br>
  <? print(lang('HELP2','wifi')) ?><br>
  <? print(lang('HELP3','wifi')) ?><br>
  <? print(lang('HELP4','wifi')) ?><br>
  <? print(lang('HELP5','wifi')) ?><br>
  
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','wifi')) ?></div>

<!--VARIABLES-->

<? 
if (nvram_get("use_nvram")!=1) {
  $ip=ini_get("/config/wifi.ini","network","ip","0.0.0.0");
  $iparr=explode($ip,".");
  $netmask=ini_get("/config/wifi.ini","network","netmask","0.0.0.0");
  $nmarr=explode($netmask,".");
  $gw=ini_get("/config/wifi.ini","network","gateway","0.0.0.0");
  $gwarr=explode($gw,".");
  $dns=ini_get("/config/wifi.ini","network","dns","0.0.0.0");
  $dnsarr=explode($dns,".");
  $wifi_enabled=ini_get("/config/wifi.ini","network","enabled",0);
  $dhcp_enabled=ini_get("/config/wifi.ini","network","dhcp_enabled",1);
  $connect_mode=ini_get("/config/wifi.ini","network","connect_mode",0);
  $auth_mode=ini_get("/config/wifi.ini","network","auth_mode",0);
  $ssid=ini_get("/config/wifi.ini","network","ssid","");
  $password=ini_get("/config/wifi.ini","network","password","");
  $ap_dhcp_enabled=ini_get("/config/wifi.ini","network","ap_dhcp",0);
  $ap_channel=ini_get("/config/wifi.ini","network","ap_channel",1);
  $ap_ip=ini_get("/config/wifi.ini","network","ap_ip","192.168.4.1");
  $ap_iparr=explode($ap_ip,".");
  $ap_connect_mode=ini_get("/config/wifi.ini","network","ap_connect_mode",0);
  $ap_auth_mode=ini_get("/config/wifi.ini","network","ap_auth_mode",0);
  $ap_ssid=ini_get("/config/wifi.ini","network","ap_ssid","wattmon");
  $ap_password=ini_get("/config/wifi.ini","network","ap_password","");
  
  
} else {
  $ip=nvram_get("net_ip","0.0.0.0");
  $iparr=explode($ip,".");
  $netmask=nvram_get("net_netmask","0.0.0.0");
  $nmarr=explode($netmask,".");
  $gw=nvram_get("net_gateway","0.0.0.0");
  $gwarr=explode($gw,".");
  $dns=nvram_get("net_dns1","0.0.0.0");
  $dnsarr=explode($dns,".");
  $dhcp_enabled=nvram_get("net_dhcp",1);
  
  
}

    $arr=getwifistat();
    $dhcp_ip=$arr['ip_address'];
    $dhcp_gw=$arr['gateway'];


?>
<div ng-init="scan_index=0;"></div>
<div ng-init="dhcp_enabled=<? print($dhcp_enabled); ?>;"></div>
<div ng-init="enabled=<? print($wifi_enabled); ?>;"></div>
<div ng-init="connect_mode=<? print($connect_mode); ?>;"></div>
<div ng-init="auth_mode=<? print($auth_mode); ?>;"></div>
<div ng-init="ssid='<? print($ssid); ?>';"></div>
<div ng-init="connected=<? print($arr['connected']); ?>;"></div>
<div ng-init="connection_status=<? print($arr['status']); ?>;"></div>
<div ng-init="password='<? print($password); ?>';"></div>
<div ng-init="dhcp_ip='<? print($dhcp_ip); ?>';"></div>
<div ng-init="dhcp_gw='<? print($dhcp_gw); ?>';"></div>
<div ng-init="ip1=<? print($iparr[0]); ?>;"></div><div ng-init="ip2=<? print($iparr[1]); ?>;"></div><div ng-init="ip3=<? print($iparr[2]); ?>;"></div><div ng-init="ip4=<? print($iparr[3]); ?>;"></div>
<div ng-init="nm1=<? print($nmarr[0]); ?>;"></div><div ng-init="nm2=<? print($nmarr[1]); ?>;"></div><div ng-init="nm3=<? print($nmarr[2]); ?>;"></div><div ng-init="nm4=<? print($nmarr[3]); ?>;"></div>
<div ng-init="gw1=<? print($gwarr[0]); ?>;"></div><div ng-init="gw2=<? print($gwarr[1]); ?>;"></div><div ng-init="gw3=<? print($gwarr[2]); ?>;"></div><div ng-init="gw4=<? print($gwarr[3]); ?>;"></div>
<div ng-init="dns1=<? print($dnsarr[0]); ?>;"></div><div ng-init="dns2=<? print($dnsarr[1]); ?>;"></div><div ng-init="dns3=<? print($dnsarr[2]); ?>;"></div><div ng-init="dns4=<? print($dnsarr[3]); ?>;"></div>
<div ng-init="ap_dhcp_enabled=<? print($ap_dhcp_enabled); ?>;"></div>
<div ng-init="ap_channel=<? print($ap_channel); ?>;"></div>
<div ng-init="ap_connect_mode=<? print($ap_connect_mode); ?>;"></div>
<div ng-init="ap_password='<? print($ap_password); ?>';"></div>
<div ng-init="ap_auth_mode=<? print($ap_auth_mode); ?>;"></div>
<div ng-init="ap_ssid='<? print($ap_ssid); ?>';"></div>
<div ng-init="ap_ip1=<? print($ap_iparr[0]); ?>;"></div><div ng-init="ap_ip2=<? print($ap_iparr[1]); ?>;"></div><div ng-init="ap_ip3=<? print($ap_iparr[2]); ?>;"></div><div ng-init="ap_ip4=<? print($ap_iparr[3]); ?>;"></div>
<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('WIFI_SETTINGS','wifi')) ?></h5>
        <p class="card-text">    
            <div class="alert alert-success" ng-cloak ng-show="connection_status==5"> You are currently connected to the Wi-Fi network - Signal quality is {{makeSignal()}}</div>
            <div class="alert alert-danger" ng-cloak ng-show="connection_status!=5"> Connection status: {{makeStatus(connection_status)}}</div>        
            <div class="form-group">
                <label for="enabled"><small class='text-muted'><? print(lang('USE_WIFI','wifi')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="enabled" id="exampleRadios31" value="0">
                  <label class="form-check-label" for="exampleRadios31">
                    &nbsp;<? print(lang('DISABLED','wifi')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="enabled" id="exampleRadios32" value="1">
                  <label class="form-check-label" for="exampleRadios32">
                    &nbsp;<? print(lang('ENABLED','wifi')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('DHCP_HELP','wifi')) ?></small>
            </div>             
            <div class="form-group">
                <label for="connect_mode"><small class='text-muted'><? print(lang('CONNECT_MODE','wifi')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="connect_mode" id="exampleRadios2" value="0">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('MODE_CLIENT','wifi')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="connect_mode" id="exampleRadios3" value="1">
                  <label class="form-check-label" for="exampleRadios3">
                    &nbsp;<? print(lang('MODE_AP_CLIENT','wifi')) ?>
                  </label>
                </div>  
                 <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="connect_mode" id="exampleRadios4" value="2">
                  <label class="form-check-label" for="exampleRadios4">
                    &nbsp;<? print(lang('MODE_AP','wifi')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('CONNECT_MODE_HELP','wifi')) ?></small>
            </div> 
        </p>
    </div>
</div>
<br/>
<div class="card" ng-show='show_scanresults==1'>
    <div class="card-body">
        <h5 class="card-title"><? print(lang('SCAN_RESULTS','wifi')) ?></h5>
        <p class="card-text">    
            <div class="form-group" >
                <div class="table-responsive">					
                <table class='table table-striped' summary="Device List">
                    <tr>
                        <th scope="col">Channel</th></th>
                        <th scope="col">SSID</th>
                        <th scope="col">Encryption</th>
                        <th scope="col">RSSI</th>
                        <th scope="col">Options</th>
                    </tr>
                    <tr ng-repeat="item in scanresults">
                        <td><span class="badge badge-pill badge-dark">{{item.channel}}</span></td>
                        <td><strong>{{item.ssid}}</strong></td><td>{{makeEncryption(item.auth_mode)}}</td>
                        <td>{{item.rssi}}</td>
                        <td>
                            <button class="btn btn-secondary " type="button" ng-click='connect($index)'>
                                <? print(lang('SELECT','wifi')) ?>
                            </button>
                        </td>
                    </tr>
                </table>
            </div>
            </div>
        </p>
        
    </div>
</div><br>
<div class="card" ng-show='connect_mode<2'>
    <div class="card-body">
        <h5 class="card-title"><? print(lang('CLIENT_SETTINGS','wifi')) ?></h5>
        <p class="card-text">    
         <div class="form-group">
                <label for="ssid"><? print(lang('SSID','wifi')) ?></label>
                <input type="text" class="form-control" id="ssid" ng-model="ssid" aria-describedby="userHelp" placeholder="<? print(lang('SSID','wifi')) ?>">
                <div ng-cloak class='small text-danger' ng-show="form.ssid.$invalid"><strong><? print(lang('SSID','wifi')) ?></strong></div>
                <small id="sntpHelp" class="form-text text-muted"><? print(lang('SSID_HELP','wifi')) ?></small>
            </div>  
            
            <div class="form-group">
                <label for="auth_mode"><small class='text-muted'><? print(lang('AUTH_MODE','wifi')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="auth_mode" id="aexampleRadios1" value="0">
                  <label class="form-check-label" for="aexampleRadios1">
                    &nbsp;<? print(lang('WIFI_AUTH_OPEN','wifi')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="auth_mode" id="aexampleRadios3" value="1">
                  <label class="form-check-label" for="aexampleRadios3">
                    &nbsp;<? print(lang('WIFI_AUTH_WEP','wifi')) ?>
                  </label>
                </div>  
                 <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="auth_mode" id="aexampleRadios4" value="2">
                  <label class="form-check-label" for="aexampleRadios4">
                    &nbsp;<? print(lang('WIFI_AUTH_WPA_PSK','wifi')) ?>
                  </label>
                </div>  
                 <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="auth_mode" id="aexampleRadios5" value="3">
                  <label class="form-check-label" for="aexampleRadios5">
                    &nbsp;<? print(lang('WIFI_AUTH_WPA2_PSK','wifi')) ?>
                  </label>
                </div>  
                 <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="auth_mode" id="aexampleRadios6" value="4">
                  <label class="form-check-label" for="aexampleRadios6">
                    &nbsp;<? print(lang('WIFI_AUTH_WPA_WPA2_PSK','wifi')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('AUTH_MODE_HELP','wifi')) ?></small>
            </div> 
            
            <div class="form-group" ng-show='auth_mode>0'>
                <label for="password"><? print(lang('PASSWORD','wifi')) ?></label>
                <input type="password" class="form-control" id="password" ng-model="password" aria-describedby="userHelp" placeholder="<? print(lang('PASSWORD','wifi')) ?>">
                <div ng-cloak class='small text-danger' ng-show="form.password.$invalid"><strong><? print(lang('PASSWORD','wifi')) ?></strong></div>
                <small id="sntpHelp" class="form-text text-muted"><? print(lang('PASSWORD_HELP','wifi')) ?></small>
            </div>  
            <div class="form-group">
                <label for="dhcp_enabled"><small class='text-muted'><? print(lang('USE_DHCP','wifi')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="dhcp_enabled" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('STATIC','wifi')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="dhcp_enabled" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('DYNAMIC','wifi')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('DHCP_HELP','wifi')) ?></small>
            </div> 
            <div class="form-group" ng-show="dhcp_enabled==0">
                <label for="user_name"><? print(lang('IP_TITLE','wifi')) ?></label>
                <div class="form-row" style='line-height:40px'>
                    <div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ip1" name='ip1' min="1" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ip2" name='ip2' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ip3" name='ip3' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ip4" name='ip4' min="1" max="254" integer required>
                      
                    </div>
                    
              </div>
               <div ng-cloak class='small text-danger' ng-show="form.ip1.$invalid || form.ip2.$invalid || form.ip3.$invalid || form.ip4.$invalid"><strong><? print(lang('IP_INVALID','wifi')) ?></strong></div>
            <small id="dtHelp" class="form-text text-muted"><? print(lang('IP_HELP','wifi')) ?></small>
          </div>
          <div class="form-group" ng-show="dhcp_enabled==0">
                <label><? print(lang('NETMASK_TITLE','wifi')) ?></label>
                <div class="form-row" style='line-height:40px'>
                    <div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="nm1" name='nm1' min="0" max="255" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="nm2" name='nm2' min="0" max="255" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="nm3" name='nm3' min="0" max="255" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="nm4" name='nm4' min="0" max="255" integer required>
                      
                    </div>
                    
              </div>
              <div ng-cloak class='small text-danger' ng-show="form.nm1.$invalid || form.nm2.$invalid || form.nm3.$invalid || form.nm4.$invalid"><strong><? print(lang('NETMASK_INVALID','wifi')) ?></strong></div>
            <small id="dtHelp" class="form-text text-muted"><? print(lang('NETMASK_HELP','wifi')) ?></small>
          </div>
          <div class="form-group" ng-show="dhcp_enabled==0">
                <label ><? print(lang('GW_TITLE','wifi')) ?></label>
                <div class="form-row" style='line-height:40px'>
                    <div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="gw1" name='gw1' min="1" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="gw2" name='gw2' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="gw3" name='gw3' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="gw4" name='gw4' min="1" max="254" integer required>
                    </div>
                    
              </div>
               <div ng-cloak class='small text-danger' ng-show="form.gw1.$invalid || form.gw2.$invalid || form.gw3.$invalid || form.gw4.$invalid"><strong><? print(lang('GW_INVALID','wifi')) ?></strong></div>
            <small id="dtgHelp" class="form-text text-muted"><? print(lang('GW_HELP','wifi')) ?></small>
          </div>
          <div class="form-group" ng-show="dhcp_enabled==0">
                <label ><? print(lang('DNS_TITLE','wifi')) ?></label>
                <div class="form-row" style='line-height:40px'>
                    <div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="dns1" name='dns1' min="1" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="dns2" name='dns2' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="dns3" name='dns3' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="dns4" name='dns4' min="1" max="254" integer required>
                    </div>
                    
              </div>
               <div ng-cloak class='small text-danger' ng-show="form.dns1.$invalid || form.dns2.$invalid || form.dns3.$invalid || form.dns4.$invalid"><strong><? print(lang('DNS_INVALID','wifi')) ?></strong></div>
            <small id="dtgHelp" class="form-text text-muted"><? print(lang('DNS_HELP','wifi')) ?></small>
          </div>
           <div class="control-group" ng-show="dhcp_enabled==1" ng-cloak>
								<div class="controls">
								    <p class="help-block">
								        <? print(lang('DHCPHELP1','wifi')) ?><br>

								    </div>
							  </div>
        <a name='mac'></a>
                        <div class="control-group">
								<label class="control-label" for="prependedInput"><? print(lang('MAC','wifi')) ?><br></label>
								<div class="controls">
								  <div class="input-append" style='padding-top:5px'><strong><? print($arr['mac']); ?></strong> <a href='#mac' onclick='copyTextToClipboard("<? print($arr['mac']); ?>")'> <? print(lang('COPY','wifi')) ?></a></div>
								</div>
						 </div>
						 <hr>
                        <div class="control-group">
								<label class="control-label" for="prependedInput"><? print(lang('IP_TITLE','wifi')) ?><br></label>
								<div class="controls">
								  <div class="input-append" style='padding-top:5px'><strong>{{dhcp_ip}}</strong></div>
								</div>
						 </div>
						 <hr>
						<div class="control-group">
								<label class="control-label" for="prependedInput"><? print(lang('GW_TITLE','wifi')) ?><br></label>
								<div class="controls">
								  <div class="input-append" style='padding-top:5px'><strong>{{dhcp_gw}}</strong></div>
								</div>
						 </div> 
						 
        </p>
    </div>
</div><br>

<div class="card" ng-show='connect_mode>0'>
    <div class="card-body">
        <h5 class="card-title"><? print(lang('AP_SETTINGS','wifi')) ?></h5>
        <p class="card-text">    
         <div class="form-group">
                <label for="ap_ssid"><? print(lang('SSID','wifi')) ?></label>
                <input type="text" class="form-control" id="ap_ssid" ng-model="ap_ssid" aria-describedby="userHelp" placeholder="<? print(lang('SSID','wifi')) ?>">
                <div ng-cloak class='small text-danger' ng-show="form.ap_ssid.$invalid"><strong><? print(lang('SSID','wifi')) ?></strong></div>
                <small id="sntpHelp" class="form-text text-muted"><? print(lang('SSID_HELP','wifi')) ?></small>
            </div>  
            <div class="form-group">
                <label for="ap_channel"><? print(lang('CHANNEL','wifi')) ?></label>
                <select ng-model="ap_channel" name='ap_channel' class="custom-select custom-select-sm">
                    <option value='1'>Channel 1</option>
                    <option value='2'>Channel 2</option>
                    <option value='3'>Channel 3</option>
                    <option value='4'>Channel 4</option>
                    <option value='5'>Channel 5</option>
                    <option value='6'>Channel 6</option>
                    <option value='7'>Channel 7</option>
                    <option value='8'>Channel 8</option>
                    <option value='9'>Channel 9</option>
                    <option value='10'>Channel 10</option>
                    <option value='11'>Channel 11</option>
                    <option value='12'>Channel 12</option>
                    
                </select>
                <small id="langH" class="form-text text-muted"><? print(lang('DEVICE_LANGUAGE_HELP','user')) ?></small>
              </div>            
            <div class="form-group">
                <label for="ap_auth_mode"><small class='text-muted'><? print(lang('AUTH_MODE','wifi')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ap_auth_mode" id="ap_aexampleRadios1" value="0">
                  <label class="form-check-label" for="ap_aexampleRadios1">
                    &nbsp;<? print(lang('WIFI_AUTH_OPEN','wifi')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ap_auth_mode" id="ap_aexampleRadios3" value="1">
                  <label class="form-check-label" for="ap_aexampleRadios3">
                    &nbsp;<? print(lang('WIFI_AUTH_WEP','wifi')) ?>
                  </label>
                </div>  
                 <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ap_auth_mode" id="ap_aexampleRadios4" value="2">
                  <label class="form-check-label" for="ap_aexampleRadios4">
                    &nbsp;<? print(lang('WIFI_AUTH_WPA_PSK','wifi')) ?>
                  </label>
                </div>  
                 <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ap_auth_mode" id="ap_aexampleRadios5" value="3">
                  <label class="form-check-label" for="ap_aexampleRadios5">
                    &nbsp;<? print(lang('WIFI_AUTH_WPA2_PSK','wifi')) ?>
                  </label>
                </div>  
                 <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ap_auth_mode" id="ap_aexampleRadios6" value="4">
                  <label class="form-check-label" for="ap_aexampleRadios6">
                    &nbsp;<? print(lang('WIFI_AUTH_WPA_WPA2_PSK','wifi')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('AUTH_MODE_HELP','wifi')) ?></small>
            </div> 
            
            <div class="form-group" ng-show='ap_auth_mode>0'>
                <label for="ap_password"><? print(lang('PASSWORD','wifi')) ?></label>
                <input type="ap_password" class="form-control" id="ap_password" ng-model="ap_password" aria-describedby="userHelp" placeholder="<? print(lang('PASSWORD','wifi')) ?>">
                <div ng-cloak class='small text-danger' ng-show="form.ap_password.$invalid"><strong><? print(lang('PASSWORD','wifi')) ?></strong></div>
                <small id="sntpHelp" class="form-text text-muted"><? print(lang('PASSWORD_HELP','wifi')) ?></small>
            </div>  
            <div class="form-group" >
                <label for="ap_ip"><? print(lang('IP_TITLE','wifi')) ?></label>
                <div class="form-row" style='line-height:40px'>
                    <div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ap_ip1" name='ap_ip1' min="1" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ap_ip2" name='ap_ip2' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ap_ip3" name='ap_ip3' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ap_ip4" name='ap_ip4' min="1" max="254" integer required>
                      
                    </div>
                    
              </div>
               <div ng-cloak class='small text-danger' ng-show="form.ap_ip1.$invalid || form.ap_ip2.$invalid || form.ap_ip3.$invalid || form.ap_ip4.$invalid"><strong><? print(lang('IP_INVALID','wifi')) ?></strong></div>
            <small id="dtHelp" class="form-text text-muted"><? print(lang('IP_HELP','wifi')) ?></small>
          </div>
          
            <div class="form-group">
                <label for="ap_dhcp_enabled"><small class='text-muted'><? print(lang('USE_DHCP_SERVER','wifi')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ap_dhcp_enabled" id="ap_exampleRadios1" value="0">
                  <label class="form-check-label" for="ap_exampleRadios1">
                    &nbsp;<? print(lang('DISABLED','wifi')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ap_dhcp_enabled" id="ap_exampleRadios2" value="1">
                  <label class="form-check-label" for="ap_exampleRadios2">
                    &nbsp;<? print(lang('ENABLED','wifi')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('DHCP_HELP','wifi')) ?></small>
            </div> 
          
        <a name='mac'></a>
                        <div class="control-group">
								<label class="control-label" for="prependedInput"><? print(lang('MAC','wifi')) ?><br></label>
								<div class="controls">
								  <div class="input-append" style='padding-top:5px'><strong><? print($arr['mac']); ?></strong> <a href='#mac' onclick='copyTextToClipboard("<? print($arr['mac']); ?>")'> <? print(lang('COPY','wifi')) ?></a></div>
								</div>
						 </div>

        </p>
    </div>
</div><br>
							  
</form>

<script type='text/javascript'>

function fallbackCopyTextToClipboard(text) {
  var textArea = document.createElement("textarea");
  textArea.value = text;
  document.body.appendChild(textArea);
  textArea.focus();
  textArea.select();

  try {
    var successful = document.execCommand('copy');
    var msg = successful ? 'successful' : 'unsuccessful';
    console.log('Fallback: Copying text command was ' + msg);
  } catch (err) {
    console.error('Fallback: Oops, unable to copy', err);
  }

  document.body.removeChild(textArea);
}
function copyTextToClipboard(text) {
  if (!navigator.clipboard) {
    fallbackCopyTextToClipboard(text);
    return;
  }
  navigator.clipboard.writeText(text).then(function() {
    console.log('Async: Copying to clipboard was successful!');
  }, function(err) {
    console.error('Async: Could not copy text: ', err);
  });
}

var app = angular.module('myApp', []);

/**
* Network controller object used by Angular.JS
* @param $scope Application scope
* @param $http  HTTP object used for ajax requests
*/
function NetworkCtrl($scope,$timeout,$http) {
    var self = this;
    $scope.infomsg="";
   $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
    
    /**
    * Restores default network settings into the form fields
    */
    $scope.restoreDefaults=function() {
      $scope.ip1=192;
      $scope.ip2=168;
      $scope.ip3=0;
      $scope.ip4=55;
      $scope.nm1=255;
      $scope.nm2=255;
      $scope.nm3=255;
      $scope.nm4=0;
      $scope.gw1=192;
      $scope.gw2=168;
      $scope.gw3=0;
      $scope.gw4=1;
      $scope.dns1=8;
      $scope.dns2=8;
      $scope.dns3=8;
      $scope.dns4=8;
      $scope.dhcp_enabled=0;
      $scope.successmsg="Default values loaded.  Settings will not be saved until you click Apply Changes."
    }
    $scope.isChecked=function(invert) {
        if (!invert) {
            if (Number($scope.dhcp_enabled)) return 'checked';
            return 'unchecked';
        } else {
        if (!Number($scope.dhcp_enabled)) return 'checked';
            return 'unchecked';
        }
   }
   
   $scope.scan=function () {
        $scope.loading=1;
        $scope.show_scanresults=0;
        $http.get('/app/wifi_ajax.cgi?scan=1')
            .then(function (response) {
                var data = response.data;
                $scope.scanresults=data;
                $scope.show_scanresults=1;
                $scope.errormsg="";
                $scope.loading=0;
                return data;
            }, function(reason) {
                $scope.errormsg="Error saving settings";
                $scope.successmsg="";
                $scope.loading=0;
            });
    }
    
    $scope.poll=function () {
        $scope.loading=1;
        //$scope.show_scanresults=0;
        $http.get('/app/wifi_ajax.cgi')
            .then(function (response) {
                var data = response.data;
                $scope.connection_status=data.status;
                $scope.connected=data.connected;
                $scope.dhcp_ip=data.ip_address;
                $scope.dhcp_gw=data.gateway;
                $scope.rssi=Number(data.rssi);
                $scope.errormsg="";
                $scope.loading=0;
                if ($scope.connection_status < 5) {
                    $timeout($scope.poll, 2000);
                } else if ($scope.dhcp_ip=='0.0.0.0') {
                    $scope.connection_status=6;
                    $timeout($scope.poll, 2000);
                } 
                return data;
            }, function(reason) {
                $scope.errormsg="Error saving settings";
                $scope.successmsg="";
                $scope.loading=0;
            });
    }
    $scope.makeSignal=function() {
    console.log($scope.rssi+ " "+($scope.rssi >= -70));
        if ($scope.rssi <= -70) return "Weak ("+$scope.rssi+" dBi)";
        if ($scope.rssi <= -60) return "Fair ("+$scope.rssi+" dBi)";
        if ($scope.rssi > -60) return "Excellent ("+$scope.rssi+" dBi)";
        
        return $scope.rssi+" dBi";
    }
   $scope.restart=function () {
        $scope.loading=1;
        $scope.show_scanresults=0;
        $http.get('/app/wifi_ajax.cgi?restart=1')
            .then(function (response) {
                var data = response.data;
                $scope.connection_status=0;
                $scope.connected=0;
                $scope.errormsg="";
                $scope.loading=0;
                return data;
            }, function(reason) {
                $scope.errormsg="Error saving settings";
                $scope.successmsg="";
                $scope.loading=0;
            });
    }
    
    $scope.makeEncryption=function(idx) {
        switch(idx) {
            case 0: return "Open";break;
            case 1: return "WEP";break;
            case 2: return "WPA PSK";break;
            case 3: return "WPA2 PSK";break;
            case 4: return "WPA WPA2 PSK";break;
        }
    }

    $scope.makeStatus=function(idx) {
        switch(idx) {
            case 0: return "Idle";break;
            case 1: return "Connecting";break;
            case 2: return "Wrong Password";break;
            case 3: return "No AP Found";break;
            case 4: return "Connection Failed";break;
            case 5: return "Connection Failed";break;
            case 6: return "Connected, obtaining IP Address";break;
        }
    }
    
    $scope.connect=function(idx) {
        $scope.auth_mode=$scope.scanresults[idx].auth_mode;
        $scope.ssid=$scope.scanresults[idx].ssid;
    }
    /**
    * Posts settings to networksave.cgi and processes the response
    */
    $scope.saveSettings=function (restart_mode) {
        if ($scope.ap_password.length<8 && $scope.ap_auth_mode>0 && $scope.connect_mode>0) {
            $scope.errormsg="Please ensure password for access point is at least 8 characters long!";
            return;
        }
        $scope.ipaddress=$scope.ip1+"."+$scope.ip2+"."+$scope.ip3+"."+$scope.ip4;
        $scope.netmask=$scope.nm1+"."+$scope.nm2+"."+$scope.nm3+"."+$scope.nm4;
        $scope.gateway=$scope.gw1+"."+$scope.gw2+"."+$scope.gw3+"."+$scope.gw4;
        $scope.dns=$scope.dns1+"."+$scope.dns2+"."+$scope.dns3+"."+$scope.dns4;
        $scope.ap_ipaddress=$scope.ap_ip1+"."+$scope.ap_ip2+"."+$scope.ap_ip3+"."+$scope.ap_ip4;
        str="&ssid="+encodeURI($scope.ssid)+
            "&password="+encodeURI($scope.password)+
            "&connect_mode="+$scope.connect_mode+
            "&enabled="+$scope.enabled+
            "&auth_mode="+$scope.auth_mode+
            "&ap_ssid="+encodeURI($scope.ap_ssid)+
            "&ap_password="+encodeURI($scope.ap_password)+
            "&ap_connect_mode="+$scope.ap_connect_mode+
            "&ap_auth_mode="+$scope.ap_auth_mode+
            "&ap_channel="+$scope.ap_channel+
            "&ap_dhcp="+$scope.ap_dhcp_enabled+
            "&ap_gateway="+$scope.ap_ipaddress+
            "&ap_netmask=255.255.255.0"+
            "&ap_ip="+$scope.ap_ipaddress;
        $scope.successmsg="";
        $scope.errormsg="";
        $scope.infomsg="";
        $http.post('/app/configsave.cgi?config=wifi.ini&section=network',"ip=" + $scope.ipaddress + "&netmask=" + $scope.netmask + "&gateway=" + $scope.gateway + "&dns=" + $scope.dns+"&dhcp_enabled="+$scope.dhcp_enabled+str)
            .then(function (response) {
                var data = response.data;
                $scope.successmsg=data.sysmsg;
                $scope.errormsg="";
                if (restart_mode) {
                    $scope.restart();
                }
                return data;
            }, function(reason) {
                $scope.errormsg="Error saving settings";
                $scope.successmsg="";
            });
        
    }
    
    $scope.$watch('connection_status', function() {
    
       // if ($scope.connection_status < 5) 
       {
            if ($scope.enabled)
                $timeout($scope.poll, 2000);
        }
  });
}
</script>
<? include("/app/footer.inc"); ?>







