<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : osman.cgi
 * 
 *  Description: Package manager page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *                      25/04/16    scan option for packages
 * Akash Heimlich       20/06/18    WattmonOS 3 and split to osman
 *                      06/03/19    M2 Support
 * 
 ********************************************************************/
include("/app/config.inc");
$bodyid='rootscope';
$angular_controller="FirmwareCtrl"; 
$title='WattmonOS Manager';
$cat=$_GET['cat'];
if (!$cat) {
    $cat=4;
}

if (isset($_GET['custom_repository'])) {
    $custom_repository=$_GET['custom_repository'];
    $cat=-1;
}
mkdir("/repository");

include("/app/header.inc");
?>
<style>
    /* GLOBAL STYLES
    -------------------------------------------------- */
table {
    font: 90%/140% Verdana,Arial,Helvetica,sans-serif;
}
    
.enabled0 td{
    background-color:#CCC!important;
    color:#333;
}
</style>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','osman')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-suitcase"></i> <? print(lang('UPDATE_TITLE','osman')) ?> - <small><? 
if ($cat==-1) print("Custom Package Repository");
if ($cat==2) print(lang('COMPLETE_UPDATES','osman')); 
if ($cat==4) print(lang('PACKAGE_UPDATES','osman')); 
if ($cat==5) print(lang('THIRD_UPDATES','osman')); ?></small></h4>

<ul class="nav justify-content-end">
<div ng-cloak ng-show='loading==1'><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i></div>
  <li class="nav-item">
    <a class="btn btn-primary" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  
  <li class="nav-item">
    <div class="dropdown">
        <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButtonAdd" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <? print(lang('PACKAGE_TYPES','osman')) ?> <span class="caret"></span>
        </button>
    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuButtonAdd">
    <!-- dropdown menu links -->
    <a class="dropdown-item"  href='/app/osman.cgi?cat=4'><? print(lang('PACKAGE_UPDATES','osman')) ?></a>
    <a class="dropdown-item"  href='/app/osman.cgi?cat=2'><? print(lang('COMPLETE_UPDATES','osman')) ?></a>
    <a class="dropdown-item"  href='/app/osman.cgi?cat=5'><? print(lang('THIRD_UPDATES','osman')) ?></a>
    <? 
    $custom_repository = ini_get("/config/ota.ini","config","ota_custom_url","");
    if ($custom_repository) {
        print('<a class="dropdown-item" href="/app/osman.cgi?custom_repository='.urlencode($custom_repository).'">Custom Repository</a>');
    }
    ?>
    </div>
    </div>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','osman')) ?><br>
    <? print(lang('HELP2','osman')) ?><br>
    <? print(lang('HELP3','osman')) ?><br>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-success" ng-cloak ng-show="infomsg"> <button type="button" class="close" ng-click='infomsg=""'>&times;</button>{{infomsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="scanning"> Scanning: <div class="progress"><div class="progress-bar" style="width: {{scanpercent}}%;"></div></div></div>
<? if ($_GET['action']=='untar') { print("<div ng-init='infomsg=\"Untarring the file, please wait...\";'></div><div ng-init='loading=1;'></div><div ng-init='msg=\"Untarring package "+$_GET['version']+"\";'></div>"); } 
if ($_GET['action']=='completed') { print("<div ng-init='infomsg=\"The package has been successfully installed.  You may need to reboot for changes to take effect.\";'></div>"); 
} 
if ($_GLOBALS['md5_sync_changed'] && $_GLOBALS['md5_sync']) {
        print("<div class='alert alert-danger'>You will need to resync the file system once all your packages have been updated.  <a href='/app/pacman.cgi?action=resync'>Resync File System Now</a></div>");
}

if ($_GET['action']=='resync') {
    include("/scripts/md5_resync.cgi");
}
if ($_GET['action']=='md5_check') {
    include("/scripts/md5_check.cgi");
}
?>
<div ng-cloak ng-show='loading==1'><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i> {{msg}} <progress min="0" max="100" value="0">0% complete</progress></div>

<!-- VARIABLES -->

<? 
$prefix='';
    if ($_SERVER['HW_PLATFORM']==11) $prefix='0:';
if ($_GET['action']=='untar') {
    max_execution_time(500);
    chdir("/");
    ?><div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('UNCOMPRESS','osman')) ?></h5>
        <p class="card-text"><pre>
    <?
    if ($_GET['version']) {
        untar($prefix.'/repository/'.$_GET['version'],1);
    } else
        untar($prefix.'/package.tar',1);
    $_GLOBALS['md5_sync_changed']=1;
    ini_set("/config/md5.ini",'config','md5_sync_changed',1);
    print("</pre>");
    $_GLOBALS['sysmsg']=lang('NEED_REBOOT','osman');
    print("<script>document.location='/app/osman.cgi?action=completed';</script>");
    die();
}
?>        

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('AVAILABLE_LIST','osman')) ?></h5>
        <p class="card-text">   					
            <div class="table-responsive">					
                <table class='table table-striped' summary="Device List">
                    <tr>
                        <th scope="col"></th>
                        <th scope="col"><a href="" ng-click="predicate = 'id'; reverse=!reverse">ID</a></th></th>
                        <th scope="col"><a href="" ng-click="predicate = 'title'; reverse=!reverse"><? print(lang('NAME','osman')) ?></a></th>
                        <th scope="col"><a href="" ng-click="predicate = 'version'; reverse=!reverse"><? print(lang('VERSION','osman')) ?></a></th>
                        <th scope="col"><a href="" ng-click="predicate = 'filesize'; reverse=!reverse"><? print(lang('SIZE','osman')) ?></a></th>
                        <th scope="col"><a href="" ng-click="predicate = 'date'; reverse=!reverse"><? print(lang('DATE','osman')) ?></a></th>
                        <th scope="col"><? print(lang('OPTIONS','osman')) ?></th>
                    </tr>
                    <tr ng-repeat="item in files | orderBy:predicate:reverse">
                        <td></td>
                        <td><span class="badge badge-pill badge-dark">{{item.id}}</span></td>
                        <td><strong>{{item.title}}</strong><br><div ng-bind-html-unsafe="item.description"></div>MD5: {{item.md5}}</td>
                        <td>{{item.version}}</td>
                        <td>{{item.filesize}}</td>
                        <td>{{item.date}}</td>
                        <td><a class="btn btn-primary btn-outline" ng-show='loading==0'  ng-hide='settings_locked' ng-click="confirmInstall(item);" href="#">Install</a></td>
                    </tr>
                </table>
			</div>
        </p>
    </div>
</div>

<br>
<script>
  var thePath="<? print($_GET['dir']); ?>";
  
  
  
</script>
</div>        

          </div><!--/span-->
      </div><!--/row-->
    
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Warning</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>{{question}}</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" ng-click="doModal()">Continue</button>
      </div>
    </div>
  </div>
</div>
    
  <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function FirmwareCtrl($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
   
   $scope.setLoading=function(val) {
    $scope.loading=val;
   }
   $scope.predicate='version';
   $scope.reverse=1;
$scope.files=[];
$scope.pkgName="<? print($_GLOBALS['PKG_NAME']); ?>";
$scope.pkgVersion="<? print($_GLOBALS['PKG_VERSION']); ?>";

 $scope.hideModal=function() {
    $('#myModal').modal('hide');
  }  
  $scope.scan=function() {
    document.location="/app/pacman.cgi?scan=1";
  }
  $scope.doModal=function() {
      if ($scope.action==1) {
        $('#myModal').modal('hide');
          $scope.startUpdate($scope.filename);
      } 
  }
  
    $scope.confirmInstall=function(item) {
        $scope.filename=item.filename;
        $scope.action=1;
        $scope.version=item.version;
        //alert(item.version+" "+item.title);
        if ($scope.pkgName==item.title) {
            if ($scope.pkgVersion<item.version) {
                $scope.question="You have chosen to install an older version of the current package.  Are you sure you want to install this package? ";
            } else if ($scope.pkgVersion==item.version) {
                $scope.question="Your already installed this version of the package.  Are you sure you want to install this package? ";
            } else {
                $scope.question="You are about to upgrade "+$scope.pkgName+" from version "+$scope.pkgVersion+" to version "+item.version+".  Are you sure you want to continue? ";
            }
        } else {
            $scope.question="Certain packages could overwrite your current settings, please read the description carefully.  Are you sure you want to install this package? ";
        }
        $('#myModal').modal('show');
    }
  function poll(){
  
   var x = new XMLHttpRequest();
         x.open('GET', '<? if ($cat>9 && $custom_repository) print('http://'.$custom_repository); else print("http://www.wattmon.com/live/updater.php?action=list&cat=".$cat); ?>', true);
        x.onload=function() {
            var jsonlist = eval("(" + x.response + ")");
            //alert(jsonlist.files.length);
            $scope.$apply(function() {
                $scope.files=jsonlist.files;
            });
        }
        x.send();
      //$scope.asyncData = dataService.async();
     
    };
   poll();
   $scope.startUpdate=function(aFile) {
    <? if ($_SERVER['HW_PLATFORM']==11) {
            $cur_drive=get_drive();
            //print('if (1) { alert("'.disk_free_space($cur_drive).' Unable to update package.  Please make sure an SD card is inserted for this to happen."); return 0; }');
            if (disk_free_space($cur_drive)<2000) {
                if (disk_status(0)!=0) {
                    print('if (1) { alert("Unable to update package.  Please make sure sufficient space or an SD card is inserted for this to happen."); return 0; }');
                }
            }
        }
   ?>
    $scope.msg="Downloading package file...";
        var x = new XMLHttpRequest();
                $scope.setLoading(1);
      var progressBar = document.querySelector('progress');
      $scope.cur_file=aFile;
      x.open('GET', 'http://www.wattmon.com/live/updater.php?action=download&filename='+aFile, true);
      x.responseType = "blob";
      x.onprogress = function(e) {
                if (e.lengthComputable) {
                    progressBar.value = (e.loaded / e.total) * 100;
                    progressBar.textContent = progressBar.value; // Fallback for unsupported browsers.
                }
            };
      x.onload=function() {

            $scope.$apply(function() {
                $scope.msg="Uploading package file...";
            });
            var xmlhttp;
            if (window.XMLHttpRequest)  {// code for IE7+, Firefox, Chrome, Opera, Safari
    		    xmlhttp=new XMLHttpRequest();
    		}
    		else {// code for IE6, IE5
    		    xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
    		}
    		xmlhttp.onreadystatechange=function() {
    		    if (xmlhttp.readyState==4 && xmlhttp.status==201) {
    	    	    document.location="/app/osman.cgi?action=untar&version="+$scope.filename;
    		    }
    		}
    		xmlhttp.open("PUT","<? print(strval($prefix)); ?>/repository/"+$scope.filename,true);
            var progressBar = document.querySelector('progress');
            xmlhttp.upload.onprogress = function(e) {
                if (e.lengthComputable) {
                    progressBar.value = (e.loaded / e.total) * 100;
                    progressBar.textContent = progressBar.value; // Fallback for unsupported browsers.
                }
            };
		    xmlhttp.setRequestHeader("Content-Length",x.response.length);
	  	    xmlhttp.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
		    xmlhttp.send(x.response);
      }
      x.send();
      $gscope=0;
   }
 }
</script>
<? include("/app/footer.inc"); ?>




