<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : onewire.cgi
 * 
 *  Description: Onewire Device manager page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Ruchir Sharma        17/10/17    v1.1
 * Akash Heimlich       19/06/18    v2.0 WattmonOS3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="DeviceCtrl"; 
$title='Onewire';
include("/app/header.inc");
?>

<style>
    /* GLOBAL STYLES
    -------------------------------------------------- */
table {
    font: 90%/140% Verdana,Arial,Helvetica,sans-serif;
}
    
.enabled0 td{
    background-color:#CCC!important;
    color:#333;
}
</style>


<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','onewire')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h5><i class="icon-sitemap"></i> <? print(lang('ONEWIRE','onewire')) ?></h5>
<ul class="nav justify-content-end">
<div ng-cloak ng-show='loading==1'><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i></div>
  <li class="nav-item">
    <a class="btn btn-primary" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="btn btn-primary" role="button" ng-click="scan()"><i class="icon-plus"></i><? print(lang('SCAN','onewire')) ?>
  </a>
  </li>
  

</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  <? print(lang('HELP1','onewire')) ?><br>
  <? print(lang('HELP2','onewire')) ?><br>
  <? print(lang('HELP3','onewire')) ?><br>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<!-- VARIABLES -->
<div class='clearfix'></div>
<div class="card">
    <div class="card-body">
        <p class="card-text">   	

<div class="table-responsive">					
<table class='table table-striped' summary="Device List">
<tr>
<th scope="col"></th>
<th scope="col"><a href="" ng-click="predicate = 'id'; reverse=!reverse">ID</a></th></th>
<th scope="col"><a href="" ng-click="predicate = 'name'; reverse=!reverse">Name</a></th>
<th scope="col"><a href="" ng-click="predicate = 'type'; reverse=!reverse">Type</a></th>
<th scope="col">Role</th>
<th scope="col"><a href="" ng-click="predicate = 'status'; reverse=!reverse">Status</a></th>
<th scope="col">Options</th>
</tr>
					
<tr ng-repeat="item in devices | orderBy:predicate:reverse" class="enabled{{item.status}}" ng-show='item.status<2'>
    <td></td>
    <td><span class="badge badge-pill badge-dark">{{item.id}}</span></td><td><strong>{{item.name}}</strong></td><td>{{item.description}}</td>
    <td width='40%'><div class="row" style='margin-bottom:5px' ng-repeat="role in item.roles" ng-show='role.role!="Undefined"'>
            <div class='col-md-12 col-lg-6' >{{role.desc}}</div><div class="col-md-12 col-lg-6"><div class='col-12 badge badge-secondary text-left'>{{role.role}}</div>
            </div>
            
        </div>
    </td>
    <td>
        <span ng-show="isActive(item)" class="label label-success">{{lastAccess(item)}}</span>
        <span ng-show="isError(item)" class="label label-important">{{lastAccess(item)}}</span>
        <span class="label" ng-show="isDisabled(item)">Disabled</span>
    </td>
    <td><div ng-show="refresh">Disable Refresh to edit</div><div ng-hide="refresh" class="pull-right btn-group"><button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Action <span class="caret"></span></button>
            <div class="dropdown-menu dropdown-menu-right text-dark">
                <a class="dropdown-item" ng-click='edit($index)' href='#'><i class="icon-pencil"></i>&nbsp;Configure</a>
                <a class="dropdown-item" ng-show='item.status==1' ng-click='disable($index)' href='#'><i class="icon-check-empty"></i>&nbsp;Disable</a>
                <a class="dropdown-item" ng-show='item.status==0' ng-click='enable($index)' href='#'><i class="icon-check"></i>&nbsp;Enable</a>
                <a class="dropdown-item" ng-click='del($index)' href='#'><i class="icon-remove"></i>&nbsp;Delete</a>
            </div>
        </div>
    </td>
</tr>
</table>
</div>
        </p>
    </div>
</div>

   <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Warning</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>{{question}}</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" ng-click="doModal()">Continue</button>
      </div>
    </div>
  </div>
</div>
<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.factory('dataService', function($http) {
  
  this.async = function() {
    return $http.get('/app/ow_ajax.cgi?action=list')
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
        //alert('Failed: ' + reason);
        //$timeout(poll, 100);  // try again
    });
    
  };
  
  return this;
});


function DeviceCtrl(dataService,$scope, $timeout,$http) {
  var self = this;
  var pc=100;
  $scope.scanning=0;
  $scope.refresh=0;
$scope.helpvisible=0;
$scope.items=[];

$scope.asyncData = dataService.async();
  function poll(){
      $scope.asyncData = dataService.async();
    }
  
  $scope.poll=poll;  
  
  $scope.edit=function(idx) {
    document.location="/app/owedit.cgi?device_idx="+idx;
  }
  $scope.del=function(idx) {
   // alert('del '+item.id);
  //  alert('in del');
    $scope.selectedIdx=idx;
    $scope.action=1;
    $scope.question="Deleting a device will disable and remove it, along with all associated configuration values.  You can always scan and reconfigure the device at a later time. Are you sure you want to delete this device?";
    $('#myModal').modal('show');
  }
  
  $scope.hideModal=function() {
    $('#myModal').modal('hide');
  }  
  
  $scope.doModal=function() {
      if ($scope.action==1) {
          $scope.delDevice();
      } else {
  //      document.location="/app/devicecalib.cgi?device_idx="+$scope.selectedIdx;
      }
  }
  $scope.delDevice=function() {
    $('#myModal').modal('hide');
    $scope.errormsg="";
    $scope.successmsg="";
      
     $http.get('/app/ow_ajax.cgi?action=delete&device_idx='+$scope.selectedIdx) 
    .then(function (response) {
        if (response.data.status==0) {
            $scope.errormsg="There was an error deleting the device.";
        } else $scope.successmsg="Device deleted successfully";
        
      poll();
      return response;
    }, function(reason) {
        $scope.errormsg="Error while updating";
    });
  }
  $scope.isActive=function(item) {
      if (item.status==1) return 1;
      return 0;
  }
  $scope.isDisabled=function(item) {
      if (item.status==0) return 1;
      return 0;
  }
  $scope.isError=function(item) {
      if (item.status!=0 && item.last_response>=2) return 1;
      return 0;
  }
  $scope.lastAccess=function(item) {
      
        return "Active";
  }
  $scope.enable=function(item) {
      $scope.errormsg="";
      $scope.successmsg="";
      
     $http.get('/app/ow_ajax.cgi?action=update&id='+item+"&status=1") 
    .then(function (response) {
        if (response.status==0) {
            $scope.errormsg="There was an error enabling device ";
        } else {
            $scope.successmsg="Device is now enabled";
        }
        
      poll();
      return response;
    }, function(reason) {
        $scope.errormsg="Error while updating";
    });
  }
  $scope.disable=function(item) {
      $scope.errormsg="";
      $scope.successmsg="";
   $http.get('/app/ow_ajax.cgi?action=update&id='+item+"&status=0") 
    .then(function (response) {
        if (response.status==0) {
            $scope.errormsg="There was an error disabling device";
        } else $scope.successmsg="Device  is now disabled";
      poll();
      return response;
    }, function(reason) {
        $scope.errormsg="Error while updating";
    });
    }  
  $scope.scan=function() {
     $scope.infomsg="Performing a scan of the device bus.";
     
     $http.get('/app/ow_ajax.cgi?action=scan') 
    .then(function (response) {
      $scope.scanning = 1;
      $scope.scanpercent=0;
      $scope.successmsg="Onewire bus scan completed";
      poll();
      return response;
    }, function(reason) {
        $scope.errormsg="Error while starting scan";
    }); 
  }
  
  $scope.$watch('refresh', function(ref) {
      if (ref) poll();
  });
  $scope.$watch('scanning', function(ref) {
      if (ref) poll();
  });
  $scope.$watch('asyncData', function(asyncData) {
    if(angular.isDefined(asyncData)) {
        $scope.connectstatus=asyncData.loggedin?"loggedin":"loggedout";
        $scope.devices = asyncData.devices;
        $scope.scanpercent = asyncData.scanpercent;
        $scope.scanning = asyncData.scanning;
        
        pc=0;
        if ($scope.scanning || $scope.refresh)
            $timeout(poll, 2000);
    }
  });
  

}

</script>    
<? include("/app/footer.inc"); ?>
