{<?        
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : group_ajax.cgi
 * 
 *  Description: Ajax group interface script
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       18/12/13    v1.0
 *			01/05/14    
 * v1.1
 * This revision takes care of creating sysvars automatically and re-syncs
 * when a group name is changed.
 ********************************************************************/
 max_execution_time(20);
        if ($_GET['action']=='list') {
            print('"loggedin": '+$_SESSION['logged_in']+',\n');
            //$arr=ini_get_array("/config/graph.ini","data");            
            //$ds_arr=ini_get_array("/config/datalog.ini","data");
            $num_act=ini_get("/config/groups.ini","groups","num_groups",0);//intval($arr['num_graphs']);
            //$k=array_keys($arr);
            print('"groups": [');
            //$roles=ini_get_array("/config/roles.ini","roles");
            for ($i=0;$i<$num_act;$i++) {

                print('{');            
                {
                    print('"id": '+$i+',\n');
                    print('"name": "'+ini_get("/config/groups.ini","groups",'group'+$i,"")+'",\n');
                    print('"type": "'+ini_get("/config/groups.ini","groups",'group'+$i+'type',0)+'",\n');
                    print('"show": "'+ini_get("/config/groups.ini","groups",'group'+$i+'show',0)+'",\n');
                    print('"rated_watts": "'+ini_get("/config/groups.ini","groups",'group'+$i+'rated_watts',0)+'",\n');
                    print('"color": "'+ini_get("/config/groups.ini","groups",'group'+$i+'color','#008000')+'",\n');
                    print('"icon": "'+ini_get("/config/groups.ini","groups",'group'+$i+'icon','/img/group/sun.png')+'"\n');
                }
                print('}');
                if ($i<($num_act-1)) print(",");
            }
            print(']');
        } else {
            if ($_GET['action']=='save') {
                
                $id=intval($_GET['group_id']);
                // new role!
                if ($id==-1)  {
                    $id=ini_get("/config/groups.ini","groups","num_groups",0);
                    ini_set("/config/groups.ini","groups","num_groups",$id+1);
                    
                }
                $error="";
                $group_name=$_POST['group_name'];
                $group_type=$_POST['group_type'];
                $group_show=$_POST['group_show'];
                $rated_watts=$_POST['rated_watts'];
                $group_color=$_POST['group_color'];
                $group_icon=$_POST['group_icon'];
                if (ini_get("/config/groups.ini","groups",'group'+$id,"")!=$group_name)
                    ini_set("/config/groups.ini","groups","group"+$id,$group_name);
                if (ini_get("/config/groups.ini","groups",'group'+$id+"type","")!=$group_type)                    
                    ini_set("/config/groups.ini","groups","group"+$id+"type",$group_type);
                if (ini_get("/config/groups.ini","groups",'group'+$id+"show","")!=$group_show)                                        
                    ini_set("/config/groups.ini","groups","group"+$id+"show",$group_show);
                if (ini_get("/config/groups.ini","groups",'group'+$id+"rated_watts","")!=$rated_watts)                                        
                    ini_set("/config/groups.ini","groups","group"+$id+"rated_watts",$rated_watts);
                if (ini_get("/config/groups.ini","groups",'group'+$id+"color","")!=$group_color)                                        
                    ini_set("/config/groups.ini","groups","group"+$id+"color",$group_color);
                if (ini_get("/config/groups.ini","groups",'group'+$id+"icon","")!=$group_icon)
                    ini_set("/config/groups.ini","groups","group"+$id+"icon",$group_icon);
                
                
                // only for energy group, we need to ensure the right sysvars are saved
                if (intval($group_type)<=1) {
                    $num_sysvars=ini_get("/config/sysvars.ini","sysvars","num_sysvars",0);
                    $found=array(0,0,0,0,0,0);  // A_IN, A_OUT, W_IN, W_OUT, WD_IN, WD_OUT
                    
                    $grpst='G;'.$id.";";
                    for ($i=0;$i<$num_sysvars;$i++) {
                        $sysvar=ini_get("/config/sysvars.ini","sysvars","sysvar".$i."name","");
                        $systitle=ini_get("/config/sysvars.ini","sysvars","sysvar".$i."title","");
                        // if this is a group var for the group we are part of...
                        if (substr($sysvar,0,strlen($grpst))==$grpst) {
                            $arr=explode($sysvar,';');
                            if ($arr[2]=='a_in') {
                                $found[0]=1;
                                if ($systitle!=$group_name." amps in") {
                                    ini_set("/config/sysvars.ini","sysvars","sysvar".$i."title",$group_name." amps in");
                                }
                            }
                            if ($arr[2]=='a_out') {
                                $found[1]=1;
                                if ($systitle!=$group_name." amps out") {
                                    ini_set("/config/sysvars.ini","sysvars","sysvar".$i."title",$group_name." amps out");
                                }
                            }
                            if ($arr[2]=='w_in') {
                                $found[2]=1;
                                if ($systitle!=$group_name." watts in") {
                                    ini_set("/config/sysvars.ini","sysvars","sysvar".$i."title",$group_name." watts in");
                                }
                            }
                            if ($arr[2]=='w_out') {
                                $found[3]=1;
                                if ($systitle!=$group_name." watts out") {
                                    ini_set("/config/sysvars.ini","sysvars","sysvar".$i."title",$group_name." watts out");
                                }
                            }
                            if ($arr[2]=='wd_in') {
                                $found[4]=1;
                                if ($systitle!=$group_name." watt hours in") {
                                    ini_set("/config/sysvars.ini","sysvars","sysvar".$i."title",$group_name." watt hours in");
                                }
                            }
                            if ($arr[2]=='wd_out') {
                                $found[5]=1;
                                if ($systitle!=$group_name." watt hours out") {
                                    ini_set("/config/sysvars.ini","sysvars","sysvar".$i."title",$group_name." watt hours out");
                                }
                            }
                            if ($arr[2]=='kwh_out') {
                                $found[6]=1;
                                if ($systitle!=$group_name." kWh out") {
                                    ini_set("/config/sysvars.ini","sysvars","sysvar".$i."title",$group_name." kWh out");
                                }
                            }
                            if ($arr[2]=='kwh_out') {
                                $found[7]=1;
                                if ($systitle!=$group_name." kWh in") {
                                    ini_set("/config/sysvars.ini","sysvars","sysvar".$i."title",$group_name." kWh in");
                                }
                            }
                            
                        }
                    }
                    $new_num_sysvars=$num_sysvars;
                    if (!$found[0]) {
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."name",$grpst."a_in;2;1");
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."title",$group_name." amps in");
                        $new_num_sysvars++;
                        //print("didnt find amps_in");
                    }
                    if (!$found[1]) {
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."name",$grpst."a_out;2;1");
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."title",$group_name." amps out");
                        $new_num_sysvars++;
                        ///print("didnt find amps_out");
                    }
                    if (!$found[2]) {
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."name",$grpst."w_in;1;1");
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."title",$group_name." watts in");
                        $new_num_sysvars++;
                        //print("didnt find w_in");
                    }
                    if (!$found[3]) {
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."name",$grpst."w_out;1;1");
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."title",$group_name." watts out");
                        $new_num_sysvars++;
                        //print("didnt find w_out");
                    }
                    if (!$found[4]) {
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."name",$grpst."wd_in;3;1000");
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."title",$group_name." watts hours in");
                        $new_num_sysvars++;
                      //  print("didnt find wd_in");
                    }
                    if (!$found[5]) {
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."name",$grpst."wd_out;3;1000");
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."title",$group_name." watts hours out");
                        $new_num_sysvars++;
                    //    print("didnt find wd_out");
                    }
                    if (!$found[6]) {
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."name",$grpst."kwh_out;3;1");
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."title",$group_name." kWh out");
                        $new_num_sysvars++;
                    //    print("didnt find wd_out");
                    }
                    if (!$found[7]) {
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."name",$grpst."kwh_in;3;1");
                        ini_set("/config/sysvars.ini","sysvars","sysvar".$new_num_sysvars."title",$group_name." kWh in");
                        $new_num_sysvars++;
                    //    print("didnt find wd_out");
                    }
                    if ($new_num_sysvars!=$num_sysvars) {
                        ini_set("/config/sysvars.ini","sysvars","num_sysvars",$new_num_sysvars);
                    }
                }
                if ($error!="") {
                    print('"status":0, "error":"'+$error+'"');
                } else {
                    print('"status":1');
                }
            }
        } 
    ?>
}
           

