<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : graphedit.cgi
 * 
 *  Description: Graph edit page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *                      16/12/13    v1.1 - memory management
                        17/04/14    v1.2 - added an item type
*                       28/06/18    v2.0    WattmonOS 3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="GraphEditCtrl"; 
$title=lang('CONFIGURE_GRAPHS','graphedit');
include("/app/header.inc");
print('<script src="/lib/jscolor.js"></script>');

  if ($_GET['new']==1) {
    $_GET['graph_idx']=ini_get("/config/graph.ini","data",'num_graphs');
    
  } 
  $idx=$_GET['graph_idx'];
  $graph_name=ini_get("/config/graph.ini","data",'graph'+$idx+'name','New Graph');
  $graph_status=ini_get("/config/graph.ini","data",'graph'+$idx+'status',1);
  $graph_datasrc=ini_get("/config/graph.ini","data",'graph'+$idx+'datasrc',0);
  $graph_numvar=ini_get("/config/graph.ini","data",'graph'+$idx+'numvar',0);
      
  
  $idx=$_GET['graph_idx'];
  //print_r($arr);
?>
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/graphs.cgi"><? print(lang('GRAPHS','graphedit')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('CONFIGURE_GRAPHS','graphedit')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-cog"></i>&nbsp;<? print(lang('CONFIGURE_TITLE','graphedit')) ?> <? print($graph_name); ?></small></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('CLOSE','roleedit')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/graphs.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','graphedit')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','graphedit')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','graphedit')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','graphedit')) ?></div>
<form name="form" class="css-form form-horizontal" novalidate>

<!-- VARIABLES -->

<div ng-init="graph_index=<? print($_GET['graph_idx']); ?>;"></div>
<div ng-init="graph_id=<? print($idx); ?>;"></div>
<div ng-init="graph_name='<? print($graph_name); ?>';"></div>
<div ng-init="graph_datasrc=<? print($graph_datasrc); ?>;"></div>
<div ng-init="graph_status=<? print($graph_status); ?>;"></div>
<div ng-init="graph_numvar=<? print($graph_numvar); ?>;"></div>
<? 

for ($i=0;$i<$graph_numvar;$i++) {
  print('<div ng-init="points.push({varidx:'+ini_get("/config/graph.ini","data",'graph'+$idx+'var'+$i+'varidx'));
  print(',vartype:'+ini_get("/config/graph.ini","data",'graph'+$idx+'var'+$i+'vartype'));
  print(',varerror:'+ini_get("/config/graph.ini","data",'graph'+$idx+'var'+$i+'varerror'));
  print(',varmax:'+ini_get("/config/graph.ini","data",'graph'+$idx+'var'+$i+'varmax',0));
  print(',varopt:'+ini_get("/config/graph.ini","data",'graph'+$idx+'var'+$i+'varopt')+',vartitle:\'');
  print((ini_get("/config/graph.ini","data",'graph'+$idx+'var'+$i+'vartitle'))+'\',varcolor:\''+(ini_get("/config/graph.ini","data",'graph'+$idx+'var'+$i+'varcolor'))+'\',varcolor2:\'');
  print((ini_get("/config/graph.ini","data",'graph'+$idx+'var'+$i+'varcolor'))
    +'\',varfunc:\''+(ini_get("/config/graph.ini","data",'graph'+$idx+'var'+$i+'varfunc'))+'\'})"></div>');
}
?>

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('GRAPH_TITLE','graphedit')) ?></h5>
        <p class="card-text">    
        
	        <div class="form-group">
                <label for="graph_name"><? print(lang('GRAPH_NAME','graphedit')) ?></label>
                <input type="text" class="form-control" ng-model="graph_name"  class='span12' ng-maxlength=30 name='graph_name' required aria-describedby="rnHelp" my-directive placeholder="<? print(lang('GRAPH_NAME','graphedit')) ?>">
                <small id="rnHelp" class="form-text text-muted"><? print(lang('GRAPH_NAME_HELP','graphedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.graph_name.$invalid"><? print(lang('GRAPH_NAME_INVALID','graphedit')) ?></small>
            </div>	        
            <div class="form-group">
                <label for="graph_datasrc"><? print(lang('DATASRC','graphedit')) ?></label>
                <select ng-options="item.groupidx as item.name for item in groups" ng-model="graph_datasrc" ng-model="graph_datasrc" class='form-control'>
                            <option value="{{item.groupidx}}">{{item.name}}</option>
                        </select>                
                <small id="gHelp" class="form-text text-muted"><? print(lang('DATASRC_HELP','graphedit')) ?></small>
            </div>               
            <div class="form-group">
                <label for="bus"><? print(lang('GRAPH_STATUS','graphedit')) ?></label>
                <select ng-model="graph_status" name='graph_status' class="form-control">
			                <option value='0'><? print(lang('DISABLED','graphedit')) ?></option>
                            <option value='1'><? print(lang('ENABLED','graphedit')) ?></option>
                            <option value='2'><? print(lang('DELETED','graphedit')) ?></option>
                </select>
                <small class="form-text text-muted"><? print(lang('GRAPH_STATUS_HELP','graphedit')) ?></small>
	        </div>
        </p>
	</div>
</div>
<br/>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('GRAPH_DATA_TITLE','graphedit')) ?></h5>
        <p class="card-text">    
            <div style='float:right'><a name='adddatapoint'></a><a name='addact'></a><button class="btn btn-large" ng-click="points.push({edit:1,varcolor:'#808080',function:1})"><i class="icon-plus"></i> <? print(lang('ADD','graphedit')) ?></button></div>

            <table class='table table-striped' summary="Conditions">
                <tr>
                    <th scope="col"></th>
                    <th scope="col">ID</th>
                    <th scope="col"><? print(lang('DATA_POINT','graphedit')) ?></th>
                    <th scope="col"><? print(lang('TITLE','graphedit')) ?></th>
                    <th scope="col"><? print(lang('TYPE','graphedit')) ?></th>
                    <th scope="col"><? print(lang('COLOR','graphedit')) ?></th>
                    <th scope="col"><? print(lang('FUNCTION','graphedit')) ?></th>
                    <th scope="col"><? print(lang('MAX','graphedit')) ?></th>
                    <th scope="col"><? print(lang('OPTIONS','graphedit')) ?></th>
                </tr>
                <tr ng-repeat="item in points">
                    <td><a name='datapoint{{$index}}'></a></td>
                    <td><span class="badge badge-inverse">{{$index+1}}</span></td>
                    <td><strong>{{makeDescription(item)}}</strong><div ng-show='item.edit==1'>
                        <select ng-options="vitem.id as vitem.vardesc for vitem in groups[graph_datasrc].variables" ng-model="item.varidx" class='span12'>
                                <option value="{{vitem.id}}">{{vitem.vardesc}}</option>       
                            </select>
                        </div></td>
                    <td><strong>{{makeTitle(item)}}</strong>
                        <div ng-show='item.edit==1'><input type='text' ng-model='item.vartitle' class='span12' ></div>
                    </td>      
                    <td><div ng-show='item.edit!=1'><strong>{{makeItemType(item)}}</strong></div>
                        <div ng-show='item.edit==1'>
                        <select class='span12' ng-model="item.vartype">
                            <option value='0'>Undefined</option>
                            <option value='1'>Amps</option>
                            <option value='2'>Volts</option>        
                            <option value='3'>Watts</option>
                            <option value='4'>kW</option>
                            <option value='5'>kWh</option>
                            <option value='6'>m/s</option>
                            <option value='7'>l</option>
                            <option value='8'>l/h</option>
                            <option value='9'>degrees</option>
                            <option value='10'>percent</option>
                        </select>
                        </div>
                        <div ng-show='item.edit!=1'><strong>{{makeError(item)}}</strong></div>
                         <div ng-show='item.edit==1'><input type='text' ng-model='item.varerror' class='span12' ></div>
                    </td>
                    <td ><strong><div ng-show='item.edit!=1'><div style='background-color:{{makeColor(item)}};'>{{makeColor(item)}}</div></div> {{makeOpt(item)}}</strong>
                    <div ng-show='item.edit==1'>
                        <input class='span12 color' ng-model="item.varcolor" id="varcolor{{$index}}"></input>
                    
                    <br><select class='span12' ng-model="item.varopt">
                            <option value='0'>Display Line</option>
                            <option value='1'>Display Filled Area</option>
                            <option value='2'>Inverted Line</option>        
                            <option value='3'>Inverted Filled Area</option>            
                            </select></div>
                        </td>                 
                    <td><strong>{{makeFunction(item)}}</strong>
                        <div ng-show='item.edit==1'>        <select ng-model="item.varfunc" class='span12' >
                            <option value='1'>No special processing</option>
                            <option value='2'>Plot value, aggregate total</option>
                            <option value='3'>Plot value, aggregate total by hour</option>        
                            <option value='4'>Plot aggregated value</option>            
                            <option value='5'>Plot aggregated value, by hour</option>            
                            <option value='6'>Plot value, average total</option>
                            <option value='7'>Plot value, aggregate as kWH</option>
                            <option value='8'>Plot aggregated value, aggregate as kWH</option>
                            <option value='9'>Time when zero</option>
                            <option value='10'>Time when non-zero</option>
                            </select></div>
                        </td>                 
                    <td>{{item.varmax}}<div ng-show='item.edit==1'><input type='text' ng-model='item.varmax' class='span12' ></div></td>
                    <td>
                        <div class="pull-right btn-group">
                            <a class="btn dropdown-toggle" data-toggle="dropdown" href="#">Action <span class="caret"></span></a>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <!-- dropdown menu links -->
                                <li class="dropdown-item"  ng-show='item.edit!=1'><a ng-click='item.edit=1' href='#datapoint{{$index}}'><i class="icon-pencil"></i> Edit</a></li>
                                <li class="dropdown-item"  ng-show='item.edit==1'><a ng-click='item.edit=0' href='#datapoint{{$index}}'><i class="icon-pencil"></i> Stop Edit</a></li>
                                <li class="dropdown-item" ><a ng-click='points.splice($index,1)' href='#adddatapoint'><i class="icon-remove"></i> Delete</a></li>
                            </ul>
                        </div>
                    </td>
                </tr>
            </table>
		</p>
	</div>
</div>  		        
</form>
    <script>
    var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.directive('color',function($timeout){
  return {
    require : '?ngModel',
    restrict : 'C',
    link : function(scope,element,attrs,ngModelCtrl){
      if(!ngModelCtrl){
        return;
      }
      //document.getElementById('myField1')
      
      //el=document.getElementById(elid);
       $timeout(function () {
                    // This code will run after
                    // templateUrl has been loaded, cloned
                    // and transformed by directives.
                    elid=element.attr('id');//.children()[0];
                    //alert(elid);
                    var myPicker = new jscolor.color(document.getElementById(elid), {});
                }, 0);
      
      scope.$watch('onChange', function(nVal) { 
        if (nVal)
         ngModelCtrl.$setViewValue(nVal); 
      });                   
      element.bind('change', function() {
                
                var currentValue = element.val();
                //alert(element.val());                
                if( scope.onChange !== currentValue ) {
                    scope.$apply(function() {
                        //scope.onChange = currentValue;
                        ngModelCtrl.$setViewValue('#'+currentValue);//element.html());
                    });
                }
            });
            
        // Listen for change events to enable binding
/*        element.bind('blur keyup change', function() {
            scope.$apply(read);
        });
        read(); // initialize
     
    // Write data to the model
        function read() {
             ngModelCtrl.$setViewValue(element.html());
        }*/
   //     }
    //};    
        //
//      }
      /*$(element).keyboard({
        stickyShift: false,
        usePreview: false,
        autoAccept: true,

        change: function(e, kb, el) {
            ngModelCtrl.$setViewValue(el.value);
        }
    });*/
    }
  };
});


   
    
function GraphEditCtrl($scope, $timeout,$http) {


//app.controller('ItemListCtrl', function( dataService,$scope,$timeout) {
    
  var self = this;
  $scope.points = [];
  $scope.groups = [];
  
<?  
  //$groups=ini_get_array("/config/datalog.ini","data");
  $num_groups=ini_get("/config/datalog.ini","data","num_groups");
  $num_sysvars=ini_get("/config/sysvars.ini","data","num_sysvars");
    for ($idx=0;$idx<$num_groups;$idx++) {
        print('$scope.groups['+$idx+']={groupidx:'+$idx+',name:\''+(ini_get("/config/datalog.ini","data",'group'+$idx+'name'))+'\',variables:[]};\r\n');
        $nv=ini_get("/config/datalog.ini","data",'group'+$idx+'numvar');
        for ($j=0;$j<$nv;$j++) {
            print('$scope.groups['+$idx+'].variables['+$j+']={id:'+$j+',vartitle:\'');
            print(ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$j+'vartitle')+'\',varcolor:\'');
            print(ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$j+'varcolor')+'\',varopt: '.ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$j+'varopt').',varfunc:');
            print(intval(ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$j+'varfunc'))+',');
            $vt=ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$j+'vartype');
            if ($vt==1) {
                print('vardesc: "Sysvar: ');
                $v=ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$j+'varval');
                print(ini_get("/config/sysvars.ini","sysvars","sysvar".$v."title","unknown"));
                print('"');
                
            }
            if ($vt==2) {
                print('vardesc: "Device Var: ');
                print(ini_get("/config/roles.ini","roles",'role'+ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$j+'varval'))+'"');
            }
            if ($vt==3) {
                print('vardesc: "Global Var: ');
                print(ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$j+'varval')+'"');
            }
        
            print('};\r\n');            
        }
    }
?>
  $scope.infomsg="";
  
  function swapElement(array, indexA, indexB) {
     var tmp = array[indexA];
    array[indexA] = array[indexB];
    array[indexB] = tmp;
  }
  $scope.moveUp=function(arr,idx) {
     if (idx>0)
        swapElement(arr,idx-1,idx);
  }
  $scope.moveDown=function(arr,idx) {
     if (idx<arr.length-1)
        swapElement(arr,idx,idx+1);
  }  
  $scope.deleteDataPoint = function ( idx ) {
    $scope.datapoints.splice(idx, 1);
};

  $scope.makeDescription=function(item) {
    if (item.edit) return '';
    str='';
    return $scope.groups[$scope.graph_datasrc].variables[item.varidx].vardesc;
  }
  $scope.makeColor=function(item) {
    if (item.edit) return ''
    
    str=item.varcolor;
    return str;
  }
  $scope.makeItemType =function(item) {
    if (item.edit) return '';
    switch (Number(item.vartype)) {
        case 0:str='Undefined';break;
        case 1:str='Amps';break;
        case 2:str='Volts';break;
        case 3:str='Watts';break;
        case 4:str='kW';break;
        case 5:str='kWh';break;
        case 6:str='m/s';break;
        case 7:str='l';break;
        case 8:str='l/h';break;
        case 9:str='degrees';break;
        case 10:str='percent';break;
    }
    return str;    
  }
  $scope.makeOpt=function(item) {
    if (item.edit) return '';
    switch (Number(item.varopt)) {
        case 0:str='Line';break;
        case 1:str='Filled Area';break;
        case 2:str='Inverted Line';break;
        case 3:str='Inverted Filled Area';break;        
    }
    return str;
  }  
  $scope.makeTitle=function(item) {
    if (item.edit) return '';
    str=item.vartitle;
    return str;
  }
  $scope.makeError=function(item) {
    if (item.edit) return '';
    str="Noise:"+item.varerror;
    return str;
  }
  $scope.makeFunction=function(item) {
    if (item.edit) return '';
    str=item.varfunc;
    switch (Number(item.varfunc)) {
        case 0:str='Undefined';break;
        case 1:str='No special processing';break;
        case 2:str='Plot value, aggregate total';break;
        case 3:str='Plot value, aggregate total by hour';break;        
        case 4:str='Plot aggregated value';break;
        case 5:str='Plot aggregated value, by hour';break;
        case 6:str='Plot value, average total';break;
        case 7:str='Plot value, aggregate as kWH';break;
        case 8:str='Plot aggregated value, aggregate as kWH';break;
        case 9:str='Time at zero';break;
        case 10:str='Time at non-zero';break;
    }
    return str;
  }
  
  $scope.makeValue=function(fitem) {
    if (fitem.edit) return '';
    str='';
    item=$scope.groups[$scope.graph_datasrc].variables[fitem.varidx];
    if (Number(item.vartype)==1)  { // preset role
      switch (Number(item.varval)) {
      <? for ($i=0;$i<$num_sysvars;$i++) {
            print("case ".$i.":str='".ini_get("/config/sysvars.ini","sysvars","sysvar".$i."title","unknown")."';break;\r\n");
      } ?>
      }
    }
    if (Number(item.vartype)==2)  { // role role
        switch (Number(item.varval)) {
        <? 
            $nr=ini_get("/config/roles.ini","roles",'num_roles');
            for ($i=0;$i<$nr;$i++) { 
            print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
            }
            ?>
        }
      }
      if (Number(item.vartype)==3)  { // global value
        str=item.varval;
      }
    return str;  
  }
  

   $scope.saveSettings=function () {
      $scope.successmsg="";
      $scope.loading=1;
      $scope.errormsg="";  $scope.infomsg="";
      astr="name="+encodeURIComponent($scope.graph_name);
      astr+="&datasrc="+encodeURIComponent($scope.graph_datasrc);
      astr+="&status="+encodeURIComponent($scope.graph_status);
      astr+="&numvar="+$scope.points.length;
      for (i=0;i<$scope.points.length;i++) {
        astr+="&var"+i+"varidx="+$scope.points[i].varidx;     
        astr+="&var"+i+"vartitle="+encodeURIComponent($scope.points[i].vartitle);     
        astr+="&var"+i+"varfunc="+encodeURIComponent($scope.points[i].varfunc);     
        astr+="&var"+i+"varcolor="+''+$scope.points[i].varcolor;   
        astr+="&var"+i+"varopt="+($scope.points[i].varopt);     
        astr+="&var"+i+"varmax="+($scope.points[i].varmax);   
        astr+="&var"+i+"varerror="+($scope.points[i].varerror);             
        astr+="&var"+i+"vartype="+($scope.points[i].vartype);     
      }
      //alert(astr);
      //return;
      $http.post('/app/graph_ajax.cgi?action=save&graph_id='+$scope.graph_id,astr)
        .then(function (response) {
        //alert(response.data);
          var data = response.data;
          $scope.loading=0;
          //alert(data);
          if (data.status)
            $scope.successmsg="Settings saved.";
          else {
            $scope.errormsg=data.error;
          }
          return data;
        }, function(reason) {
            $scope.loading=0;
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

}
//);
//app.ItemListCtrl.$inject=['$defer'];

</script>
<? include("/app/footer.inc"); ?>
