<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : email.cgi
 * 
 *  Description: Email settings page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Ruchir Sharma        17/10/17    v1.1
 * Akash Heimlich       19/06/18    v2.0 WattmonOS3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="EmailEditCtrl"; 
$title='Email Settings';
include("/app/header.inc");
?>


<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','email')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-group"></i> <? print(lang('PAGE_TITLE','email')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','email')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="testEmail()" ng-disabled="form.$invalid"><i class="icon-cog"></i> <? print(lang('SEND_EMAIL','email')) ?></a>
  </li>
  
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked' ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','email')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  <? print(lang('HELP1','email')) ?><br>
  <? print(lang('HELP2','email')) ?><br>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

<!--VARIABLES-->
<? 
  $arr=ini_get_array("/config/mail.ini","smtp");
  $host=$arr["host"];
  $username=$arr["username"];
  $from=$arr["from"];
  $password=$arr["password"];
  $ssl=$arr["ssl"];
  $port=$arr["port"];
?>
<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print("You will need to reboot the device for changes to take effect."); ?>';"></div>
<div ng-init="ssl=<? print($ssl); ?>;"></div>
<div ng-init="user_name='<? print($username); ?>';"></div>
<div ng-init="password='<? print($password); ?>';"></div>
<div ng-init="from='<? print($from); ?>';"></div>
<div ng-init="host='<? print($host); ?>';"></div>
<div ng-init="port=<? print($port); ?>;"></div>


<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('EMAIL_SETTINGS','email')) ?></h5>
        <p class="card-text">    
            <div class="form-group">
                <label for="from"><? print(lang('FROM_NAME','email')) ?></label>
                <input type="text" class="form-control" id="from" ng-model="from" aria-describedby="fromHelp" placeholder="<? print(lang('FROM_HELP','email')) ?>">
                <small id="fromHelp" class="form-text text-muted"><? print(lang('FROM_HELP','email')) ?></small>
            </div>            
            <div class="form-group">
                <label for="host"><? print(lang('SMTP_SERVER','email')) ?></label>
                <input type="text" class="form-control" id="host" ng-model="host" aria-describedby="fromsHelp" placeholder="<? print(lang('SMTP_SERVER_HELP','email')) ?>">
                <small id="fromsHelp" class="form-text text-muted"><? print(lang('SMTP_SERVER_HELP','email')) ?></small>
            </div>            
            <div class="form-group">
                <label for="user_name"><? print(lang('USER_NAME','email')) ?></label>
                <input type="text" class="form-control" id="user_name" ng-model="user_name" aria-describedby="nfromHelp" placeholder="<? print(lang('USER_NAME_HELP','email')) ?>">
                <small id="nfromHelp" class="form-text text-muted"><? print(lang('USER_NAME_HELP','email')) ?></small>
            </div>            
            <div class="form-group">
                <label for="password"><? print(lang('PASSWORD','email')) ?></label>
                <input type="password" class="form-control" id="password" ng-model="password" aria-describedby="pnfromHelp" placeholder="<? print(lang('PASSWORD_HELP','email')) ?>">
                <small id="pnfromHelp" class="form-text text-muted"><? print(lang('PASSWORD_HELP','email')) ?></small>
            </div>            
            
            <div class="form-group">
                <label for="ssl"><small class='text-muted'><? print(lang('USE_SSL','email')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ssl" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('NO','email')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ssl" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('YES','email')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('SSL_HELP','email')) ?></small>
            </div>
            <div class="form-group">
                <label for="port"><? print(lang('PORT','email')) ?></label>
                <input type="number" integer min=1 max=10000 class="form-control" id="port" ng-model="port" aria-describedby="pfromHelp" placeholder="<? print(lang('PORT_HELP','email')) ?>">
                <small id="pfromHelp" class="form-text text-muted"><? print(lang('PORT_HELP','email')) ?></small>
            </div>
            
 </p>
    </div>
</div>

</form>

    
     <script>
var app = angular.module('myApp', []);     
function EmailEditCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";
   $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
   
  $scope.testEmail=function() {
    $('#myModal').modal({
keyboard: true
});
  }
  $scope.hideModal=function() {
    $('#myModal').modal('hide');
  }  
     $scope.isChecked=function(invert) {
    if (!invert) {
        if (Number($scope.ssl)) return 'checked';
        return 'unchecked';
   } else {
       if (!Number($scope.ssl)) return 'checked';
        return 'unchecked';
   }
   }

   $scope.doModal=function() {
        
        $('#myModal').modal('hide');
        if ($scope.to.length==0) {
            $scope.errormsg="Please enter a valid email";
            return;
        }
        $http.get('/app/emailtest.cgi?to='+$scope.to)
        .then(function (response) {
          var data = response.data;      
          $scope.successmsg=(data.status==1)?"Mail sent successfully":"";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error sending test mail: "+reason;
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
   $scope.saveSettings=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       if ($scope.form.$invalid) {
        $scope.errormsg="<? print(lang('INVALID_SETTINGS','email')) ?>";
        return;
       }

       //alert();
       //
       $http.post('/app/configsave.cgi?config=mail.ini&section=smtp',"ssl="+$scope.ssl+"&host="+$scope.host+"&username="+$scope.user_name+"&from="+$scope.from+"&password="+$scope.password+"&port="+$scope.port)
        .then(function (response) {
          var data = response.data;      
          $scope.successmsg=(data.status==1)?"<? print(lang('SAVED_SETTINGS','email')) ?>":"";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="<? print(lang('ERROR_SAVING','email')) ?>";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

}</script>

<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Send Test Email</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>Enter email address: <input type='email' ng-model="to"></p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" ng-click="doModal()">Continue</button>
      </div>
    </div>
  </div>
</div>

<? include("/app/footer.inc"); ?>

