<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : time.cgi
 * 
 *  Description: Time settings page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013-2016 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *                      30/08/16    v1.1 Added RTC Calib
 * Ruchir Sharma        17/10/17    v1.1
 * Akash Heimlich       18/06/18    v2.0 WattmonOS 3
 * Akash Heimlich       31/07/20    Allowed no time option
 *                       6/10/20    Time protocol support
 ********************************************************************/
include("/app/config.inc");
$angular_controller="TimeEditCtrl"; 
$title='Time and Date Settings';
include("/app/header.inc");
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','time')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-group"></i> <? print(lang('PAGE_TITLE','time')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','time')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="syncTime()"><i class="icon-check"></i> <? print(lang('SYNC','time')) ?></a>
  </li>
  <li class="nav-item">
    <a ng-hide='settings_locked' class="nav-link" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','time')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  <? print(lang('HELP1','time')) ?><br>
  <? print(lang('HELP2','time')) ?><br>
  <? print(lang('HELP3','time')) ?><br>
  <? print(lang('HELP4','time')) ?><br>
  <? print(lang('HELP5','time')) ?><br>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

<!--VARIABLES-->
<? 
  $iniarr=ini_get_array("/config/time.ini","time");
  $use_sntp=$iniarr["use_sntp"];
  $use_wattmon=$iniarr["use_wattmon"];
  $sntp_server=$iniarr["sntp_server"];
  $time_server=$iniarr["time_server"];
  
  if (!isset($iniarr['rtc_adjust']))
    $iniarr['rtc_adjust'] = 7; // default calibration, increases time somewhat to deal with clock lag
  $rtc_adjust=$iniarr["rtc_adjust"];    
    
/*  if (function_exists("get_rtc_calib")) {
        $calib=get_rtc_calib();
    } else {
        $calib=0;
    }    */
  $arr=explode(strftime("%d/%m/%Y/%H/%M/%S"),'/');
  if (strpos(strval($iniarr["utc_offset"]),'.')<=0) {
      $utc_offset=$iniarr["utc_offset"];
      //print("somehow utc offset set here "+$arr["utc_offset"]+" "+strpos(strval($arr["utc_offset"]),'.'));
  } else $utc_offset=number_format($iniarr["utc_offset"],1);  

?>
<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print("You will need to reboot the device for changes to take effect."); ?>';"></div>
<div ng-init="use_wattmon=<? print($use_wattmon); ?>;"></div>
<div ng-init="use_sntp=<? print($use_sntp); ?>;"></div>
<div ng-init="rtc_adjust=<? print(intval($rtc_adjust)); ?>;"></div>
<div ng-init="sntp_server='<? print($sntp_server); ?>';"></div>
<div ng-init="time_server='<? print($time_server); ?>';"></div>
<div ng-init="curtime=<? print(time()); ?>;"></div>
<div ng-init="date_y='<? printf("%04d",intval($arr[2])); ?>';"></div>
<div ng-init="date_m='<? printf("%02d",intval($arr[1])); ?>';"></div>
<div ng-init="date_d='<? printf("%02d",intval($arr[0])); ?>';"></div>
<div ng-init="date_hour='<? printf("%02d",intval($arr[3])); ?>';"></div>
<div ng-init="date_min='<? printf("%02d",intval($arr[4])); ?>';"></div>
<div ng-init="date_sec='<? printf("%02d",intval($arr[5])); ?>';"></div>
<div ng-init="utc_offset='<? print($utc_offset); ?>';"></div>

<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('TIME_SETTINGS','time')) ?></h5>
        <p class="card-text">    
            <div class="form-group">
                <label for="use_sntp"><small class='text-muted'><? print(lang('USE_SNTP','time')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="use_sntp" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('METHOD_0','time')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="use_sntp" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('METHOD_1','time')) ?> (Does not work with 3G/4G)
                  </label>
                  <small id="ddHelp" class="form-text text-muted"><? print(lang('SNTP_HELP','time')) ?></small>
                </div>
                  <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="use_sntp" id="exampleRadios4" value="4">
                  <label class="form-check-label" for="exampleRadios4">
                    &nbsp;Time Server (works with 3G/4G dongles)
                  </label>
                  <small id="dtHelp" class="form-text text-muted">Use a TCP-based time server to synchronize your clock using the older Time protocol</small>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="use_sntp" id="exampleRadios3" value="2">
                  <label class="form-check-label" for="exampleRadios3">
                    &nbsp;<? print(lang('METHOD_2','time')) ?>
                  </label>
                  <small id="dtHelp" class="form-text text-muted">If you are experiencing issues with the internal real time click, select this option</small>
                </div>  
                
            </div> 
            <div class="form-group" ng-show='use_sntp==1'>
                <label for="sntp_server"><? print(lang('SNTP_SERVER','time')) ?></label>
                <input type="text" class="form-control" id="sntp_server" ng-model="sntp_server" aria-describedby="userHelp" placeholder="<? print(lang('SNTP_SERVER_HELP','time')) ?>">
                <small id="sntpHelp" class="form-text text-muted"><? print(lang('SNTP_SERVER_HELP','time')) ?></small>
                
            </div>            
             <div class="form-group" ng-show='use_sntp==4'>
                <label for="time_server">Time Server</label>
                <input type="text" class="form-control" id="time_server" ng-model="time_server" aria-describedby="userHelp" placeholder="Time server URL">
                <small id="sntpHelp" class="form-text text-muted">Use a time server to synchronize your system time</small>
                
            </div> 
          <div class="form-group">
            <label for="user_name"><? print(lang('DATE_TITLE','time')) ?></label>
            <div class="form-row" style='line-height:40px'>
                <div class="col-1">
                  <input type="text" class="form-control" ng-model="date_d" name='date_d' required placeholder="Day">
                </div>/<div class="col-1">
                  <input type="text" class="form-control" ng-model="date_m" name='date_m' required placeholder="Month">
                </div>/<div class="col-2">
                  <input type="text" class="form-control" ng-model="date_y" name='date_y' required placeholder="Year">
                </div>
                
              </div>
            <small id="dtHelp" class="form-text text-muted"><? print(lang('DATE_HELP','time')) ?></small>
          </div>
          <div class="form-group">
            <label for="user_name"><? print(lang('TIME_TITLE','time')) ?></label>
            <div class="form-row" style='line-height:40px'>
                <div class="col-1">
                  <input type="text" class="form-control" ng-model="date_hour" name='date_hour' required placeholder="Hour">
                </div>:<div class="col-1">
                  <input type="text" class="form-control" ng-model="date_min" name='date_min' required placeholder="Min">
                </div>:<div class="col-1">
                  <input type="text" class="form-control" ng-model="date_sec" name='date_sec' required placeholder="Sec">
                </div>
              </div>
            <small id="dtHelp" class="form-text text-muted"><? print(lang('TIME_HELP','time')) ?></small>
          </div>
          

        <div class="form-group">
                <label for="use_wattmon"><small class='text-muted'><? print(lang('USE_WATTMON','time')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="use_wattmon" id="exampleRadios3" value="0">
                  <label class="form-check-label" for="exampleRadios3">
                    &nbsp;<? print(lang('NO','time')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="use_wattmon" id="exampleRadios4" value="1">
                  <label class="form-check-label" for="exampleRadios4">
                    &nbsp;<? print(lang('YES','time')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('USE_WATTMON_HELP','time')) ?></small>
            </div>           
            
<div class="form-group">
                <label for="utc_offset"><? print(lang('UTC_OFFSET','time')) ?></label>
                <select ng-model="utc_offset" name='utc_offset' class="custom-select custom-select-sm">
<option value="-12">[UTC - 12] Baker Island Time</option>
<option value="-11">[UTC - 11] Niue Time, Samoa Standard Time</option>
<option value="-10">[UTC - 10] Hawaii-Aleutian Standard Time, Cook Island Time</option>
<option value="-9.5">[UTC - 9:30] Marquesas Islands Time</option>
<option value="-9">[UTC - 9] Alaska Standard Time, Gambier Island Time</option>
<option value="-8">[UTC - 8] Pacific Standard Time</option>
<option value="-7">[UTC - 7] Mountain Standard Time</option>
<option value="-6">[UTC - 6] Central Standard Time</option>
<option value="-5">[UTC - 5] Eastern Standard Time</option>
<option value="-4.5">[UTC - 4:30] Venezuelan Standard Time</option>
<option value="-4">[UTC - 4] Atlantic Standard Time</option>
<option value="-3.5">[UTC - 3:30] Newfoundland Standard Time</option>
<option value="-3">[UTC - 3] Amazon Standard Time, Central Greenland Time</option>
<option value="-2">[UTC - 2] Fernando de Noronha Time, South Georgia &amp; the South Sandwich Islands Time</option>
<option value="-1">[UTC - 1] Azores Standard Time, Cape Verde Time, Eastern Greenland Time</option>
<option value="0">[UTC] Western European Time, Greenwich Mean Time</option>
<option value="1">[UTC + 1] Central European Time, West African Time</option>
<option value="2">[UTC + 2] Eastern European Time, Central African Time</option>
<option value="3">[UTC + 3] Moscow Standard Time, Eastern African Time</option>
<option value="3.5">[UTC + 3:30] Iran Standard Time</option>
<option value="4">[UTC + 4] Gulf Standard Time, Samara Standard Time</option>
<option value="4.5">[UTC + 4:30] Afghanistan Time</option>
<option value="5">[UTC + 5] Pakistan Standard Time, Yekaterinburg Standard Time</option>
<option value="5.5">[UTC + 5:30] Indian Standard Time, Sri Lanka Time</option>
<option value="5.75">[UTC + 5:45] Nepal Time</option>
<option value="6">[UTC + 6] Bangladesh Time, Bhutan Time, Novosibirsk Standard Time</option>
<option value="6.5">[UTC + 6:30] Cocos Islands Time, Myanmar Time</option>
<option value="7">[UTC + 7] Indochina Time, Krasnoyarsk Standard Time</option>
<option value="8">[UTC + 8] Chinese Standard Time, Australian Western Standard Time, Irkutsk Standard Time</option>
<option value="8.75">[UTC + 8:45] Southeastern Western Australia Standard Time</option>
<option value="9">[UTC + 9] Japan Standard Time, Korea Standard Time, Chita Standard Time</option>
<option value="9.5">[UTC + 9:30] Australian Central Standard Time</option>
<option value="10">[UTC + 10] Australian Eastern Standard Time, Vladivostok Standard Time</option>
<option value="10.5">[UTC + 10:30] Lord Howe Standard Time</option>
<option value="11">[UTC + 11] Solomon Island Time, Magadan Standard Time</option>
<option value="11.5">[UTC + 11:30] Norfolk Island Time</option><option value="12">[UTC + 12] New Zealand Time, Fiji Time, Kamchatka Standard Time</option>
<option value="12.75">[UTC + 12:45] Chatham Islands Time</option>
<option value="13">[UTC + 13] Tonga Time, Phoenix Islands Time</option>
<option value="14">[UTC + 14] Line Island Time</option>
                </select>
                <small id="langs" class="form-text text-muted"><? print(lang('UTC_OFFSET_HELP','time')) ?></small>
              </div>
              
        </p>
    </div>
</div>

</form>

      
     <script>
var app = angular.module('myApp', []);     
function TimeEditCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";

   $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
   
   $scope.isChecked=function(invert) {
    if (!invert) {
        if (Number($scope.use_sntp)) return 'checked';
        return 'unchecked';
   } else {
       if (!Number($scope.use_sntp)) return 'checked';
        return 'unchecked';
   }
   }
    $scope.isWMChecked=function(invert) {
    if (!invert) {
        if (Number($scope.use_wattmon)) return 'checked';
        return 'unchecked';
   } else {
       if (!Number($scope.use_wattmon)) return 'checked';
        return 'unchecked';
   }
   }
    $scope.syncTime=function() {   
       $http.get('/scripts/time.cgi?force=1')
        .then(function (response) {
                        var data = response.data;      
                        $scope.successmsg=(data.result==1)?data.value:"";
                        $scope.errormsg=(data.result==0)?data.value:"";
                        if (data.result==1) {
                            $scope.date_y=data.year;
                            $scope.date_m=data.month;
                            $scope.date_d=data.day;
                            $scope.date_hour=data.hour;
                            $scope.date_min=data.minute;
                            $scope.date_sec=data.second;
                        }
                        return data;

        }, function(reason) {
            $scope.errormsg="Error getting time ";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
    }
   
   $scope.saveSettings=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       //alert();
       //
       $http.post('/app/configsave.cgi?config=time.ini&section=time',"use_sntp="+$scope.use_sntp+"&sntp_server="+$scope.sntp_server+"&time_server="+$scope.time_server+"&utc_offset="+$scope.utc_offset+"&use_wattmon="+$scope.use_wattmon+
        "&rtc_adjust="+$scope.rtc_adjust)
        .then(function (response) {
            if ($scope.use_sntp==0) {
                $http.post('/app/timeset.cgi',"d="+$scope.date_d+"&m="+$scope.date_m+"&y="+$scope.date_y+"&hour="+$scope.date_hour+"&min="+$scope.date_min+"&sec="+$scope.date_sec)
                    .then(function (response) {
                        var data = response.data;      
                        $scope.successmsg=(data.status==1)?"Saved settings and updated system time":"";
                        $scope.errormsg=data.error;
                        $scope.sysmsg=data.sysmsg;
                        return data;
                    } , function(reason) {
                    $scope.errormsg="Error setting date";
                    $scope.successmsg="";
            //alert('Failed: ' + reason);
           
                });           
            } else {
                var data = response.data;      
                $scope.successmsg=(data.status==1)?"Saved Settings":"";
                $scope.errormsg=data.error;
                $scope.sysmsg=data.sysmsg;
              return data;
            }
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

}</script>
<? include("/app/footer.inc"); ?>




