<?
/**
 * @package SyncWidget
 * @author Akash Heimlich
 * @description This allows you to sync variables between up
 * for further development
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function Sync_install($val) {
        Sync_enable();
        return 1;
    }
     
    function Sync_uninstall() {
        setPackageStatus("Sync",0);
        return 1;
    }
    
    function Sync_enable() {
        setPackageStatus("Sync",2);
//        addWidget("/package/Sync.inc","Sync",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function Sync_disable() {
        setPackageStatus("Sync",3);
  //      addWidget("/package/Sync.inc","Sync",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function Sync_init() {
        
        // load the test Value into the globals
        $_GLOBALS['sync_interval']=ini_get("/config/Sync.ini","config","interval",60);
        $_GLOBALS['sync_enabled']=ini_get("/config/Sync.ini","config","enabled",0);
    
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/Sync.cgi?action=configure';
        $arr['title']='Sync';
        $arr['icon']='icon-undo';
        $arr['desc']='Sync Variable Settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/SyncAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/SyncAjax.inc';

        // runs this file once a second
        if (file_exists('/package/SyncSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/SyncSec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/SyncMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/SyncMin.inc';
            
        // runs this file once a day
        if (file_exists('/package/SyncDay.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/SyncDay.inc';            
        return 1;
    }
    
    function Sync_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="Sync"; 
        $title='Configure Package Sync';
        $config_file="Sync.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">Sync</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> Sync Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Configure sunc here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
This package allows you to synchronise global variables between different devices. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Widget Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		
		<div ng-init="enabled=<? print(intval(ini_get("/config/".$config_file,$config_section,"enabled",0))); ?>;">
		<div ng-init="interval=<? print(intval(ini_get("/config/".$config_file,$config_section,"interval",60))); ?>;">
		<div ng-init="key_read='<? print(ini_get("/config/".$config_file,$config_section,"key_read",'')); ?>';">
		<div ng-init="key_write='<? print(ini_get("/config/".$config_file,$config_section,"key_write",'')); ?>';">
		<div ng-init="url='<? print(ini_get("/config/".$config_file,$config_section,"url",'http://sync.wattmon.com/api/')); ?>';">
		<div ng-init="variables='<? print(ini_get("/config/".$config_file,$config_section,"variables",'')); ?>';">
		<div ng-init="write_variables='<? print(ini_get("/config/".$config_file,$config_section,"write_variables",'')); ?>';">

		 <fieldset>
			 <div class="control-group">
		            <label class="control-label" for='enabled'>Enabled</label>
		            <div class="controls">
			            <select ng-model="enabled"  class='span10' name='enabled'>
			                <option value='0'>Disabled</option>
                            <option value='1'>Enabled</option>
                        </select>
			        </div>
		        </div>	
			    <div class="control-group">
		            <label class="control-label" for='interval'>Interval</label>
		            <div class="controls">
			            <input type='text' ng-model="interval"  name='interval' title="Enter interval in seconds to update data" data-rel="tooltip"> 
			        </div>

		        </div>
			    <div class="control-group">
		            <label class="control-label" for='key_read'>Read Key</label>
		            <div class="controls">
			            <input type='text' ng-model="key_read"  name='key_read' title="Enter read key" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='key_write'>Write Key</label>
		            <div class="controls">
			            <input type='text' ng-model="key_write"  name='key_write' title="Enter write key" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='url'>Server URL</label>
		            <div class="controls">
			            <input type='text' ng-model="url"  name='url' title="Enter server API URL" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='variables'>Read Variables</label>
		            <div class="controls">
			            <input type='text' ng-model="variables"  name='variables' title="Enter a comma separated list of variables" data-rel="tooltip"> 
			        </div>
		        </div>
		        <div class="control-group">
		            <label class="control-label" for='write_variables'>Write Variables</label>
		            <div class="controls">
			            <input type='text' ng-model="write_variables"  name='variables' title="Enter a comma separated list of variables to sync up" data-rel="tooltip"> 
			        </div>
		        </div>

		</fieldset>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function Sync($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="interval="+$scope.interval+
			"&enabled="+$scope.enabled+
			"&key_read="+$scope.key_read+
			"&key_write="+$scope.key_write+
			"&url="+encodeURI($scope.url)+
			"&variables="+$scope.variables+
			"&write_variables="+$scope.write_variables
       post_config="Sync.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>


