<?
/**
 * @package Kaco Widget
 * @author Akash Heimlich
 * @description This widget communicates with Kaco inverters
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function Kaco_install($val) {
        Kaco_enable();
        return 1;
    }
     
    function Kaco_uninstall() {
        setPackageStatus("Kaco",0);
        return 1;
    }
    
    function Kaco_enable() {
        setPackageStatus("Kaco",2);
        addWidget("/package/Kaco.inc","Kaco",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function Kaco_disable() {
        setPackageStatus("Kaco",3);
        addWidget("/package/Kaco.inc","Kaco",4,"icon-play",1,1); // disable
        return 1;
    }
    
function header_checksum($data,$start,$len) {
    $A = 0xFF;
    $B = 0;
    for ($I = 0;$i<$len;$i++) {
        $A = ($A + $data[$start+$i]) % 0x100;
        $B = ($B + $A) % 0x100;
    }
    return ($A + $B<<8);
}



    function Kaco_ajax() {
        $_GLOBALS['Kaco_custom_id']=$_GET['device_id'];
        $_GLOBALS['Kaco_custom_prop']=$_GET['prop'];
        $_GLOBALS['Kaco_custom_object']=$_GET['object_id'];
        $_GLOBALS['Kaco_custom_get']=1;
        
        // wait for second script to finish off 
        while ($_GLOBALS['Kaco_custom_get']) {
            sleep(100);
        }
        print('{"status":1,"val":"'.$_GLOBALS['Kaco_custom_response']['val'].'","prop":"'.$_GLOBALS['Kaco_custom_response']['prop'].'"}');
    }
    $s=0;;

    /* this is called at system boot */
    function Kaco_init() {
        global $s;
        $config_file='Kaco.ini';
        $config_section='config';
        //return 0;
        $_GLOBALS['kaco']=array();
        $_GLOBALS['kaco_count']=0;
        $_GLOBALS['kaco_installed_count']=ini_get("/config/".$config_file,$config_section,"kaco_installed_count",0);
        $kaco_installed_count=$_GLOBALS['kaco_installed_count'];
        //$s=fseropen(38400,0,0,1); // even parity
        $s=f485open(9600,0,0,0); // even parity
       // if (filesize($s)) $st=fread($s,filesize($s));
       print("<pre>");
        for ($i=0;$i<$kaco_installed_count;$i++) {
            fwrite($s,array('#',strval($i),0,13));
            sleep(500);
            if (filesize($s)) {
                $data=fread($s,filesize($s));
                $_GLOBALS['kaco'][$_GLOBALS['kaco_count']++]=$i;
            } else {
                 print("No response from ".$id);
            }
        }
        
     
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/Kaco.cgi?action=configure';
        $arr['title']='Kaco';
        $arr['icon']='icon-hdd';
        $arr['desc']='Kaco settings';
/*        $_GLOBALS['vars'][]='meter_frequency';
        $_GLOBALS['vars'][]='meter_voltage';
        $_GLOBALS['vars'][]='meter_current1';
        $_GLOBALS['vars'][]='meter_current2';
        $_GLOBALS['vars'][]='meter_current3';
        */
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        
        // generate ajax data for front end processing
        if (file_exists('/package/KacoAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/KacoAjax.inc';

        // runs this file once a second
        if (file_exists('/package/KacoSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/KacoSec.inc';
            
        // runs this file once a minute
//        if (file_exists('/package/EnergyMeterWidgetMin.inc')) 
//            $_GLOBALS['hooks']['min'][]='/package/EnergyMeterWidgetMin.inc';
            
        // runs this file once a day
//        if (file_exists('/package/EnergyMeterWidgetDay.inc')) 
//            $_GLOBALS['hooks']['sec'][]='/package/EnergyMeterWidgetDay.inc';            
        return 1;
    }
    
    function Kaco_configure() {
          include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="TestWidget"; 
        $title='Configure Package Kaco';
        $config_file="Kaco.ini";
        $config_section="config";
        $num_inverters=$_GLOBALS['kaco_count']?$_GLOBALS['kaco_count']:1;
        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">Kaco</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> Kaco Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav" style='max-width:100%'>
        <div class="navbar well" style='max-width:100%'>
            <div class='container' style='max-width:100%'>
                <div id='navcontent' style='max-width:100%'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
Delta RPI inverters are automatically detected at boot up. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="kaco_installed_count=<? print(ini_get("/config/".$config_file,$config_section,"kaco_installed_count",1)); ?>;">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='kaco_installed_count'>Num Installed Inverters</label>
		            <div class="controls">
			            <input type='number' ng-model="kaco_installed_count"  name='kaco_installed_count' title="Enter the number of inverters installed" data-rel="tooltip"> 
			        </div>
		        </div>
		</fieldset>
		<? for ($i=0;$i<$num_inverters;$i++) { ?>
		<div ng-init="kaco<? print ($i); ?>_kwh_offset=<? print(ini_get("/config/".$config_file,$config_section,"kaco"+$i+"_kwh_offset",0)); ?>;">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='kaco<? print ($i); ?>_kwh_offset'><? print("Inverter ".($i+1)." kWh Offset"); ?></label>
		            <div class="controls">
			            <input type='number' ng-model="kaco<? print ($i); ?>_kwh_offset"  name='kaco<? print ($i); ?>_kwh_offset' title="Enter a kwh reading offset if required" data-rel="tooltip"> 
			        </div>
		        </div>
		</fieldset>
		<? } ?>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function TestWidget($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data=<?
        for ($i=0;$i<$num_inverters;$i++) {
            if ($i) print("&");
            print('"kaco'.$i.'_kwh_offset="+$scope.kaco'+$i+'_kwh_offset');
        }
        ?>;
        post_data+="&kaco_installed_count="+$scope.kaco_installed_count;
       post_config="Kaco.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
</div>   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>



