<?
/**
 * @package SysInfoWidget
 * @author Akash Heimlich
 * @description This widget shows system info on the screen
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function GridTie_install($val) {
        GridTie_enable();
        return 1;
    }
     
    function GridTie_uninstall() {
        setPackageStatus("GridTie",0);
        return 1;
    }
    
    function GridTie_enable() {
        setPackageStatus("GridTie",2);
        addWidget("/package/GridTie.inc","Grid Tie",12,"none",0,0); // enable
        return 1;
    }
    
    function GridTie_disable() {
        setPackageStatus("GridTie",3);
        addWidget("/package/GridTie.inc","Grid Tie",12,"none",0,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function GridTie_init() {

             // load the test Value into the globals
        $_GLOBALS['gt_watt_role']=ini_get("/config/GridTie.ini","config","watt_role","0");
    
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/GridTie.cgi?action=configure';
        $arr['title']='Test';
        $arr['icon']='icon-hdd';
        $arr['desc']='Test widget settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/GridTieAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/GridTieAjax.inc';

        return 1;
    }
    
    function GridTie_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="GridTie"; 
        $title='GridTie Widget Configuration';
        $config_file="GridTie.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">GridTie Widget</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> GridTie Widget Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
This widget lets you associate roles with to gride tie variables for proper display on the front end. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Widget Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="watt_role=<? print(ini_get("/config/".$config_file,$config_section,"watt_role",0)); ?>;">
		<div ng-init="grid_group=<? print(ini_get("/config/".$config_file,$config_section,"grid_group",0)); ?>;">
		<div ng-init="kwh_rate='<? print(ini_get("/config/".$config_file,$config_section,"kwh_rate",0.0)); ?>';">
		<div ng-init="kwh_currency='<? print(ini_get("/config/".$config_file,$config_section,"kwh_currency",'INR')); ?>';">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='watt_role'>Role for Total Export Watts</label>
		            <div class="controls">
		                <select name='watt_role' ng-model='watt_role'>
		                    <? 
$role_ini="/config/roles.ini";
$role_section="roles";
$role_cnt=ini_get($role_ini,$role_section,'num_roles',0);

for ($i=0;$i<$role_cnt;$i++) {
  print("<option value='".$i."'>".ini_get($role_ini,$role_section,'role'.$i)."</option>\r\n";
}
		                    ?>
			            </select>
			        </div>
		        </div>
        <div class="control-group">
		            <label class="control-label" for='grid_group'>Data Group</label>
		            <div class="controls">
		                <select name='watt_role' ng-model='grid_group'>
		                    <? 
$ini="/config/groups.ini";
$section="groups";
$cnt=ini_get($ini,$section,'num_groups',0);

for ($i=0;$i<$cnt;$i++) {
  print("<option value='".$i."'>".ini_get($ini,$section,'group'.$i)."</option>\r\n";
}
		                    ?>
			            </select>
			        </div>
		        </div>		        
		        
                <div class="control-group">
		            <label class="control-label" for='kwh_rate'>Rate per kWh</label>
		            <div class="controls">
			            <input type='text' ng-model="kwh_rate"  name='kwh_rate' title="Enter a price per kWH hour" data-rel="tooltip"> 
			        </div>
		        </div>
                <div class="control-group">
		            <label class="control-label" for='kwh_currency'>Currency</label>
		            <div class="controls">
			            <input type='text' ng-model="kwh_currency"  name='kwh_currency' title="Enter 3-character Currency (i.e. EUR, INR, USD)" data-rel="tooltip"> 
			        </div>
		        </div>
		        
		</fieldset>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function GridTie($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="watt_role="+$scope.watt_role;
       post_data+="&kwh_currency="+$scope.kwh_currency;
       post_data+="&kwh_rate="+$scope.kwh_rate;
       post_data+="&grid_group="+$scope.grid_group;
       post_config="GridTie.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function

    
?>

