<?
/**
 * @package BatteryWidget
 * @author Akash Heimlich
 * @description This package is a demo of how to install and uninstall packages in Wattmon
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function BatteryWidget_install($val) {
        BatteryWidget_enable();
        $_GLOBALS['needreboot']=1;
        return 1;
    }
     
    function BatteryWidget_uninstall() {
        setPackageStatus("BatteryWidget",0);
        return 1;
    }
    
    function BatteryWidget_enable() {
        setPackageStatus("BatteryWidget",2);
        addWidget("/package/BatteryWidget.inc","Battery",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function BatteryWidget_disable() {
        setPackageStatus("BatteryWidget",3);
        addWidget("/package/BatteryWidget.inc","Battery",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function BatteryWidget_init() {
        $arr=array();
        $arr['script']='/package/BatteryWidget.cgi?action=configure';
        $arr['title']='Battery';
        $arr['icon']='icon-hdd';
        $arr['desc']='Configure your battery settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/BatteryWidgetAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/BatteryWidgetAjax.inc';
        //if (file_exists('/package/BatteryWidgetSec.inc')) 
            //$_GLOBALS['hooks']['sec'][]='/package/BatteryWidgetSec.inc';            
        /*
        // ensure that whatever roles are 'wanted' are added to the list of roles to transfer
        $roles=ini_get("/config/VariableWidget.ini","config","roles","");
        $arr=explode($roles,',');
        for ($i=0;$i<sizeof($arr);$i++) {
            $role=array();
            $role["name"]=ini_get("/config/roles.ini","roles","role".$arr[$i],"");
            $role["role"]=$arr[$i];
            $exists=0;
            for ($j=0;$j<sizeof($_GLOBALS['roles']);$j++) {
                if ($_GLOBALS['roles'][$j]['role']==$arr[$i]) 
                    $exists=1;
            } 
            if (!$exists)
                $_GLOBALS['roles'][]=$role;
        }*/
        
        return 1;
    }
    
    function BatteryWidget_configure() {

include("/app/config.inc");
$angular_controller="BatteryEditCtrl"; 
$title='Battery and Charge Settings';
include("/app/header.inc");
print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
?>
      <div class="row-fluid">
        <div class="span12">
        <ul class="breadcrumb">
  <li><a href="/">Home</a> <span class="divider">/</span></li>
  <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
  <li class="active">Battery Settings</li>
</ul>


<form name="form" class="css-form  form-horizontal" novalidate>

<div class="page-header">
  <h1><i class="icon-hdd icon-2x"></i> Battery And Charge Settings</h1>
</div>
        
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Battery and Charge configuration</div>
                
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-primary btn-large  pull-right" ng-click="setBatteryAH()">Update Battery AH</button>                     
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>

                </div>
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
<h4>Battery AH</h4>
    Enter the battery Amp-hour rating for your battery pack here.  If your battery pack is older, you could reduce this value (i.e from 180 to 150) which will increase the accuracy of the remaining power calculations.
    <h4>System Voltage</h4>
    Choose your system voltage (i.e two batteries makes a 24V system)
    <h4>C Rating</h4>
    Normally, batteries are rated at a 20-hour discharge rate.  Look at the datasheet and choose the correct hour rating.  This will affect the battery percentage calculations.
    <h4>Battery Full Voltage</h4>
    Enter the voltage that will cause the battery counters to reset to full.  This can be useful when batteries are not often completely charged and exact battery remaining percentage loses accuracy.  For example, a 24 V system could
    reset counters to full capacity when voltage reaches 28V with a solar system or 27.6 with a grid charger, it would depend on the type of charger you are using.
    <h4>Return Amps</h4>
    This is used to determine when the battery is full - the charge voltage will reach the Battery Full voltage, and the current will taper off slowly as the battery gets full.  This is a percentage of the total
    amp hour capacity of the battery, and would normally be set to 2% but can be adjusted as required.  Set this to Not used if you do not wish to take charge current into account.
    <h4>Charge Parameters Met Time</h4>
    The number of minutes that the voltage and current parameters must be set for before the battery is reset to full.  Use this to prevent erronous readings.  This could be set to 1 minute or more.
    <h4>Charge Efficiency</h4>
    Enter the estimated charge efficiency for your battery.  Most lead acid chargers are typically 80-90%.  This will affect the state of charge algorithm.
    <h4>Peukert Const</h4>
    Peukert's constant for a battery can change over time but typically values of about 1.1 work well.  This value is used to estimate the remaining capacity based on the rate of discharge as this is non-linear 
    with lead acid setups.  If you don't want any correction, enter 1 here.
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

                
            
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>

<? 
  $arr=ini_get_array("/config/battery.ini","battery");
  $charge_efficiency=$arr["charge_efficiency"];
  $peukert_const=$arr["peukert_const"];
  $battery_ah=$arr["battery_ah"];  
  $battery_voltage=$arr["battery_voltage"];
  $c_rating=$arr["c_rating"];
  $battery_full_voltage=number_format(floatval($arr["battery_full_voltage"]),2);
  $min_charge_percent=$arr["min_charge_percent"];  
  $max_charge_percent=$arr["max_charge_percent"];  
?>
<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print("You will need to reboot the device for changes to take effect."); ?>';"></div>
<div ng-init="charge_efficiency=<? print($charge_efficiency); ?>;"></div>
<div ng-init="peukert_const=<? print($peukert_const); ?>;"></div>
<div ng-init="battery_ah=<? print($battery_ah); ?>;"></div>
<div ng-init="met_time=<? print($arr['met_time']); ?>;"></div>
<div ng-init="return_amps_pc=<? print($arr['return_amps_pc']); ?>;"></div>
<div ng-init="c_rating=<? print($c_rating); ?>;"></div>
<div ng-init="battery_full_voltage=<? print($battery_full_voltage); ?>;"></div>
<div ng-init="battery_voltage=<? print($battery_voltage); ?>;"></div>
<div ng-init="min_charge_percent=<? print($min_charge_percent); ?>;"></div>
<div ng-init="max_charge_percent=<? print($max_charge_percent); ?>;"></div>
<div ng-init="battery_cur_ah=<? print($_GLOBALS['battery_cur_ah']); ?>;"></div>


<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Battery and Charge Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
         <fieldset>
                <div class="control-group">
		            <label class="control-label" for='battery_ah'>Battery Ah</label>
		            <div class="controls">
		                <input type='number' ng-model="battery_ah"   name='battery_ah' min="10" integer required title="The amp hour rating of your battery bank" data-rel="tooltip">
		                <div ng-show='form.battery_ah.$invalid' class="alert">Battery AH is invalid</div>
		            </div>
		        </div>		    
                <div class="control-group">
		            <label class="control-label" for='battery_voltage'>Nominal Battery Voltage</label>
		            <div class="controls">
			            <div class="input-append">
                            <div class="btn-group">
                                <input class="span4"  ng-model="battery_voltage" type="number" size='5' min="12" max="600" integer required ng-change="battery_full_voltage=battery_voltage/12*13.8;">
                                <button class="btn dropdown-toggle" data-toggle="dropdown">
                                    Select
                                    <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a ng-click='setV(12)' href='#'>12V</a></li>
                                    <li><a ng-click='setV(24)' href='#'>24V</a></li>
                                    <li><a ng-click='setV(48)' href='#'>48V</a></li>
                                    <li><a ng-click='setV(60)' href='#'>60V (Only with External sensor)</a></li>
                                    <li><a ng-click='setV(72)' href='#'>72V (Only with External sensor)</a></li>
                                    <li><a ng-click='setV(96)' href='#'>96V (Only with External sensor)</a></li>
                                    <li><a ng-click='setV(144)' href='#'>144V (Only with External sensor)</a></li>
                                    <li><a ng-click='setV(360)' href='#'>360V (Only with External sensor)</a></li>
                                </ul>
                            </div>
                        </div>
			        </div>
		        </div>		        
                <div class="control-group">
		            <label class="control-label" for='return_amps_pc'>Return Amps</label>
		            <div class="controls">
			            <select ng-model="return_amps_pc"  class='span10' name='return_amps_pc' required title="The percentage of current in relation to battery ah before the battery is reset to full." data-rel="tooltip">
			                <option value="0">Not used</option>
                            <option value="1">1%</option>
                            <option value="2">2%</option>
                            <option value="3">3%</option>
                            <option value="4">4%</option>
                            <option value="5">5%</option>
                            <option value="10">10%</option>
                        </select>
			        </div>
		        </div>	
                <div class="control-group">
		            <label class="control-label" for='battery_full_voltage'>Battery Full Voltage</label>
		            <div class="controls">
			            <input type='number' ng-model="battery_full_voltage"  class='span10' name='max_execution_time' min="0" required title="Voltage above which battery percent is reset to full" data-rel="tooltip">
			        </div>
		        </div>			
                <div class="control-group">
		            <label class="control-label" for='met_time'>Charge parameters met time</label>
		            <div class="controls">
			            <input type='number' ng-model="met_time"  class='span10' name='met_time' min="0" required title="The duration in minutes that the full voltage and return amps must be valid for before affecting battery percentage" data-rel="tooltip">
			        </div>
		        </div>			
                <div class="control-group">
		            <label class="control-label" for='c_rating'>Battery C-Rating</label>
		            <div class="controls">
			            <select ng-model="c_rating"  class='span10' name='c_rating' required title="The C rating of the battery, this is used when calculating the available capacity at different discharge rates" data-rel="tooltip">
			                <option value="1">1-hour (C)</option>                
                            <option value="5">5-hour (C/5)</option>
                            <option value="10">10-hour (C/10)</option>
                            <option value="20">20-hour (C/20)</option>
                            <option value="40">40-hour (C/40)</option>
                        </select>
			        </div>
		        </div>	
            <div class="control-group">
		            <label class="control-label" for='charge_efficiency'>Charge Efficiency</label>
		            <div class="controls">
			            <select ng-model="charge_efficiency"  class='span10' name='charge_efficiency' required title="The efficient of your battery (some energy will be wasted in heat or the battery chemistry while charging)" data-rel="tooltip">
			               <option value="60">60%</option>
                            <option value="65">65%</option>
                            <option value="70">70%</option>
                            <option value="75">75%</option>
                            <option value="80">80%</option>
                            <option value="85">85%</option>
                            <option value="90">90%</option>
                            <option value="95">95%</option>
                            <option value="100">100%</option>
                        </select>
			        </div>
		    </div>	
		      <div class="control-group">
		            <label class="control-label" for='peukert_const'>Peukert Constant</label>
		            <div class="controls">
			            <input type='number' ng-model="peukert_const"  class='span10' name='peukert_const' min="0" required title="The peukert constant for your battery.  Leave this at 1 if you do not want any correction" data-rel="tooltip">
			            <div ng-show='form.peukert_const.$invalid' class="alert">Peukert const is invalid. Enter 1 if you don't require peukert compensation</div>
			        </div>
		        </div>			  
        </fieldset>

        <div class="clearfix"></div>
					</div>
				</div>
			</div>  		        

<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Battery State of Charge</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
         <fieldset>
          <div class="control-group">
		            <label class="control-label" for='battery_cur_ah'>Current Battery AH</label>
		            <div class="controls">
			            <input type='number' ng-model="battery_cur_ah"  class='span10' name='peukert_cobattery_cur_ahnst' min="0" required title="The Amp Hours remaining in the battery.  Set this to the battery bank AH in order to reset battery to full." data-rel="tooltip">
			        </div>
		        </div>			  
        </fieldset>

        <div class="clearfix"></div>
					</div>
				</div>
		</div>  	


</form>

        </div><!--/span-->
      </div><!--/row-->


    
     <script>
     var app = angular.module('myApp', []);
function BatteryEditCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";
   $scope.setV=function (v) {
        $scope.battery_voltage=v;
        $scope.battery_full_voltage=Number(Math.floor(v/12*13.8*100)/100);
   }
   
   $scope.saveSettings=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       if ($scope.battery_full_voltage < $scope.battery_voltage) {
            $scope.errormsg="Please make sure the battery full voltage is greater than the system voltage";
            return;
       }
       //alert();
       //
       $http.post('/app/configsave.cgi?config=battery.ini&section=battery',"charge_efficiency="+$scope.charge_efficiency+"&battery_ah="+$scope.battery_ah+"&battery_voltage="+$scope.battery_voltage+
        "&battery_full_voltage="+$scope.battery_full_voltage+"&c_rating="+$scope.c_rating+"&charge_efficiency="+$scope.charge_efficiency+"&peukert_const="+$scope.peukert_const+"&met_time="+$scope.met_time
        +"&return_amps_pc="+$scope.return_amps_pc)
        .then(function (response) {
          var data = response.data;      
          $scope.successmsg=(data.status==1)?"Saved Settings":"";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
     $scope.setBatteryAH=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       if (confirm("This will change the current battery amp hours and may interfere with the automatic calculations.  Continue?")) {
           $http.get('/app/globalset.cgi?var=battery_cur_ah&val='+$scope.battery_cur_ah)
            .then(function (response) {
              var data = response.data;      
              $scope.successmsg=(data.status==1)?"Updated battery state":"";
              $scope.errormsg=data.error;
              $scope.sysmsg=data.sysmsg;
              return data;
            }, function(reason) {
                $scope.errormsg="Error setting battery charge state";
                $scope.successmsg="";
            });
       }
   }    
    
  //poll();

}</script>
<? include("/app/footer.inc"); ?>
<script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script>
<?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>

