<pre><?
$DEBUG=1;

if (!$_GLOBALS['MQTTJSON_template']) {
    $_GLOBALS['MQTTJSON_template']=ini_get("/config/MQTTJSON.ini","config","template","");
}
if (!$_GLOBALS['MQTTJSON_channel']) {
    $_GLOBALS['MQTTJSON_channel']=ini_get("/config/MQTTJSON.ini","config","channel","");
}
if ($_GLOBALS['MQTTJSON_interval'])
    $_GLOBALS['MQTTJSON_interval']=ini_get("/config/MQTTJSON.ini","config","interval",15);
    
//print($_GLOBALS['MQTTJSON_template']);
$prefix='';
if ($_GET['force']) $_GLOBALS['MQTTJSON_cnt']=$_GLOBALS['MQTTJSON_interval'];
$_GLOBALS['MQTTJSON_cnt']++;
if (($_GLOBALS['MQTTJSON_cnt']>=$_GLOBALS['MQTTJSON_interval']) && file_exists($_GLOBALS['MQTTJSON_template'])) {
    include("/lib/uphp/expression.inc");
    include("/lib/uphp/fileio.inc");
    include("/lib/uphp/debug.inc");

    $_GLOBALS['MQTTJSON_cnt']=0;
    $f=fopen($_GLOBALS['MQTTJSON_template'],"r");
    $_buf=fread($f,filesize($f));
    $_loop_buf="";
    print($_buf);
    fclose($f);
    $res=array();
    $roles=array();
    
    
/*  Historic Data */
    // get last export pointer
    
    $last_export_time    = ini_get("/logs/mqttjson_status.ini", "export", "last_export", 0);
    $last_export_file    = ini_get("/logs/mqttjson_status.ini", "export", "file", "");
    $last_export_filepos = ini_get("/logs/mqttjson_status.ini", "export", "filepos", 0);
    
    //log ("last_export_time = ".$last_export_time. " last_export_file=".$last_export_file." last_export_filepos=".$last_export_filepos);

    if ($DEBUG) {
        debug_print("1. last_export_file=" . $logdir . $last_export_file,'file','blue');
    }
    
    // if this is new, just start from now
    
    if (!$last_export_file) {
        
        $logdir = $prefix."/logs/" + strftime("%Y", time()) . "/" . strftime("%m", time()) . "/";
        
        $last_export_time    = time();
        $m                   = strftime("%M", time());
        $h                   = strftime("%H", time());
        $last_export_file    = strftime("%Y%m%d", time()) . "_0.csv";
        $last_export_filepos = filesize($logdir . $last_export_file);
        
        ini_set("/logs/mqttjson_status.ini", "export", "filepos", $last_export_filepos);
        ini_set("/logs/mqttjson_status.ini", "export", "last_export", time());
        ini_set("/logs/mqttjson_status.ini", "export", "file", $last_export_file);
        
    } else {
        
        $y = substr($last_export_file, 0, 4);
        $m = substr($last_export_file, 4, 2);
        
        $logdir = $prefix."/logs/" + $y . "/" . $m . "/";
    }
            
    if ($DEBUG) 
        debug_print("2. last_export_file=" . $logdir.$last_export_file, 'file');
    
    $last_size = filesize($logdir . $last_export_file);
    
    if ($DEBUG) {
        debug_print($last_size . " " . $last_export_filepos);
        debug_print("Comparison : last_size <= last_export_filepos + 10 = ".($last_size <= $last_export_filepos + 10), 'file', 'blue');
    }
            
    // check if end of file is reached
    
    if ($last_size <= $last_export_filepos + 10) {
        $y = substr($last_export_file, 0, 4);
        $m = substr($last_export_file, 4, 2);
        $d = substr($last_export_file, 6, 2);
        
        if ($DEBUG) 
            debug_print("fn=" . $y . " " . $m . " " . $d, 'file', 'green');
            
        $found_file=0;
        $date_offset=0;
        $date_offset=86400;
        while (!$found_file) {
            
            $t = mktime(0, 0, 0, intval($m) - 1, intval($d), intval($y)) + $date_offset;
            
            $m = strftime("%m", $t);
            $d = strftime("%d", $t);
            $y = strftime("%Y", $t);
            
            $logdir          = $prefix."/logs/" + $y . "/" . $m . "/";
            $new_export_file = strftime("%Y%m%d", $t) . "_0.csv";
            
            if ($DEBUG) {
                debug_print("ts=".$t . " " . $logdir,"file","green");
                debug_print("Check for new file " . $new_export_file);
            }
            
            // check if more data is available in a new file (i.e day change)
            
            if (!file_exists($logdir . $new_export_file)) {
                debug_print("File not found for day ".$d."/".$m."/".$y);
                if (($t < (time() - 86400 * 30)) || ($t > time())) {
                    $logdir          = $prefix . "/logs/" + strftime("%Y", time()) . "/" . strftime("%m", time()) . "/";
                    $new_export_file = strftime("%Y%m%d", time()) . "_0.csv";
                    $found_file = 1;
                    // if we have switched days
                    if ($new_export_file != $last_export_file) {
                        
                        
                        if ((time() - $last_export_time) > (15*60)) {
                            $last_export_file    = $new_export_file;
                            $last_export_filepos = 0;
                        }
                    }
                }
                
            } else {
                debug_print("Using file for day ".$d."/".$m."/".$y);
                $found_file=1;
                $last_export_file    = $new_export_file;
                $last_export_filepos = 0;
            }
        }
    }
            
    debug_print("3. last_export_file=" . $last_export_file,"file","green");
    $has_data=0;
    
    $f_csv_log = fopen($logdir . $last_export_file, "r");
    if ($f_csv_log) {
        $csv_line = fgets_long($f_csv_log);
        $csv_headers=explode($csv_line, ',');
        $csv_line='';
        fseek($f_csv_log, $last_export_filepos, 0);
        
        // make sure to respect the inverval (skip any lines in-between)
        $csv_interval = 0;
        debug_print("Reading up to 1 lines ","file","green");
        
        for ($lines=0;$lines <= 1;$lines++) {
            $csv_line = fgets_long($f_csv_log);
            print($csv_line."\r\n");
            if (!$csv_line) {
                if (feof($f_csv_log)) {
                    if ($DEBUG) {
                        print("End of log reached, lines=" . $lines . "\r\n");
                    }
                    break;
                }
            }

            $f_arr=explode($csv_line, ',');
            
            //log ("intval(f_arr[0]) = ".intval($f_arr[0]). " csv_interval=".$csv_interval. " lines =".$lines);
            if (is_numeric($f_arr[0]) && (intval($f_arr[0]) - $csv_interval>= $_GLOBALS['MQTTJSON_interval'])) {//&&
               //(intval(strftime("%M", intval($f_arr[0]))) % $_GLOBALS['QOS_interval'] == 0))  {
                if ($DEBUG) {
                    print("Adding line. \r\n");
                }

                $csv_data = $f_arr;
                
                // free memory;
                $f_arr = 0;
                
                
                // free memory
                $csv_line = '';
                $has_data=1;
                break;
            } else {
                $lines--;
                if ($DEBUG)
                    print("Skipping line... ".intval(intval($f_arr[0])/60)." ".$_GLOBALS['MQTTJSON_interval']."\r\n");
            }
	    
		}
		
		
		$last_export_filepos = ftell($f_csv_log);
		if ($DEBUG) {
		    debug_print("update last_export_file=" . $last_export_file,"file","green");
		}
		ini_set("/logs/mqttjson_status.ini", "export", "filepos", $last_export_filepos);
		ini_set("/logs/mqttjson_status.ini", "export", "last_export", time());
		ini_set("/logs/mqttjson_status.ini", "export", "file", $last_export_file);
		
		
        fclose($f_csv_log);
    }
        
/* --- end historic data */
    if ($has_data) {
        $roles=array();
        for ($i=0;$i<sizeof($csv_headers);$i++) {
            $roles[$csv_headers[$i]]=$csv_data[$i];
        }
        //print_r($roles);
        $output="";
        $done=0;
        max_execution_time(35);
        while (!$done) {
            $key_start_pos=strpos($_buf,'{{');
            if ($key_start_pos==-1) {
                $done=1;
            }
            if ($key_start_pos==-1) {   // no more keys to parse
                $output.=$_buf;
            } else {
                $output.=substr($_buf,0,$key_start_pos);
                $_buf=substr($_buf,$key_start_pos+2);
                $key_end_pos=strpos($_buf,'}}');
                if (!$key_end_pos) {  // mismatch - no end key
                    $output="closing }} not found in template";
                    $done=1;
                } else {
                    $tag=substr($_buf,0,$key_end_pos);
                    if (trim($tag)!='') {
                        if (strtolower(trim($tag))=="do") {
                            $_buf=substr($_buf,$key_end_pos+2);
                            $_loop_buf=$_buf; // full loop buff here
                        } else if (strtolower(substr($tag,0,6))=="while "){
                            $_buf=substr($_buf,$key_end_pos+2);
                            $tag=substr($tag,6);
                            $result=parseExpression($tag);
                            if (intval($result)>0) {
                                $_buf=$_loop_buf;
                            }
                        } else {
                            $result=parseExpression($tag);
                            $output.= $result;
                            $_buf=substr($_buf,$key_end_pos+2);
                        }
                        
                    }
                }
            }
        }
        mqtt_publish($_GLOBALS['MQTTJSON_channel'],$output);
        print($output);
        if ($_GLOBALS['MQTTJSON_debug']) {
            log("[mqttjson] Published JSON data for timestamp ".$csv_data[0]);
        }
    } else {
        print("no data...");
    }
    
} else {
    print($_GLOBALS['MQTTJSON_cnt']." < ".$_GLOBALS['MQTTJSON_interval']);
}


?>
