<?
/**
 * @package MQTTJSON
 * @author Akash Heimlich
 * @description MQTT Message enpoint management
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function MQTTJSON_install($val) {
    	$stack_size=ini_get("/config/uphp.ini","debug","stack_size",0);
    	if ($stack_size<3000) 
	    ini_set("/config/uphp.ini","debug","stack_size",3000);
    	$call_depth=ini_get("/config/uphp.ini","debug","call_depth",0);
    	if ($call_depth<10) 
	    ini_set("/config/uphp.ini","debug","call_depth",10);
	    
        MQTTJSON_enable();
        return 1;
    }
     
    function MQTTJSON_uninstall() {
        setPackageStatus("MQTTJSON",0);
        return 1;
    }
    
    function MQTTJSON_enable() {
        setPackageStatus("MQTTJSON",2);
        return 1;
    }
    
    function MQTTJSON_disable() {
        setPackageStatus("MQTTJSON",3);
        return 1;
    }
    
    function MQTTJSON_status() {
        $MQTTJSON_enabled=ini_get("/config/mqttjson.ini","config","enabled",1);
        if (!$MQTTJSON_enabled) {
            return "MQTT is not enabled.";
        }
        if ($_GLOBALS['MQTTJSON_connected']) {
            return "MQTT is enabled and connected to the server";
        }
        return "MQTT is enabled but not connected to the server";
    }
    /* this is called at system boot */
    function MQTTJSON_init() {
        
        $MQTTJSON_enabled=ini_get("/config/mqttjson.ini","config","enabled",0);
        $_GLOBALS['MQTTJSON_debug']=ini_get("/config/mqttjson.ini","config","debug",0);
        
        $_GLOBALS['MQTTJSON_interval']=ini_get("/config/mqttjson.ini","config","interval",60);

        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/MQTTJSON.cgi?action=configure';
        $arr['title']='MQTT JSON';
        $arr['icon']='icon-hdd';
        $arr['desc']='MQTT JSON settings';
        
		if (!$_GLOBALS['hooks']) 
			$_GLOBALS['hooks']=array();

		if (!$_GLOBALS['hooks']['menu']) 
			$_GLOBALS['hooks']['menu']=array();

		// add this to the sidebar

		$item=array();
		$item['link']='/package/MQTTJSON.cgi?action=configure';
		$item['title']='Configure MQTT-JSON';
		$item['icon']='fa-handshake';
		$_GLOBALS['hooks']['menu']['mqttjson']=$item;




         if (!is_array($_GLOBALS['hooks']['footer']))
            $_GLOBALS['hooks']['footer']=array();
            
        $_GLOBALS['hooks']['footer']['mqttjson']='/package/mqttjson/MQTTJSONFooter.inc';   
        
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/mqttjson/MQTTJSONAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/mqttjson/MQTTJSONAjax.inc';

        // runs this file once a second
        if (file_exists('/package/mqttjson/MQTTJSONSec.cgi')) 
            $_GLOBALS['hooks']['sec'][]='/package/mqttjson/MQTTJSONSec.cgi';
            
        // runs this file once a minute
        if (file_exists('/package/mqttjson/MQTTJSONMin.cgi')) 
            $_GLOBALS['hooks']['min'][]='/package/mqttjson/MQTTJSONMin.cgi';
            
        // runs this file once a day
        if (file_exists('/package/mqttjson/MQTTJSONDay.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/mqttjson/MQTTJSONDay.inc';            
            
        // channel to publish  to
        $_GLOBALS['MQTTJSON_channel']=ini_get("/config/mqtt.ini","config","channel","");
        // template file
        $_GLOBALS['MQTTJSON_template']=ini_get("/config/mqtt.ini","config","template","/package/mqttjson/template.txt");


        return 1;
    }
    
    function MQTTJSON_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="MQTT"; 
        $config_file="mqttjson.ini";
        $config_section="config";
        $rev=ini_get("/package/MQTTJSON.ini","package","version","");
        $title='MQTTJSON '.($rev).'<small> Configuration Settings</small>';
        $header_subtitle=MQTTJSON_status();
        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> 
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<div class="row">

    <div class="col-md-12 col-xl-12">
        <div class="tab-content">
            <div class="tab-pane fade show active" id="account" role="tabpanel">        
            
            
                <div class="card">
                        <div class="card-body">
                            <div class="py-2 border-bottom d-lg-block">
									<div class="d-flex align-items-center py-1">
										<div class="flex-grow-1 ps-3">
											<h5>Configuration Options</h5>
										</div>
									</div>
								</div>
                        
                            <p class="card-text">

                            <div class="alert alert-success alert-dismissible" role="alert" ng-cloak ng-show="successmsg">
                                <div class="alert-message">
                                    {{successmsg}}
                                </div>

                            </div>
                            <div class="alert alert-danger alert-dismissible" role="alert" ng-cloak ng-show="errormsg">
                                <div class="alert-message">
                                    {{errormsg}}
                                </div>

                            </div>
     
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','deviceedit')) ?></div>

<form id="form" name="form" class="css-form">

    <div ng-init="channel='<? print(ini_get("/config/mqttjson.ini","config","channel","")); ?>';"></div>
    <div ng-init="template='<? print(ini_get("/config/mqttjson.ini","config","template","/package/mqttjson/template.txt")); ?>';"></div>
    <div ng-init="interval=<? print(ini_get("/config/mqtt.ini","config","interval",15)); ?>;"></div>
    <div ng-init="debug=<? print(ini_get("/config/mqtt.ini","config","debug",0)); ?>;"></div>



            	            <div class="mb-3 row">
                                <label for="debug" class="col-form-label col-sm-2 text-sm-end pt-sm-0">Debug Mode</label>
                                <div class="col-sm-10">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" ng-model="debug" id="debug1" value="0">
                                        <label class="form-check-label" for="debug1">
                                            &nbsp;<? print(lang('DISABLED','network3g')) ?>
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" ng-model="debug" id="debug2" value="1">
                                        <label class="form-check-label" for="debug2">
                                            &nbsp;<? print(lang('ENABLED','network3g')) ?>
                                        </label>
                                    </div>
                                    <small id="dnHelp" class="form-text text-muted">MQTT JSON debug mode (to log file)</small>
                                </div>
                                
                            </div>
<br/>
<div class="card" >
    <div class="card-body">
        <h5 class="card-title">MQTT JSON Publishing</h5>
        <p class="card-text">
			<div class="mb-3 row">
                <label class="col-form-label col-sm-2 text-sm-end">Publish Channel</label>
                <div class="col-sm-10">
                    <input type='text' class="form-control" id="channel" ng-model="channel" aria-describedby="buserHelp" placeholder="MQTT Publish Channel">
                    <small id="dnHelp" class="form-text text-muted">MQTT Channel</small>
                </div>
            </div>

            <div class="mb-3 row" >
                <label class="col-form-label col-sm-2 text-sm-end">Publish interval in seconds</label>
                <div class="col-sm-10">
                    <input type='text' class="form-control" id="interval" size='4' integer minval="1" maxval="65535" ng-model="interval" aria-describedby="buserHelp" placeholder="MQTT publish interval">
                    <small id="dnHelp" class="form-text text-muted">This can be reduced below 60 seconds to push historic data.  Since the package uses the CSV data, it will not push more than once per minute when all historic data is pushed</small>
                    <small ng-cloak class='text-danger' ng-show="form.interval.$invalid">Invalid interval</small>
                </div>
            </div>    
        
			<div class="mb-3 row">
                <label class="col-form-label col-sm-2 text-sm-end">MQTT Template File</label>
                <div class="col-sm-10">
                    <input type='text' class="form-control" id="template" ng-model="template" aria-describedby="buserHelp" placeholder="MQTT Template File">
                    
                    <small id="dnHelp" class="form-text text-muted">Path and filename (i.e. /config/mqtt_template.txt) </small>
                    <button class="btn btn-primary" ng-hide='loading==1'  ng-click="editTemplate()">EDIT TEMPLATE</button>
                </div>
            </div>

        </p>
    </div>
</div>
<br/>
 <div class="mb-3 row">
								<div class="col-sm-10 ms-sm-auto">
                                    <button class="btn btn-primary" ng-hide='loading==1'  ng-click="saveSettings()"><? print(lang('APPLY','deviceedit')) ?></button>
                                </div>
                            </div>
                            <div class="alert alert-success alert-dismissible" role="alert" ng-cloak ng-show="successmsg">
                                <div class="alert-message">
                                    {{successmsg}}
                                </div>

                            </div>
                            <div class="alert alert-danger alert-dismissible" role="alert" ng-cloak ng-show="errormsg">
                                <div class="alert-message">
                                    {{errormsg}}
                                </div>

                            </div>
<br/>        
	</p>
    </div>
</div>
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

document.addEventListener("DOMContentLoaded", function() {
			// Select2
			$(".select2").each(function() {
				$(this)
					.wrap("<div class=\"position-relative\"></div>")
					.select2({
						placeholder: "Select value",
						dropdownParent: $(this).parent()
					});
			});
});
</script>
 <?
        include("/app/footer.inc");?>
<script>
function MQTT($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.regexURL = $scope.regex = new RegExp('^((https?|ftp)://)?([a-z0-9]+[.])?[a-z0-9-]+([.][a-z]{1,4}){1,2}(/.*[?].*)?$', 'i');
   $scope.loading=0;
   $gscope=$scope;
    $scope.editTemplate=function() {
        path=$scope.template.split('/');
        thepath="";
        for (i=0;i<path.length-1;i++) {
            thepath=thepath+path[i]+"/";
        }
        console.log(thepath);
        window.open("/app/edit.cgi?dir="+thepath+"&fn="+path[path.length-1],"_blank");
    }
   $scope.saveSettings=function() {
   $scope.successmsg="";
    //console.log(publish_dev);
    //return;
       post_data="enabled="+$scope.enabled;
       post_data+="&template="+btoa(encodeURIComponent($scope.template));
       post_data+="&debug="+$scope.debug;
       post_data+="&channel="+$scope.channel;
       post_data+="&interval="+$scope.interval;
       post_data+="&encoded_keys=template";
       post_config="mqttjson.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
       
}
   </script>
   
       
    <?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>












