<pre><?
/**
 * @package FTP Min
 * @author Akash Heimlich
 * @description Runs once a minute
 */
function is_ok($str) {
    $res=1;
    $res=ereg("^[a-zA-Z0-9_.,-]*$",&$str);
    return $res;
}

$_GLOBALS['ftp_counter']++;

$y = strftime("%y", time());
$y2 = strftime("%Y", time());
$day = strftime("%d", time());
$m = strftime("%m", time());
$base_dir = "/logs/";
$fs_prefix = '';

if ($_SERVER['HW_PLATFORM']==11) {
	$fs_prefix = '0:';
}
if ($_SERVER['HW_PLATFORM']>=20)   // ULTRA, Mega2, Mega2-4G
	$fs_prefix = intval($_GLOBALS['log_drive']) . ':';    
	
// if data logging is necessary

$min = intval(strftime("%M", time()));

$ftp_enabled = ini_get("/config/ftp.ini", "config", "ftp_enabled", 1);
    
if ($ftp_enabled) {
    
    $last_export_time = ini_get($fs_prefix."/config/ftp_status.ini", "status", "last_export", 0);
    $last_export_file = ini_get($fs_prefix."/config/ftp_status.ini", "status", "file", "");
    $last_export_filepos = ini_get($fs_prefix."/config/ftp_status.ini", "status", "filepos", 0);
        
	print("last export time=".$last_export_time."\r\n");
	print("last export file=".$last_export_file."\r\n");
	print("last export pos=".$last_export_filepos."\r\n");
	
    $logdir = $fs_prefix . "/logs/" + strftime("%Y",time()) . "/" . strftime("%m", time()) . "/";
    
    // this will be set if execution should be aborted
    $ftp_skip = 0;
    
    // month change bug
    
    
	// if this is new, just start from now
    if (!$last_export_file) {
        
        $last_export_time = time();
        $m = strftime("%M", time());
        $h = strftime("%H", time());
        
        $last_export_file = strftime("%Y%m%d", time()) . "_0.csv";
        $last_export_filepos = filesize($logdir . $last_export_file);
        
        print("updating ini file");
        
        ini_set($fs_prefix . "/config/ftp_status.ini", "status", "filepos", $last_export_filepos);
        ini_set($fs_prefix . "/config/ftp_status.ini", "status", "last_export", time());
        ini_set($fs_prefix . "/config/ftp_status.ini", "status", "file", $last_export_file);
            	                    
    } else {
		$y = substr($last_export_file, 0, 4);
		$m = substr($last_export_file, 4, 2);
		$cury = strftime("%Y", time());
		
		if ($y < $cury - 1) {
			print("Year wrong, resetting log file (cury=" . $cur . " and year=" . $y);
			unlink($fs_prefix . "/config/ftp_status.ini");
			$ftp_skip = 1;
		}
       
        $logdir=$fs_prefix."/logs/"+$y."/".$m."/";
    }
        
    $last_size = filesize($logdir.$last_export_file);
    
    if (!$ftp_skip) {
        
        if ($last_size <= $last_export_filepos + 2) {  // added 2 bytes if the last line is CR+LF
    
			$y = substr($last_export_file, 0, 4);
			$m = substr($last_export_file, 4, 2);
			$d = substr($last_export_file, 6, 2);
			
			print("fn=" . $y . " " . $m . " " . $d . "\r\n");
			
			$t = mktime(0, 0, 0, intval($m) - 1, intval($d), intval($y)) + 86400;
			
			// iterate through the days until today in case the Wattmon was offline for more than 1 day
			
			while ($t < time()) {
		        $m = strftime("%m", $t);
		        $d = strftime("%d", $t);
				$y = strftime("%Y", $t);
				
				$logdir = $fs_prefix . "/logs/" . $y . "/" . $m . "/";
				
			    $new_export_file = strftime("%Y%m%d", $t) . "_0.csv";
				
			    print($t . " " . $logdir);
		        
		        print("Check for new file " . $new_export_file);
		        
				if (file_exists($logdir . $new_export_file)) {
					log("[ftp] Starting to export from " . $new_export_file);
		            $last_export_file = $new_export_file;
		            $last_export_filepos = 0;
		            break;
				}
				$t += 86400; // add 1 day
			}
			if (!file_exists($logdir . $new_export_file)) {
					
					if (($t < (time() - 86400 * 30)) || ($t > time())) {
					    
				        $logdir = $fs_prefix . "/logs/" + strftime("%Y", time()) . "/" . strftime("%m", time()) . "/";
		            	$new_export_file = strftime("%Y%m%d", time()) . "_0.csv";
		            	
				        // if we have switched days
				        
				        if ($new_export_file != $last_export_file) {
				            if ((time() - $last_export_time) > (intval($ini['intervalportal']) * 6)) {
				                $last_export_file = $new_export_file;
				                $last_export_filepos = 0;
				                
				            }
				        }
					}
			}
        }
            
        // if for any reason the log file does not exist, just move to today's file at the current position.
        
        if (file_exists($logdir . $last_export_file)) { // && ($min %5==0)) {
                
            $fsize = filesize($logdir . $last_export_file);
            $has_data = 0;
            
            if ($last_export_filepos < $fsize) {
                print("last_log_pos=" . $last_export_filepos . " and filesize=" . $fsize . "\r\n");
                
                $local_log_file = $last_log_file;
                $has_data = 1;
            } 
    		
            if ($has_data) {
                $cur_line = 0;
                $log_st = '';
                
                log("[ftp] ftp status is: " . ftp_is_busy());
                
                $host = ini_get("/config/ftp.ini", "config", "ftp_url", "");
                $user = ini_get("/config/ftp.ini", "config", "ftp_username", "");
                $pass = ini_get("/config/ftp.ini", "config", "ftp_password", "");
                $ftp_secure = ini_get("/config/ftp.ini", "config", "ftp_secure", 0);
                $ftp_ignore_response = ini_get("/config/ftp.ini", "config", "ftp_ignore_response", 0);
                $folder_path = ini_get("/config/ftp.ini", "config", "ftp_path", "/");
                $multiple_files = ini_get("/config/ftp.ini", "config", "multiple_files", 1);
                $prefix = ini_get("/config/ftp.ini", "config", "ftp_prefix", "");
                $port = ini_get("/config/ftp.ini", "config", "ftp_port", 21);
                $ftp_partial_upload = ini_get("/config/ftp.ini", "config", "ftp_partial_upload", 0);
                max_execution_time(60);
                
                if (ftp_is_busy()) {
                    $stat = ftp_status();
                    
                    if ($stat['status'] == -1) 
                        $_GLOBALS['ftp_busy'] = 5; 
                        
                    $_GLOBALS['ftp_busy']++;
                    
                    log("FTP is busy...");
                    print("FTP is busy...");
                    
                    if ($_GLOBALS['ftp_busy'] > 5) {
                        log("Force close FTP..");
                        ftp_close();
                    } else {
                        $ftp_skip = 1;
                    }
                } else {
                    
                    $_GLOBALS['ftp_busy'] = 0;
                    
                    if ($_GLOBALS['log_level'] == 2) {
                        log("[ftp] Connected=" . ftp_is_connected());
                    }
                    
                    if (!ftp_is_connected()) {
                        
                        $ftp = ftp_open($host, $port, $user, $pass, $ftp_secure, 1, $ftp_ignore_response);
                        
                        if ($_GLOBALS['log_level'] == 2) {
                            print("[ftp] open result=".$ftp);
                            log("[ftp] open result=".$ftp);
                        }
                        
                        if (!$ftp) {
                            log("ERROR ESTABLISHING");
                            print("ERROR ESTABLISHING");
                            
                            if (!ftp_is_busy()) {
                                ftp_close();
                            }
                            $ftp_skip = 1;
                        }
                    }
                    
                    $timeout = time();
                    max_execution_time(45);
                    $ftp_skip=0;
                    while (!$ftp_skip && !ftp_is_connected()) {
                        
                        if (ftp_error() > 0) {
                            print("FTP ERROR " + ftp_error());
                            ftp_close();
                            
                            $ftp_skip = 1;
                            //break;
                        }
                        if (time()-$timeout > 25) {
                            print("FTP TIMEOUT " + ftp_error());
                            ftp_close();
                            
                            $ftp_skip = 1;
//                            break;
                        }
                        
                    }
                    
                    if (!$ftp_skip) {

                        $res = ftp_command("cwd " . $folder_path);
                        if ($_GLOBALS['log_level'] == 2) {
                            print("cwd result=" . $res);
                            log("cwd result=" . $res." (".$folder_path.")");
                        }
                        
                        // standard upload method - just sync
                        if (!$multiple_files) {
                            
                            $size = ftp_size($last_export_file);
                            print("File size=" . $size);
                            
                            if ($size != filesize($logdir . $last_export_file)) {
                                
                                print("File size is ".$size."\r\n");
                                
                                if ($size < 0) 
                                    $size = 0;
                                
                                $res = ftp_upload($last_export_file, $logdir . $last_export_file, $size, 1,$ftp_partial_upload);
                                print ("upload result is " . $res);
                                
                                if ($res == 1) {
                                    
                                    ini_set($fs_prefix."/config/ftp_status.ini", "status", "filepos", filesize($logdir . $last_export_file));
                                    ini_set($fs_prefix."/config/ftp_status.ini", "status", "file", $last_export_file);
                
                                } else {  // deal with dongle reconnection issue
                                    $stat=get3gstat(); 
                                    
                                    if ($stat['enabled']) {
                                        if ($stat['connected']) {
                                            if ($stat['ip_address']!='0.0.0.0') {
                                                $_GLOBALS['error3g']++;
                                                
                                                if ($_GLOBALS['error3g'] >= 5) {
                                                    log("Cellular link seems to have died, restarting USB power");
                                                    
                                                    setusbpower(0);
                                                    sleep(100);
                                                    setusbpower(1);
                                                    
                                                    $_GLOBALS['error3g']=0;
                                                }
                                                    
                                            }
                                        }
                                    }
                                }
                            } else {
                                print("Nothing to do.  Remote File size is ".$size);
                                ini_set($fs_prefix."/config/ftp_status.ini","status","filepos",$size);
                                ini_set($fs_prefix."/config/ftp_status.ini","status","file",$last_export_file);
                            }
                            
                        } else {  // multiple files
                        
                            if (!file_exists($fs_prefix.'/logs/ftp_temp.csv')) {
                                
                                print('/logs/ftp_temp.csv does not exist, creating it..\r\n');
                                if ($_GLOBALS['log_level'] == 2) {
                                    log('/logs/ftp_temp.csv does not exist, creating it..\r\n');
                                }
                                
                                $f_log = fopen($logdir . $last_export_file, "r");
                                $lines = array();
                                $export_size = 0;
                                $csv_size = 0;
                                $mem_lines = 0;
                
                                if ($f_log) {
                                    // navigate to the last saved pos
                                    print("Seeking to " .$last_export_filepos . "\r\n");
                                    fseek($f_log, $last_export_filepos, 0);
                                    
                                    print("<pre>");
                                    
                                     // include the fgets_long function
                                    include("/lib/uphp/fileio.inc");
                                    
                                    for ($l = 0; $l < 15; $l++) {
                                        
                                        $st = fgets_long($f_log);
                                        
                                        if (!$st) {
                                            break;
                                        }
                                        
                                        $dt = intval(substr($st, 0, strpos($st, ',')));
                                        $dt = intval(strftime("%Y", $dt));
                                        
                                        print("Line: ". $st ."\r\n");
                                        
                                        if (is_ok($st) && ($dt >= 2015)) {
                                            print($dt . " OK\r\n");
                                            $st .= "\r\n";
                                            $export_size += strlen($st);  // add cr+lf
                                            $csv_size += strlen($st);
                                            $lines[$l] = $st;$st="";
                                        } else {
                                            $l--;
                                            $csv_size+=strlen($st);
                                            log("[csv] Year=".$a." skipping CSV line ".$st);
                                        }
                                    }
                                    
                                    print("<pre>Found ". ($l - $mem_lines) . " lines\r\n");
                                    print("Export_file =" . $last_export_file . "\r\n");            
                                    print("File_size =" . filesize($logdir . $last_export_file) . "\r\n");
                                    print("Export_size =" . $export_size . "\r\n");
                                    print("CSV _size =" . $csv_size . "\r\n");
                                    print("CUR POSITION=" . ftell($f_log) . "\r\n");
                                    
                                    $fp = ftell($f_log);
                                    
                                    ini_set($fs_prefix."/config/ftp_status.ini", "status", "filepos", $fp);
                                    ini_set($fs_prefix."/config/ftp_status.ini", "status", "file", $last_export_file);
                                    
                                    fclose($f_log);
                                    
                                    $f = fopen($fs_prefix.'/logs/ftp_temp.csv','w');
                                    $ini = ini_get_array("/config/dataexport.ini","export");
        
                                    $num_groups = ini_get("/config/datalog.ini","data","num_groups",0);
                                    
                            		$static_header = intval($ini['static_header']);
                            		
                                    if ($static_header && file_exists("/config/csv_headers.txt")) {
                                        print("Found static csv_headers\r\n");
                                        
                                        $data='';
                                        
                                        $fh = fopen("/config/csv_headers.txt", "r");
                                        while (!feof($fh)) {
                                            $data .= fread($fh, 512);
                                        }
                                        fclose($fh);
                                    } else {
                                    
                                        $data='"ts",';
                                        for ($i=0;$i<$num_groups;$i++) {
                                            $s=ini_get("/config/datalog.ini","data",'group'+$i+'status',0);
                                            
                                            if ($s==1) {
                                    
                                                $logfile2 = $fs_prefix."/logs/log_"+$i+".ini";
                                                //$arr=ini_get_array($logfile2);
                                                
                                                $grpnvar=ini_get("/config/datalog.ini","data",'group'+$i+"numvar",0);
                                                for ($j=0;$j<$grpnvar;$j++) {
                                                    $vt=ini_get("/config/datalog.ini","data",'group'+$i+'var'+$j+'vartype',0);
                                                    $vfn=ini_get("/config/datalog.ini","data",'group'+$i+'var'+$j+'varfn',0);
                                                    $vval=ini_get("/config/datalog.ini","data",'group'+$i+'var'+$j+'varval',0);
                                                    if ($vt==1) {  // system
                                                        $varst=ini_get("/config/sysvars.ini","sysvars","sysvar".$vval."name","");
                                                        $varr=explode($varst,';');
                                                        if ($varr[0]=='V') {
                                                            $varst=$varr[1];
                                                        } else {
                                                            if ($varr[0]=='G') {
                                                                $varst=$varr[2].$varr[1];
                                                            }
                                                        }
                                                    } else {
                                                        if ($vt==2) {  // device
                                                            $varst=ini_get("/config/roles.ini","roles","role".$vval,"");
                                                        }
                                                        if ($vt==3) {  // global
                                                            //$varst=$vval;
                                                             $varst=ini_get("/config/datalog.ini","data",'group'+$i+'var'+$j+'varval','');
                                                        }                
                                                    }
                                                    //$data.="\"".$varst."\":\"".$arr['data']['p'.$j]."\"";
                                                    $data.='"'.$varst.'"';
                                                    if ($j<($grpnvar-1)) $data.=",";
                                                }
                                    
                                            }
                                        }
                                    }
                                    fwrite($f, $data);
                                    fwrite($f, "\r\n");
                                    for ($i = 0; $i < sizeof($lines); $i++) {
                                        fwrite($f,$lines[$i]);
                                    }
                                    fclose($f);
                                    print('/logs/ftp_temp.csv created..size=' . filesize('/logs/ftp_temp.csv').'\r\n');
                                    
                                }   
                            }
                            
                            $st = $prefix . substr($last_export_file, 0, strlen($last_export_file) - 4) . time() . ".csv";
                            
                            $res = ftp_upload($st, $fs_prefix."/logs/ftp_temp.csv", 0, 1,$ftp_partial_upload);
                            if ($_GLOBALS['log_level'] == 2) {
                                log ("upload result is " . $st." ".$res);
                            }
                            
                            print ("upload result is " . $res);
                             
                            if ($res==1) {
                                log('deleting file as it was uploaded\r\n');       
                                unlink($fs_prefix."/logs/ftp_temp.csv");
                
                            } else {  // deal with dongle reconnection issue
                                $stat=get3gstat(); 
                                if ($stat['enabled']) {
                                    if ($stat['connected']) {
                                        if ($stat['ip_address']!='0.0.0.0') {
                                            $_GLOBALS['error3g']++;
                                            if ($_GLOBALS['error3g']>=5) {
                                                log("Cellular link seems to have died, restarting USB power");
                                                setusbpower(0);
                                                sleep(100);
                                                setusbpower(1);
                                                $_GLOBALS['error3g']=0;
                                            }
                                                
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
} else { // FTP Enabled
    print("FTP Is disabled");
}
// end
?>








