<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : settings.cgi
 * 
 *  Description: Control panel page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *                      14/02/17    added support for mega
 * Ruchir Sharma        17/10/17    changed layout and added modbus comm
 * Akash Heimlich       20/06/18    WattmonOS 3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="SettingCtrl"; 
$title=lang('SETTINGS','settings');
include("/app/header.inc");
print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
?>
<style>
.card {
position:inherit!important;
}
</style>
<h2> <? print(lang('CONTROL_PANEL','settings')) ?></h2>
<h4> <? print(lang('BASIC_CONFIG','settings')) ?></h4>
    <div class="card-columns">
            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-group  pull-left"></i><? print(lang('USERS','settings')) ?></h5>
                    <p class="card-text"><? print(lang('USERS_DESC','settings')); ?></p>
                    <a href="/app/user.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>
        <? if (($_SERVER['HW_PLATFORM']<=1) || ($_SERVER['HW_PLATFORM']==10) ) { ?>
            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-tasks  pull-left"></i><? print(lang('BATTERY','settings')) ?></h5>
                    <p class="card-text"><? print(lang('BATTERY_DESC','settings')) ?></p>
                    <a href="/app/battery.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>
        <? } ?>
            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-cog  pull-left"></i><? print(lang('MBTEST','settings')) ?></h5>
                    <p class="card-text"><? print(lang('MBTEST_DESC','settings')); ?></p>
                    <a href="/app/modbustest.cgi" class="btn btn-outline-light"><? print(lang('OPEN','settings')) ?></a>
                </div>
            </div>
            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-time  pull-left"></i><? print(lang('TIME','settings')) ?></h5>
                    <p class="card-text"><? print(lang('TIME_DESC','settings')); ?></p>
                    <a href="/app/datetime.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>
            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-envelope  pull-left"></i><? print(lang('EMAIL','settings')) ?></h5>
                    <p class="card-text"><? print(lang('EMAIL_DESC','settings')); ?></p>
                    <a href="/app/email.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>
            <div class="card  text-white bg-warning">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-globe  pull-left"></i><? print(lang('NETWORK','settings')) ?></h5>
                    <p class="card-text"><? print(lang('NETWORK_DESC','settings')); ?></p>
                    <a href="/app/network.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>
<? if (($_SERVER['HW_PLATFORM']>=20) || ($_SERVER['HW_PLATFORM']==12)) { ?>            
            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-hdd  pull-left"></i><? print(lang('USB_ALT','settings')) ?></h5>
                    <p class="card-text"><? print(lang('USB_ALT_DESC','settings')); ?></p>
                    <a href="/app/usb.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>

<? } else { ?>    
            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-hdd  pull-left"></i><? print(lang('USB','settings')) ?></h5>
                    <p class="card-text"><? print(lang('USB_DESC','settings')); ?></p>
                    <a href="/app/usb.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>
            
<? } ?>
<? if (($_SERVER['HW_PLATFORM']==1) || ($_SERVER['HW_PLATFORM']==10)  || ($_SERVER['HW_PLATFORM']==11)) { ?>
            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-bolt  pull-left"></i><? print(lang('ONEWIRE','settings')) ?></h5>
                    <p class="card-text"><? print(lang('ONEWIRE_DESC','settings')); ?></p>
                    <a href="/app/onewire.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>
        <? } ?>
            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-signal  pull-left"></i><? print(lang('CELLULAR','settings')) ?></h5>
                    <p class="card-text"><? print(lang('CELLULAR_DESC','settings')); ?></p>
                    <a href="/app/network3g.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>
            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-download  pull-left"></i><? print(lang('BACKUP','settings')) ?></h5>
                    <p class="card-text"><? print(lang('BACKUP_DESC','settings')); ?></p>
                    <a href="/app/backup.cgi" class="btn btn-outline-light"><? print(lang('OPEN','settings')) ?></a>
                </div>
            </div>
            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-info-sign  pull-left"></i><? print(lang('ABOUT','settings')) ?></h5>
                    <p class="card-text"><? print(lang('ABOUT_DESC','settings')); ?></p>
                    <a href="/app/about.cgi" class="btn btn-outline-light"><? print(lang('OPEN','settings')) ?></a>
                </div>
            </div>
            <div class="card  text-white bg-danger">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-cogs  pull-left"></i><? print(lang('MBCOMM','settings')) ?></h5>
                    <p class="card-text"><? print(lang('MBCOMM_DESC','settings')); ?></p>
                    <a href="/app/modbusconfig.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>
            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-cogs  pull-left"></i><? print(lang('SNMP','settings')) ?></h5>
                    <p class="card-text"><? print(lang('SNMP_DESC','settings')); ?></p>
                    <a href="/app/snmp.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>
            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-cogs  pull-left"></i><? print(lang('OTA','settings')) ?></h5>
                    <p class="card-text"><? print(lang('OTA_DESC','settings')); ?></p>
                    <a href="/app/ota.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>
            
<? if (($_SERVER['HW_PLATFORM']==11)|| ($_SERVER['HW_PLATFORM']>=20)) { ?>            
            <div class="card  text-white bg-danger">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-cogs  pull-left"></i><? print(lang('FLASH','settings')) ?></h5>
                    <p class="card-text"><? print(lang('FLASH_DESC','settings')); ?></p>
                    <a href="/app/flash.cgi" class="btn btn-outline-light"><? print(lang('OPEN','settings')) ?></a>
                </div>
            </div>
            <div class="card  text-white bg-warning">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-globe pull-left"></i><? print(lang('WIFI','settings')) ?></h5>
                    <p class="card-text"><? print(lang('WIFI_DESC','settings')); ?></p>
                    <a href="/app/wifi.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>
<? } ?>            
<? if (($_GLOBALS['VERMINOR']>1343)) { ?>            

            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="icon-globe pull-left"></i>Wattmon App</h5>
                    <p class="card-text">Wattmon App Settings</p>
                    <a href="/app/app.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>
<? } ?>            

    </div>   
    <? if (sizeof($_GLOBALS['hooks']['cpanel'])) { ?>
    <h3><? print(lang('USER_SETTINGS','settings')) ?></h3>
    <div class='card-columns'>
    <? for ($i=0;$i<sizeof($_GLOBALS['hooks']['cpanel']);$i++) { ?>
            <div class="card  text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="<? print($_GLOBALS['hooks']['cpanel'][$i]['icon']); ?>  pull-left"></i><? print($_GLOBALS['hooks']['cpanel'][$i]['title']); ?></h5>
                    <p class="card-text"><? print($_GLOBALS['hooks']['cpanel'][$i]['desc']); ?></p>
                    <a href="<? print($_GLOBALS['hooks']['cpanel'][$i]['script']); ?>" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
                </div>
            </div>
    <? } ?>            
    </div>
    <? } ?>

    <h4><? print(lang('ADVANCED_SETTINGS','settings')) ?></h4>
    
    <div class="card-columns">
       <div class="card  text-white bg-success">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-suitcase  pull-left"></i><? print(lang('WATTMONOS_UPDATER','settings')) ?></h5>
                <p class="card-text"><? print(lang('WATTMONOS_UPDATER_DESC','settings')); ?></p>
                <a href="/app/osman.cgi" class="btn btn-outline-light"><? print(lang('OPEN','settings')) ?></a>
            </div>
        </div>
        <div class="card  text-white bg-success">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-suitcase  pull-left"></i><? print(lang('PACKAGE_MANAGER','settings')) ?></h5>
                <p class="card-text"><? print(lang('PACKAGE_MANAGER_DESC','settings')); ?></p>
                <a href="/app/pacman.cgi" class="btn btn-outline-light"><? print(lang('OPEN','settings')) ?></a>
            </div>
        </div>
        <div class="card  text-white bg-success">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-suitcase  pull-left"></i><? print(lang('FIRMWARE_UPDATER','settings')) ?></h5>
                <p class="card-text"><? print(lang('FIRMWARE_UPDATER_DESC','settings')); ?></p>
                <a href="/app/firmwareman.cgi" class="btn btn-outline-light"><? print(lang('OPEN','settings')) ?></a>
            </div>
        </div>       
        <div class="card  text-white bg-warning">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-sitemap  pull-left"></i><? print(lang('DEVICES','settings')) ?></h5>
                <p class="card-text"><? print(lang('DEVICES_DESC','settings')); ?></p>
                <a href="/app/devices.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
            </div>
        </div>       
        <div class="card  text-white bg-success">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-random  pull-left"></i><? print(lang('GROUPS','settings')) ?></h5>
                <p class="card-text"><? print(lang('GROUPS_DESC','settings')); ?></p>
                <a href="/app/groups.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
            </div>
        </div>
        <div class="card  text-white bg-danger">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-wrench  pull-left"></i><? print(lang('ROLES','settings')) ?></h5>
                <p class="card-text"><? print(lang('ROLES_DESC','settings')); ?></p>
                <a href="/app/roles.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
            </div>
        </div>       
        <div class="card  text-white bg-warning">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-pushpin  pull-left"></i><? print(lang('WIDGETS','settings')) ?></h5>
                <p class="card-text"><? print(lang('WIDGETS_DESC','settings')); ?></p>
                <a href="/app/widgets.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
            </div>
        </div>
        <div class="card  text-white bg-danger">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-edit  pull-left"></i><? print(lang('DATA_COLLECTION','settings')) ?></h5>
                <p class="card-text"><? print(lang('DATA_COLLECTION_DESC','settings')); ?></p>
                <a href="/app/datalogging.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
            </div>
        </div>      
        <div class="card  text-white bg-success">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-bar-chart  pull-left"></i><? print(lang('GRAPHS','settings')) ?></h5>
                <p class="card-text"><? print(lang('GRAPHS_DESC','settings')); ?></p>
                <a href="/app/graphs.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
            </div>
        </div>
        <div class="card  text-white bg-warning">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-lightbulb  pull-left"></i><? print(lang('ACTIONS','settings')) ?></h5>
                <p class="card-text"><? print(lang('ACTIONS_DESC','settings')); ?></p>
                <a href="/app/actions.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
            </div>
        </div>
        <div class="card  text-white bg-danger">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-dashboard  pull-left"></i><? print(lang('UPHP','settings')) ?></h5>
                <p class="card-text"><? print(lang('UPHP_DESC','settings')); ?></p>
                <a href="/app/uphp.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
            </div>
        </div>   
        <div class="card  text-white bg-warning">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-exchange  pull-left"></i><? print(lang('HTTP','settings')) ?></h5>
                <p class="card-text"><? print(lang('HTTP_DESC','settings')); ?></p>
                <a href="/app/http.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
            </div>
        </div>
        <div class="card  text-white bg-danger">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-upload-alt  pull-left"></i><? print(lang('DATA_EXPORT','settings')) ?></h5>
                <p class="card-text"><? print(lang('DATA_EXPORT_DESC','settings')); ?></p>
                <a href="/app/dataexport.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
            </div>
        </div>   
        <div class="card  text-white bg-warning">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-desktop  pull-left"></i><? print(lang('INTERFACE','settings')) ?></h5>
                <p class="card-text"><? print(lang('INTERFACE_DESC','settings')); ?></p>
                <a href="/app/interface.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
            </div>
        </div>
        <div class="card  text-white bg-danger">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-refresh  pull-left"></i><? print(lang('SCHEDULED_TASKS','settings')) ?></h5>
                <p class="card-text"><? print(lang('SCHEDULED_TASKS_DESC','settings')); ?></p>
                <a href="/app/edit.cgi?dir=/config/&fn=crontab.txt" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
            </div>
        </div> 
        <div class="card  text-white bg-danger">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-legal  pull-left"></i><? print(lang('DEVICE_TYPES','settings')) ?></h5>
                <p class="card-text"><? print(lang('DEVICE_TYPES_DESC','settings')); ?></p>
                <a href="/app/devicetypes.cgi" class="btn btn-outline-light"><? print(lang('CONFIGURE','settings')) ?></a>
            </div>
        </div>  
<? if ($_SERVER['HW_PLATFORM']>=8)	{ ?>            
        <div class="card  text-white bg-danger">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-legal  pull-left"></i>EZConfig</h5>
                <p class="card-text">Inverter and power meter configuration</p>
                <a href="/app/ezconfig.cgi" class="btn btn-outline-light">RUN</a>
            </div>
        </div>  
<? } ?>    
<? if ($_SERVER['HW_PLATFORM']>=20)	{ ?>            
        <div class="card  text-white bg-warning">
            <div class="card-body">
                <h5 class="card-title"><i class="icon-legal  pull-left"></i>IEC104</h5>
                <p class="card-text">Configure IEC 104 Settings</p>
                <a href="/app/iec104.cgi" class="btn btn-outline-light">CONFIGURE</a>
            </div>
        </div>  
<? } ?>    

  </div><!--/row-->


<script>
var app = angular.module('myApp', []);    
function SettingCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";


}</script>
<? include("/app/footer.inc"); ?>