<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : devicetypeedit.cgi
 * 
 *  Description: Edit device types
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2014-18 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       18/12/13    v1.0
 * @date 05/03/16 - updated bug in roles
 * @date 04/10/17 - save using PUT, much faster
 * Akash Heimlich       10/07/18    v2.0 WattmonOS 3
 *                      20/12/18    v2.1 added Unsigned
 *                      23/04/19    doesnt jump anymore
 ********************************************************************/
include("/app/config.inc");
$angular_controller="DeviceTypeEditCtrl"; 
$title=lang('PAGE_TITLE','devicetypeedit');
include("/app/header.inc");
?>
<?
  
  $dev_type_id=$_GET['device_type_id'];
  if (!$dev_type_id) $dev_type_id=-1;
  
  $info_ini="/dev/dev"+$dev_type_id+".ini";
  $info_section="config";
  //$info=ini_get_array("/dev/dev"+$arr['device_type_id']+".ini","config");
  //$roles=ini_get_array("/config/roles.ini","roles");
  //print_r($arr);
?>
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/devicetypes.cgi"><? print(lang('DEVICE_TYPES','devicetypeedit')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','devicetypeedit')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-cog"></i>&nbsp;<? print(lang('CONFIGURE_TITLE','devicetypeedit')) ?> <small><? print($dev_type_id); ?></small></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','roleedit')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/roles.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','devicetypeedit')) ?></a>
  </li>
  <li ng-hide='settings_locked' class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','devicetypeedit')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','devicetypeedit')) ?>
  </div>
  <br/>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','devicetypeedit')) ?></div>
<form name="form" class="css-form form-horizontal" novalidate>

<!-- VARIABLES -->
<div ng-init="dev_type_id=<? print($dev_type_id); ?>;"></div>
<div ng-init="dev_name='<? print(htmlspecialchars(ini_get($info_ini,$info_section,'name','Dev '.$dev_type_id))); ?>';"></div>
<div ng-init="dev_description='<? print(htmlspecialchars(ini_get($info_ini,$info_section,'description','Dev '.$dev_type_id))); ?>';"></div>
<div ng-init="dev_category=<? print(ini_get($info_ini,$info_section,'dev_category',0)); ?>;"></div>
<div ng-init="dev_rating='<? print(ini_get($info_ini,$info_section,'dev_rating',0)); ?>';"></div>

<div ng-init="client_id=<? print(ini_get($info_ini,$info_section,'client_id',0)); ?>;"></div>
<div ng-init="auth=<? print(ini_get($info_ini,$info_section,'auth',0)); ?>;"></div>
<div ng-init="password='<? print(htmlspecialchars(ini_get($info_ini,$info_section,'password','ABCD0001'))); ?>';"></div>

<div ng-init="num_di=<? print(ini_get($info_ini,$info_section,'num_di',0)); ?>;"></div>
<div ng-init="num_do=<? print(ini_get($info_ini,$info_section,'num_do',0)); ?>;"></div>
<div ng-init="num_ro=<? print(ini_get($info_ini,$info_section,'num_ro',0)); ?>;"></div>
<div ng-init="num_roles=<? print(ini_get($info_ini,$info_section,'num_roles',0)); ?>;"></div>
<div ng-init="num_rw=<? print(ini_get($info_ini,$info_section,'num_rw',0)); ?>;"></div>
<div ng-init="num_ot=<? print(ini_get($info_ini,$info_section,'num_ot',0)); ?>;"></div>

<div ng-init="rw_poll_once=<? print(ini_get($info_ini,$info_section,'rw_poll_once',0)); ?>;"></div>
<div ng-init="ro_fn=<? print(ini_get($info_ini,$info_section,'ro_fn',0)); ?>;"></div>
<div ng-init="ro_multiblock=<? print(ini_get($info_ini,$info_section,'ro_multiblock',0)); ?>;"></div>
<div ng-init="rw_multiblock=<? print(ini_get($info_ini,$info_section,'rw_multiblock',0)); ?>;"></div>
<div ng-init="di_base_address=<? print(ini_get($info_ini,$info_section,'di_base_address',1)); ?>;"></div>
<div ng-init="do_base_address=<? print(ini_get($info_ini,$info_section,'do_base_address',1)); ?>;"></div>
<div ng-init="ro_base_address=<? print(ini_get($info_ini,$info_section,'ro_base_address',1)); ?>;"></div>
<div ng-init="rw_base_address=<? print(ini_get($info_ini,$info_section,'rw_base_address',1)); ?>;"></div>

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('DRIVER_CONFIGURATION','devicetypeedit')) ?></h5>
        <p class="card-text">    
        
             <div class="form-group">
                <label for="dev_type_id"><? print(lang('DEVICE_TYPE_ID','devicetypeedit')) ?></label>
                <input class="form-control" type='number' ng-model="dev_type_id"  class='span12' name='dev_type_id' required integer aria-describedby="rHelp" placeholder="<? print(lang('DEVICE_TYPE_ID','devicetypeedit')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('DEVICE_TYPE_ID_HELP','devicetypeedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.dev_type_id.$invalid"><? print(lang('DEVICE_TYPE_ID_INVALID','devicetypeedit')) ?></small>
            </div>
         
            <div class="form-group">
                <label for="dev_name"><? print(lang('DEVICE_NAME','devicetypeedit')) ?></label>
                <input type="text" class="form-control" ng-model="dev_name"  class='span12' ng-maxlength=64 name='dev_name' required aria-describedby="rnHelp" placeholder="<? print(lang('DEVICE_NAME','devicetypeedit')) ?>">
                <small id="rnHelp" class="form-text text-muted"><? print(lang('DEVICE_NAME_HELP','devicetypeedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.dev_name.$invalid"><? print(lang('DEVICE_NAME_INVALID','devicetypeedit')) ?></small>
            </div>	        
            
            <div class="form-group">
                <label for="dev_description"><? print(lang('DEVICE_DESCRIPTION','devicetypeedit')) ?></label>
                <input type="text" class="form-control" ng-model="dev_description"  class='span12' ng-maxlength=128 name='dev_description' required aria-describedby="rnHelp" my-directive placeholder="<? print(lang('DEVICE_DESCRIPTION','devicetypeedit')) ?>">
                <small id="rnHelp" class="form-text text-muted"><? print(lang('DEVICE_DESCRIPTION_HELP','devicetypeedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.dev_description.$invalid"><? print(lang('DEVICE_DESCRIPTION_INVALID','devicetypeedit')) ?></small>
            </div>	             
               
           <div class="form-group" ng-cloak>
                <label for="dev_category"><? print(lang('CATEGORY','devicetypeedit')) ?></label>
                <select ng-model="dev_category" name='dev_category' class="form-control">
	                <option value=0>Inverter</option>
				    <option value=1>Power Meter</option>
					<option value=2>Charge Controlle</option>
					<option value=3>Sensor</option>
					<option value=4>Other</option>
					<option value=5>Wattmon Master</option>
                </select>
                <small class="form-text text-muted"><? print(lang('CATEGORY_HELP','devicetypeedit')) ?></small>
	        </div>
	        <div class="form-group" ng-show='dev_category==0'>
                <label for="dev_rating">Inverter Rating in kW</label>
                <input type="text" class="form-control" ng-model="dev_rating"  class='span12' ng-maxlength=128 name='dev_rating' required aria-describedby="rnHelp" my-directive placeholder="Rating in kW">
                <small id="rnHelp" class="form-text text-muted">Inverter rating</small>
            </div>
			<div class="form-group">
                <label for="num_roles"><? print(lang('ROLE_COUNT','devicetypeedit')) ?></label>
                <input class="form-control" type='number' ng-model="num_roles"  class='span12' name='num_roles' required integer aria-describedby="rHelp" placeholder="<? print(lang('ROLE_COUNT','devicetypeedit')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('ROLE_COUNT_HELP','devicetypeedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.num_roles.$invalid"><? print(lang('INVALID_VALUE','devicetypeedit')) ?></small>
            </div>
            <div class="form-group" ng-hide='ro_fn==100'>
                <label for="num_di"><? print(lang('DI_COUNT','devicetypeedit')) ?></label>
                <input class="form-control" type='number' ng-model="num_di"  class='span12' name='num_di' required integer aria-describedby="rHelp" placeholder="<? print(lang('DI_COUNT','devicetypeedit')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('DI_COUNT_HELP','devicetypeedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.num_di.$invalid"><? print(lang('INVALID_VALUE','devicetypeedit')) ?></small>
            </div>
            <div class="form-group" ng-show='num_di>0'>
                <label for="di_base_address"><? print(lang('DI_BASE','devicetypeedit')) ?></label>
                <input class="form-control" type='number' ng-model="di_base_address"  class='span12' name='di_base_address'  min=0  integer aria-describedby="rHelp" placeholder="<? print(lang('DI_BASE','devicetypeedit')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('DI_BASE_HELP','devicetypeedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.di_base_address.$invalid"><? print(lang('INVALID_VALUE','devicetypeedit')) ?></small>
            </div>
            <div class="form-group" ng-cloak ng-hide='ro_fn==100'>
                <label for="num_do"><? print(lang('DO_COUNT','devicetypeedit')) ?></label>
                <input class="form-control" type='number' ng-model="num_do"  class='span12' name='num_do' required integer aria-describedby="rHelp" placeholder="<? print(lang('DO_COUNT','devicetypeedit')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('DO_COUNT_HELP','devicetypeedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.num_do.$invalid"><? print(lang('INVALID_VALUE','devicetypeedit')) ?></small>
            </div>
            <div class="form-group" ng-show='num_do>0'>
                <label for="di_base_address"><? print(lang('DO_BASE','devicetypeedit')) ?></label>
                <input class="form-control" type='number' ng-model="do_base_address"  class='span12' name='do_base_address'  min=0  integer aria-describedby="rHelp" placeholder="<? print(lang('DO_BASE','devicetypeedit')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('DO_BASE_HELP','devicetypeedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.do_base_address.$invalid"><? print(lang('INVALID_VALUE','devicetypeedit')) ?></small>
            </div>
            <div class="form-group">
                <label for="num_ro"><? print(lang('RO_COUNT','devicetypeedit')) ?></label>
                <input class="form-control" type='number' ng-model="num_ro"  class='span12' name='num_ro' min=0 required integer aria-describedby="rHelp" placeholder="<? print(lang('RO_COUNT','devicetypeedit')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('RO_COUNT_HELP','devicetypeedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.num_ro.$invalid"><? print(lang('INVALID_VALUE','devicetypeedit')) ?></small>
            </div>
            <div class="form-group">
                <label for="ro_multiblock"><small class='text-muted'><? print(lang('RO_TYPE','devicetypeedit')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ro_multiblock" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('SINGLE','devicetypeedit')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ro_multiblock" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('MULTI','devicetypeedit')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('RO_TYPE_HELP','devicetypeedit')) ?></small>
            </div>
            <div class="form-group" ng-show='ro_fn!=100 && num_ro>0 && ro_multiblock==0'>
                <label for="ro_base_address"><? print(lang('RO_BASE','devicetypeedit')) ?></label>
                <input class="form-control" type='number' ng-model="ro_base_address"  class='span12' name='ro_base_address'  min=0  integer aria-describedby="rHelp" placeholder="<? print(lang('RO_BASE','devicetypeedit')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('RO_BASE_HELP','devicetypeedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.ro_base_address.$invalid"><? print(lang('INVALID_VALUE','devicetypeedit')) ?></small>
            </div>
		 
		    <div class="form-group" ng-cloak>
                <label for="ro_fn"><? print(lang('RO_FN','devicetypeedit')) ?></label>
                <select ng-model="ro_fn" name='ro_fn' class="form-control">
	                <option value=0>Default</option>
			        <option value=3>3 - Read Holding Register</option>
			        <option value=4>4 - Read Input Register</option>
			        <option value=100>DLMS</option>
                </select>
                <small class="form-text text-muted"><? print(lang('RO_FN_HELP','devicetypeedit')) ?></small>
	        </div>
            <div class="form-group" ng-cloak ng-show='ro_fn==100'>
                <label for="auth">DLMS Authentication Mode</label>
                <select ng-model="auth" name='auth' class="form-control">
	                <option value=0>None</option>
			        <option value=1>Low</option>
                </select>
                <small class="form-text text-muted">Select the DLMS authentication mode</small>
	        </div>
            <div class="form-group" ng-cloak ng-show='ro_fn==100'>
                <label for="password">DLMS Password</label>
                <input type="text" class="form-control" ng-model="password"  class='span12' ng-maxlength=128 name='password' aria-describedby="rnHelp">
                <small id="rnHelp" class="form-text text-muted"><? print(lang('DEVICE_DESCRIPTION_HELP','devicetypeedit')) ?></small>
            </div>	             
            <div class="form-group" ng-cloak ng-show='ro_fn==100'>
                <label for="client_id">DLMS Client ID</label>
                <input class="form-control" type='number' ng-model="client_id"  class='span12' name='client_id' min=0 required integer aria-describedby="rHelp" placeholder="Client ID">
                <small id="rHelp" class="form-text text-muted">Enter a client ID</small>
            </div>
		 
		    <div class="form-group"  ng-hide='ro_fn==100'>
                <label for="num_rw"><? print(lang('RW_COUNT','devicetypeedit')) ?></label>
                <input class="form-control" type='number' ng-model="num_rw"  class='span12' name='num_rw' min=0 required integer aria-describedby="rHelp" placeholder="<? print(lang('RW_COUNT','devicetypeedit')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('RW_COUNT_HELP','devicetypeedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.num_rw.$invalid"><? print(lang('INVALID_VALUE','devicetypeedit')) ?></small>
            </div>
            <div class="form-group"  ng-hide='ro_fn==100'>
                <label for="rw_multiblock"><small class='text-muted'><? print(lang('RW_TYPE','devicetypeedit')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="rw_multiblock" value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('SINGLE','devicetypeedit')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="rw_multiblock" value="1">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('MULTI','devicetypeedit')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('RW_TYPE_HELP','devicetypeedit')) ?></small>
            </div>
            <div class="form-group" ng-cloak  ng-hide='ro_fn==100'>
                <label for="rw_poll_once"><? print(lang('RW_POLL_ONCE','devicetypeedit')) ?></label>
                <select ng-model="rw_poll_once" name='rw_poll_once' class="form-control">
	                <option value=0><? print(lang('RW_POLL_0','devicetypeedit')) ?></option>
			        <option value=1><? print(lang('RW_POLL_1','devicetypeedit')) ?></option>
                </select>
                <small class="form-text text-muted"><? print(lang('RW_POLL_ONCE_HELP','devicetypeedit')) ?></small>
	        </div>
            <div class="form-group" ng-show='num_rw>0 && rw_multiblock==0'>
                <label for="rw_base_address"><? print(lang('RW_BASE','devicetypeedit')) ?></label>
                <input class="form-control" type='number' ng-model="rw_base_address"  class='span12' name='rw_base_address'  min=0  integer aria-describedby="rHelp" placeholder="<? print(lang('RW_BASE','devicetypeedit')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('RW_BASE_HELP','devicetypeedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.rw_base_address.$invalid"><? print(lang('INVALID_VALUE','devicetypeedit')) ?></small>
            </div>
        </p>
	</div>
</div>  
<br/>
<div class="card" ng-cloak ng-hide='ro_fn==100'>
    <div class="card-body">
        <h5 class="card-title"><? print(lang('DIGITAL_INPUT_REGISTERS','devicetypeedit')) ?></h5>
        <p class="card-text">    
             <div style='float:right'><a name='di_addact'></a><button class="btn btn-large" ng-click="doEditAll(di)"><? print(lang('EDIT_ALL','devicetypeedit')) ?></button><button class="btn btn-large" ng-click="doAdd(di)"><? print(lang('ADD','devicetypeedit')) ?></button></div>
 
            <table class='table table-striped' summary="Actions">
                <tr>
                    <th scope="col"></th>
                    <th scope="col"><? print(lang('REGISTER_INDEX','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('REGISTER_NAME','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('DESCRIPTION','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('OPTIONS','devicetypeedit')) ?></th>
                </tr>
                <tr ng-repeat="item in di">
                    <td><a name='di{{$index}}'></a></td>
                    <td><span class="badge badge-pill badge-dark">{{$index}}</span></td>
                    <td><strong ng-show='item.edit!=1'>{{item.name}}</strong><div ng-show='item.edit==1'>
                        <input type='text' class='form-control' ng-model='item.name'>
                        </div></td>            
                    <td><strong ng-show='item.edit!=1'>{{item.description}}</strong><div ng-show='item.edit==1'>
                        <input type='text' class='form-control' ng-model='item.description'>
                        </div>
                    </td>            
                    <td>
                        <div ng-hide="refresh" class="dropdown">
                                <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <? print(lang('ACTION','devicetypeedit')) ?> <span class="caret"></span>
                                </button>
                        
                                <div class="dropdown-menu dropdown-menu-right text-dark" >
                                    <a ng-show='item.edit!=1' class="dropdown-item" ng-click='item.edit=1' href='javascript:void(0)'><i class="icon-pencil"></i>&nbsp;<? print(lang('EDIT','devicetypeedit')) ?></a>
                                    <a ng-show='item.edit==1'  class="dropdown-item" ng-click='stopEdit(di,$index)' href='javascript:void(0)'><i class="icon-pencil"></i>&nbsp;<?print(lang('STOP_EDIT','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-show='$index>0' ng-click='moveUp(di,$index)' href='javascript:void(0)'><i class="icon-up"></i>&nbsp;<? print(lang('MOVE_UP','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-show='$index<di.length-1' ng-click='moveDown(di,$index)' href='javascript:void(0)'><i class="icon-down"></i>&nbsp;<? print(lang('MOVE_DOWN','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-click='deleteItem(di,$index)' href='javascript:void(0)'><i class="icon-remove"></i>&nbsp;<? print(lang('DELETE','devicetypeedit')) ?></a>
                                </div>
                            </div>
                    <td>    
                </tr>
            </table>
        </p>
    </div>
</div>

<br/>

<div class="card" ng-cloak ng-hide='ro_fn==100'>
    <div class="card-body">
        <h5 class="card-title"><? print(lang('DIGITAL_OUTPUT_REGISTERS','devicetypeedit')) ?></h5>
        <p class="card-text">    
             <div style='float:right'><a name='do_addact'></a><button class="btn btn-large" ng-click="doEditAll(do)"><? print(lang('EDIT_ALL','devicetypeedit')) ?></button><button class="btn btn-large" ng-click="doAdd(do)"><? print(lang('ADD','devicetypeedit')) ?></button></div>
 
            <table class='table table-striped' summary="Actions">
                <tr>
                    <th scope="col"></th>
                    <th scope="col"><? print(lang('REGISTER_INDEX','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('REGISTER_NAME','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('DESCRIPTION','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('OPTIONS','devicetypeedit')) ?></th>
                </tr>
                <tr ng-repeat="item in do">
                    <td><a name='di{{$index}}'></a></td>
                    <td><span class="badge badge-pill badge-dark">{{$index}}</span></td>
                    <td><strong ng-show='item.edit!=1'>{{item.name}}</strong><div ng-show='item.edit==1'>
                        <input type='text' class='form-control' ng-model='item.name'>
                        </div></td>            
                    <td><strong ng-show='item.edit!=1'>{{item.description}}</strong><div ng-show='item.edit==1'>
                        <input type='text' class='form-control' ng-model='item.description'>
                        </div>
                    </td>            
                    <td>
                        <div ng-hide="refresh" class="dropdown">
                                <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <? print(lang('ACTION','devicetypeedit')) ?> <span class="caret"></span>
                                </button>
                        
                                <div class="dropdown-menu dropdown-menu-right text-dark" >
                                    <a ng-show='item.edit!=1' class="dropdown-item" ng-click='item.edit=1' href='javascript:void(0)'><i class="icon-pencil"></i>&nbsp;<? print(lang('EDIT','devicetypeedit')) ?></a>
                                    <a ng-show='item.edit==1'  class="dropdown-item" ng-click='stopEdit(do,$index)' href='javascript:void(0)'><i class="icon-pencil"></i>&nbsp;<? print(lang('STOP_EDIT','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-show='$index>0' ng-click='moveUp(do,$index)' href='javascript:void(0)'><i class="icon-up"></i>&nbsp;<? print(lang('MOVE_UP','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-show='$index<do.length-1' ng-click='moveDown(do,$index)' href='javascript:void(0)'><i class="icon-down"></i>&nbsp;<? print(lang('MOVE_DOWN','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-click='deleteItem(do,$index)' href='javascript:void(0)'><i class="icon-remove"></i>&nbsp;<? print(lang('DELETE','devicetypeedit')) ?></a>
                                </div>
                            </div>
                    <td>    
                </tr>
            </table>
        </p>
    </div>
</div>

<br/>

<div class="card">
    <div class="card-body">
        <h5 class="card-title text-success" ><? print(lang('READ_ONLY_REGISTERS','devicetypeedit')) ?></h5>
        <p class="card-text">    
            <div style='float:right'><a name='ro_addact'></a><button type="button" class="btn btn-primary" ng-click='hexEditor=!hexEditor'><? print(lang('HEX_CONVERTER','devicetypeedit')) ?></button><button class="btn btn-large" ng-click="doEditAll(ro)"><? print(lang('EDIT_ALL','devicetypeedit')) ?></button><button class="btn btn-large" ng-click="doAdd(ro)"><? print(lang('ADD','devicetypeedit')) ?></button></div>
            <div class='clearfix'></div>
            <div ng-show='hexEditor==1' class='bg-light card-body'>
                <h6 class="card-title"><? print(lang('HEX_TITLE','devicetypeedit')) ?></h6>
                <div class="form-row">
                    <div class="form-group col-md-4">
                        <label><? print(lang('HEX','devicetypeedit')) ?></label>
                        <input class='form-control' ng-model='hexval' type='text' value='0'>
                    </div>
                    <div class="form-group col-md-4">
                        <label><? print(lang('DECIMAL','devicetypeedit')) ?>: </label>
                        <input ng-model='decval' class='form-control' type='text' readonly value="0">
                    </div>
                </div>
            </div>
            <br ng-show='hexEditor==1'/>
            <div class='clearfix'></div>
            <table class='table table-striped' summary="Actions">
                <tr>
                    <th scope="col"></th>
                    <th scope="col"><? print(lang('REGISTER_INDEX','devicetypeedit')) ?></th>
                    <th scope="col" ng_show='ro_multiblock==1'><? print(lang('REGISTER_ADDRESS','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('REGISTER_NAME','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('DESCRIPTION','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('PERSISTENT','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('INTERVAL','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('OPTIONS','devicetypeedit')) ?></th>
                </tr>
                <tr ng-repeat="item in ro">
                    <td><a name='ro{{$index}}'></a></td>
                    <td><span class="badge badge-pill badge-success">{{$index}}</span></td>
                    <td ng_show='ro_multiblock==1'><span class="badge badge-secondary">{{item.address}}</span><div ng-show='item.edit==1'>
                        <input type='text' class='form-control' ng-model='item.address'>
                        </div></td>
                    <td><strong ng-show='item.edit!=1'>{{item.name}}</strong><div ng-show='item.edit==1'>
                        <input type='text' class='form-control' ng-model='item.name'>
                        </div></td>            
                    <td><strong ng-show='item.edit!=1'>{{item.description}}</strong><div ng-show='item.edit==1'>
                        <input type='text' class='form-control' ng-model='item.description'>
                        </div></td>      
                    <td><strong ng-show='item.edit!=1'>{{item.persistent}}</strong><div ng-show='item.edit==1'>
                        <input type='checkbox' class='form-control' ng-model='item.persistent'>
                        </div></td>              
                    <td><strong ng-show='item.edit!=1'>{{item.poll_interval}}</strong><div ng-show='item.edit==1'>
                        <input type='text' class='form-control' ng-model='item.poll_interval'>
                        </div></td>              
                        
                    <td>
                        <div ng-hide="refresh" class="dropdown">
                                <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <? print(lang('ACTION','devicetypeedit')) ?> <span class="caret"></span>
                                </button>
                        
                                <div class="dropdown-menu dropdown-menu-right text-dark" >
                                    <a ng-show='item.edit!=1' class="dropdown-item" ng-click='item.edit=1' href='javascript:void(0)'><i class="icon-pencil"></i>&nbsp;<? print(lang('EDIT','devicetypeedit')) ?></a>
                                    <a ng-show='item.edit==1'  class="dropdown-item" ng-click='stopEdit(ro,$index)' href='javascript:void(0)'><i class="icon-pencil"></i>&nbsp;<? print(lang('STOP_EDIT','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-show='$index>0' ng-click='moveUp(ro,$index)' href='javascript:void(0)'><i class="icon-up"></i>&nbsp;<? print(lang('MOVE_UP','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-show='$index<ro.length-1' ng-click='moveDown(ro,$index)' href='javascript:void(0)'><i class="icon-down"></i>&nbsp;<? print(lang('MOVE_DOWN','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-click='insertItem2(ro,$index+1)' href='javascript:void(0)'><i class="icon-up"></i> <? print(lang('INSERT_AFTER','devicetypeedit')) ?></a></a> 
                                    <a class="dropdown-item" ng-click='deleteItem(ro,$index)' href='javascript:void(0)'><i class="icon-remove"></i>&nbsp;<? print(lang('DELETE','devicetypeedit')) ?></a>
                                </div>
                            </div>
                    </td>    
                </tr>
            </table>
            <div style='float:right'><button class="btn btn-large" ng-click="doEditAll(ro)"><? print(lang('EDIT_ALL','devicetypeedit')) ?></button><button class="btn btn-large" ng-click="doAdd(ro)"><? print(lang('ADD','devicetypeedit')) ?></button></div>            
        </p>
    </div>
</div>
    
<br/>

<div class="card" ng-cloak ng-hide='ro_fn==100'>
    <div class="card-body">
        <h5 class="card-title text-danger"><? print(lang('READ_WRITE_REGISTERS','devicetypeedit')) ?></h5>
        <p class="card-text">    
            <div style='float:right'><a name='ro_addact'></a><button type="button" class="btn btn-primary" ng-click='hexEditor=!hexEditor'><? print(lang('HEX_CONVERTER','devicetypeedit')) ?></button><button class="btn btn-large" ng-click="doEditAll(rw)"><? print(lang('EDIT_ALL','devicetypeedit')) ?></button><button class="btn btn-large" ng-click="doAdd(rw)"><? print(lang('ADD','devicetypeedit')) ?></button></div>
            <div class='clearfix'></div>
            <div ng-show='hexEditor==1' class='bg-light card-body'>
                <h6 class="card-title"><? print(lang('HEX_TITLE','devicetypeedit')) ?></h6>
                <div class="form-row">
                    <div class="form-group col-md-4">
                        <label><? print(lang('HEX','devicetypeedit')) ?></label>
                        <input class='form-control' ng-model='hexval' type='text' value='0'>
                    </div>
                    <div class="form-group col-md-4">
                        <label><? print(lang('DECIMAL','devicetypeedit')) ?>: </label>
                        <input ng-model='decval' class='form-control' type='text' readonly value="0">
                    </div>
                </div>
            </div>
            <br ng-show='hexEditor==1'/>
            <div class='clearfix'></div>
            <table class='table table-striped' summary="Actions">
                <tr>
                    <th scope="col"></th>
                    <th scope="col"><? print(lang('REGISTER_INDEX','devicetypeedit')) ?></th>
                    <th scope="col" ng_show='rw_multiblock==1'><? print(lang('REGISTER_ADDRESS','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('REGISTER_NAME','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('DESCRIPTION','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('PERSISTENT','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('OPTIONS','devicetypeedit')) ?></th>
                </tr>
                <tr ng-repeat="item in rw">
                    <td><a name='rw{{$index}}'></a></td>
                    <td><span class="badge badge-pill badge-danger">{{$index}}</span></td>
                    <td ng_show='rw_multiblock==1'><span ng-show='item.edit!=1' class="badge badge-secondary">{{item.address}}</span><div ng-show='item.edit==1'>
                        <input type='text' class='form-control' ng-model='item.address'>
                        </div></td>
                    <td><strong ng-show='item.edit!=1'>{{item.name}}</strong><div ng-show='item.edit==1'>
                        <input type='text' class='form-control' ng-model='item.name'>
                        </div></td>            
                    <td><strong ng-show='item.edit!=1'>{{item.description}}</strong><div ng-show='item.edit==1'>
                        <input type='text' class='form-control' ng-model='item.description'>
                        </div></td>      
                    <td><strong ng-show='item.edit!=1'>{{item.persistent}}</strong><div ng-show='item.edit==1'>
                        <input type='checkbox' class='form-control' ng-model='item.persistent'>
                        </div></td>              
                    <td>
                        <div ng-hide="refresh" class="dropdown">
                                <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <? print(lang('ACTION','devicetypeedit')) ?> <span class="caret"></span>
                                </button>
                        
                                <div class="dropdown-menu dropdown-menu-right text-dark" >
                                    <a ng-show='item.edit!=1' class="dropdown-item" ng-click='item.edit=1' href='javascript:void(0)'><i class="icon-pencil"></i>&nbsp;<? print(lang('EDIT','devicetypeedit')) ?></a>
                                    <a ng-show='item.edit==1'  class="dropdown-item" ng-click='stopEdit(rw,$index)' href='javascript:void(0)'><i class="icon-pencil"></i>&nbsp;<? print(lang('STOP_EDIT','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-show='$index>0' ng-click='moveUp(rw,$index)' href='javascript:void(0)'><i class="icon-up"></i> <? print(lang('MOVE_UP','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-show='$index<rw.length-1' ng-click='moveDown(rw,$index)' href='javascript:void(0)'><i class="icon-down"></i>&nbsp;<? print(lang('MOVE_DOWN','devicetypeedit')) ?></a>
                                    <a  class="dropdown-item" ng-click='insertItem2(rw,$index+1)' href='javascript:void(0)'><i class="icon-plus"></i>&nbsp;<? print(lang('INSERT_AFTER','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-click='deleteItem(rw,$index)' href='javascript:void(0)'><i class="icon-remove"></i>&nbsp;<? print(lang('DELETE','devicetypeedit')) ?></a>
                                </div>
                            </div>
                    </td>    
                </tr>
            </table>
        </p>
    </div>
</div>
    
<br/>

<div class="card">
    <div class="card-body">
        <h5 class="card-title text-info"><? print(lang('OT_STRING_DATA','devicetypeedit')) ?></h5>
        <p class="card-text">    
            <div style='float:right'><a name='ot_addact'></a>
                <button type="button" class="btn btn-primary" ng-click='hexEditor=!hexEditor'><? print(lang('HEX_CONVERTER','devicetypeedit')) ?></button>
                <button class="btn btn-large" ng-click="doEditAll(ot)"><? print(lang('EDIT_ALL','devicetypeedit')) ?></button>
                <button class="btn btn-large" ng-click="doAdd(ot)"><? print(lang('ADD','devicetypeedit')) ?></button>
            </div>
            <div class='clearfix'></div>
            <div ng-show='hexEditor==1' class='bg-light card-body'>
                <h6 class="card-title"><? print(lang('HEX_TITLE','devicetypeedit')) ?></h6>
                <div class="form-row">
                    <div class="form-group col-md-4">
                        <label><? print(lang('HEX','devicetypeedit')) ?></label>
                        <input class='form-control' ng-model='hexval' type='text' value='0'>
                    </div>
                    <div class="form-group col-md-4">
                        <label><? print(lang('DECIMAL','devicetypeedit')) ?>: </label>
                        <input ng-model='decval' class='form-control' type='text' readonly value="0">
                    </div>
                </div>
            </div>
            <br ng-show='hexEditor==1'/>
            <div class='clearfix'></div>
            <table class='table table-striped'>
                <tr>
                    <th scope="col"></th>
                    <th scope="col"><? print(lang('TYPE','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('FUNCTION_CODE','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('START_ADDRESS','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('COUNT','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('OPTIONS','devicetypeedit')) ?></th>
                </tr>
                
        
                <tr ng-repeat="item in ot">
                    <td><a name='ot{{$index}}'></a><span class="badge badge-pill badge-dark">{{$index}}</span></td>
                    <td><div ng-show='item.edit!=1' class="badge badge-secondary">{{makeOtType(item.type)}}</div><div ng-show='item.edit==1'>
                            <select class='form-control' ng-model="item.type" name='item.type'>
                			    <option value="0">Serial Number</option>
                			    <option value="1">Model Number</option>
                			    <option value="2">User Defined 1</option>
                			    <option value="3">User Defined 2</option>
                			    <option value="4">User Defined 3</option>
                			</select>
                        </div></td>    
                    <td  ng-cloak ng-hide='ro_fn==100'><strong ng-show='item.edit!=1' >{{item.func}}</strong><div ng-show='item.edit==1'>
                            <select class='form-control' ng-model="item.func" name='item.func'>
                			    <option value=3>3 - Read Holding Register</option>
                			    <option value=4>4 - Read Input Register</option>
                			</select>
                
                        </div></td>            
                    <td ng-cloak ng-hide='ro_fn==100'><strong ng-show='item.edit!=1' >{{item.address}}</strong><div ng-show='item.edit==1'>
                        <input class='form-control' type='text' ng-model='item.address'>
                        </div></td>            
                    <td ng-cloak ng-hide='ro_fn==100'><strong ng-show='item.edit!=1' >{{item.count}}</strong><div ng-show='item.edit==1'>
                        <input class='form-control' type='text' ng-model='item.count'>
                        </div></td>            
                        
                     <td>
                        <div ng-hide="refresh" class="dropdown">
                                <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <? print(lang('ACTION','devicetypeedit')) ?> <span class="caret"></span>
                                </button>
                        
                                <div class="dropdown-menu dropdown-menu-right text-dark" >
                                    <a ng-show='item.edit!=1' class="dropdown-item" ng-click='item.edit=1' href='#ot{{$index}}'><i class="icon-pencil"></i>&nbsp;<? print(lang('EDIT','devicetypeedit')) ?></a>
                                    <a ng-show='item.edit==1'  class="dropdown-item" ng-click='stopEdit(ot,$index)' href='#ot{{$index}}'><i class="icon-pencil"></i>&nbsp;<? print(lang('STOP_EDIT','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-show='$index>0' ng-click='moveUp(ot,$index)' href='#ot{{$index}}'><i class="icon-up"></i>&nbsp;<? print(lang('MOVE_UP','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-show='$index<ot.length-1' ng-click='moveDown(ot,$index)' href='#ot{{$index}}'><i class="icon-down"></i>&nbsp;<? print(lang('MOVE_DOWN','devicetypeedit')) ?></a>
                                    <a  class="dropdown-item" ng-click='insertItem2(ot,$index+1)' href='#ot{{$index}}'><i class="icon-plus"></i>&nbsp;<? print(lang('INSERT_AFTER','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-click='deleteItem(ot,$index)' href='#ot_addact'><i class="icon-remove"></i>&nbsp;<? print(lang('DELETE','devicetypeedit')) ?></a>
                                </div>
                            </div>
                    </td>    
                </tr>
            </table>
        </p>
    </div>
</div> 			

<br>
<div class="card">
    <div class="card-body">
        <h5 class="card-title text-preimary"><? print(lang('ROLES','devicetypeedit')) ?></h5>
        <p class="card-text">    
            <div style='float:right'><a name='ot_addact'></a>
                <button class="btn btn-large" ng-click="doEditAll(roles)"><? print(lang('EDIT_ALL','devicetypeedit')) ?></button>
                <button class="btn btn-large" ng-click="doAdd(roles)"><? print(lang('ADD','devicetypeedit')) ?></button>
            </div>
            <table class='table table-striped'>
                <tr>
                    <th scope="col"></th>
                    <th scope="col"><? print(lang('ROLE_ID','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('ROLE_NAME','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('ROLE_TYPE','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('REGISTER_INDEX','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('ROLE_SCALE','devicetypeedit')) ?></th>
                    <th scope="col"><? print(lang('OPTIONS','devicetypeedit')) ?></th>
                </tr>
                <tr ng-repeat="item in roles">
                    <td><a name='role{{$index}}'></a></td>
                    <td><span class="badge badge-pill {{makeRoleClass(item.type)}}">{{$index}}</span></td>
                    <td><strong ng-show='item.edit!=1'>{{item.name}}</strong><div ng-show='item.edit==1'>
                        <input class='form-control' type='text' ng-model='item.name'>
                        </div></td>            
                    <td><strong ng-show='item.edit!=1' >{{makeType(item.type)}}</strong><div ng-show='item.edit==1'>
                        <select class='form-control' ng-model='item.type'>
                            <option value='2'>Read Only Int (16-bit) Signed Register</option>
                            <option value='31'>Read Only Int (16-bit) Unsigned Register</option>
                            <option value='24'>Read Only Unsigned Long (32-bit) Little Endian</option>
                            <option value='25'>Read Only Unsigned Long (32-bit) Big Endian </option>
                            <option value='38'>Read Only Unsigned Long (64-bit) Little Endian </option>                            
                            <option value='39'>Read Only Unsigned Long (64-bit) Big Endian </option>
                            <option value='40'>Read Only Unsigned Long (64-bit) Little Endian Swapped</option>                            
                            <option value='41'>Read Only Unsigned Long (64-bit) Big Endian Swapped</option>
                            
                            <option value='26'>Read Only Signed Long (32-bit) Little Endian</option>
                            <option value='27'>Read Only Signed Long (32-bit) Big Endian </option>
                            <option value='28'>Read Only Float (32-bit) Little Endian </option>
                            <option value='22'>Read Only Float (32-bit) Big Endian</option>
                            <option value='37'>Read Only Float (64-bit) Little Endian </option>
                            <option value='36'>Read Only Float (64-bit) Big Endian</option>
                            
                            <option value='3'>Read/Write (Holding Register) Int (16-bit) Signed Register </option>
                            <option value='32'>Read/Write (Holding Register) Int (16-bit) Unsigned Register</option>
                            <option value='23'>Read/Write (Holding Register) Float (32-bit) Little Endian </option>
                            <option value='29'>Read/Write (Holding Register) Float (32-bit) Big Endian</option>
                            <option value='33'>Read/Write (Holding Register) UINT32 Little Endian</option>
                            <option value='30'>Read/Write (Holding Register) UINT32 Big Endian</option>
                            <option value='34'>Read/Write (Holding Register) INT32 Big Endian</option>
                            <option value='35'>Read/Write (Holding Register) INT32 Little Endian</option>
                            
                            <option value='0'>Digital Output</option>
                            <option value='1'>Digital Input</option>
                            
                            </select>
                        </div></td>
                    <td><strong>{{makeIndex(item)}}</strong><div ng-show='item.edit==1'>
                        <input class='form-control' type='text' ng-model='item.idx'>
                        </div></td>                    
                    <td><strong>{{makeScale(item.scale)}}</strong><div ng-show='item.edit==1'>
                        <input class='form-control' type='text' ng-model='item.scale'>
                        </div></td>                    
                    <td>
                        <div ng-hide="refresh" class="dropdown">
                                <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <? print(lang('ACTION','devicetypeedit')) ?> <span class="caret"></span>
                                </button>
                        
                                <div class="dropdown-menu dropdown-menu-right text-dark" >
                                    <a ng-show='item.edit!=1' class="dropdown-item" ng-click='item.edit=1' href='javascript:void(0)'><i class="icon-pencil"></i>&nbsp;<? print(lang('EDIT','devicetypeedit')) ?></a>
                                    <a ng-show='item.edit==1'  class="dropdown-item" ng-click='stopEdit(role,$index)' href='javascript:void(0)'><i class="icon-pencil"></i>&nbsp;<? print(lang('STOP_EDIT','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-show='$index>0' ng-click='moveUp(roles,$index)' href='javascript:void(0)'><i class="icon-up"></i>&nbsp;<? print(lang('MOVE_UP','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-show='$index<roles.length-1' ng-click='moveDown(roles,$index)' href='javascript:void(0)'><i class="icon-down"></i>&nbsp;<? print(lang('MOVE_DOWN','devicetypeedit')) ?></a>
                                    <a  class="dropdown-item" ng-click='insertItem2(roles,$index+1)' href='javascript:void(0)'><i class="icon-plus"></i>&nbsp;<? print(lang('INSERT_AFTER','devicetypeedit')) ?></a>
                                    <a class="dropdown-item" ng-click='deleteItem(roles,$index)' href='javascript:void(0)'><i class="icon-remove"></i>&nbsp;<? print(lang('DELETE','devicetypeedit')) ?></a>
                                </div>
                            </div>
                    </td>    
                </tr>
            </table>
            <div style='float:right'>
                <button class="btn btn-large" ng-click="doEditAll(roles)"><? print(lang('EDIT_ALL','devicetypeedit')) ?></button>
                <button class="btn btn-large" ng-click="doAdd(roles)"><? print(lang('ADD','devicetypeedit')) ?></button>
            </div>
            
        </p>    
 	</div>
</div> 
</form>

<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
var globalScope;
Array.prototype.insert = function ( index, item ) {
    this.splice( index, 0, item );
};
app.factory('dataService', function($http, $q,$timeout) {
  
  this.async = function(devid) {
    return $http.get('/app/role_ajax.cgi?action=get&index='+devid)
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
        alert('Failed: ' + reason);
        $timeout(poll, 100);  // try again
    });
    
  };
  
  return this;
});


function clone(obj) {
    if (null == obj || "object" != typeof obj) return obj;
    var copy = obj.constructor();
    for (var attr in obj) {
        if (obj.hasOwnProperty(attr)) copy[attr] = obj[attr];
    }
    return copy;
}
function DeviceTypeEditCtrl(dataService,$scope, $timeout,$http) {
  var self = this;
  globalScope=$scope;
  $scope.infomsg="";
    $scope.settings_locked=settings_locked;
    if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
  
  $scope.di=[<?
    $num=ini_get($info_ini,$info_section,'num_di',0);
    for ($i=0;$i<$num;$i++) {
        print("{index:".$i.',name:"'.ini_get($info_ini,$info_section,'di_var_'.$i,'divar'.$i).'",description:"'.ini_get($info_ini,$info_section,'di_desc_'.$i,''.$i)."\"},");
   }  
  ?>];
  $scope.do=[<?
    $num=ini_get($info_ini,$info_section,'num_do',0);
    for ($i=0;$i<$num;$i++) {
        print("{index:".$i.',name:"'.ini_get($info_ini,$info_section,'do_var_'.$i,'dovar'.$i).'",description:"'.ini_get($info_ini,$info_section,'do_desc_'.$i,''.$i)."\"},");
   }  
  ?>];
  $scope.rw=[<?
    $num=ini_get($info_ini,$info_section,'num_rw',0);
    for ($i=0;$i<$num;$i++) {
        $p=ini_get($info_ini,$info_section,'rw_p_'.$i,0);
        if (!$p) $p="false"; else $p="true";
        print("{index:".$i.',name:"'.ini_get($info_ini,$info_section,'rw_var_'.$i,'rwvar'.$i).'",address:'.ini_get($info_ini,$info_section,'rw_reg_'.$i,0).',description:"'.ini_get($info_ini,$info_section,'rw_desc_'.$i,''.$i)."\",persistent:".$p."},");
   }  
  ?>];
  $scope.ro=[<?
    $num=ini_get($info_ini,$info_section,'num_ro',0);
    for ($i=0;$i<$num;$i++) {
        $p=ini_get($info_ini,$info_section,'ro_p_'.$i,0);
        $pi=ini_get($info_ini,$info_section,'ro_i_'.$i,0);
        if (!$p) $p="false"; else $p="true";
        print("{index:".$i.',name:"'.ini_get($info_ini,$info_section,'ro_var_'.$i,'rovar'.$i).'",address:'.ini_get($info_ini,$info_section,'ro_reg_'.$i,0).',description:"'.ini_get($info_ini,$info_section,'ro_desc_'.$i,''.$i)."\",persistent:".$p.",poll_interval:".$pi."},");
   }  
  ?>];

  $scope.ot=[<?
    $num=ini_get($info_ini,$info_section,'num_ot',0);
    for ($i=0;$i<$num;$i++) {
        print("{index:".$i.',type:'.ini_get($info_ini,$info_section,'ot_type_'.$i,0).
            ',address:'.ini_get($info_ini,$info_section,'ot_address_'.$i,0).
            ',count:'.ini_get($info_ini,$info_section,'ot_count_'.$i,0).
            ',func:"'.ini_get($info_ini,$info_section,'ot_func_'.$i,3)."\"},");
   }  
  ?>];

  $scope.roles=[<?
    $num=ini_get($info_ini,$info_section,'num_roles',0);
    for ($i=0;$i<$num;$i++) {
        print("{index:".$i.',name:"'.ini_get($info_ini,$info_section,'role_var_'.$i,'role'.$i).'",type:'.ini_get($info_ini,$info_section,'role_type_'.$i,0).",idx:".ini_get($info_ini,$info_section,'role_idx_'.$i,0).",scale:".ini_get($info_ini,$info_section,'role_scale_'.$i,0)."},");
   }  
  ?>];

  
  // keep a copy and don't send what's not changed
  $scope.do_orig=Array();
  for (var i = 0; i < $scope.do.length; i++){
        $scope.do_orig.push(clone($scope.do[i]));
  }
  
  $scope.di_orig=Array();
  for (var i = 0; i < $scope.di.length; i++){
        $scope.di_orig.push(clone($scope.di[i]));
  }

  $scope.rw_orig=Array();
  for (var i = 0; i < $scope.rw.length; i++){
        $scope.rw_orig.push(clone($scope.rw[i]));
  }
  $scope.ro_orig=Array();
  for (var i = 0; i < $scope.ro.length; i++){
        $scope.ro_orig.push(clone($scope.ro[i]));
  }
  $scope.roles_orig=Array();
  for (var i = 0; i < $scope.roles.length; i++){
        $scope.roles_orig.push(clone($scope.roles[i]));
  }

  $scope.makeOtType=function(item) {
    switch(Number(item)) {
        case 0: return "Serial Number";break;
        case 1: return "Model Number";break;
        case 2: return "User1";break;
        case 3: return "User2";break;
        case 4: return "User3";break;
    }
        
  }
  
  /*$scope.do_orig=$scope.do.splice(0,$scope.do.length);
  $scope.di_orig=$scope.di.splice(0,$scope.di.length);
  $scope.rw_orig=$scope.rw.splice(0,$scope.rw.length);
  $scope.ro_orig=$scope.ro.splice(0,$scope.ro.length);
  $scope.roles_orig=$scope.roles.splice(0,$scope.roles.length);
  */
  $scope.doAdd=function(arr) {
    if (arr==$scope.di) {
        $scope.num_di++;$scope.di.push({edit:1,name:'newreg'+$scope.num_di})
    }
    if (arr==$scope.do) {
        $scope.num_do++;$scope.do.push({edit:1,name:'newreg'+$scope.num_do})
    }
    if (arr==$scope.ro) {
        $scope.num_ro++;$scope.ro.push({edit:1,name:'newreg'+$scope.num_ro,address:0})
    }
    if (arr==$scope.rw) {
        $scope.num_rw++;$scope.rw.push({edit:1,name:'newreg'+$scope.num_rw,address:0})
    }
    if (arr==$scope.roles) {
        $scope.num_roles++;$scope.roles.push({edit:1,name:'newrole'+$scope.num_roles})
    }
    if (arr==$scope.ot) {
        $scope.num_ot++;$scope.ot.push({edit:1,type:0})
    }
  }
  $scope.doEditAll=function(arr) {
    if (arr==$scope.di) {
         for (i=0;i<$scope.num_di;i++) {
            $scope.di[i].edit=1;
         }
    }
    if (arr==$scope.do) {
         for (i=0;i<$scope.num_do;i++) {
            $scope.do[i].edit=1;
         }
    }
    if (arr==$scope.ro) {
         for (i=0;i<$scope.num_ro;i++) {
            $scope.ro[i].edit=1;
         }

    }
    if (arr==$scope.rw) {
         for (i=0;i<$scope.num_rw;i++) {
            $scope.rw[i].edit=1;
         }

    }
    if (arr==$scope.roles) {
         for (i=0;i<$scope.num_roles;i++) {
            $scope.roles[i].edit=1;
         }

    }
    if (arr==$scope.ot) {
         for (i=0;i<$scope.num_ot;i++) {
            $scope.ot[i].edit=1;
         }

    }
  }
   function swapElement(array, indexA, indexB) {
     var tmp = array[indexA];
    array[indexA] = array[indexB];
    array[indexB] = tmp;
  }
  
  $scope.moveUp=function(arr,idx) {
     if (idx>0)
        swapElement(arr,idx-1,idx);
  }
  
  $scope.insertItem2=function(arr, idx) {
          //alert(idx);

    if (arr==$scope.di) {
    }
    if (arr==$scope.do) {
        $scope.num_do++;$scope.do.insert(idx,{edit:1,name:'newreg'+$scope.num_do});
    }
    if (arr==$scope.ro) {
        $scope.num_ro++;$scope.ro.insert(idx,{edit:1,name:'newreg'+$scope.num_ro,address:0});
    }
    if (arr==$scope.rw) {
        $scope.num_rw++;$scope.rw.insert(idx,{edit:1,name:'newreg'+$scope.num_rw,address:0});
    }
    if (arr==$scope.roles) {
        $scope.num_roles++;$scope.roles.insert(idx,{edit:1,name:'newrole'+$scope.num_roles});
    }
    if (arr==$scope.ot) {
        $scope.num_ot++;$scope.ot.insert(idx,{edit:1,type:0});
    }
  }
  $scope.moveDown=function(arr,idx) {
     if (idx<arr.length-1)
        swapElement(arr,idx,idx+1);
  } 
  $scope.stopEdit = function ( arr,idx ) {
    arr[idx].edit=0;
    return 1;
  }
  
  

  $scope.deleteItem = function ( arr,idx ) {
      var person_to_delete = arr[idx];

    //API.DeleteAction({ id: person_to_delete.id }, function (success) {
        arr.splice(idx, 1);
         if (arr==$scope.di) {
        $scope.num_di--;
    }
    if (arr==$scope.do) {
        $scope.num_do--;
    }
    if (arr==$scope.ro) {
        $scope.num_ro--;
    }
    if (arr==$scope.rw) {
        $scope.num_rw--;
    }
    if (arr==$scope.roles) {
        $scope.num_roles--;
    }
    if (arr==$scope.ot) {
        $scope.num_ot--;
    }
    //});
  };
  
  $scope.makeIndex=function(item) {
        arr=0;
        switch (Number(item.type)) {
            case 0:arr=$scope.do;break;
            case 1:arr=$scope.di;break;
            case 2:arr=$scope.ro;break;
            case 3:arr=$scope.rw;break;
            case 22:arr=$scope.ro;break;
            case 23:arr=$scope.rw;break;
            case 24:arr=$scope.ro;break;
            case 25:arr=$scope.ro;break;
            case 26:arr=$scope.ro;break;
            case 27:arr=$scope.ro;break;
            case 28:arr=$scope.ro;break;
            case 29:arr=$scope.rw;break;
            case 30:arr=$scope.rw;break;
            case 31:arr=$scope.ro;break;
            case 32:arr=$scope.rw;break;
            case 33:arr=$scope.rw;break;
            case 34:arr=$scope.rw;break;
            case 35:arr=$scope.rw;break;
            case 36:arr=$scope.ro;break;
            case 37:arr=$scope.ro;break;
            case 38:arr=$scope.ro;break;
            case 39:arr=$scope.ro;break;
            case 40:arr=$scope.ro;break;
            case 41:arr=$scope.ro;break;
            
            
        }
        if (arr) {
            if (Number(item.idx)<arr.length)
                return item.idx+" ("+arr[Number(item.idx)].name+")";
            else return "Invalid index ("+item.idx+")";
        } else return "0";
  }
  
  $scope.makeScale=function(scale) {
        arr=0;
        arr=$scope.ro;
        if (scale<0) {
            if (arr) {
                if (Number(scale)<arr.length)
                    return " ("+arr[-scale].name+")";
                else return "Invalid index ("+(-scale)+")";
            } 
        }
        else return scale;
  }
  
  $scope.makeType=function(id) {
    switch (Number(id)) {
        case 0:return "Digital Output";
        case 1:return "Digital Input";
        case 2:return "Read Only Register (16-bit)";
        case 3:return "Holding Register (16-bit)";
        case 22:return "Read Only Floating point (32-bit)";
        case 23:return "Read/Write (Holding Register) Floating point (32-bit)";
        case 24:return "Read Only Unsigned Long Little Endian (32-bit)";
        case 25:return "Read Only Unsigned Long Big Endian (32-bit)";
        case 26:return "Read Only Signed Long Little Endian (32-bit)";
        case 27:return "Read Only Signed Long Big Endian (32-bit)";
        case 28:return "Read Only Float Little Endian (32-bit)";
        case 29:return "Read/Write (Holding) Float Little Endian";
        case 30:return "Read/Write (Holding Register) Big Endian (32-bit)";
        case 31:return "Read Only Unsigned Register (16-bit)";
        case 32:return "Read/Write Unsigned Register (16-bit)";
        case 33:return "Read/Write (Holding Register) Little Endian (32-bit)";
        case 34:return "Read/Write (Holding Register) Signed Little Endian (32-bit)";
        case 35:return "Read/Write (Holding Register) Signed Big Endian (32-bit)";
        case 37:return "Read Only Float Little Endian (64-bit)";
        case 36:return "Read Only Float Big Endian (64-bit)";
        case 38:return "Read Only Unsigned Long Little Endian (64-bit)";
        case 39:return "Read Only Unsigned Long Big Endian (64-bit)";
        case 40:return "Read Only Unsigned Long Little Endian (64-bit) Swapped";
        case 41:return "Read Only Unsigned Long Big Endian (64-bit) Swapped";
        

    }
  }
  
  $scope.makeRoleClass=function(id) {
    switch (Number(id)) {
        case 0:return "badge-dark";
        case 1:return "badge-dark";
        case 2:return "badge-success";
        case 3:return "badge-danger";
        case 22:return "badge-success";
        case 23:return "badge-danger";
        case 24:return "badge-success";
        case 25:return "badge-success";
        case 26:return "badge-success";
        case 27:return "badge-success";
        case 28:return "badge-success";
        case 29:return "badge-danger";
        case 30:return "badge-danger";
        case 31:return "badge-success";
        case 34:return "badge-danger";
        case 35:return "badge-danger";
        case 36:return "badge-success";
        case 38:return "badge-success";
        case 39:return "badge-success";
        case 40:return "badge-success";
        case 41:return "badge-success";
        
    }
  }
  $scope.hexToDec=function(hex) {
    var result = 0, digitValue;
    hex = hex.toLowerCase();
    if (hex.substr(0,2)=='0x') hex=hex.substr(2);
    for (var i = 0; i < hex.length; i++) {
        digitValue = '0123456789abcdefgh'.indexOf(hex[i]);
        result = result * 16 + digitValue;
    }
    return result;
 }
 
  $scope.$watch('hexval', function(asyncData) {
    //alert("changed");
    if (asyncData) 
        $scope.decval=$scope.hexToDec($scope.hexval);
  });

  $scope.makeText=function(item) {
        return item.name;
        return item.device_id;
    }
  $scope.saveAsNew=function () {
    $scope.role_id=-1;
    $scope.saveSettings();
  }
  $scope.saveSettings=function () {
      $scope.successmsg="";
      $scope.errormsg="";
      $scope.infomsg="";
      $scope.role_devices="";
      $scope.loading=1;
      data ="[config]\n"+
            "num_di="+$scope.num_di+"\n"+
            "num_do="+$scope.num_do+"\n"+
            "num_rw="+$scope.num_rw+"\n"+
            "num_ro="+$scope.num_ro+"\n"+
            "num_roles="+$scope.num_roles+"\n"+
            "num_ot="+$scope.num_ot+"\n"+
            "num_di="+$scope.num_di+"\n"+
            "dev_category="+$scope.dev_category+"\n"+
            "dev_rating="+Number($scope.dev_rating).toFixed(1)+"\n"+
            "ro_fn="+$scope.ro_fn+"\n"+
            "rw_poll_once="+$scope.rw_poll_once+"\n"+
            "ro_multiblock="+$scope.ro_multiblock+"\n"+
            "rw_multiblock="+$scope.rw_multiblock+"\n"+
            "device_type_id="+$scope.dev_type_id+"\n"+
            "name="+($scope.dev_name)+"\n"+
            "auth="+$scope.auth+"\n"+
            "client_id="+$scope.client_id+"\n"+
            "password="+$scope.password+"\n"+
            "description="+($scope.dev_description)+"\n"+
            "di_base_address="+$scope.di_base_address+"\n"+
            "do_base_address="+$scope.do_base_address+"\n"+
            "rw_base_address="+$scope.rw_base_address+"\n"+
            "ro_base_address="+$scope.ro_base_address+"\n";
        for (i=0;i<$scope.num_di;i++) {
            data+="di_var_"+i+"="+($scope.di[i].name)+"\n";
            data+="di_desc_"+i+"="+($scope.di[i].description)+"\n";
        }
        for (i=0;i<$scope.num_do;i++) {
            data+="do_var_"+i+"="+($scope.do[i].name)+"\n";
            data+="do_desc_"+i+"="+($scope.do[i].description)+"\n";
        }
        for (i=0;i<$scope.num_rw;i++) {
                    data+="rw_var_"+i+"="+($scope.rw[i].name)+"\n";
                    data+="rw_p_"+i+"="+($scope.rw[i].persistent==true?1:0)+"\n";
                    data+="rw_desc_"+i+"="+($scope.rw[i].description)+"\n";
                    if ($scope.rw_multiblock) {
                        data+="rw_reg_"+i+"="+$scope.rw[i].address+"\n";
                    }
        }
        for (i=0;i<$scope.num_ro;i++) {
                    data+="ro_var_"+i+"="+($scope.ro[i].name)+"\n";
                    data+="ro_desc_"+i+"="+($scope.ro[i].description)+"\n";
                    data+="ro_p_"+i+"="+($scope.ro[i].persistent==true?1:0)+"\n";
                    data+="ro_i_"+i+"="+($scope.ro[i].poll_interval)+"\n";
                    if ($scope.ro_multiblock) {
                        data+="ro_reg_"+i+"="+$scope.ro[i].address+"\n";
                    }
        }
        for (i=0;i<$scope.num_roles;i++) {
                    data+="role_var_"+i+"="+($scope.roles[i].name)+"\n";
                    data+="role_type_"+i+"="+$scope.roles[i].type+"\n";
                    data+="role_idx_"+i+"="+$scope.roles[i].idx+"\n";
                    data+="role_scale_"+i+"="+$scope.roles[i].scale+"\n";
        }
        for (i=0;i<$scope.num_ot;i++) {
            data+="ot_type_"+i+"="+($scope.ot[i].type)+"\n";
            data+="ot_func_"+i+"="+($scope.ot[i].func)+"\n";
            data+="ot_address_"+i+"="+($scope.ot[i].address)+"\n";
            data+="ot_count_"+i+"="+($scope.ot[i].count)+"\n";
        }
        
    //document.getElementById("statusmsg").innerHTML="<i>Saving file, please wait...</i>";
    fn = "/dev/dev"+$scope.dev_type_id+'.ini';
    
	/*$.ajax({
          type: "PUT",
          url: fn,
          data: data,
          dataType: "html"
        }).done(function( msg ) {
           if (msg.substr(0,2)!="OK") alert(msg);
          //alert( "Data Saved: " + msg );
          globalScope.apply(function() {
        //  alert("OK!");
        	$scope.successmsg="Settings saved. You will need to reboot for changes to take effect";
          });
        	//document.getElementById("successmsg").innerHTML="Settings saved. You will need to reboot for changes to take effect";
        });    
      */  
      //alert(data);return;    
      role_url='/app/configsavedev.cgi?config=dev'+$scope.dev_type_id+'.ini&section=config';
      $http.put(fn,data)
        .then(function (response) {
        //alert(response.data);
          //if (response=="OK")
          var data = response.data;
          $scope.loading=0;
          //alert(data);
          if (data=="OK")
            $scope.successmsg="Settings saved. You will need to reboot for changes to take effect";
          else {
            $scope.errormsg=data;
          }
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.loading=0;
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }

}


</script>
<? include("/app/footer.inc"); ?>      












