<?
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : networksave.cgi
 * 
 *  Description: Ajax used for network settings
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 ********************************************************************/

if (!$_SESSION['logged_in']) {
    print("Error: You must be logged in to change settings!");
    die();
}
if ($_SESSION['admin']==0) {    
    die();     
}

$error=0;
if (nvram_get("use_nvram")!=1) {
    if ($_POST['dhcp_enabled']) 
        ini_set("/config/network.ini","network","dhcp_enabled",$_POST['dhcp_enabled']);
    if ($_POST['ip']) {
    	if (!ini_set("/config/network.ini","network","ip",$_POST['ip'])) $error=1;
    } else $error=1;
    if ($_POST['netmask']) {
    	if (!ini_set("/config/network.ini","network","netmask",$_POST['netmask'])) $error=1;
    } else $error=1;
    if ($_POST['gateway']) {
    	if (!ini_set("/config/network.ini","network","gateway",$_POST['gateway'])) $error=1;
    } else $error=1;
    if ($_POST['dns1']) {
    	if (!ini_set("/config/network.ini","network","dns1",$_POST['dns1'])) $error=1;
    } else $error=1;
    if ($_POST['dns2']) {
    	if (!ini_set("/config/network.ini","network","dns2",$_POST['dns2'])) $error=1;
    } else $error=1;
    
    if ($_POST['tcp_server_enabled']) {
    	if (!ini_set("/config/network.ini","network","tcp_server_enabled",$_POST['tcp_server_enabled'])) $error=1;
    } else $error=1;    
    if ($_POST['tcp_server_port']) {
    	if (!ini_set("/config/network.ini","network","tcp_server_port",$_POST['tcp_server_port'])) $error=1;
    } else $error=1;    
    if ($_POST['tcp_server']) {
    	if (!ini_set("/config/network.ini","network","tcp_server",$_POST['tcp_server'])) $error=1;
    } else $error=1;    
    if ($_POST['mtu']) {
    	if (!ini_set("/config/network.ini","network","mtu",$_POST['mtu'])) $error=1;
    } 
    
} else {
     if ($_POST['dhcp_enabled']) 
        nvram_set("net_dhcp",strval($_POST['dhcp_enabled']));
    if ($_POST['ip']) {
    	nvram_set("net_ip",strval($_POST['ip']));
    } else $error=1;
    if ($_POST['netmask']) {
    	nvram_set("net_netmask",strval($_POST['netmask']));
    } else $error=1;
    if ($_POST['gateway']) {
    	nvram_set("net_gateway",strval($_POST['gateway']));
    } else $error=1;
    if ($_POST['dns']) {
    	nvram_set("net_dns1",strval($_POST['dns']));
    } else $error=1;
}
if ($error) {
	print("ERROR saving network settings.");
} else {
    ini_set("/config/setup.ini","setup","setup0status",1);
	print("Network settings updated successfully. Any changes will only take effect on the next reboot.");
	$_GLOBALS['needreboot']=1;
}

?>

