<?
/**
 * @package kWGraph
 * @author Akash Heimlich
 * @description kWGraph
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function kWGraph_install($val) {
        kWGraph_enable();
        return 1;
    }
     
    function kWGraph_uninstall() {
        setPackageStatus("kWGraph",0);
        return 1;
    }
    
    function kWGraph_enable() {
        setPackageStatus("kWGraph",2);
        addWidget("/package/kWGraph.inc","kW Generated Today",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function kWGraph_disable() {
        setPackageStatus("kWGraph",3);
        addWidget("/package/TestWidget.inc","kW Generated Today",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function kWGraph_init() {
        
        // load the test Value into the globals
        $_GLOBALS['kWGraph_col']=ini_get("/config/kWGraph.ini","config","kWGraph_col","");
    
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/kWGraph.cgi?action=configure';
        $arr['title']='kW Graph';
        $arr['icon']='icon-hdd';
        $arr['desc']='kw Graph settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        //if (file_exists('/package/TestWidgetAjax.inc')) 
          //  $_GLOBALS['hooks']['ajax'][]='/package/TestWidgetAjax.inc';

        // runs this file once a second
        //if (file_exists('/package/TestWidgetSec.inc')) 
          //  $_GLOBALS['hooks']['sec'][]='/package/TestWidgetSec.inc';
            
        // runs this file once a minute
        //if (file_exists('/package/TestWidgetMin.inc')) 
          //  $_GLOBALS['hooks']['min'][]='/package/TestWidgetMin.inc';
            
        // runs this file once a day
        //if (file_exists('/package/TestWidgetDay.inc')) 
          //  $_GLOBALS['hooks']['sec'][]='/package/TestWidgetDay.inc';            
        return 1;
    }
    
    function kWGraph_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="kWGraph"; 
        $title='Configure kW Graph Widget';
        $config_file="kWGraph.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">kWGraph Widget</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> kW Graph Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
This widget displays kW data for the selected group. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Widget Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="kWGraph_col='<? print(ini_get("/config/".$config_file,$config_section,"kWGraph_col","")); ?>';">
		<? 
$grpnumvar=ini_get("/config/datalog.ini","data","group0numvar",0);		
 
?>
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='kWGraph_col'>Source Field</label>
		            <div class="controls">
		              <select ng-model="kWGraph_col"  name='kWGraph_col' title="Enter a value to be saved to a config file for re-use later" data-rel="tooltip"> 
		                   <? 
		                   
		                   
                            $num_sysvars=ini_get("/config/sysvars.ini","sysvars","num_sysvars",0);

                            $num_roles=ini_get("/config/roles.ini","roles","num_roles",0);
            

		                   for ($i=0;$i<$grpnumvar;$i++) {
		                        $type=ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$i+'vartype');
                                $val=ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$i+'varval');
                                
                                if ($type==1) {
                                    $title=ini_get("/config/sysvars.ini","sysvars",'sysvar'.intval($val).'title',"");
                                } 
                                if ($type==2) {
                                    $title=ini_get("/config/roles.ini","roles",'role'+intval($val));
                                }
                                if ($type==3) { 
                                    $title=$val;
                                }
                                print("<option value='".$i."'>".$title."</option>");
		                   }
		                   ?>
		              </select>
			        </div>
		        </div>
		</fieldset>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function kWGraph($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   
  
   $scope.saveSettings=function() {
       post_data="kWGraph_col="+$scope.kWGraph_col;
       post_config="kWGraph.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>



