<?
/**
 * @package WeatherWidget
 * @author Akash Heimlich
 * @description Grabs the weather from the internet
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function WeatherWidget_install($val) {
        WeatherWidget_enable();
        return 1;
    }
     
    function WeatherWidget_uninstall() {
        setPackageStatus("WeatherWidget",0);
        return 1;
    }
    
    function WeatherWidget_enable() {
        setPackageStatus("WeatherWidget",2);
        addWidget("/package/WeatherWidget.inc","Weather",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function WeatherWidget_disable() {
        setPackageStatus("WeatherWidget",3);
        addWidget("/package/WeatherWidget.inc","Weather",4,"icon-play",1,1); // disable
        return 1;
    }
    
    function WeatherWidget_detect() {
        $f=fsockopen("ip-api.com",80,10);
        	if ($f) {
        	    $out = "GET /json HTTP/1.0\r\n";
                $out = $out."Host: ip-api.com\r\n";
        	    $out = $out."Connection: Keep-Alive\r\n\r\n";
        	    fwrite($f, $out);
        	    //print($out);
        	    // get header
        	    $done=0;
        	    while (!$done) {
        		    $str=fgets($f);
        		    print($str);
        		    if (strlen($str)==0) $done=1;
        	    }
        	    print('header');
        	    $str='';
        	    $done=0;
        	    /*while (!$done) {//feof($f)) {
            	    //$str2=fread($f,filesize($f));
            	    //if (filesize($f))
        		    $str2=fgets($f);
        		    print($str2);
        		    if (!$str2) break;
        		    $str=$str.$str2;
    
        	    }*/
        	    $str=fread($f,filesize($f));
        	    //print($str);
    //    	    $str=$str2;
        	    //fclose($f);
        	    //die();
        	    $keys=array();
        	    if (substr($str,0,1)=='{') {
        	       $dat=substr($str,1,strlen($str)-2);
        	       $arr=explode($dat,",");
        	       for ($i=0;$i<sizeof($arr);$i++) {
        	           $arr[$i]=explode($arr[$i],":");
        	           for ($j=0;$j<sizeof($arr[$i]);$j++) {
        	               if (substr($arr[$i][$j],0,1)=='"') {
        	                   $arr[$i][$j]=substr($arr[$i][$j],1,strlen($arr[$i][$j])-2);
        	               }
        	           }
        	           $keys[$arr[$i][0]]=$arr[$i][1];
        	           $arr[$i]=0;
        	       }
        	       if ($keys['lat']!=0) {
        	           $_GLOBALS['geo_lat']=$keys['lat'];
        	           $lat=floatval(nvram_get("geo_lat"));
        	           if ($lat!=$keys['lat'])
        	             nvram_set("geo_lat",$keys['lat']);
        	       }
        	       if ($keys['lon']!=0) {
        	           $_GLOBALS['geo_lon']=$keys['lon'];
        	           $lon=floatval(nvram_get("geo_lon"));
        	           if ($lon!=$keys['lon'])
        	             nvram_set("geo_lon",$keys['lon']);
        	       }
        	       if ($keys['city']!=0) {
        	           $_GLOBALS['geo_city']=$keys['city'];
        	           $lat=nvram_get("geo_city");
        	           if ($lat!=$keys['city'])
        	             nvram_set("geo_city",$keys['city']);
        	       }
        	       if ($keys['country']!=0) {
        	           $lat=nvram_get("geo_country");
        	           if ($lat!=$keys['country'])
        	             nvram_set("geo_country",$keys['country']);
        	       }
        	       print_r($keys);
        	    }
    		    //print($str+"\r\n");
        
        	    fclose($f);
    
        	} else {
        	    print("unable to connect to host");
        	}
    }
    /* this is called at system boot */
    function WeatherWidget_init() {
        $lat=floatval(nvram_get("geo_lat","0"));
        // first time, set the geo coordinates
        if ($lat==0) {
            WeatherWidget_detect();
        }
        // load the test Value into the globals
        $_GLOBALS['weather_min']=0; // force update next minute
    
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/WeatherWidget.cgi?action=configure';
        $arr['title']='Weather';
        $arr['icon']='icon-hdd';
        $arr['desc']='WeatherWidget settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        

        // runs this file once a minute
        if (file_exists('/package/WeatherWidgetMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/WeatherWidgetMin.inc';
            
        return 1;
    }
    
    function WeatherWidget_configure() {
        include("/lang/lang.inc");
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="WeatherWidget"; 
        $title='Configure Package Weather';
        $config_file="weather.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">Weather Widget</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> Weather Widget Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
This widget is a test widget.  Put your text here. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Widget Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="weather_min='<? print(nvram_get("weather_min","60")); ?>';">
		<div ng-init="geo_lat='<? print(nvram_get("geo_lat","0")); ?>';">
		<div ng-init="geo_lon='<? print(nvram_get("geo_lon","0")); ?>';">
		<div ng-init="geo_city='<? print(nvram_get("geo_city","Puducherry")); ?>';">
		<div ng-init="geo_key='<? print(nvram_get("geo_key","")); ?>';">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='weather_min'>Update Interval (Minutes)</label>
		            <div class="controls">
			            <input type='text' ng-model="weather_min"  name='weather_min' title="Enter a value to be saved to a config file for re-use later" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='geo_lat'>Latitude</label>
		            <div class="controls">
			            <input type='text' ng-model="geo_lat"  name='geo_lat' title="Latitude" data-rel="tooltip"> 
			        </div>
		        </div>
		        <div class="control-group">
		            <label class="control-label" for='geo_lon'>Longitude</label>
		            <div class="controls">
			            <input type='text' ng-model="geo_lon"  name='geo_lon' title="Longitude" data-rel="tooltip"> 
			        </div>
		        </div>
		        <div class="control-group">
		            <label class="control-label" for='geo_city'>City (overrides geo coordinates if set)</label>
		            <div class="controls">
			            <input type='text' ng-model="geo_city"  name='geo_city' title="City" data-rel="tooltip"> 
			        </div>
		        </div>
                <div class="control-group">
		            <label class="control-label" for='geo_city'>API Key (See https://openweathermap.org/)</label>
		            <div class="controls">
			            <input type='text' ng-model="geo_key"  name='geo_key' title="Key" data-rel="tooltip"> 
			        </div>
		        </div>
				        
		        
		</fieldset>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function WeatherWidget($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="weather_min="+$scope.weather_min+
       "&geo_lat="+$scope.geo_lat+
       "&geo_lon="+$scope.geo_lon+
       "&geo_key="+$scope.geo_key+
       "&geo_city="+$scope.geo_city;
       $http.post('/app/configsavenv.cgi',post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>



