<?
/**
 * @package LCD Widget
 * @author Akash Heimlich
 * @description display custom information on the LCD display
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function LCD_install($val) {
        LCD_enable();
        return 1;
    }
     
    function LCD_uninstall() {
        setPackageStatus("LCD",0);
        return 1;
    }
    
    function LCD_enable() {
        setPackageStatus("LCD",2);
        addWidget("/package/LCD.inc","LCD",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function LCD_disable() {
        setPackageStatus("LCD",3);
        addWidget("/package/LCD.inc","LCD",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function LCD_init() {
        
        // load the test Value into the globals
        $_GLOBALS['testValue']=ini_get("/config/LCD.ini","config","test","");
    
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/LCD.cgi?action=configure';
        $arr['title']='LCD';
        $arr['icon']='icon-hdd';
        $arr['desc']='LCD settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/LCDAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/LCDAjax.inc';

        // runs this file once a second
        if (file_exists('/package/LCDSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/LCDSec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/LCDMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/LCDMin.inc';
            
        // runs this file once a day
        if (file_exists('/package/LCDDay.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/LCDDay.inc';            
        return 1;
    }
    
    function LCD_configure() {
        include("/app/config.inc");
		$num_sysvars=ini_get("/config/sysvars.ini","sysvars","num_sysvars",0);

        $bodyid='rootscope';
        $angular_controller="LCD"; 
        $title='Configure Package LCD';
        $config_file="LCD.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">Test Widget</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> LCD Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
Variables can be integrated in the rows using the @ symbol.  Variables for the page start at index 1.  For example, to show the contents of variable number 1, you would put @1 in your row.
Variables can be of type System Variable, of type Device Variable (row), of type Global variable or of type Time.
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> LCD Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="num_pages='<? print(ini_get("/config/".$config_file,$config_section,"num_pages",0)); ?>';">
		 <fieldset>
				<div class="control-group">
		            <label class="control-label" for='device_id'>Modbus ID</label>
		            <div class="controls">
			            <input type='text' ng-model="device_id"  name='device_id' title="Modbus ID" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='num_pages'>Num Pages</label>
		            <div class="controls">
			            <input readonly type='text' ng-model="num_pages"  name='num_pages' title="Number of pages" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='update_interval'>Update Interval (seconds)</label>
		            <div class="controls">
			            <input type='text' ng-model="update_interval"  name='update_interval' title="Number of seconds between refresh" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='rotate_interval'>Rotate Interval (seconds)</label>
		            <div class="controls">
			            <input type='text' ng-model="rotate_interval"  name='rotate_interval' title="Number of seconds between rotate" data-rel="tooltip"> 
			        </div>
		        </div>

		</fieldset>

 		<div class="row-fluid">
				<div class="box span12">
					<div class="box-header well">
						<h2><i class="icon-align-justify"></i> Page List</h2>
						<div class="box-icon">
							<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
						</div>
					</div>
					<div class="box-content">
					
		<a name='addvar'></a>
		<button class="btn" ng-click="addPage()"><i class="icon-plus"></i> Add Page</button>

<table class='table table-striped' summary="Pages">
<tr>
<th scope="col">ID</th>
<th scope="col">Details</th></th>
<th scope="col">Options</th>
</tr>
<tr ng-repeat="page in pages">
    <td ><span class="badge badge-inverse">{{$index}}</span></td>
    <td>
		<fieldset>
		See help above on how to integrate variables in the row<p>
			    <div class="control-group">
		            <label class="control-label" for='page.row0'>Row 1</label>
		            <div class="controls">
			            <input type='text' style='font-family:monospace' ng-model="page.row0"  name='page.row0' title="Row 1" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='page.row1'>Row 2</label>
		            <div class="controls">
			            <input style='font-family:monospace' type='text' ng-model="page.row1"  name='page.row1' title="Row 2" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='page.row2'>Row 3</label>
		            <div class="controls">
			            <input style='font-family:monospace' type='text' ng-model="page.row2"  name='page.row2' title="Row 3" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='page.row3'>Row 4</label>
		            <div class="controls">
			            <input type='text' style='font-family:monospace' ng-model="page.row3"  name='page.row3' title="Row 4" data-rel="tooltip"> 
			        </div>
		        </div>

			    <div class="control-group">
		            <label class="control-label" for='page.num_vars'>Num Variables</label>
		            <div class="controls">
			            <input type='number' readonly  ng-model="page.num_vars"  name='page.num_vars' title="Number of variables" data-rel="tooltip"> 
			        </div>
		        </div>
		</fieldset>
		<a name='addvar'></a>
		<button class="btn" ng-click="addVar(page)"><i class="icon-plus"></i> Add</button>

		<table class='table table-striped' summary="Fields">
			<tr>
				<th scope="col">ID</th>
				<th scope="col">Type</th>
				<th scope="col">Value</th>
				<th scope="col">Decimals</th>
				<th scope="col">Options</th>
			</tr>
			<tr ng-repeat="item in page.variables">
		
				<td><a name='var{{$index}}'></a><span class="badge badge-inverse">{{$index+1}}</span></td>
				<td><strong>{{makeValueType(item)}}</strong><div ng-show='item.edit==1'>
					<select class='span12' ng-model="item.vartype">
						<option value='1'>System Variable</option>
						<option value='2'>Device Variable</option>
						<option value='3'>Time</option>
						<option value='4'>Global Variable</option>            
						</select>
					</div>
				</td>            
				<td><strong>{{makeValue(item)}}</strong>
					<div ng-show='item.edit==1 && item.vartype==1'>
						<select class='span12' ng-model="item.varval">
						<? //$num_sysvars=ini_get("/config/sysvars.ini","sysvars","num_sysvars",0);
						  for ($i=1;$i<$num_sysvars;$i++) {
							$st=ini_get("/config/sysvars.ini","sysvars",'sysvar'.$i.'title');
							print("<option value='".$i."'>".$st."</option>\r\n");
						} ?>
							</select>
					</div>
					<div ng-show='item.edit==1 && item.vartype==2'>
						<select class='span12' ng-model="item.varval">
						<? $nr=ini_get("/config/roles.ini","roles","num_roles",0);
							for ($i=0;$i<$nr;$i++) { 
							print("<option value='"+$i+"'>"+ini_get("/config/roles.ini","roles",'role'+$i)+"</option>");
							}
							   ?>
						</select>
					</div>
					<div ng-show='item.edit==1 && item.vartype>=3'>
						<input class='span12' type='text' ng-model='item.varval'>
					</div>
				</td>     
				<td>
					<div ng-show='item.edit==0'>{{item.decimals}}</div>
					<div ng-show='item.edit==1'>
						<input class='span12' type='number' ng-model='item.decimals'>
					</div>
				</td>
				<td>
					<div class="pull-right btn-group">
					<a class="btn dropdown-toggle" data-toggle="dropdown" href="#">
					Action
					<span class="caret"></span>
					</a>
					<ul class="dropdown-menu">
						<!-- dropdown menu links -->
						<li ng-show='item.edit!=1'><a ng-click='item.edit=1' href='#var{{$index}}'><i class="icon-pencil"></i> Edit</a></li>
						<li ng-show='item.edit==1'><a ng-click='item.edit=0' href='#var{{$index}}''><i class="icon-pencil"></i> Stop Edit</a></li>
						 <li><a ng-click='page.variables.splice($index,1)' href='#addvar'><i class="icon-remove"></i> Delete</a></li>
					</ul>
				    </div>
				</td>
			</tr>
		</table>

	</td>
    <td>
    <a ng-click='page.edit=1' class="btn">
    Edit
    
    </a>
    	<div class="pull-right btn-group">
					<a class="btn dropdown-toggle" data-toggle="dropdown" href="#">
					Action
					<span class="caret"></span>
					</a>
					<ul class="dropdown-menu">
						<!-- dropdown menu links -->
						<li ng-show='page.edit!=1'><a ng-click='page.edit=1' href='#var{{$index}}'><i class="icon-pencil"></i> Edit</a></li>
						<li ng-show='page.edit==1'><a ng-click='page.edit=0' href='#var{{$index}}''><i class="icon-pencil"></i> Stop Edit</a></li>
						 <li><a ng-click='delPage($index)' href='#addvar'><i class="icon-remove"></i> Delete</a></li>
					</ul>
				    </div>
    </td>
</tr>
</table>

<div class="clearfix"></div>    <!-- actionlist-->
					</div>
				</div>
			</div>  


		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function LCD($scope, $timeout,$http) {
   var self = this;
   //alert('init');
	$scope.pages=[];
	$scope.num_pages=<? print(ini_get("/config/LCD.ini","config","num_pages",0)); ?>;
	$scope.update_interval=<? print(ini_get("/config/LCD.ini","config","update_interval",5)); ?>;
	$scope.device_id=<? print(ini_get("/config/LCD.ini","config","device_id",1)); ?>;
	$scope.rotate_interval=<? print(ini_get("/config/LCD.ini","config","rotate_interval",10)); ?>;
	<?
	$num_pages=ini_get("/config/LCD.ini","config","num_pages",0);
	for ($i=0;$i<$num_pages;$i++) {
		$num_vars=ini_get("/config/LCD.ini","config","p".$i."num_vars",0);
		$row0=ini_get("/config/LCD.ini","config","p".$i."row0","");
		$row1=ini_get("/config/LCD.ini","config","p".$i."row1","");
		$row2=ini_get("/config/LCD.ini","config","p".$i."row2","");
		$row3=ini_get("/config/LCD.ini","config","p".$i."row3","");
		print('page={"edit":0,"row0":"'.$row0.'","row1":"'.$row1.'","row2":"'.$row2.'","row3":"'.$row3.'","num_vars":'.$num_vars.',"variables":[');
		
		for ($v=0;$v<$num_vars;$v++) {
		   $vt=ini_get("/config/LCD.ini","config","p".$i."v".$v."vt",0);
			$st='{"edit":0,"vartype":'.$vt.",";
			if ($vt<3) {
			    $st.='"varval":"'.ini_get("/config/LCD.ini","config","p".$i."v".$v."vv",0).'",';
			} else $st.='"varval":"'.ini_get("/config/LCD.ini","config","p".$i."v".$v."vv","").'",';
			$st.='"decimals":'.intval(ini_get("/config/LCD.ini","config","p".$i."v".$v."d",0)).'},';
			print($st);
		}
		print("]};\r\n");
		print("$scope.pages.push(page); ");
	}
	?>
   $scope.loading=0;
   $gscope=$scope;


	$scope.makeValue=function(item) {
		if (item.edit) return '';
		str='';
		if (Number(item.vartype)==1)  { // preset role
		  switch (Number(item.varval)) {
		  <? for ($i=0;$i<$num_sysvars;$i++) {
		        $st=ini_get("/config/sysvars.ini","sysvars",'sysvar'.$i.'title',"");            
		        //$st=$sysvars['sysvar'.$i.'title'];
		        print("case ".$i.":str='".$st."';break;\r\n");
		    } ?>
		    
		  }
		}
		if (Number(item.vartype)==2)  { // role role
		    switch (Number(item.varval)) {
		    <? $nr=ini_get("/config/roles.ini","roles","num_roles",0);
		        for ($i=0;$i<$nr;$i++) { 
		            print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
		        }
		        ?>
		    }
		  }
		  if (Number(item.vartype)>=3)  { // global value
		    str=item.varval;
		  }
		  return str;
		
	  }
	 $scope.makeValueType=function(item) {
		if (item.edit) return '';
		str='';
		switch (Number(item.vartype)) {
		    case 0: str="Undefined";break;
		    case 1: str="System Variable";break;
		    case 2: str="Device Variable";break;
		    case 3: str="Time";break;
		    case 4: str="Global Variable";break;
		}
		return str;
	  }
	  $scope.addVar=function(page) {
		  page.num_vars++;
		  page.variables.push({edit:1,decimals:0});
	  }
	  $scope.addPage=function() {
		  $scope.num_pages++;$scope.pages.push({edit:1,num_vars:0,variables:[]});
	  }
	  $scope.delPage=function(idx) {
	    $scope.pages.splice(idx,1);
	    $scope.num_pages--;
	  }
   $scope.saveSettings=function() {
       post_data="num_pages="+$scope.num_pages;
       post_data+="&rotate_interval="+$scope.rotate_interval;
       post_data+="&update_interval="+$scope.update_interval;
       post_data+="&device_id="+$scope.device_id;
       for (i=0;i<$scope.pages.length;i++) {
            if ($scope.pages[i].row0=="undefined") $scope.pages[i].row0="";
            if ($scope.pages[i].row1=="undefined") $scope.pages[i].row1="";
            if ($scope.pages[i].row2=="undefined") $scope.pages[i].row2="";
            if ($scope.pages[i].row3=="undefined") $scope.pages[i].row3="";
            
       	  	post_data+="&p"+i+"row0="+encodeURIComponent($scope.pages[i].row0);
       	  	post_data+="&p"+i+"row1="+encodeURIComponent($scope.pages[i].row1);
       		post_data+="&p"+i+"row2="+encodeURIComponent($scope.pages[i].row2);
       		post_data+="&p"+i+"row3="+encodeURIComponent($scope.pages[i].row3);
       		post_data+="&p"+i+"num_vars="+($scope.pages[i].num_vars);
       		for (v=0;v<$scope.pages[i].variables.length;v++) {
       			post_data+="&p"+i+"v"+v+"vt="+$scope.pages[i].variables[v].vartype;
       			post_data+="&p"+i+"v"+v+"vv="+encodeURIComponent($scope.pages[i].variables[v].varval);
       			post_data+="&p"+i+"v"+v+"d="+$scope.pages[i].variables[v].decimals;
       		}
       }
//       alert(post_data);
       post_config="LCD.ini";
       post_section="config";
       
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }

}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>




