<?
/**
 * @package TestWidget
 * @author Akash Heimlich
 * @description This dummy widget shows the basic functionality of widgets and can be used as a starting point
 * for further development
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function TestWidget_install($val) {
        TestWidget_enable();
        return 1;
    }
     
    function TestWidget_uninstall() {
        setPackageStatus("TestWidget",0);
        return 1;
    }
    
    function TestWidget_enable() {
        setPackageStatus("TestWidget",2);
        addWidget("/package/TestWidget.inc","TestWidget",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function TestWidget_disable() {
        setPackageStatus("TestWidget",3);
        addWidget("/package/TestWidget.inc","TestWidget",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function TestWidget_init() {
        
        // load the test Value into the globals
        $_GLOBALS['testValue']=ini_get("/config/TestWidget.ini","config","test","");
    
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/TestWidget.cgi?action=configure';
        $arr['title']='Test';
        $arr['icon']='icon-hdd';
        $arr['desc']='Test widget settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/TestWidgetAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/TestWidgetAjax.inc';

        // runs this file once a second
        if (file_exists('/package/TestWidgetSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/TestWidgetSec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/TestWidgetMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/TestWidgetMin.inc';
            
        // runs this file once a day
        if (file_exists('/package/TestWidgetDay.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/TestWidgetDay.inc';            
        return 1;
    }
    
    function TestWidget_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="TestWidgetCtrl"; 
        $title='Configure Package TestWidget';
        $config_file="/config/TestWidget.ini";
        $config_section="config";

    
        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> 
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/">Home</a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi">Settings</a></li>
    <li class="breadcrumb-item active" aria-current="page">Test Widget</li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-group"></i> Widget Settings</h2>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> CLOSE</a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> APPLY</a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <h4>Test Widget<br>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<!-- VARIABLES -->
<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print(lang('NEED_REBOOT')); ?>';"></div>

<!-- LOAD YOUR CONFIG VALUES HERE -->
<div ng-init="test_value='<? print(ini_get($config_file,$config_section,"test_value",'')); ?>';">
<div ng-init="test_radio=<? print(ini_get($config_file,$config_section,"test_radio",0)); ?>;">

<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Settings</h5>
        <p class="card-text">    

          <div class="form-group">
            <label for="test_value">Test Value</label>
            <input type="text" class="form-control" id="test_value" ng-model="test_value" aria-describedby="testValueHelp" placeholder="Enter value">
            <small id="testValueHelp" class="form-text text-muted">Your value help</small>
          </div>
          <div class="form-group">
            <label for="test_radio">Test Option Selection</label>
            <select ng-model="test_radio" name='test_radio' class="custom-select custom-select-sm">
                <option value='0'>Disabled</option>
                <option value='1'>Enabled</option>
            </select>
            <small id="langH" class="form-text text-muted">Select an option</small>
          </div>
        </p>
    </div>
</div>
<br/>

</form>
     <script>
     var app = angular.module('myApp', []);
     function TestWidgetCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";
    $scope.saveSettings=function() {
       post_data="test_value="+$scope.test_value;
       post_data+="&test_radio="+$scope.test_radio;
       post_config="TestWidget.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
   }
    
  //poll();

</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>




