<?
/**
 * @package SavedCounters
 * @author Akash Heimlich
 * @description This widget periodically writes counter values to an INI file and reloads them at bootup to allow for flow totalization
 * it also allows you to configure the multiplier for the counter to turn pulses to liters, etc.
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
     function add_role($id,$role_name,$role_group,$role_type,$role_show,$role_def,$role_devices) {
        if ($id==-1)  {
            $num_r=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($j=0;$j<$num_r;$j++) { 
                if ($role_name==ini_get("/config/roles.ini","roles","role"+$j,'')) {
                    break;
                }
            }
            $id=$j;
         //   print("found role at ".$id."\r\n");
            if ($id==$num_r)  {
                ini_set("/config/roles.ini","roles","num_roles",$id+1);
                $f=fopen("/config/roles.ini",'a+');
                $st="role"+$id+"=".$role_name."\r\n".
                    "role"+$id+"group=".$role_group."\r\n".
                    "role"+$id+"type=".$role_type."\r\n".
                    "role"+$id+"ids=".$role_devices."\r\n".
                    "role"+$id+"def=".$role_def."\r\n".
                    "role"+$id+"show=".$role_show."\r\n";
                fwrite($f,$st);
                fclose($f);
                
            /*    ini_set("/config/roles.ini","roles","role"+$id,$role_name);
                ini_set("/config/roles.ini","roles","role"+$id+"group",$role_group);
                ini_set("/config/roles.ini","roles","role"+$id+"type",$role_type);
                ini_set("/config/roles.ini","roles","role"+$id+"ids",$role_devices);
                ini_set("/config/roles.ini","roles","role"+$id+"def",$role_def);
                ini_set("/config/roles.ini","roles","role"+$id+"show",$role_show);*/
            }
            
        } else {
            if (ini_get("/config/roles.ini","roles","role"+$id)!=$role_name)
                        ini_set("/config/roles.ini","roles","role"+$id,$role_name);
            if (ini_get("/config/roles.ini","roles","role"+$id+"group")!=$role_group)                    
                        ini_set("/config/roles.ini","roles","role"+$id+"group",$role_group);
            if (ini_get("/config/roles.ini","roles","role"+$id+"type")!=$role_type)                                        
                        ini_set("/config/roles.ini","roles","role"+$id+"type",$role_type);
            if (ini_get("/config/roles.ini","roles","role"+$id+"ids")!=$role_devices)                                            
                        ini_set("/config/roles.ini","roles","role"+$id+"ids",$role_devices);
            if (ini_get("/config/roles.ini","roles","role"+$id+"def")!=$role_def)                                        
                        ini_set("/config/roles.ini","roles","role"+$id+"def",$role_def);
            if (ini_get("/config/roles.ini","roles","role"+$id+"show",0)!=$role_show)                                        
                        ini_set("/config/roles.ini","roles","role"+$id+"show",$role_show);
        }
    }
    function SavedCounters_install($val) {
        SavedCounters_enable();
        return 1;
    }
     
    function SavedCounters_uninstall() {
        setPackageStatus("SavedCounters",0);
        return 1;
    }
    
    function SavedCounters_enable() {
        setPackageStatus("SavedCounters",2);
        addWidget("/package/SavedCounters.inc","Counters",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function SavedCounters_disable() {
        setPackageStatus("SavedCounters",3);
        addWidget("/package/SavedCounters.inc","Counters",4,"icon-play",1,1); // disable
        return 1;
    }
    
    function SavedCounters_globals() {
        return array(
            array('c1_total','Total for counter 1'),
            array('c1_today','Day total for counter 1'),
            array('c1_rate','Counter 1 rate'),
            array('c2_total','Total for counter 2'),
            array('c2_today','Day total for counter 2'),
            array('c2_rate','Counter 2 rate'),
            array('c3_total','Total for counter 3'),
            array('c3_today','Day total for counter 3'),
            array('c3_rate','Counter 3 rate'));
            
    }
    
    /* this is called at system boot */
    function SavedCounters_init() {
        
        // check if the counters are active
        $_GLOBALS['c1_enabled']=ini_get("/config/SavedCounters.ini","config","c1_enabled",0);
        $_GLOBALS['c2_enabled']=ini_get("/config/SavedCounters.ini","config","c2_enabled",0);
        $_GLOBALS['c3_enabled']=ini_get("/config/SavedCounters.ini","config","c3_enabled",0);
        $err='';
        $prefix='';
        if ($_SERVER['HW_PLATFORM']==11) {
            $prefix='0:';
        }
        if ($_SERVER['HW_PLATFORM']>=20)   // ULTRA
            $prefix=intval($_GLOBALS['log_drive']).':';    


        // get the main 
        $arr=mb_get_dev_by_id(0); 
        //print('value is '.$_GLOBALS['c1_enabled']);
      //  print_r($arr);
        if ($_GLOBALS['c1_enabled']) {
            add_role(-1,'c1_total',0,5,1,0,'1');  
            add_role(-1,'c1_today',0,5,1,0,'1');  
            add_role(-1,'c1_rate',0,5,1,0,'1');
            add_role(-1,'c1_mins',0,5,1,0,'1');  
            //($id,$role_name,$role_group,$role_type,$role_show,$role_def,$role_devices)
            $_GLOBALS['c1_raw']=ini_get($prefix."/ini/SavedCounters.ini","config","c1_raw",0);
            $_GLOBALS['c1_mins']=ini_get($prefix."/ini/SavedCounters.ini","config","c1_mins",0);
            $_GLOBALS['c1_rawtoday']=ini_get($prefix."/ini/SavedCounters.ini","config","c1_rawtoday",0);
            $_GLOBALS['c1_div']=ini_get("/config/SavedCounters.ini","config","c1_div",1);
            $_GLOBALS['c1_interval']=ini_get("/config/SavedCounters.ini","config","c1_interval",0);
            $_GLOBALS['c1_total']=$_GLOBALS['c1_raw']/$_GLOBALS['c1_div'];
            $_GLOBALS['c1_today']=$_GLOBALS['c1_raw_today']/$_GLOBALS['c1_div'];
            $_GLOBALS['c1_unit']=ini_get("/config/SavedCounters.ini","config","c1_unit","l");
            $_GLOBALS['c1_rate']=0; // rate
            $_GLOBALS['c1_last']=0; // rate
            if (!$arr['di1_counter_enabled']) {
                mb_set_dev_var($arr['name'],'di1_counter_enabled',16);
                //$err.="Counter 1 is disabled in hardware. ";
            }
            
        }
        if ($_GLOBALS['c2_enabled']) {
            add_role(-1,'c2_total',0,5,1,0,'1');  
            add_role(-1,'c2_today',0,5,1,0,'1');  
            add_role(-1,'c2_rate',0,5,1,0,'1');  
            $_GLOBALS['c2_raw']=ini_get($prefix."/ini/SavedCounters.ini","config","c2_raw",0);
            $_GLOBALS['c2_raw_today']=ini_get($prefix."/ini/SavedCounters.ini","config","c2_raw_today",0);
            $_GLOBALS['c2_div']=ini_get("/config/SavedCounters.ini","config","c2_div",0);
            $_GLOBALS['c2_total']=$_GLOBALS['c2_raw']/$_GLOBALS['c2_div'];
            $_GLOBALS['c2_today']=$_GLOBALS['c2_raw_today']/$_GLOBALS['c2_div'];
            $_GLOBALS['c2_unit']=ini_get("/config/SavedCounters.ini","config","c2_unit","l");
            $_GLOBALS['c2_interval']=ini_get("/config/SavedCounters.ini","config","c2_interval",0);
            $_GLOBALS['c2_rate']=0; // rate
            $_GLOBALS['c2_last']=0;
            if (!$arr['di2_counter_enabled']) {
                //$err.="Counter 2 is disabled in hardware. ";
                mb_set_dev_var($arr['name'],'di2_counter_enabled',1);
            }
        }
        if ($_GLOBALS['c3_enabled']) {
            add_role(-1,'c3_total',0,5,1,0,'0');  
            add_role(-1,'c3_today',0,5,1,0,'0');  
            add_role(-1,'c3_rate',0,5,1,0,'1');  
            $_GLOBALS['c3_raw']=ini_get($prefix."/ini/SavedCounters.ini","config","c3_raw",0);
            $_GLOBALS['c3_raw_today']=ini_get($prefix."/ini/SavedCounters.ini","config","c3_raw_today",0);
            $_GLOBALS['c3_div']=ini_get("/config/SavedCounters.ini","config","c3_div",0);
            $_GLOBALS['c3_total']=$_GLOBALS['c3_raw']/$_GLOBALS['c3_div'];
            $_GLOBALS['c3_today']=$_GLOBALS['c3_raw_today']/$_GLOBALS['c3_div'];
            $_GLOBALS['c3_unit']=ini_get("/config/SavedCounters.ini","config","c3_unit","l");
            $_GLOBALS['c3_interval']=ini_get("/config/SavedCounters.ini","config","c3_interval",0);
            $_GLOBALS['c3_rate']=0; // rate
            $_GLOBALS['c3_last']=0;
            if (!$arr['di3_counter_enabled']) {
                //$err.="Counter 3 is disabled in hardware. ";
                mb_set_dev_var($arr['name'],'di3_counter_enabled',1);
            }
        }
        if ($err) $_GLOBALS['sysmsg']=$err;
        //print($err);
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/SavedCounters.cgi?action=configure';
        $arr['title']='Saved Counters';
        $arr['icon']='icon-hdd';
        $arr['desc']='Lets you set persistent counter values';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/SavedCountersAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/SavedCountersAjax.inc';

        // runs this file once a second
        if (file_exists('/package/SavedCountersSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/SavedCountersSec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/SavedCountersMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/SavedCountersMin.inc';
            
        // runs this file once a day
        if (file_exists('/package/SavedCountersDay.inc')) 
            $_GLOBALS['hooks']['day'][]='/package/SavedCountersDay.inc';            
        return 1;
    }
    
    function SavedCounters_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="SavedCounters"; 
        $title='Configure Package SavedCounters';
        $config_file="SavedCounters.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">SavedCounters</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> SavedCounters Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
Saved counters for calculating various things. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Widget Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<? $config_file='SavedCounters.ini';
		$config_section='config';
		?>
		<div ng-init="c1_enabled=<? print(ini_get("/config/".$config_file,$config_section,"c1_enabled",0)); ?>;">
		<div ng-init="c1_raw='<? print(ini_get($prefix."/ini/".$config_file,$config_section,"c1_raw","0")); ?>';">
		<div ng-init="c1_rawtoday='<? print(ini_get($prefix."/ini/".$config_file,$config_section,"c1_rawtoday","0")); ?>';">
		<div ng-init="c1_div='<? print(ini_get("/config/".$config_file,$config_section,"c1_div","0")); ?>';">
		<div ng-init="c1_interval='<? print(ini_get("/config/".$config_file,$config_section,"c1_interval","0")); ?>';">
		<div ng-init="c1_total='<? print(ini_get("/config/".$config_file,$config_section,"c1_total","0")); ?>';">
		<div ng-init="c1_unit='<? print(ini_get("/config/".$config_file,$config_section,"c1_unit","0")); ?>';">
		<div ng-init="c2_enabled=<? print(ini_get("/config/".$config_file,$config_section,"c2_enabled",0)); ?>;">
		<div ng-init="c2_raw='<? print(ini_get($prefix."/ini/".$config_file,$config_section,"c2_raw","0")); ?>';">
		<div ng-init="c2_rawtoday='<? print(ini_get($prefix."/ini/".$config_file,$config_section,"c2_rawtoday","0")); ?>';">
		<div ng-init="c2_div='<? print(ini_get("/config/".$config_file,$config_section,"c2_div","0")); ?>';">
		<div ng-init="c2_interval='<? print(ini_get("/config/".$config_file,$config_section,"c2_interval","0")); ?>';">
		<div ng-init="c2_total='<? print(ini_get("/config/".$config_file,$config_section,"c2_total","0")); ?>';">
		<div ng-init="c2_unit='<? print(ini_get("/config/".$config_file,$config_section,"c2_unit","0")); ?>';">
		 <fieldset>
		        <div class="control-group">
		            <label class="control-label" for='c1_enabled'>Counter 1 Enabled</label>
		            <div class="controls">
			            <select ng-model="c1_enabled"><option value='0'>Disabled</option>
			            <option value='1'>Enabled</option>
			            </select>
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='c1_raw'>Counter 1 Raw Value</label>
		            <div class="controls">
			            <input type='text' ng-model="c1_raw"  readonly name='c1_raw' title="raw counter value" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='c1_rawtoday'>Counter 1 Raw Today</label>
		            <div class="controls">
			            <input type='text' ng-model="c1_rawtoday"  readonly name='c1_rawtoday' title="raw counter value" data-rel="tooltip"> 
			        </div>
		        </div>
		        <div class="control-group">
		            <label class="control-label" for='c1_total'>Counter 1 Total</label>
		            <div class="controls">
			            <input type='text' ng-model="c1_total"  readonly name='c1_total' title="Total value" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='c1_div'>Counter 1 Divider</label>
		            <div class="controls">
			            <input type='text' ng-model="c1_div"  name='c1_div' title="Number of pulses per division" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='c1_interval'>Counter 1 Interval (in seconds)</label>
		            <div class="controls">
			            <input type='text' ng-model="c1_interval"  name='c1_interval' title="Interval (i.e 3600 = value/hour)" data-rel="tooltip"> 
			        </div>
		        </div>
		        <div class="control-group">
		            <label class="control-label" for='c1_unit'>Counter 1 Unit</label>
		            <div class="controls">
			            <input type='text' ng-model="c1_unit"  name='c1_unit' title="Unit (i.e Hz, l/h, etc)" data-rel="tooltip"> 
			        </div>
		        </div>
		        <div class="control-group">
		            <label class="control-label" for='c2_enabled'>Counter 2 Enabled</label>
		            <div class="controls">
			            <select ng-model="c2_enabled"><option value='0'>Disabled</option>
			            <option value='1'>Enabled</option>
			            </select>
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='c2_raw'>Counter 2 Raw Value</label>
		            <div class="controls">
			            <input type='text' ng-model="c2_raw"  readonly name='c2_raw' title="raw counter value" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='c2_rawtoday'>Counter 2 Raw Today</label>
		            <div class="controls">
			            <input type='text' ng-model="c2_rawtoday"  readonly name='c2_rawtoday' title="raw counter value" data-rel="tooltip"> 
			        </div>
		        </div>
		        <div class="control-group">
		            <label class="control-label" for='c2_total'>Counter 2 Total</label>
		            <div class="controls">
			            <input type='text' ng-model="c2_total"  readonly name='c2_total' title="Total value" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='c2_div'>Counter 2 Divider</label>
		            <div class="controls">
			            <input type='text' ng-model="c2_div"  name='c2_div' title="Number of pulses per division" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='c2_interval'>Counter 2 Interval (in seconds)</label>
		            <div class="controls">
			            <input type='text' ng-model="c2_interval"  name='c2_interval' title="Interval (i.e 3600 = value/hour)" data-rel="tooltip"> 
			        </div>
		        </div>
		        <div class="control-group">
		            <label class="control-label" for='c2_unit'>Counter 2 Unit</label>
		            <div class="controls">
			            <input type='text' ng-model="c2_unit"  name='c2_unit' title="Unit (i.e Hz, l/h, etc)" data-rel="tooltip"> 
			        </div>
		        </div>
		</fieldset>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function SavedCounters($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="c1_enabled="+$scope.c1_enabled;
       post_data+="&c1_unit="+$scope.c1_unit;
       post_data+="&c1_div="+$scope.c1_div;
       post_data+="&c1_interval="+$scope.c1_interval;
		post_data+="&c2_enabled="+$scope.c2_enabled;
       post_data+="&c2_unit="+$scope.c2_unit;
       post_data+="&c2_div="+$scope.c2_div;
       post_data+="&c2_interval="+$scope.c2_interval;
       post_config="SavedCounters.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>







