<?
include("/lib/uphp/expression.inc");
include("/lib/uphp/fileio.inc");

define("PARSE_BUFFER_SIZE",1024);

$_f=0;
$_buf='';
$_pos=0;
$_datalog_headers=array();
$_datalog_headers_size=0;
function get_csv_headers($grp) {
    $ini = ini_get_array("/config/dataexport.ini","export");
    $res=array('ts');
    $data='"ts",';

    $logfile2 = "/logs/log_"+$grp+".ini";
    //$arr=ini_get_array($logfile2);
    
    $grpnvar=ini_get("/config/datalog.ini","data",'group'+$grp+"numvar",0);
    for ($j=0;$j<$grpnvar;$j++) {
        $vt=ini_get("/config/datalog.ini","data",'group'+$grp+'var'+$j+'vartype',0);
        $vfn=ini_get("/config/datalog.ini","data",'group'+$grp+'var'+$j+'varfn',0);
        $vval=ini_get("/config/datalog.ini","data",'group'+$grp+'var'+$j+'varval',0);
        if ($vt==1) {  // system
            $varst=ini_get("/config/sysvars.ini","sysvars","sysvar".$vval."name","");
            $varr=explode($varst,';');
            if ($varr[0]=='V') {
                $varst=$varr[1];
            } else {
                if ($varr[0]=='G') {
                    $varst=$varr[2].$varr[1];
                }
            }
        } else {
            if ($vt==2) {  // device
                $varst=ini_get("/config/roles.ini","roles","role".$vval,"");
            }
            if ($vt==3) {  // global
                //$varst=$vval;
                 $varst=ini_get("/config/datalog.ini","data",'group'+$grp+'var'+$j+'varval','');
            }                
        }
        $res[]=$varst;
    }
    return $res;
}

function get_role_index($role_name) {
    global $_datalog_headers;
    global $_datalog_headers_size;
    $role_index=-1;
    //print("<pre>".$_datalog_headers_size);
    //print_r($_datalog_headers);
    for ($i=0;$i<$_datalog_headers_size;$i++) {
        if ($_datalog_headers[$i]==$role_name) {
            $role_index=$i;
            break;
        }
    }
    return ($role_index);
}

function get_date_from_period($period, $from_date) {
    if (!$from_date) 
        $from_date=time();
    $ts=0;
    $arr=explode($period,' ');
    if (sizeof($arr)==2) {
        $val=intval($arr[0]);
        $type=strtolower($arr[1]);
        if ($type=='day' || $type=='days') {
            $ts=$from_date-$val*86400;
        }
        if ($type=='week' || $type=='weeks') {
            $ts=$from_date-$val*86400*7;
        }
        if ($type=='month' || $type=='months') {
            $d=intval(strftime("%d",$from_date));
            $m=intval(strftime("%m",$from_date))-1;
            $y=intval(strftime("%Y",$from_date));
          //  print("M=".$m."\r\n");
            $m=$m-$val;
           // print("M=".$m."\r\n");
            while ($m<0) {
                $y--;
                $m+=12;
                //print("M=".$m."\r\n");
            }
            $ts=mktime(0,0,0,$m,$d,$y);
        }
        if ($type=='year' || $type=='years') {
            $ts=$from_date-$val*86400*365;
        }
        return $ts;
    }
    else return 0;
}

function get_first_value_from_csv($date,$role_index) {
    $path="/logs/".strftime("%Y/%m/%Y%m%d",$date)."_0.csv";
    //print("\r\n".$path);
    if (file_exists($path)) {
        $f=fopen($path,'r');
        
        while (!$done) {
            $line=fgets_long($f);
            if (!strlen($line)) continue;
   //         print("\r\nGOT LINE: ".$line);
     //       print("\r\n");
            $vals=explode($line,',');
            
            //print("\r\nts: ".intval($vals[0])." >= ".$date);
            
            if (strlen($line)>5 && is_numeric($vals[0])) {
                
                fclose($f);
                
           //     print("ROLE=".$role_index." RESULT IS: ".$vals[intval($role_index)]);
                return floatval($vals[$role_index]);
            }  //else print("Line is ".$line);
            if (feof($f)) {
        //        print("\r\nEOF");
                $done=1;
                fclose($f);
            }
        }
        
    } //else print(" NO FILE");
    //print($path);
    return 0;
}

function get_value_from_csv($date,$role_index) {
    $path="/logs/".strftime("%Y/%m/%Y%m%d",$date)."_0.csv";
    //print("\r\n".$path);
    if (file_exists($path)) {
        $f=fopen($path,'r');
        
        while (!$done) {
            $line=fgets_long($f);
            if (!strlen($line)) continue;
         //   print("\r\nGOT LINE: ".$line);
            //print("\r\n");
            $vals=explode($line,',');
            
            //print("\r\nts: ".intval($vals[0])." >= ".$date);
            
            if (strlen($line)>5 && is_numeric($vals[0]) && (intval($vals[0])>=($date-86400))) {
                
                fclose($f);
                
              //  print("ROLE=".$role_index." RESULT IS: ".$vals[intval($role_index)]);
                return floatval($vals[$role_index]);
            }  //else print("Line is ".$line);
            if (feof($f)) {
        //        print("\r\nEOF");
                $done=1;
                fclose($f);
            }
        }
        
    } //else print(" NO FILE");
    //print($path);
    return 0;
}

function get_last_value_from_csv($date,$role_index) {
    $path="/logs/".strftime("%Y/%m/%Y%m%d",$date)."_0.csv";
  //  print("\r\n".$path);
    if (file_exists($path)) {
        $f=fopen($path,'r');
        
        $len=filesize($f)-2048;
        if ($len<0) $len=filesize($f);
        fseek($f,$len);
        
        while (!$done) {
            $line=fgets_long($f); // skip till line break;
            if (!strlen($line)) continue;
            //print("\r\n:NEAR LAST:");
            //print($line);
            $line=fgets_long($f);
  //          print("\r\n:LAST:");
            //print($line);
            $vals=explode($line,',');
            
            if (strlen($line)>5 && is_numeric($vals[0]) && (intval($vals[0])>=($date-86400))) {
                fclose($f);
                
            //    print("get_last_value_from_csv=".$vals[intval($role_index)]);
                return floatval($vals[intval($role_index)]);
            }  //else print("Line is ".$line);
            if (feof($f)) {
        //        print("\r\nEOF");
                $done=1;
                fclose($f);
            }
        }
        
    } //else print(" NO FILE");
    //print($path);
    return 0;
}

function bcmbvar($params) {
    if (is_numeric($params[0])) {
        $dev=mb_get_dev_by_id(intval($params[0]))
    } else
        $dev=mb_get_dev_by_name($params[0])
    if ($dev) return $dev[$params[1]];
    return 0;
}

function bcdiff($params) {
    //print('Called DIFF');
    //print_r($params);
    
    $role_index=get_role_index($params[0]);
    //print("ROLE INDEX=".$role_index);
    if ($role_index==-1) return 0;
    
    if (sizeof($params)>=3) {
        $offset_date=get_date_from_period($params[2]);
    } else $offset_date=time();
    if (sizeof($params)==4) {
        $max=floatval($params[3]);
    } else $max=0;
    $calculated_date=get_date_from_period($params[1],$offset_date);
    
    /*print("\r\nCalculated date=".$calculated_date);
    print(strftime("%c",$calculated_date));
    print("\r\nOffset date=".$offset_date);
    print(strftime("%c",$offset_date));
    print("\r\n===== OLD_VAL =");*/
    
    $old_value= get_first_value_from_csv($offset_date,$role_index);
    
    //print("\r\n===== NEW_VAL =");
    $cur_value= get_last_value_from_csv($offset_date,$role_index);
    //$cur_value= get_value_from_csv($offset_date,$role_index);
    
    $res=$cur_value-$old_value;
    //print("OLD=".$old_value." and cur=".$cur_value." DIFF=".$res);
    if ($max && $res>$max) $res=0;
    if ($res<0) $res=0;
    return ($res);
}

function bclast($params) {
    //print('Called DIFF');
    //print_r($params);
    $role_index=get_role_index($params[0]);
    //print("ROLE INDEX=".$role_index);
    if ($role_index==-1) return 0;
    
    if (sizeof($params)>=2) {
        $offset_date=get_date_from_period($params[1]);
    } else $offset_date=time();
    if (sizeof($params)==3) {
        $max=floatval($params[2]);
    } else $max=0;
    $res=get_last_value_from_csv($offset_date,$role_index);
    //print("\r\nLAST VALUE=".$res);
    //$res=0;
    if ($max && $res>$max) $res=0;
    return ($res);
}

function bcfirst($params) {
    //print('Called DIFF');
    //print_r($params);
    $role_index=get_role_index($params[0]);
    //print("ROLE INDEX=".$role_index);
    if ($role_index==-1) return 0;
    
    if (sizeof($params)>=2) {
        $offset_date=get_date_from_period($params[1]);
    } else $offset_date=time();
    if (sizeof($params)==3) {
        $max=floatval($params[2]);
    } else $max=0;
    $res=get_value_from_csv($offset_date,$role_index);
    //$res=0;
    if ($max && $res>$max) $res=0;
    return ($res);
}

function bcdate($params) {
    $format=$params[0];
    if (sizeof($params)==2) {
        $offset_date=get_date_from_period($params[1]);
    } else $offset_date=time();
    
    return strftime($format,$offset_date);
}

function fill_buffer() {
    global $_f;
    global $_pos;
    global $_buf;
    if (!$_f) {
        return 0;
    }
    if (feof($_f)) return 0;
    $_buf.=fread($_f,PARSE_BUFFER_SIZE);
    $_pos = ftell($_f);
    return 1;
}

function parse_start($template_file) {
    global $_f;
    global $_datalog_headers;
    global $_datalog_headers_size;
    $_f=fopen($template_file,'r');
    
    if ($_f) {
        $_datalog_headers=get_csv_headers(0);
        $_datalog_headers_size=sizeof($_datalog_headers);
        //print_r($_datalog_headers);
        return 1;
    }
    return 0;
}

function parse_end() {
    global $_f;
    if ($_f) fclose($_f);
    $_f=0;
}


function parse_file($fn,$fn_output) {
    global $_buf;
    $output="";
    $ts=microtime();
    
    $f_output=0;
    if (parse_start($fn)) {
        if ($fn_output) {
            $f_output=fopen($fn_output,"w");
        }
        $done=!fill_buffer();
        while (!$done) {
            $key_start_pos=strpos($_buf,'{{');
            while ($key_start_pos==-1) {
                if (fill_buffer()) {
                    $key_start_pos=strpos($_buf,'{{');
                } else {
                    $done=1;
                    break;
                }
            }
            if ($key_start_pos==-1) {   // no more keys to parse
                $output.=$_buf;
            } else {
                $output.=substr($_buf,0,$key_start_pos);
                $_buf=substr($_buf,$key_start_pos+2);
                $key_end_pos=strpos($_buf,'}}');
                while ($key_end_pos<0) {
                    if (!fill_buffer()) {
                        break;
                    }
                    $key_end_pos=strpos($_buf,'}}');
                }
                if (!$key_end_pos) {  // mismatch - no end key
                    $output="closing }} not found in template";
                    $done=1;
                } else {
                    $tag=substr($_buf,0,$key_end_pos);
                    if (trim($tag)!='') {
                      //  print("Found tag: ".$tag." - ts=".(microtime()-$ts)."\r\n");
                        $result=execute_function($tag);
                  //      print("End tag: ".$tag." - ts=".(microtime()-$ts)."\r\n");
                        $output.= $result;
                        $_buf=substr($_buf,$key_end_pos+2);
                    }
                }
            }
            if ($f_output) {
                fwrite($f_output,$output);
                $output='';
            }
        }
        if ($f_output) {
                fwrite($f_output,$output);
                $output='';
        }
        
        parse_end();
    } else {
        log("Unable to open file ".$fn);
    }
    return $output;
}

function execute_function($fn) {
    $dev=array();
    return parseExpression($fn,$dev);
    //return "[executed ".$fn."]";
}
?>



