<?
/**
 * @file string.inc
 * @author Akash Heimlich
 * @version 1.0
 * @date 24/06/2019
 * @description Expression Parser
 */
//max_execution_time(5); 
$tokens=array();
$variables=array();
$func_depth=0; 

function bcglobal ($params) {
    global $func_dev;
    //print("role ");
    //print_r($params);
    //print($_GLOBALS[$params[0]]);
    return ($_GLOBALS[$params[0]]);
}

function bcdevrole ($params) {
    global $func_dev;
    //print("role ");
    print_r($params);
    //print($_GLOBALS[$params[0]]);
    $dev=mb_get_dev_by_name($params[0]);
    return ($dev['roleval'.$params[1]]);
}

function bcdevvar ($params) {
    global $func_dev;
    //print("role ");
   // print_r($params);
    //print($_GLOBALS[$params[0]]);
    $dev=mb_get_dev_by_name($params[0]);
    return ($dev[$params[1]]);
}

function bcrolename ($params) {
    global $roles;
    //print("role ");
    //print_r($params);
    //print(params[0])
    return (array_key($roles,intval($params[0])));
}
function bcrolebyname ($params) {
    global $roles;
    //print("role ");
    //print_r($params);
    return ($roles[$params[0]]);
}

function bcall_roles ($params) {
    global $roles;
    //print("role ");
    //print_r($params);
    $data='';
    $role_keys=array_keys($roles);
    for ($i=1;$i<sizeof($roles);$i++) {
        if ($i>1) $data.=',';
        if ($params[0]=='n:v') {
            $data.='"'.$role_keys[$i].'":'.$roles[$role_keys[$i]];
        } else if ($params[0]=='v') {
            $data.=$roles[$role_keys[$i]];
        }
    }
    return $data;
}

function bcall_roles_with($params) {
    global $roles;
    //print("role ");
    //print_r($params);
    $data='';
    $role_keys=array_keys($roles);
    
    for ($i=1;$i<sizeof($roles);$i++) {
        
        if (strpos($role_keys[$i],$params[0])>=0) {
            if ($data!='') $data.=',';
            if ($params[1]=='n:v') {
                $data.='"'.$role_keys[$i].'":'.$roles[$role_keys[$i]];
            } else if ($params[1]=='v') {
                $data.=$roles[$role_keys[$i]];
            }
        }
    }
    return $data;
}


function bcrolebyindex ($params) {
    global $roles;
    //print("role ");
    //print_r($params);
    return ($roles[array_key($roles,intval($params[0]))]);
}

function bcrole ($params) {
    global $func_dev;
    //print("role ");
    //print_r($params);
    return ($func_dev['roleval'.intval($params[0])]);
}

function bcregister($params) {
    global $func_dev;
    //print_r($params);
    return ($func_dev[$params[0]]);
}

/**
 * Add two arbitrary precision numbers
 * @link http://www.php.net/manual/en/function.bcadd.php
 * @param string $left_operand <p>
 * The left operand, as a string.
 * </p>
 * @param string $right_operand <p>
 * The right operand, as a string.
 * </p>
 * @param int $scale [optional] 
 * @return string The sum of the two operands, as a string.
 */
function bcadd ($left_operand, $right_operand, $scale) {
    return strval(floatval($left_operand)+floatval($right_operand));
}

/**
 * Subtract one arbitrary precision number from another
 * @link http://www.php.net/manual/en/function.bcsub.php
 * @param string $left_operand <p>
 * The left operand, as a string.
 * </p>
 * @param string $right_operand <p>
 * The right operand, as a string.
 * </p>
 * @param int $scale [optional] 
 * @return string The result of the subtraction, as a string.
 */
function bcsub ($left_operand, $right_operand, $scale) {
    return floatval($left_operand)-floatval($right_operand);
}

/**
 * Multiply two arbitrary precision numbers
 * @link http://www.php.net/manual/en/function.bcmul.php
 * @param string $left_operand <p>
 * The left operand, as a string.
 * </p>
 * @param string $right_operand <p>
 * The right operand, as a string.
 * </p>
 * @param int $scale [optional] 
 * @return string the result as a string.
 */
function bcmul ($left_operand, $right_operand, $scale) {
    return floatval($left_operand)*floatval($right_operand);
}

/**
 * Divide two arbitrary precision numbers
 * @link http://www.php.net/manual/en/function.bcdiv.php
 * @param string $left_operand <p>
 * The left operand, as a string.
 * </p>
 * @param string $right_operand <p>
 * The right operand, as a string.
 * </p>
 * @param int $scale [optional] 
 * @return string the result of the division as a string, or &null; if 
 * right_operand is 0.
 */
function bcdiv ($left_operand, $right_operand, $scale) {
    return floatval($left_operand)/floatval($right_operand);
}

 
 /**
  * Tokenize the expression.
     * @internal
     */
function get_number($str) {
    $res='';
    $idx=0;
    while ($idx<strlen($str)) {
        $c=charat($str,$idx);
        if ((($c>=48) && ($c<=57)) || ($c==46)) {
            $res.=chr($c);
            $idx++;
        } else return $res;
    }
    return $res;
}

function get_ident($str) {
    $res='';
    $idx=0;
    while ($idx<strlen($str)) {
        $c=charat($str,$idx);
        // A-Z a-z 0-9 _
        if ((($c>=48) && ($c<=57)) || (($c>=65) && ($c<=89)) || (($c>=97) && ($c<=122)) || ($c==95)) {
            $res.=chr($c);
            $idx++;
        } else return $res;
    }
    return $res;
}


function get_var($str) {
    $res='';
    $idx=0;
    $quote=0;
    if (charat($str,0)==34) {  // single quote
        $quote=charat($str,0);
    } else if (charat($str,0)==39) { // double quote
        $quote=charat($str,0);
    }
    if (!$quote) 
        return $res;
    $res=substr($str,0,1);    
    $idx=1; // skip first character
    while ($idx<strlen($str)) {
        
        $c=charat($str,$idx);
        $res.=chr($c);
        $idx++;
        if ($c==$quote) {
            return $res;
        }
        
    }
    return "";
}


function tokenize($expression) {
        global $tokens;
        $expr = $expression;
        $i = 0;
        $c = " ";
        //while there are more string to be tokenized
        while ($c) {
            //exit if there are no more string.
            if ($i >= strlen($expr)) {
               // print_r($tokens);
                return;
            }
            //the code to be scanned
            $c = substr($expr, $i);
            //print("c=".$c."\r\n");
            $tok=get_number($c);
            if (strlen($tok)) { 
                //numbers
                $i += strlen($tok);
                $tokens[]=array('NUMBER', $tok);
            } else {
                $tok=get_ident($c);
                if (strlen($tok)) {
                //variables
                    $i += strlen($tok);
                   // print("add var ".$tok);
                    $tokens[]=array('IDENT', $tok);
                }  else {
                    $tok=get_var($c);
                    if (strlen($tok)) {
                        //variables
                        $var=(substr($tok,1,strlen($tok)-2));
                       // print("VAR=".$var."\r\n");
                        $i += strlen($tok);
                        $tokens[]=array('IDENT', $var);
                    } else {
                        if (($c == 32) || ($c == 8) || ($c == 10) || ($c == 13)) {
                //whitespaces
                            $i ++;
                        } else {
                //operators
                            $tokens[]=array(chr(charat($expr,$i)), chr(charat($expr,$i)));
                            $i ++;
                        }
                        
                    }
                }
            }
        
    }
    
}
/**
 * Determines if the next token exists.
 * This function takes multiple arguments.
 * @internal
 */
function has($type) {
    global $tokens;
    if (sizeof($tokens)==0) return 0;
    $t = $tokens[0];
    //print("has(".$type.")");
    //print_r($t);
    if (strval($t[0]) == $type) {
        //print($t[0]." : ".$type." ==1\r\n");
        return 1;
    }
    return 0;
}

/**
 * Consume the next token.
*/
function token() {
    global $tokens;
    $res=$tokens[0];
    $tokens2=array();
    //print_r($tokens);
    for ($i=1;$i<sizeof($tokens);$i++) {
        $tokens2[]=$tokens[$i];
    }
    //$tokens[sizeof($tokens)-1]='';
    $tokens=$tokens2;
    //print("token()=====\r\n");
    //print_r($tokens);
    return $res;
}

/**
* Calls a function.
* @internal
*/
function call_user($name, $values) {
	/*for ($i=0;$i<sizeof($values);$i++) {
		if (is_string($values[$i])) {
			$values[$i]='"'.$values[$i].'"';
		}
	}*/
    	//print('return ' . $this->prefix . $name . '(' . implode(',', $values) . ');');
    if (function_exists('bc'.strtolower($name))) 
    
    	return call_user_func('bc'.strtolower($name),$values);
    else {
    	if ($_GET['debug']) {
    		print("Function does not exist - bc".strtolower($name));
    	}
    	return 0;
    }
}

function primary() {
    global $variables;
    global $tokens;
    global $func_depth;
    $func_depth++;

		//print_r($this->tokens);
        if (has('NUMBER')) {
            //numbers
            $t = token();
            $func_depth--;
            return $t[1];
        } else if (has('-')) {
            //negative numbers
            token();
            $res=primary();
            $func_depth--;
            return -$res;
        } else if (has('(')) {
            //brackets
            token();
            $v = expression();
            token();
            $func_depth--;
            return $v;
        } else if (has('IDENT') && $tokens[1][0] == '(') {
            //function call

            $name = token();
            $name = $name[1];
            token();
            $args = array();

            if (has(')')) {
                //zero arguments
				

                $res= call_user($name);
                $func_depth--;
                return $res;
            } else {
            	
                //one or more arguments
                $args=array();
      //          print_r($tokens);
                //print("====\r\n");
                $args[]= expression();
              //  print_r($tokens);
                //print("====\r\n");
                while (has(',')) {
                    token();
                    $args[] = expression();
                //print_r($tokens);
                //print("====\r\n");
                    
                }
				//print($name);print_r($args);				
                $v = call_user($name, $args);
                token();
                $func_depth--;
                return $v;
            }
        } else if (has('IDENT')) {
            //get variable
            $t = token();
            //print_r($t);
            if ($_GET['debug']) {
                print_r($variables);
			 print($t[1]." Token=".$variables[$t[1]]."\r\n");
            }
			//print_r($t);
//throw new RuntimeException('Syntax error.');
            $func_depth--;
            return isset($variables[$t[1]])?$variables[$t[1]]:$t[1];// or '0';
        } else {
            $func_depth--;
            return ('Syntax error.');   //throw new RuntimeException
        }
    }
function evaluate($expr) {
    tokenize($expr);
    return expression();
}    

function term() {
    global $variables;
    global $tokens;
    global $func_depth;
    $func_depth++;
        $v = primary();
        
		//print("term v=\r\n");
	//	print_r($v);
        while (has('*') || has('/')) {
            $op = token();
            $right = primary();
            if ($op[0]=='*') {
                    $v = bcmul($v, $right,2);
            } else if ($op[0]=='/') {
                    $v = bcdiv($v, $right,2);
            } else {
                    print('Invalid operator, expection "*" or "/".');
                    die();
            }
        }
        $func_depth--;
        return $v;
}

function addexpr() {
    global $variables;
    global $tokens;
    global $func_depth;
    $func_depth++;

        $v = term();
       // print("\r\nterm=".$v);
        while (has('+') || has('-') || has('<') || has('>') || has('==')) {
            
            $op = token();
            $right = term();
            if ($op[0]=='+') {
                $v = bcadd($v, $right,2);
            } else if ($op[0]=='-') {
                $v = bcsub($v, $right,2);
            } else if ($op[0]=='<') {
                if (floatval($v)<floatval($right)) return 1;
                return 0;
            }  else if ($op[0]=='>') {
                if (floatval($v)>floatval($right)) return 1;
                return 0;
            
            } else if ($op[0]=='==') {
                if (floatval($v)==floatval($right)) return 1;
                return 0;
            }
            
            else {
                    print('Invalid operator, expection "+" or "-"');
                    die();
            }
        }
        $func_depth--;
//        print("returning ".$v."\r\n");
        return $v;
}

function expression() {
    global $variables;
    global $tokens;
    global $func_depth;
    $func_depth++;

        if (has('IDENT') && ($tokens[1][0] == '=')) {
            $left = token();
            $left = $left[1];
		//	print("left=".$left);
            token();
            $right = expression();
		//	print("right=".$right);
            $variables[$left] = $right;
//            print_r($variables);
            $func_depth--;
           // print_r($tokens);
            if (($tokens[0][0] == ';')) {
                $left = token();
                return expression();
            } else
                return ""; //$right
        } else {
            
            $res= addexpr();
            $func_depth--;
            return $res;
        }
}



function parseExpression($str,$dev) {
    global $variables;
    global $tokens; 
    global $func_depth;
    global $func_dev;

    $func_dev=&$dev;
    $func_depth++;
    //print("parseExpression depth="+$func_depth);
    $tokens=array();
    
    //$variables=array();
	$expstr=$str;
	tokenize($expstr);
	if ($_GET['tokens'])
	    print_r($tokens);
    $res=expression();
    $func_depth--;
    return $res;
	//return evaluate($expstr);
}


?>






