var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.factory('dataService', function($http) {
  
  this.async = function(roles) {
    return $http.get('/app/dev_ajax.cgi?action=list&roles='+roles)
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
        //alert('Failed: ' + reason);
        //$timeout(poll, 100);  // try again
    });
    
  };
  
  return this;
});


function DeviceCtrl(dataService,$scope, $timeout,$http) {
  var self = this;
  var pc=100;
  $scope.scanning=0;
  $scope.refresh=0;
  $scope.roles=0;
$scope.helpvisible=0;
$scope.items=[];

$scope.loading=1;
$scope.asyncData = dataService.async();
   $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";

  function poll(){
      if (!$scope.loading) {
        $scope.loading=1;
        $scope.asyncData = dataService.async($scope.roles);
      }
    }
  
  $scope.poll=poll;  
  
  $scope.edit=function(idx) {
    document.location="/app/deviceedit.cgi?device_idx="+idx;
  }
  $scope.del=function(idx) {
   // alert('del '+item.id);
  //  alert('in del');
    $scope.selectedIdx=idx;
    $scope.action=1;
    $scope.question="Deleting a device will disable and remove it, along with all associated configuration values.  You can always scan and reconfigure the device at a later time. Are you sure you want to delete this device?";
    $('#myModal').modal('show');
  }
  $scope.calib=function(idx) {
   // alert('del '+item.id);
  //  alert('in del');
    $scope.selectedIdx=idx;
    $scope.action=2;
    $scope.question="Are you sure you want to calibrate this device? If you change calibration constants without understanding their meaning your device may become unusable.";
    $('#myModal').modal({
keyboard: true
});
  }
  $scope.hideModal=function() {
    $('#myModal').modal('hide');
  }  
  
  $scope.doModal=function() {
      if ($scope.action==1) {
          $scope.delDevice();
      } else {
        document.location="/app/devicecalib.cgi?device_idx="+$scope.selectedIdx;
      }
  }
  $scope.delDevice=function() {
    $('#myModal').modal('hide');
    $scope.errormsg="";
    $scope.successmsg="";
      
     $http.get('/app/dev_ajax.cgi?action=delete&device_idx='+$scope.selectedIdx) 
    .then(function (response) {
        if (response.data.status==0) {
            $scope.errormsg="There was an error deleting the device.";
        } else {
            $scope.successmsg="Device deleted successfully";
        }
        
      poll();
      return response;
    }, function(reason) {
        $scope.errormsg="Error while updating";
    });
  }
  $scope.isActive=function(item) {
      if (item.status && item.last_response<2) return 1;
      return 0;
  }
  $scope.isDisabled=function(item) {
      if (item.status==0) return 1;
      return 0;
  }
  $scope.isError=function(item) {
      if (item.status!=0 && item.last_response>=2) return 1;
      return 0;
  }
  $scope.lastAccess=function(item) {
      if (item.last_response<5+$scope.poll_time)
        return "Active";
      if (item.last_response>10000)
        return "Error";
      return "Last access "+item.last_response+"s ago";
  }
  $scope.enable=function(item) {
      $scope.errormsg="";
      $scope.successmsg="";
      
     $http.get('/app/dev_ajax.cgi?action=update&name='+item.name+"&param="+item.param+"&status=1") 
    .then(function (response) {
        if (response.status==0) {
            $scope.errormsg="There was an error enabling device " + item.name;
        } else $scope.successmsg="Device "+item.name+ " is now enabled";
        
      poll();
      return response;
    }, function(reason) {
        $scope.errormsg="Error while updating";
    });
  }
  $scope.disable=function(item) {
      $scope.errormsg="";
      $scope.successmsg="";
   $http.get('/app/dev_ajax.cgi?action=update&name='+item.name+"&status=0") 
    .then(function (response) {
        if (response.status==0) {
            $scope.errormsg="There was an error disabling device "+item.name;
        } else $scope.successmsg="Device "+item.name+" is now disabled";
      poll();
      return response;
    }, function(reason) {
        $scope.errormsg="Error while updating";
    });
    }  
  $scope.quickScan=function(bus) {
     $scope.infomsg="Performing a quick scan of the device bus.";
     
     $http.get('/app/dev_ajax.cgi?action=scan&max=10'+"&bus="+bus) 
    .then(function (response) {
      $scope.scanning = 1;
      $scope.scanpercent=0;
      return response;
    }, function(reason) {
        $scope.errormsg="Error while starting scan";
    }); 
  }
  $scope.fullScan=function() {
     $scope.infomsg="Performing a full scan of the device bus, this may take a while.";
     $http.get('/app/dev_ajax.cgi?action=scan')
    .then(function (response) {            
     $scope.scanning = 1;
     $scope.scanpercent=0;
        
      return response;
    }, function(reason) {
        $scope.errormsg="Error while starting scan";
    }); 
  }
  $scope.$watch('refresh', function(ref) {
      if (ref) poll();
  });
  $scope.$watch('roles', function(ref) {
    poll();
  });
  
  $scope.$watch('scanning', function(ref) {
      if (ref) poll();
  });
  $scope.$watch('asyncData', function(asyncData) {
    if(angular.isDefined(asyncData)) {
        $scope.loading=0;
        $scope.connectstatus=asyncData.loggedin?"loggedin":"loggedout";
        $scope.devices = asyncData.devices;
        $scope.scanpercent = asyncData.scanpercent;
        $scope.scanning = asyncData.scanning;
        $scope.device_limit=asyncData.device_limit;
        $scope.poll_time=Number(asyncData.poll_time)/1000;
        $scope.poll_time2=Number(asyncData.poll_time2)/1000;
        pc=0;
        if ($scope.scanning || $scope.refresh)
            $timeout(poll, 2000);
    }
  });
  

}








