<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : pacman.cgi
 * 
 *  Description: Package manager page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *                      25/04/16    scan option for packages
 * Akash Heimlich       20/06/18    WattmonOS 3 and split to osman
 ********************************************************************/
include("/app/config.inc");
$bodyid='rootscope';
$angular_controller="FirmwareCtrl"; 
$title='Package Manager';
include("/app/header.inc");
?>
<style>
    /* GLOBAL STYLES
    -------------------------------------------------- */
table {
    font: 90%/140% Verdana,Arial,Helvetica,sans-serif;
}
    
.enabled0 td{
    background-color:#CCC!important;
    color:#333;
}
.enabled1 td{
    background-color:#fff!important;
    color:#000;
}
</style>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','pacman')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-suitcase"></i> <? print(lang('UPDATE_TITLE','pacman')) ?></h4>
<ul class="nav justify-content-end">
<div ng-cloak ng-show='loading==1'><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i></div>
  <li class="nav-item">
    <a class="btn btn-primary" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li ng-hide='settings_locked' class="nav-item">
    <a class="btn btn-primary" ng-click='scan()' href='#'>
    <? print(lang('RESCAN','pacman')) ?>
  </a>
  </li>
  

  
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','pacman')) ?><br>
    <? print(lang('HELP2','pacman')) ?><br>
    <? print(lang('HELP3','pacman')) ?><br>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-success" ng-cloak ng-show="infomsg"> <button type="button" class="close" ng-click='infomsg=""'>&times;</button>{{infomsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="scanning"> Scanning: <div class="progress"><div class="progress-bar" style="width: {{scanpercent}}%;"></div></div></div>
<? if ($_GET['action']=='untar') { print("<div ng-init='infomsg=\"Untarring the file, please wait...\";'></div><div ng-init='loading=1;'></div><div ng-init='msg=\"Untarring package "+$_GET['filename']+"\";'></div>"); } 
if ($_GET['action']=='completed') { print("<div ng-init='infomsg=\"The package has been successfully installed.  You may need to reboot for changes to take effect.\";'></div>"); 
    if ($_GLOBALS['md5_sync']) {
        print("You will need to resync the file system once all your packages have been updated.  <a href='/app/pacman.cgi?action=resync'>Resync File System Now</a>");
    }
} 
if ($_GET['action']=='resync') {
    include("/scripts/md5_resync.cgi");
}
if ($_GET['action']=='md5_check') {
    include("/scripts/md5_check.cgi");
}
?>
<div ng-cloak ng-show='loading==1'><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i> {{msg}} <progress min="0" max="100" value="0">0% complete</progress></div>

<!-- VARIABLES -->

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('AVAILABLE_LIST','osman')) ?></h5>
<? if ($_GET['action']=='untar') {
    max_execution_time(500);
    chdir("/");
    print("<h3>Uncompressing package, please wait...</h3><pre>");
    untar('/package.tar',1);
    print("</pre>");
    $_GLOBALS['sysmsg']='Reboot required for changes to take effect.';
    print("<script>document.location='/app/pacman.cgi?action=completed';</script>");
}
?>        
        
        <p class="card-text">   					
            <div class="table-responsive">					
                <table class='table table-striped' summary="Device List">
                    <tr>
                        <th scope="col"></th>
                        <th scope="col">ID</th></th>
                        <th scope="col"><? print(lang('NAME','pacman')) ?></th>
                        <th scope="col"><? print(lang('AUTHOR','pacman')) ?></th>
                        <th scope="col"><? print(lang('VERSION','pacman')) ?></th>
                        <th scope="col"><? print(lang('STATUS','pacman')) ?></th>
                        <th scope="col"><? print(lang('OPTIONS','pacman')) ?></th>
                    </tr>

					<?
include("/app/package.inc");

if ($_GET['scan']==1) {
    $res=scanPackages();
}
//print("Scanpackage returned ".$res);
$packages=getPackageList();
//print_r($packages);
$keys=array_keys($packages);
$num_packages=sizeof($packages);
for ($i=0;$i<$num_packages;$i++) {
    ?>
    <tr class="enabled<? if ($packages[$keys[$i]]==0) print("0");else print("1"); ?>">
<td ><span class="badge badge-pill badge-dark"><? print($i+1); ?></span></td><td><strong><? print($keys[$i]); ?></strong></td>
<td><? print(ini_get("/package/".$keys[$i].".ini","package","description","")); 
$install_date=ini_get("/package/".$keys[$i].".ini","package","install_date","");
$install_method=ini_get("/package/".$keys[$i].".ini","package","install_method","Installed manually");
if ($install_date) {
    print("<br><i>".$install_method." on ".$install_date."</i>");
} else if ($install_method) {
    print("<br><i>".$install_method."</i>");
}
?></td>
<td><? print(ini_get("/package/".$keys[$i].".ini","package","author","")); ?></td>
<td><? print(ini_get("/package/".$keys[$i].".ini","package","version","")); ?></td>
<td>
<? if ($packages[$keys[$i]]==0) { 
    print("Uninstalled");
} else {
    if ($packages[$keys[$i]]==1) { 
        print("Installed");
    } else {
        if ($packages[$keys[$i]]==3) {
            print("Disabled");
        } else {
            print("Enabled");
        }
    }
}
?></td>
<td>
    <div class="dropdown">
        <button ng-hide='settings_locked' class="btn btn-secondary dropdown-toggle btn-outline" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                Action <span class="caret"></span>
        </button>
    
        <div class="dropdown-menu dropdown-menu-right text-dark" >
        <? if ($packages[$keys[$i]]==0) { ?>
            <a class="dropdown-item" href='/package/<? print($keys[$i]); ?>.cgi?action=install'><i class="icon-pencil"></i>&nbsp;Install</a>
        <? } else { ?>
        
            <a class="dropdown-item" href='/package/<? print($keys[$i]); ?>.cgi?action=disable'><i class="icon-check-empty"></i>&nbsp;Disable</a>
            <a class="dropdown-item" href='/package/<? print($keys[$i]); ?>.cgi?action=enable'><i class="icon-check"></i>&nbsp;Enable</a>
            <a class="dropdown-item" href='/package/<? print($keys[$i]); ?>.cgi?action=configure'><i class="icon-pencil"></i>&nbsp;Configure</a>
            <a class="dropdown-item" href='/package/<? print($keys[$i]); ?>.cgi?action=uninstall'><i class="icon-remove"></i>&nbsp;Uninstall</a>
        <? } ?>
        </div>
    </div>
    </td>
</tr>
<? } ?>
</table>					
</p>
</div>
</div>





<br>
<script>
  var thePath="<? print($_GET['dir']); ?>";
  
  
  
</script>
</div>        

          </div><!--/span-->
      </div><!--/row-->
    
   
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Warning</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>{{question}}</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" ng-click="doModal()">Continue</button>
      </div>
    </div>
  </div>
</div>
    
  <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function FirmwareCtrl($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
       $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
   
   $scope.setLoading=function(val) {
    $scope.loading=val;
   }
$scope.files=[];
$scope.pkgName="<? print($_GLOBALS['PKG_NAME']); ?>";
$scope.pkgVersion="<? print($_GLOBALS['PKG_VERSION']); ?>";

 $scope.hideModal=function() {
    $('#myModal').modal('hide');
  }  
  $scope.scan=function() {
    document.location="/app/pacman.cgi?scan=1";
  }
  $scope.doModal=function() {
      if ($scope.action==1) {
        $('#myModal').modal('hide');
          $scope.startUpdate($scope.filename);
      } 
  }
  
    $scope.confirmInstall=function(item) {
        $scope.filename=item.filename;
        $scope.action=1;
        //alert(item.version+" "+item.title);
        if ($scope.pkgName==item.title) {
            if ($scope.pkgVersion<item.version) {
                $scope.question="You have chosen to install an older version of the current package.  Are you sure you want to install this package? ";
            } else if ($scope.pkgVersion==item.version) {
                $scope.question="Your already installed this version of the package.  Are you sure you want to install this package? ";
            } else {
                $scope.question="You are about to upgrade "+$scope.pkgName+" from version "+$scope.pkgVersion+" to version "+item.version+".  Are you sure you want to continue? ";
            }
        } else {
            $scope.question="Certain packages could overwrite your current settings, please read the description carefully.  Are you sure you want to install this package? ";
        }
        $('#myModal').modal('show');
    }
  function poll(){
  
   var x = new XMLHttpRequest();
        x.open('GET', 'http://www.wattmon.com/live/updater.php?action=list&cat=<? print ($cat); ?>', true);
        x.onload=function() {
            var jsonlist = eval("(" + x.response + ")");
            //alert(jsonlist.files.length);
            $scope.$apply(function() {
                $scope.files=jsonlist.files;
            });
        }
        x.send();
      //$scope.asyncData = dataService.async();
     
    };
   poll();
   $scope.startUpdate=function(aFile) {
    $scope.msg="Downloading package file...";
        var x = new XMLHttpRequest();
                $scope.setLoading(1);
      var progressBar = document.querySelector('progress');
      x.open('GET', 'http://www.wattmon.com/live/updater.php?action=download&filename='+aFile, true);
      x.responseType = "blob";
      x.onprogress = function(e) {
                if (e.lengthComputable) {
                    progressBar.value = (e.loaded / e.total) * 100;
                    progressBar.textContent = progressBar.value; // Fallback for unsupported browsers.
                }
            };
      x.onload=function() {
            $scope.$apply(function() {
                $scope.msg="Uploading package file...";
            });
            var xmlhttp;
            if (window.XMLHttpRequest)  {// code for IE7+, Firefox, Chrome, Opera, Safari
    		    xmlhttp=new XMLHttpRequest();
    		}
    		else {// code for IE6, IE5
    		    xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
    		}
    		xmlhttp.onreadystatechange=function() {
    		    if (xmlhttp.readyState==4 && xmlhttp.status==201) {
    	    	    document.location="/app/pacman.cgi?action=untar";
    		    }
    		}
    		xmlhttp.open("PUT","/package.tar",true);
            var progressBar = document.querySelector('progress');
            xmlhttp.upload.onprogress = function(e) {
                if (e.lengthComputable) {
                    progressBar.value = (e.loaded / e.total) * 100;
                    progressBar.textContent = progressBar.value; // Fallback for unsupported browsers.
                }
            };
		    xmlhttp.setRequestHeader("Content-Length",x.response.length);
	  	    xmlhttp.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
		    xmlhttp.send(x.response);
      }
      x.send();
      $gscope=0;
   }
 }
</script>
<? include("/app/footer.inc");
 ?>






