<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : network.cgi
 * 
 *  Description: Network settings page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *                      27/05/15    v1.1 added tcp-server-enabled part
 * Ruchir Sharma        17/10/17    v1.2
 * Akash Heimlich       19/06/18    v2.0 WattmonOS3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="NetworkCtrl"; 
$title='Network Settings';
include("/app/header.inc");
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','network')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-group"></i> <? print(lang('PAGE_TITLE','network')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','network')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked' ng-click="restoreDefaults()" ><i class="icon-cog"></i> <? print(lang('DEFAULTS','network')) ?></a>
  </li>
  
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked' ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','network')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  <? print(lang('HELP1','network')) ?><br>
  <? print(lang('HELP2','network')) ?><br>
  <? print(lang('HELP3','network')) ?><br>
  <? print(lang('HELP4','network')) ?><br>
  <? print(lang('HELP5','network')) ?><br>
  <? print(lang('HELP6','network')) ?><br>
  <? print(lang('HELP7','network')) ?><br>
  
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

<!--VARIABLES-->

<? 
if (nvram_get("use_nvram")!=1) {
  $ip=ini_get("/config/network.ini","network","ip","0.0.0.0");
  $iparr=explode($ip,".");
  $netmask=ini_get("/config/network.ini","network","netmask","0.0.0.0");
  $nmarr=explode($netmask,".");
  $gw=ini_get("/config/network.ini","network","gateway","0.0.0.0");
  $gwarr=explode($gw,".");
  $dns=ini_get("/config/network.ini","network","dns","0.0.0.0");
  $dnsarr=explode($dns,".");
  $dhcp_enabled=ini_get("/config/network.ini","network","dhcp_enabled",1);
  $tcp_server_enabled=ini_get("/config/network.ini","network","tcp_server_enabled",0);
  $tcp_server_port=ini_get("/config/network.ini","network","tcp_server_port",7000);
  $tcp_server=ini_get("/config/network.ini","network","tcp_server","remote.wattmon.com");
} else {
  $ip=nvram_get("net_ip","0.0.0.0");
  $iparr=explode($ip,".");
  $netmask=nvram_get("net_netmask","0.0.0.0");
  $nmarr=explode($netmask,".");
  $gw=nvram_get("net_gateway","0.0.0.0");
  $gwarr=explode($gw,".");
  $dns=nvram_get("net_dns1","0.0.0.0");
  $dnsarr=explode($dns,".");
  $dhcp_enabled=nvram_get("net_dhcp",1);
  
  
}

    $arr=getethstat();
    $dhcp_ip=$arr['ip_address'];
    $dhcp_gw=$arr['gateway'];


?>
<div ng-init="dhcp_enabled=<? print($dhcp_enabled); ?>;"></div>
<div ng-init="tcp_server_enabled=<? print($tcp_server_enabled); ?>;"></div>
<div ng-init="tcp_server_port=<? print($tcp_server_port); ?>;"></div>
<div ng-init="tcp_server='<? print($tcp_server); ?>';"></div>
<div ng-init="ip1=<? print($iparr[0]); ?>;"></div><div ng-init="ip2=<? print($iparr[1]); ?>;"></div><div ng-init="ip3=<? print($iparr[2]); ?>;"></div><div ng-init="ip4=<? print($iparr[3]); ?>;"></div>
<div ng-init="nm1=<? print($nmarr[0]); ?>;"></div><div ng-init="nm2=<? print($nmarr[1]); ?>;"></div><div ng-init="nm3=<? print($nmarr[2]); ?>;"></div><div ng-init="nm4=<? print($nmarr[3]); ?>;"></div>
<div ng-init="gw1=<? print($gwarr[0]); ?>;"></div><div ng-init="gw2=<? print($gwarr[1]); ?>;"></div><div ng-init="gw3=<? print($gwarr[2]); ?>;"></div><div ng-init="gw4=<? print($gwarr[3]); ?>;"></div>
<div ng-init="dns1=<? print($dnsarr[0]); ?>;"></div><div ng-init="dns2=<? print($dnsarr[1]); ?>;"></div><div ng-init="dns3=<? print($dnsarr[2]); ?>;"></div><div ng-init="dns4=<? print($dnsarr[3]); ?>;"></div>

<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('NETWORK_SETTINGS','network')) ?></h5>
        <p class="card-text">    
            <div class="form-group">
                <label for="dhcp_enabled"><small class='text-muted'><? print(lang('USE_DHCP','network')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="dhcp_enabled" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('STATIC','network')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="dhcp_enabled" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('DYNAMIC','network')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('DHCP_HELP','network')) ?></small>
            </div> 
            <div class="form-group" ng-show="dhcp_enabled==0">
                <label for="user_name"><? print(lang('IP_TITLE','network')) ?></label>
                <div class="form-row" style='line-height:40px'>
                    <div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ip1" name='ip1' min="1" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ip2" name='ip2' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ip3" name='ip3' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ip4" name='ip4' min="1" max="254" integer required>
                      
                    </div>
                    
              </div>
               <div ng-cloak class='small text-danger' ng-show="form.ip1.$invalid || form.ip2.$invalid || form.ip3.$invalid || form.ip4.$invalid"><strong><? print(lang('IP_INVALID','network')) ?></strong></div>
            <small id="dtHelp" class="form-text text-muted"><? print(lang('IP_HELP','network')) ?></small>
          </div>
          <div class="form-group" ng-show="dhcp_enabled==0">
                <label><? print(lang('NETMASK_TITLE','network')) ?></label>
                <div class="form-row" style='line-height:40px'>
                    <div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="nm1" name='nm1' min="0" max="255" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="nm2" name='nm2' min="0" max="255" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="nm3" name='nm3' min="0" max="255" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="nm4" name='nm4' min="0" max="255" integer required>
                      
                    </div>
                    
              </div>
              <div ng-cloak class='small text-danger' ng-show="form.nm1.$invalid || form.nm2.$invalid || form.nm3.$invalid || form.nm4.$invalid"><strong><? print(lang('NETMASK_INVALID','network')) ?></strong></div>
            <small id="dtHelp" class="form-text text-muted"><? print(lang('NETMASK_HELP','network')) ?></small>
          </div>
          <div class="form-group" ng-show="dhcp_enabled==0">
                <label ><? print(lang('GW_TITLE','network')) ?></label>
                <div class="form-row" style='line-height:40px'>
                    <div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="gw1" name='gw1' min="1" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="gw2" name='gw2' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="gw3" name='gw3' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="gw4" name='gw4' min="1" max="254" integer required>
                    </div>
                    
              </div>
               <div ng-cloak class='small text-danger' ng-show="form.gw1.$invalid || form.gw2.$invalid || form.gw3.$invalid || form.gw4.$invalid"><strong><? print(lang('GW_INVALID','network')) ?></strong></div>
            <small id="dtgHelp" class="form-text text-muted"><? print(lang('GW_HELP','network')) ?></small>
          </div>
          <div class="form-group" ng-show="dhcp_enabled==0">
                <label ><? print(lang('DNS_TITLE','network')) ?></label>
                <div class="form-row" style='line-height:40px'>
                    <div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="dns1" name='dns1' min="1" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="dns2" name='dns2' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="dns3" name='dns3' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="dns4" name='dns4' min="1" max="254" integer required>
                    </div>
                    
              </div>
               <div ng-cloak class='small text-danger' ng-show="form.dns1.$invalid || form.dns2.$invalid || form.dns3.$invalid || form.dns4.$invalid"><strong><? print(lang('DNS_INVALID','network')) ?></strong></div>
            <small id="dtgHelp" class="form-text text-muted"><? print(lang('DNS_HELP','network')) ?></small>
          </div>
           <div class="control-group" ng-show="dhcp_enabled==1" ng-cloak>
								<div class="controls">
								    <p class="help-block">
								        <? print(lang('DHCPHELP1','network')) ?><br>
                                        <? print(lang('DHCPHELP2','network')) ?><br>
                                        <? print(lang('DHCPHELP3','network')) ?><br>
								   
								    </div>
							  </div>
        <a name='mac'></a>
                        <div class="control-group">
								<label class="control-label" for="prependedInput"><? print(lang('MAC','network')) ?><br></label>
								<div class="controls">
								  <div class="input-append" style='padding-top:5px'><strong><? print(getmac()); ?></strong> <a href='#mac' onclick='copyTextToClipboard("<? print(getmac()); ?>")'> <? print(lang('COPY','network')) ?></a></div>
								</div>
						 </div>
                        <div class="control-group">
								<label class="control-label" for="prependedInput"><? print(lang('IP_TITLE','network')) ?><br></label>
								<div class="controls">
								  <div class="input-append" style='padding-top:5px'><strong><? print($dhcp_ip); ?></strong></div>
								</div>
						 </div>
						<div class="control-group">
								<label class="control-label" for="prependedInput"><? print(lang('GW_TITLE','network')) ?><br></label>
								<div class="controls">
								  <div class="input-append" style='padding-top:5px'><strong><? print($dhcp_gw); ?></strong></div>
								</div>
						 </div> 
						 
        </p>
    </div>
</div><br>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('PROXY_SETTINGS','network')) ?></h5>
        <p class="card-text">    
            <div class="form-group">
                <label for="tcp_server_enabled"><small class='text-muted'><? print(lang('USE_PROXY','network')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="tcp_server_enabled" id="exampleRadios2" value="0">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('DISABLED','network')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="tcp_server_enabled" id="exampleRadios3" value="1">
                  <label class="form-check-label" for="exampleRadios3">
                    &nbsp;<? print(lang('ENABLED','network')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('PROXY_HELP','network')) ?></small>
            </div> 
            <div class="form-group" ng-show='tcp_server_enabled==1'>
                <label for="tcp_server"><? print(lang('PROXY_SERVER','network')) ?></label>
                <input type="text" class="form-control" id="tcp_server" ng-model="tcp_server" aria-describedby="userHelp" placeholder="<? print(lang('PROXY_SERVER_HELP','network')) ?>">
                <small id="sntpHelp" class="form-text text-muted"><? print(lang('PROXY_SERVER_HELP','network')) ?></small>
            </div>     
            <div class="form-group" ng-show='tcp_server_enabled==1'>
                <label for="sntp_server"><? print(lang('PROXY_PORT','network')) ?></label>
                <input type="number" size=5 min=1 max=64000 class="form-control" id="tcp_server_port" ng-model="tcp_server_port" aria-describedby="userHelp" placeholder="<? print(lang('PROXY_PORT','network')) ?>">
                <div ng-cloak class='small text-danger' ng-show="form.tcp_server_port.$invalid"><strong><? print(lang('PROXY_PORT_INVALID','network')) ?></strong></div>
                <small id="sntpHelp" class="form-text text-muted"><? print(lang('PROXY_PORT_HELP','network')) ?></small>
            </div>  

       
       
     </p>
    </div>
</div>
							  
</form>

<script type='text/javascript'>

function fallbackCopyTextToClipboard(text) {
  var textArea = document.createElement("textarea");
  textArea.value = text;
  document.body.appendChild(textArea);
  textArea.focus();
  textArea.select();

  try {
    var successful = document.execCommand('copy');
    var msg = successful ? 'successful' : 'unsuccessful';
    console.log('Fallback: Copying text command was ' + msg);
  } catch (err) {
    console.error('Fallback: Oops, unable to copy', err);
  }

  document.body.removeChild(textArea);
}
function copyTextToClipboard(text) {
  if (!navigator.clipboard) {
    fallbackCopyTextToClipboard(text);
    return;
  }
  navigator.clipboard.writeText(text).then(function() {
    console.log('Async: Copying to clipboard was successful!');
  }, function(err) {
    console.error('Async: Could not copy text: ', err);
  });
}

var app = angular.module('myApp', []);

/**
* Network controller object used by Angular.JS
* @param $scope Application scope
* @param $http  HTTP object used for ajax requests
*/
function NetworkCtrl($scope,$http) {
    var self = this;
    $scope.infomsg="";
   $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
    
    /**
    * Restores default network settings into the form fields
    */
    $scope.restoreDefaults=function() {
      $scope.ip1=192;
      $scope.ip2=168;
      $scope.ip3=0;
      $scope.ip4=55;
      $scope.nm1=255;
      $scope.nm2=255;
      $scope.nm3=255;
      $scope.nm4=0;
      $scope.gw1=192;
      $scope.gw2=168;
      $scope.gw3=0;
      $scope.gw4=1;
      $scope.dns1=8;
      $scope.dns2=8;
      $scope.dns3=8;
      $scope.dns4=8;
      $scope.dhcp_enabled=0;
      $scope.successmsg="Default values loaded.  Settings will not be saved until you click Apply Changes."
    }
    $scope.isChecked=function(invert) {
        if (!invert) {
            if (Number($scope.dhcp_enabled)) return 'checked';
            return 'unchecked';
        } else {
        if (!Number($scope.dhcp_enabled)) return 'checked';
            return 'unchecked';
        }
   }
   $scope.isTCP=function(invert) {
        if (!invert) {
            if (Number($scope.tcp_server_enabled)) return 'checked';
            return 'unchecked';
        } else {
        if (!Number($scope.tcp_server_enabled)) return 'checked';
            return 'unchecked';
        }
   }
    /**
    * Posts settings to networksave.cgi and processes the response
    */
    $scope.saveSettings=function () {
        $scope.ipaddress=$scope.ip1+"."+$scope.ip2+"."+$scope.ip3+"."+$scope.ip4;
        $scope.netmask=$scope.nm1+"."+$scope.nm2+"."+$scope.nm3+"."+$scope.nm4;
        $scope.gateway=$scope.gw1+"."+$scope.gw2+"."+$scope.gw3+"."+$scope.gw4;
        $scope.dns=$scope.dns1+"."+$scope.dns2+"."+$scope.dns3+"."+$scope.dns4;
        str="&tcp_server_enabled="+$scope.tcp_server_enabled+
            "&tcp_server="+encodeURI($scope.tcp_server)+
            "&tcp_server_port="+$scope.tcp_server_port;
        $scope.successmsg="";
        $scope.errormsg="";
        $scope.infomsg="";
        $http.post('/app/networksave.cgi',"ip=" + $scope.ipaddress + "&netmask=" + $scope.netmask + "&gateway=" + $scope.gateway + "&dns=" + $scope.dns+"&dhcp_enabled="+$scope.dhcp_enabled+str)
            .then(function (response) {
                var data = response.data;
                $scope.successmsg=data;
                $scope.errormsg="";
                return data;
            }, function(reason) {
                $scope.errormsg="Error saving settings";
                $scope.successmsg="";
            });
    }
}
</script>
<? include("/app/footer.inc"); ?>


