<?
/**
 * @package PowerControl Manager
 * @author Akash Heimlich
 * @description This sets up the system with inverters and power meters automatically
 * @date    2018-11-21
 * 2018-11-21: Added instantaneous logging options
 * 2018-11-22: Added ws102 and pyra300 packages
 *             Added powercontrol and devices on dashboard
 */

$ezconfig_version='20210510';
// this will take care of the package management functions and call the right function based on the get parameters

function in_array($arr, $val) {
    for ($i=0;$i<sizeof($arr);$i++) {
        if ($arr[$i]==$val) return 1;
    }
    return 0;
}

if ($_SESSION['ezconfig_lite']==1) {
    $guest_ok=1;    
}
include("/app/config.inc");
$bodyid='rootscope';
$angular_controller="EZConfigWidget"; 
$angular_as="ezc";
$title=lang('PAGE_TITLE','ezconfig');
$config_file="EZConfig.ini";
$config_section="config";
$num_inverters=$_GLOBALS['inverter_count']?$_GLOBALS['inverter_count']:1;

// this will be overwritten if a file called EZConfigTypes.ini exists

$default_pm_types="6400,6410,6444,6445,6454,6455,6630,6640";
$default_inv_types="4506,7000,7006,7010,7026,7034,7070,7072,7078,7080,7088,7094,7096,7099";

include("/app/header.inc");
print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
/********************************************************************************************************* STAGE 0 */        
if ($_GET['stage']==0) {
        ?> 
<!-- BREADCRUMBS -->

<!-- NAVBAR -->
<h4><i class="icon-cog"></i>&nbsp;EZConfig Lite - Version <? print($ezconfig_version); ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','ezconfig')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/roles.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','ezconfig')) ?></a>
  </li>
<? if ($_SERVER['HW_PLATFORM']>=8)	{ ?>        
  <li class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1' ng-click="start()" ><i class="icon-check"></i> <? print(lang('START','ezconfig')) ?></a>
  </li>
<? } ?>                    
  
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
      <? print(lang('HELP1','ezconfig')) ?><br>
    <? print(lang('HELP2','ezconfig')) ?><br>
    <? print(lang('HELP3','ezconfig')) ?><br>
    <? print(lang('HELP4','ezconfig')) ?><br>
    <? print(lang('HELP5','ezconfig')) ?><br>
    <? print(lang('HELP6','ezconfig')) ?><br>
    <? print(lang('HELP7','ezconfig')) ?><br>
  
  </div>
  <br/>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','ezconfig')) ?></div>
<form name="form" class="css-form form-horizontal" novalidate>

<!-- VARIABLES -->        
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('ABOUT','devicetypeedit')) ?></h5>
        <p class="card-text">    
<? print(lang('ABOUT1','ezconfig')) ?>        
<? print(lang('ABOUT2','ezconfig')) ?>		
		<p>
<? if ($_SERVER['HW_PLATFORM']<7)	{ ?>
		<div class='alert alert-danger'><? print(lang('ABOUT4','ezconfig')) ?> </div>
<? } ?>		
<?  
// backup the configuration to be able to update power control
if (file_exists("/config/PC.ini")) {
    
   $inv_cnt=ini_get("/config/EZConfig.ini","config",'inv_count',0);
   $pm_cnt=ini_get("/config/EZConfig.ini","config",'pm_count',0);
   $other_cnt=ini_get("/config/EZConfig.ini","config",'other_count',0);
            
//   $ez_arr = ini_get_array("/config/EZConfig.ini","config");
   
   $pc_arr = ini_get_array("/config/PC.ini","config");
   
   for ($i=0; $i < $pc_arr['pm_count']; $i++) {
       $idx=$pc_arr['pm'.$i.'_device_idx'];
       $dev = mb_get_dev_by_index($idx);
       $name = $dev['name'];
       ini_set("/config/PC.ini","config",'pm'.$i.'_name',$name);
   }
   
    for ($i=0; $i < $pc_arr['inv_count']; $i++) {
       $idx=$pc_arr['inv'.$i.'_device_idx'];
       $dev = mb_get_dev_by_index($idx);
       $name = $dev['name'];
       ini_set("/config/PC.ini","config",'inv'.$i.'_name',$name);
   }
}

?>
        </p>
	</div>
</div>	
</form>
<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

function EZConfigWidget($scope, $timeout,$http) {
   var self = this;
   

   $scope.start=function() {
     
          document.location='/app/ezconfig_lite.cgi?stage=1';
          return data;
   }
}
   </script>
</div>
<?
      include("/app/footer.inc");?>
<?
    die();
}

/********************************************************************************************************* STAGE 1 */        
if ($_GET['stage']==1) {?> 
<style type='text/css'>
[ng-cloak].splash {
    display: block !important;
}
.splash {
    display: none;
}

.panel-heading  a:before {
   font-family: 'Arial';
   content: "^";
   float: right;
   transition: all 0.5s;
}
.panel-heading.active a:before {
	-webkit-transform: rotate(180deg);
	-moz-transform: rotate(180deg);
	transform: rotate(180deg);
} 

</style>
<!-- BREADCRUMBS -->
<!-- NAVBAR -->
<h4><i class="icon-cog"></i>&nbsp;EZConfigLite Stage 1: Select Inverters and Modify Set Points</h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','ezconfig')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','ezconfig')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link " ng-hide='loading==1' ng-click="saveAndNext()" ><i class="icon-arrow-right"></i> SAVE AND GENERATE</a>
  </li>
  
</ul>

<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','ezconfig')) ?></div>
<div class="splash" ng-cloak="">
    <p><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','ezconfig')) ?></p>
  </div>
<form ng-name='ezc.form' name="ezc.form" class="css-form form-horizontal" novalidate ng-cloak>

<!-- VARIABLES -->
<?

max_execution_time(60);
include("/app/package.inc");
include("/lib/uphp/array.inc");
        // package manager option

$all_inverters = ini_get_array('/config/devicetypes.ini','Inverter');
$all_inverters = quick_sort($all_inverters,1); // sort by value

$all_meters = ini_get_array('/config/devicetypes.ini','Meter');
$all_meters = quick_sort($all_meters,1); // sort by value

$all_other = ini_get_array('/config/devicetypes.ini','Other');
$all_other = quick_sort($all_other,1); // sort by value

            $inv_cnt=ini_get("/config/EZConfig.ini","config",'inv_count',0);
            $pm_cnt=ini_get("/config/EZConfig.ini","config",'pm_count',0);
            $other_cnt=ini_get("/config/EZConfig.ini","config",'other_count',0);
            
if (file_exists("/config/PC.ini")) {
    
   $inv_cnt=ini_get("/config/EZConfig.ini","config",'inv_count',0);
   $pm_cnt=ini_get("/config/EZConfig.ini","config",'pm_count',0);
   $other_cnt=ini_get("/config/EZConfig.ini","config",'other_count',0);
            
//   $ez_arr = ini_get_array("/config/EZConfig.ini","config");
   
   $pc_arr = ini_get_array("/config/PC.ini","config");
   
   for ($i=0; $i < $pc_arr['pm_count']; $i++) {
       $idx=$pc_arr['pm'.$i.'_device_idx'];
       $dev = mb_get_dev_by_index($idx);
       $name = $dev['name'];
       ini_set("/config/PC.ini","config",'pm'.$i.'_name',$name);
   }
   
    for ($i=0; $i < $pc_arr['inv_count']; $i++) {
       $idx=$pc_arr['inv'.$i.'_device_idx'];
       $dev = mb_get_dev_by_index($idx);
       $name = $dev['name'];
       ini_set("/config/PC.ini","config",'inv'.$i.'_name',$name);
   }
}
            $inv_cnt=ini_get("/config/EZConfig.ini","config",'inv_count',0);
            $pm_cnt=ini_get("/config/EZConfig.ini","config",'pm_count',0);
            $other_cnt=ini_get("/config/EZConfig.ini","config",'other_count',0);
            
            
            $pm_cnt=ini_get("/config/PC.ini","config",'pm_count',0);
            $pc_arr = ini_get_array("/config/PC.ini","config");
            // load power meter values
            for ($i=0;$i<$pm_cnt;$i++) {
                //if (!$pc_arr['pm'+$i+'_pf']) $pc_arr['pm'+$i+'_pf']=1;
                print('<div ng-init="pm.push({device_idx:'+
                    $pc_arr['pm'+$i+'_device_idx']+',max:'+
                    intval($pc_arr['pm'+$i+'_max'])+',min:'+
                    intval($pc_arr['pm'+$i+'_min'])+','+
                    'priority:\''+$pc_arr['pm'+$i+'_priority'] + '\','+
                    'pf:'+floatval($pc_arr['pm'+$i+'_pf']) + ','+
                    'plant_size:\''+intval($pc_arr['pm'+$i+'_plant_size']) + '\''+
                    ',device_type_id:'+$ez_arr['pm'+$i+'_device_type_id']+
                    ',type:'+intval($ez_arr['pm'+$i+'_type'])+
                    ',id:\''+$ez_arr['pm'+$i+'_id']+'\''+
                    ',device_name:\''+$ez_arr['pm'+$i+'_device_name'] + '\','+
                    'type:'+intval($pc_arr['pm'+$i+'_type']) + '})"></div>'
                    );
            }        
            
            
            $ez_arr = ini_get_array("/config/EZConfig.ini","config");
            // load power meter values
          /*  for ($i=0;$i<$pm_cnt;$i++) {
                print('<div ng-init="pm.push({device_idx:'+$ez_arr['pm'+$i+'_device_idx']+
                    ',bus:'+$ez_arr['pm'+$i+'_bus']+
                    ',type:'+intval($ez_arr['pm'+$i+'_type'])+
                    ',id:\''+$ez_arr['pm'+$i+'_id']+'\''+
                    ',device_name:\''+$ez_arr['pm'+$i+'_device_name'] + '\'})"></div>'
                    );
            } */
          
            
            // load inverter values
            for ($i=0;$i<$inv_cnt;$i++) {
                $cat=$ez_arr['inv'+$i+'_category'];
                if (!$cat) $cat='PV_INVERTER';
                print('<div ng-init="inv.push({device_idx:'+
                
                    $ez_arr['inv'+$i+'_device_idx']+
                    ',device_type_id:'+$ez_arr['inv'+$i+'_device_type_id']+
                    ',bus:'+$ez_arr['inv'+$i+'_bus']+
                    ',edit:1'+
                    ',rating:\''+$ez_arr['inv'+$i+'_rating']+'\''+
                    ',id:\''+$ez_arr['inv'+$i+'_id']+'\',device_name:\''+$ez_arr['inv'+$i+'_device_name'] + '\',category:\''+$cat + '\'})"></div>'
                    );
            } 
            
            
            // load inverter values
            for ($i=0;$i<$other_cnt;$i++) {
                $cat=$ez_arr['other'+$i+'_category'];
                if (!$cat) $cat='WEATHER_STATION';
                
                print('<div ng-init="other.push({device_idx:'+
                    $ez_arr['other'+$i+'_device_idx']+
                    ',device_type_id:'+$ez_arr['other'+$i+'_device_type_id']+
                    ',bus:'+
                    $ez_arr['other'+$i+'_bus']+',edit:1'+',id:\''+
                    $ez_arr['other'+$i+'_id']+'\',device_name:\''+$ez_arr['other'+$i+'_device_name'] + '\',category:\''+$cat + '\'})"></div>'
                    );
            }
        ?>            
<div ng-init="inv_count=<? print($inv_cnt); ?>;">
<div ng-init="other_count=<? print($other_cnt); ?>;">
<div ng-init="pm_count=<? print($pm_cnt); ?>;">
<div ng-init="pyranometer=<? print(intval($ez_arr['pyranometer'])); ?>;">
<div ng-init="ws102=<? print(intval($ez_arr['ws102'])); ?>;">
<div ng-init="use_temp=<? print(intval($ez_arr['use_temp'])); ?>;">
<div ng-init="num_temp=<? print(intval($ez_arr['num_temp'])); ?>;">
<div ng-init="module_power_control=<? print(intval($ez_arr['module_power_control'])); ?>;">
<div ng-init="module_devices=<? print(intval($ez_arr['module_devices'])); ?>;">
<div ng-init="poll_interval=<? print($ez_arr['poll_interval']>0?$ez_arr['poll_interval']:"1000"); ?>;">
<div ng-init="parity=<? print($ez_arr['parity']>0?$ez_arr['parity']:"0"); ?>;">
<div ng-init="baud_rate=<? print($ez_arr['baud_rate']>0?$ez_arr['baud_rate']:"9600"); ?>;">
<div ng-init="retries=<? print($ez_arr['retries']>0?$ez_arr['retries']:"1"); ?>;">
<div ng-init="timeout=<? print($ez_arr['timeout']>0?$ez_arr['timeout']:"300"); ?>;">
<div ng-init="interval=<? print($ez_arr['interval']>0?$ez_arr['interval']:"10"); ?>;">
<div ng-init="parity2=<? print($ez_arr['parity2']>0?$ez_arr['parity2']:"0"); ?>;">
<div ng-init="baud_rate2=<? print($ez_arr['baud_rate2']>0?$ez_arr['baud_rate2']:"9600"); ?>;">

<div ng-init="tcp_retries=<? print($ez_arr['tcp_retries']>0?$ez_arr['tcp_retries']:"1"); ?>;">
<div ng-init="tcp_timeout=<? print($ez_arr['tcp_timeout']>0?$ez_arr['tcp_timeout']:"300"); ?>;">
<div ng-init="tcp_interval=<? print($ez_arr['tcp_interval']>0?$ez_arr['tcp_interval']:"10"); ?>;">

<? for ($x=0; $x < 10; $x++)  { ?>
<div ng-init="tcp<? print($x."_ip='".$ez_arr['tcp'.$x.'_ip']); ?>';">
<div ng-init="tcp<? print($x."_s='".intval($ez_arr['tcp'.$x.'_s'])); ?>';">
<div ng-init="tcp<? print($x."_port=".intval($ez_arr['tcp'.$x.'_port']?$ez_arr['tcp'.$x.'_port']:502)); ?>;">
<? } ?>



<br/>
<div class="card">
    <div class="card-body">
        <h5 class="card-title text-success"><? print(lang('INVERTERS','ezconfig')) ?></h5>
        <h6 class="card-subtitle mb-2 text-muted"><? print(lang('INVERTER_COUNT','ezconfig')) ?>: <strong>{{inv_count}}</strong></h6>
        <p class="card-text">    
            <div class='pull-right'><a name='addinv'></a><ng-button ng-show='inv.length<10' class="btn btn-primary" ng-click="addInv()"><i class="icon-plus"></i>&nbsp;ADD INVERTER</ng-button></div>
            <table class='table table-striped' summary="Inverters" > 
                <tr>
                    <td scope="col"></td>
                    <td scope="col"><? print(lang('DEVICE','ezconfig')) ?></td>
                    <td scope="col"><? print(lang('ADDRESS','ezconfig')) ?></td>
                    <td scope="col"><? print(lang('BUS','ezconfig')) ?></td>
                    <td scope="col"><? print(lang('NAME','ezconfig')) ?></td>
                    
                    <td scope="col"><? print(lang('RATING','ezconfig')) ?> <a href="#addinv" data-toggle="tooltip" title="Select the inverter rating in kW - this can be used for power control."><span class='badge badge-dark'>?</span></a></td>
                    <td scope="col"><? print(lang('OPTIONS','ezconfig')) ?></td>
                </tr>
                <tr ng-repeat="item in inv">
                    <td><a name='inv{{$index}}'></a><span class="badge badge-success badge-pill">{{$index+1}}</span></td>
                     <td><div >
                        <select class="form-control" ng-options="vitem.device_type_id as vitem.name for vitem in inverters" ng-model="item.device_type_id" class='span12'>
                		      <option value="{{vitem.device_type_id}}">{{vitem.name}}</option>       
                		 </select>
                        </div>
                    </td>        
                    
                    
                    </td>            
                    <td>
                    <div ng-show='item.bus>=0'>
                         <input class="form-control" type='text' class='span12' ng-model='item.id'>
                    </div>
                    </td>
                
                    
                    <td><div >
                          <select class="form-control" ng-options="vbus.idx as vbus.name for vbus in bus" ng-model="item.bus" class='span12'>
                		      <option value="{{vbus.idx}}">{{vbus.name}}</option>       
                		 </select>
                        </div></td>           
                        <td><div >{{item.device_name}} </div></td>
                    <td><div>
                         <input class="form-control" type='text' class='span12' ng-model='item.rating'>
                         <small ng-cloak class='text-danger' ng-hide="isRatingValid(item.rating)">The rating is invalid. Please enter a number between 10 and 250</small>
                         
                        </div>
                    </td>
                    <td>
                    <div class="dropdown" ng-show='$last'>
                        <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <? print(lang('ACTION','ezconfig')) ?> <span class="caret"></span>
                        </button>
                        
                        <div class="dropdown-menu dropdown-menu-right text-dark" >
                                <a class="dropdown-item" ng-click='delInv($index)' href='javascript:void()'><i class="icon-remove"></i>&nbsp;<? print(lang('DELETE','ezconfig')) ?></a>                                    
                                </div>
                            </div>
                        </div>
                    </td>    
                </tr>
            </table> 
        </p>
    </div>
</div>    
<br/>
<div  class="card" >
    <div class="card-body">
        <h5 class="card-title"><? print(lang('POWER_METERS','PC')) ?></h5>
        <h6 class="card-subtitle mb-2 text-muted"><? print(lang('NUM_POWER_METERS','PC')) ?>: {{pm_count}}</h6>
        <p class="card-text">    
            <div class="form-group"> 
                
            
                <table class='table table-striped' summary="Meters" >
                    <tr>
            
                        <td scope="col"></td>
                        <td scope="col"><strong><? print(lang('CONNECTED_TO','PC')) ?></strong></td>
                        <td scope="col"><strong><? print(lang('MIN','PC')) ?></strong></td>
                        <td scope="col"><strong><? print(lang('MAX','PC')) ?></strong></td>
                        <td scope="col"><strong><? print(lang('PRIORITY','PC')) ?></strong> <i class='badge badge-pill badge-secondary' data-toggle="tooltip" data-placement="top" title="If multiple meters are active, the higher priority (larger number) will be used">?</i></td>
                        <td scope="col"><strong><? print(lang('PF','PC')) ?></strong> <i class='badge badge-pill badge-secondary' data-toggle="tooltip" data-placement="top" title="When this meter is active the inverter power factor (-1 to +1) will be set to the value below">?</i></td>
                    </tr>
                    <tr ng-repeat="item in pm">
                        <td><a name='pm{{$index}}'></a><span class="badge badge-warning badge-pill">{{$index+1}}</span></td>
                        <td><strong>{{makeType(item.type)}}</strong>
                        </td>               
                        <td><div >
                             <input type='number'  ng-model='item.min' class="form-control">
                            </div></td>
                        <td><div>
                             <input type='number' ng-model='item.max' class="form-control">
                            </div></td>
                        <td>{{item.priority}}</td>
                        <td>{{item.pf}}</td>
                    </tr>
                </table>
            </div>
        </p>
    </div>
</div>
<br/>




</form>
<script>

 $('.panel-collapse').on('show.bs.collapse', function () {
    $(this).siblings('.panel-heading').addClass('active');
  });

  $('.panel-collapse').on('hide.bs.collapse', function () {
    $(this).siblings('.panel-heading').removeClass('active');
  })
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
  app.directive('myDirective', function() {
  return {
    require: 'ngModel',
    link: function(scope, element, attr, mCtrl) {
      function myValidation(value) {
        console.log(value);
        
        var regex = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
        if(regex.test(value) == false){
            mCtrl.$setValidity('charE', false);
          
        } else {
            mCtrl.$setValidity('charE', true);
        }
        return value;
      }
      mCtrl.$parsers.push(myValidation);
    }
  };
});
function EZConfigWidget($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   //4028,4099,4098,4024,4023
   $scope.power_meter_types=[<? 
   $pm_types=implode(array_keys($all_meters),',');
   print($pm_types);
   
   /*$pm_types=ini_get('/config/EZConfigTypes.ini',"config",'pm_types','');
   
   $done=0;
   $cnt=2;
   while (!$done) {
    $pm_types2=ini_get('/config/EZConfigTypes.ini',"config",'pm_types'.$cnt,'');
    if ($pm_types2) {
        $pm_types.=",".$pm_types2;
        $cnt++;
    } else $done=1;
   }
   if (!$pm_types) {
        $pm_types=$default_pm_types;
        ini_set('/config/EZConfigTypes.ini',"config",'pm_types',$default_pm_types);
   };
   print($pm_types);*/ ?>]; 
   //2900,2901,4580,4134,4133,3360,4789,4790
   $scope.inverter_types=[<?
   $inv_types=implode(array_keys($all_inverters),',');
   print( $inv_types);
   /*
   
   $inv_types=ini_get('/config/EZConfigTypes.ini',"config",'inv_types','');
   $done=0;
   $cnt=2;
   while (!$done) {
    $pm_types2=ini_get('/config/EZConfigTypes.ini',"config",'inv_types'.$cnt,'');
    if ($pm_types2) {
        $inv_types.=",".$pm_types2;
        $cnt++;
    } else $done=1;
   }
   if (!$inv_types) {
        $inv_types=$default_inv_types;
        ini_set('/config/EZConfigTypes.ini',"config",'inv_types',$default_inv_types);
   };
   print($inv_types);*/ ?>];
   $scope.pm=[<?
       $num_pm=ini_get('/config/EZConfig.ini',"config",'num_pm',0);
       for ($d=0;$d<$num_pm;$d++) {
            $addr=ini_get("/config/EZConfig.ini","pm".$d,"address",0);
            $bus=ini_get("/config/EZConfig.ini","pm".$d,"bus",0);
            $type=ini_get("/config/EZConfig.ini","pm".$d,"type",0);
            $name=ini_get("/config/EZConfig.ini","pm".$d,"name","");
            
            $idx=ini_get("/config/EZConfig.ini","pm".$d,"idx",0);

            $st="{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="bus:".$bus.",";
            $st.="type:".$type.",";
            $st.="name:\"".$name."\"},";
            print($st);
            
       }
   ?>];
    $scope.inv=[<?
       $num_pm=ini_get('/config/EZConfig.ini',"config",'num_inv',0);
       for ($d=0;$d<$num_pm;$d++) {
            $addr=ini_get("/config/EZConfig.ini","inv".$d,"address",0);
            $bus=ini_get("/config/EZConfig.ini","inv".$d,"bus",0);
            $name=ini_get("/config/EZConfig.ini","inv".$d,"name","");
            $rating=ini_get("/config/EZConfig.ini","inv".$d,"rating","");
            $idx=ini_get("/config/EZConfig.ini","inv".$d,"idx",0);

            $st="{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="bus:".$bus.",";
            $st.="rating:\"".$rating."\",";
            $st.="name:\"".$name."\"},";
            print($st);
            
       }
   ?>];

    $scope.other=[<?
       $num_other=ini_get('/config/EZConfig.ini',"config",'num_other',0);
       for ($d=0;$d<$num_other;$d++) {
            $addr=ini_get("/config/EZConfig.ini","other".$d,"address",0);
            $bus=ini_get("/config/EZConfig.ini","other".$d,"bus",0);
            $name=ini_get("/config/EZConfig.ini","other".$d,"name","");
            $idx=ini_get("/config/EZConfig.ini","other".$d,"idx",0);

            $st="{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="bus:".$bus.",";
            $st.="name:\"".$name."\"},";
            print($st);
            
       }
   ?>];
   
   $scope.power_meters=[<?
        $pm_arr=explode($pm_types,',');
        
       
       for ($d=0;$d<sizeof($pm_arr);$d++) {
        
            $st="{device_type_id:".$pm_arr[$d].",";
            $st.="device_idx:".$d.",";
            $st.="name:\"".ini_get("/dev/dev".$pm_arr[$d].".ini","config","name","")." (".$pm_arr[$d].")\"},";
            print($st);
            
       }
   ?>];
   $scope.inverters=[<?
        $inv_arr=explode($inv_types,',');
        
       
       for ($d=0;$d<sizeof($inv_arr);$d++) {

            $st="{device_type_id:".$inv_arr[$d].",";
            $st.="device_idx:".$d.",";
            $st.="name:\"".ini_get("/dev/dev".$inv_arr[$d].".ini","config","name","")."\"},";
            print($st);
            
       }
   ?>];
   
    $scope.other_devices=[<?
    
        $curdir=getcwd();
        $maxid=0;
        chdir("/dev/");  
        $arr=findfirst("*.ini",255-8);
        $dev_arr=array();
        $idx=0;
        while ($arr) {
            $devname=ini_get('/dev/'.$arr['filename'],"config",'name');
            $devtype=ini_get('/dev/'.$arr['filename'],"config",'device_type_id',0);
            $devcat=ini_get('/dev/'.$arr['filename'],"config",'dev_category',0);
            if ($devcat==0) $devcatname="Inverter";
            if ($devcat==1) $devcatname="Power Meter";
            if ($devcat==2) $devcatname="Charge Controller";
            if ($devcat==3) $devcatname="Sensor";
            if ($devcat==4) $devcatname="Other";
            if ($devcat==5) $devcatname="Wattmon Master";
            
          
            if ($devtype>$maxid) $maxid=$devtype;
            if (($devcat<5) && strlen($devname)) {//$devtype>1) {
                print('{device_idx:'.$idx.',name:"'.$devname.'",device_type_id:'.$devtype.",device_category:\"".$devcatname."\"},");
                $idx++;
            }
            
            $arr=findnext();
        }

   ?>];

   $scope.bus=[{idx:0,name:"Modbus RTU (RS-485)"},
<? if (($_SERVER['HW_PLATFORM']==11) || ($_SERVER['HW_PLATFORM']>=20)) { ?>
   
        {idx:1,name:"Modbus RTU 2 (RS-485)"},
<? } ?>        
        {idx:2,name:"Modbus TCP Channel 1"},
        {idx:3,name:"Modbus TCP Channel 2"},
        {idx:4,name:"Modbus TCP Channel 3"},
        {idx:5,name:"Modbus TCP Channel 4"},
        {idx:6,name:"Modbus TCP Channel 5"},
        {idx:7,name:"Modbus TCP Channel 6"},
        {idx:8,name:"Modbus TCP Channel 7"},
        {idx:9,name:"Modbus TCP Channel 8"},
        {idx:10,name:"Modbus TCP Channel 9"},
        {idx:11,name:"Modbus TCP Channel 10"},
        {idx:100,name:"Virtual"},
        
    ];
   $scope.pm_count_installed=0;
   $scope.loading=0;
   $gscope=$scope;
   if ($scope.power_meters.length==0) {
        $scope.errormsg="There are currently no power meters defined that support power control.  Please add a Secure 400 or Schneider EM6400 meter.";
   }
   if ($scope.inverters.length==0) {
        if ($scope.errormsg.length>0) $scope.errormsg+="\r\n";
        $scope.errormsg+="There are currently no inverters defined that support power control.  Please add a supported inverter or contact us.";
   }
   $scope.isRatingValid=function(val) {
        if (val>=2 && val<=1000) return true;
        return false;
   }
   $scope.makeBus=function(idx) {
     for (i=0;i<$scope.bus.length;i++) {
        if ($scope.bus[i].idx==idx) 
            return $scope.bus[i].name;
     }
     return "";
   }
   
    $scope.makeType=function(atype_id) {
        switch (Number(atype_id)) {
            case 0:return "<? print(lang('UNDEFINED','ezconfig')) ?>";
            case 1:return "<? print(lang('GENSET','ezconfig')) ?>";
            case 2:return "<? print(lang('INCOMER','ezconfig')) ?>";
            case 3:return "<? print(lang('INVERTER_OUTPUT','ezconfig')) ?>";
            case 4:return "<? print(lang('BUILDING_LOAD','ezconfig')) ?>";
            default: return atype_id;
        }
    };
   $scope.addPM=function() {
    if ($scope.power_meters.length==0) {
        alert("No supported power meters found.  Add the power meter in your devices list first.");
    } else {
        // guess the next meter id
        meter_id=1;
        dbus=0;
        ddevice_idx=0;
        name='meter'+($scope.pm_count+1);
        if ($scope.pm.length) {
            meter_id=Number($scope.pm[$scope.pm.length-1].id)+1;
            ddevice_idx=Number($scope.pm[$scope.pm.length-1].device_idx);
            dbus=Number($scope.pm[$scope.pm.length-1].bus);
            for (i=0;i<$scope.pm.length;i++) {
                if ($scope.pm[i].device_name==name) {
                    name=name+"dup";
                }
            }
        }
        $scope.pm.push({edit:1,id:meter_id,device_idx:ddevice_idx,bus:dbus,device_name:name});
        $scope.pm_count++;
    }
   }
   $scope.delPM=function(idx) {
        $scope.pm.splice(idx,1);
        $scope.pm_count--;
   }
   $scope.addOD=function() {
    if ($scope.other_devices.length==0) {
        alert("No other devices found.");
    } else {
        // guess the next meter id
        other_id=1;
        dbus=0;
        ddevice_idx=0;
        name='device'+($scope.other_count+1);
        if ($scope.other.length) {
            other_id=Number($scope.other[$scope.other.length-1].id)+1;
            ddevice_idx=Number($scope.other[$scope.other.length-1].device_idx);
            dbus=Number($scope.other[$scope.other.length-1].bus);
            for (i=0;i<$scope.other.length;i++) {
                if ($scope.other[i].device_name==name) {
                    name=name+"dup";
                }
            }
        }
        $scope.other.push({edit:1,id:other_id,device_idx:ddevice_idx,bus:dbus,device_name:name});
        $scope.other_count++;
    }
   }
   
   $scope.addPyranometer=function() {
   console.log("ADD");
        pyra_index=-1;
        for (i=0;i<$scope.other.length;i++) {
            if ($scope.other_devices[$scope.other[i].device_idx].device_type_id==8010) {
                pyra_index=i;
                break;
            }
        }    
        if (pyra_index==-1) {
            for (i=0;i<$scope.other_devices.length;i++) {
                if ($scope.other_devices[i].device_type_id==8010) {
                    $scope.other.push({readonly:1,edit:0,id:200,device_idx:i,bus:100,device_name:"Pyranometer"});
                    $scope.other_count++;        
                }
            }
        }
        

   }
   
   $scope.delOD=function(idx) {
        $scope.other.splice(idx,1);
        $scope.other_count--;
   }
   
    $scope.addInv=function() {
    if ($scope.inverters.length==0) {
        alert("No supported Inverters found.  Add the Inverter in your devices list first.");
    } else {
        // guess the next meter id
        inv_id=1;
        dbus=0;
        ddevice_idx=0;
        inv_rating=50;
        name='inverter'+($scope.inv_count+1);
        if ($scope.inv.length) {
            inv_id=Number($scope.inv[$scope.inv.length-1].id)+1;
            inv_type_id=Number($scope.inv[$scope.inv.length-1].device_type_id);
            ddevice_idx=Number($scope.inv[$scope.inv.length-1].device_idx);
            dbus=Number($scope.inv[$scope.inv.length-1].bus);
            inv_rating=Number($scope.inv[$scope.inv.length-1].rating);
            for (i=0;i<$scope.inv.length;i++) {
                if ($scope.inv[i].device_name==name) {
                    name=name+"dup";
                }
            }
        }
        $scope.inv.push({edit:1,id:inv_id,device_idx:ddevice_idx,device_type_id:inv_type_id,bus:dbus,device_name:name,rating:inv_rating});
        $scope.inv_count++;
    
    }
   }
   $scope.delInv=function(idx) {
        if ($scope.inv_count > 1) {
            $scope.inv.splice(idx,1);
            $scope.inv_count--;
        } else if (idx==0) {
            $scope.errormsg="You cannot delete the first inverter";
        }
   }

    $scope.makeRole=function(itemid) {
        str='';
        switch (Number(itemid)) {
        <? //for ($i=0;$i<$roles['num_roles'];$i++) { 
            $nr=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($i=0;$i<$nr;$i++) { 
            //print("<option value='"+$i+"'>"+ini_get("/config/roles.ini","roles",'role'+$i)+"</option>");
            print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
            }
            
            //}
            ?>
      } 

      return str;

  }
$scope.$watch('pyranometer', function(asyncData) {
    if(angular.isDefined(asyncData)) {
        if (asyncData==1) $scope.addPyranometer();
    }
});
  
   
   $scope.saveAndNext=function() {
       $scope.successmsg="";
           $scope.errormsg="";
           $scope.infomsg="";
     error_msg="";
        $scope.loading=1;
       post_data="inv_count="+$scope.inv_count;
          
                
        post2_data="inv_count="+$scope.inv_count;
        
        plant_size=0;
        for (i=0;i<$scope.inv.length;i++) {
            if (($scope.inv[i].rating<10) || ($scope.inv[i].rating<10)) {
                error_msg=error_msg+" Inverter "+(i+1)+" rating needs to be between 10 and 250kW. ";
                
                
            }
            
            post_data+="&inv"+i+"_device_idx="+$scope.inv[i].device_idx;     
            post_data+="&inv"+i+"_device_type_id="+$scope.inv[i].device_type_id;//+$scope.inverters[$scope.inv[i].device_idx].device_type_id;     
            post_data+="&inv"+i+"_id="+$scope.inv[i].id;     
            post_data+="&inv"+i+"_bus="+$scope.inv[i].bus;     
            post_data+="&inv"+i+"_device_name="+$scope.inv[i].device_name;     
            post_data+="&inv"+i+"_rating="+$scope.inv[i].rating;     
            //plant_size+=$scope.inv[i].rating;
            
            post2_data+="&inv"+i+"_device_idx="+$scope.inv[i].device_idx;     
            post2_data+="&inv"+i+"_device_type_id="+$scope.inv[i].device_type_id;//+$scope.inverters[$scope.inv[i].device_idx].device_type_id;     
            post2_data+="&inv"+i+"_id="+$scope.inv[i].id;     
            post2_data+="&inv"+i+"_bus="+$scope.inv[i].bus;     
            post2_data+="&inv"+i+"_device_name="+$scope.inv[i].device_name;     
            post2_data+="&inv"+i+"_rating="+$scope.inv[i].rating;     
            plant_size+=$scope.inv[i].rating;
            
        }
                
        for (i=0;i<$scope.pm.length;i++) {
            post2_data+="&pm"+i+"_device_idx="+$scope.pm[i].device_idx;     
            post2_data+="&pm"+i+"_device_type_id=" + $scope.pm[i].device_type_id;
            post2_data+="&pm"+i+"_max="+$scope.pm[i].max;     
            post2_data+="&pm"+i+"_min="+$scope.pm[i].min;
            post2_data+="&pm"+i+"_type="+$scope.pm[i].type;
            post2_data+="&pm"+i+"_pf="+$scope.pm[i].pf;
            post2_data+="&pm"+i+"_plant_size="+plant_size;
            post2_data+="&pm"+i+"_priority="+$scope.pm[i].priority;
        }
        
/*        for (i=0;i<$scope.pm.length;i++) {
            post_data+="&pm"+i+"_device_idx="+$scope.pm[i].device_idx;     
            post_data+="&pm"+i+"_device_type_id="+$scope.power_meters[$scope.pm[i].device_idx].device_type_id;     
            post_data+="&pm"+i+"_id="+$scope.pm[i].id;     
            post_data+="&pm"+i+"_type="+$scope.pm[i].type;     
            post_data+="&pm"+i+"_bus="+$scope.pm[i].bus;     
            post_data+="&pm"+i+"_device_name="+$scope.pm[i].device_name;     
        }
        */
        
        /*for (i=0;i<$scope.other.length;i++) {
            post_data+="&other"+i+"_device_idx="+$scope.other[i].device_idx;     
            post_data+="&other"+i+"_device_type_id="+$scope.other_devices[$scope.other[i].device_idx].device_type_id;     
            post_data+="&other"+i+"_id="+$scope.other[i].id;     
            post_data+="&other"+i+"_bus="+$scope.other[i].bus;     
            post_data+="&other"+i+"_device_name="+$scope.other[i].device_name;     
        }*/
         if (error_msg) {
          $scope.errormsg=error_msg;
          $scope.loading=0;
          return;
       }
       post_config="EZConfig.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings 1":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          $scope.loading=0;
          
          post2_config="PC.ini";
          post2_section="config";
          
          $http.post('/app/configsave.cgi?config='+post2_config+'&section='+post2_section,post2_data)
            .then(function (response) {
              var data = response.data; 
              $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
              $scope.errormsg=data.error;
              $scope.sysmsg=data.sysmsg;
              $scope.loading=0;
              document.location='/app/ezconfig_lite.cgi?stage=4';
              return data;
            }, function(reason) {
                $scope.errormsg="Error saving settings";
                $scope.successmsg="";
                $scope.loading=0;
            });
          //document.location='/app/ezconfig_lite.cgi?stage=2';
          //return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            $scope.loading=0;
        });
   }
}
</script>
        <? }
        
/********************************************************************************************************* STAGE 2 */        
if ($_GET['stage']==2) {?>
<style type='text/css'>
[ng-cloak].splash {
    display: block !important;
}
.splash {
    display: none;
}
</style>
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','ezconfig')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-cog"></i>&nbsp;<? print(lang('STAGE2_TITLE','ezconfig')) ?>: <? print(lang('S2_TITLE','ezconfig')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','ezconfig')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','ezconfig')) ?></a>
  </li>
 <li class="nav-item">
    <a class="nav-link " ng-hide='loading==1' ng-click="prev()" ><i class="icon-back"></i> <? print(lang('PREVIOUS','ezconfig')) ?></a>
  </li>  
  <li class="nav-item">
    <a class="nav-link " ng-hide='loading==1' ng-click="saveSettings(0)" ><i class="icon-check"></i> <? print(lang('APPLY','ezconfig')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link " ng-hide='loading==1' ng-click="saveSettings(1)" ><i class="icon-arrow-right"></i> <? print(lang('SAVE_NEXT','ezconfig')) ?></a>
  </li>
  
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','ezconfig')) ?>
  </div>
  <br/>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','ezconfig')) ?></div>
<div class="splash" ng-cloak="">
    <p><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','ezconfig')) ?></p>
  </div>
<form name="form" class="css-form form-horizontal" novalidate ng-cloak>

<!-- VARIABLES -->
<? 
    $inv_cnt=ini_get("/config/EZConfig.ini","config",'inv_count',0);
    $pm_cnt=ini_get("/config/EZConfig.ini","config",'pm_count',0);
    $ez_arr = ini_get_array("/config/EZConfig.ini","config");
//            $=ini_get("/config/EZConfig.ini","config",'pm_count',0);       
?>            
<div ng-init="inv_count=<? print($inv_cnt); ?>;">
<div ng-init="pm_count=<? print($pm_cnt); ?>;">
        
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('S2_TITLE','ezconfig')) ?></h5>
        <p class="card-text">    
            <? print(lang('S2_1','ezconfig')) ?>
            <? print(lang('S2_2','ezconfig')) ?>
        </p>
    </div>
</div>
<br/>
<div class="card" ng-hide='pm.length==0'>
    <div class="card-body">
        <h5 class="card-title text-danger"><? print(lang('POWER_METERS','ezconfig')) ?></h5>
        <p class="card-text">    
            <table class='table' summary="Meters" >
                <tr ng-repeat="item in power_meters">
                    <td><a name='pm{{$index}}'></a><span class="badge badge-danger badge-pill">{{$index+1}}</span></td>
                    <td><h6><strong class='badge badge-secondary'>{{item.name}}</strong></h6>
                    <table class='table table-striped' summary="Roles" >
                        <tr>
                            <td scope="col"><strong><? print(lang('USE','ezconfig')) ?></strong></td>
                            <td scope="col"><a name='pm'></a><strong><? print(lang('FUNCTION','datalogedit')) ?> (<a ng-click='setMeterFn(3);' href='#pm'>INSTANTANEOUS</a> - <a ng-click='setMeterFn(0);' href='#pm'>AVERAGE</a>)</strong></td>
                            <td scope="col"><strong><? print(lang('VARIABLE','ezconfig')) ?></strong></td>
                            <td scope="col"><strong><? print(lang('DESCRIPTION','ezconfig')) ?></strong></td>
                        </tr>
                        <tr ng-repeat="role in item.roles">
                            <td><input type='checkbox' class='form-control' ng-model='role.selected'></td>
                            <td>
                                <select ng-model="role.logfn" class='form-control' >
                                    <option value='0'><? print(lang('AVERAGE','datalogedit')) ?></option>
                                    <option value='1'><? print(lang('MIN','datalogedit')) ?></option>
                                    <option value='2'><? print(lang('MAX','datalogedit')) ?></option>            
                                    <option value='3'><? print(lang('INSTANTANEOUS','datalogedit')) ?></option>            
                                </select>
                            </td>
                            <td><strong>{{role.role_name}}</strong></td>
                            <td><i>{{role.role_desc}}</i></td>
                        </tr>
                    </table>
                </td>            
            </tr>
        </table> 
    </div>
</div> 
<br/>
<div class="card" ng-hide='inv.length==0'>
    <div class="card-body">
        <h5 class="card-title text-success"><? print(lang('INVERTERS','ezconfig')) ?></h5>
        <p class="card-text">    
            <table class='table' summary="Inverters" >
                <tr ng-repeat="item in inverters">
                    <td><a name='inv{{$index}}'></a><span class="badge badge-pill badge-success">{{$index+1}}</span></td>
                    <td><h6><strong class='badge badge-secondary'>{{item.name}}</strong></h6>
                    <table class='table table-striped' summary="Roles" >
                        <tr>
                            <td scope="col"><strong><? print(lang('USE','ezconfig')) ?></strong></td>
                            
                            <td scope="col"><a name='inv'></a><strong><? print(lang('FUNCTION','datalogedit')) ?> (<a ng-click='setInvFn(3);' href='#inv'>INSTANTANEOUS</a> - <a ng-click='setInvFn(0);' href='#inv'>AVERAGE</a>)</strong></td>
                            <td scope="col"><strong><? print(lang('VARIABLE','ezconfig')) ?></strong></td>
                            <td scope="col"><strong><? print(lang('DESCRIPTION','ezconfig')) ?></strong></td>
                        </tr>
                        <tr ng-repeat="role in item.roles">
                            <td><input type='checkbox' class='form-control' ng-model='role.selected'></td>
                            <td>
                                <select ng-model="role.logfn" class='form-control' >
                                    <option value='0'><? print(lang('AVERAGE','datalogedit')) ?></option>
                                    <option value='1'><? print(lang('MIN','datalogedit')) ?></option>
                                    <option value='2'><? print(lang('MAX','datalogedit')) ?></option>            
                                    <option value='3'><? print(lang('INSTANTANEOUS','datalogedit')) ?></option>            
                                </select>
                            </td>
                            <td><strong>{{role.role_name}}</strong></td>
                            <td><i>{{role.role_desc}}</i></td>
                        </tr>
                    </table>
                </td>            
            </tr>
        </table> 
    </div>
</div> 
<br/>
<div class="card" ng-hide='other.length==0'>
    <div class="card-body">
        <h5 class="card-title text-primary"><? print(lang('OTHER_DEVICES','ezconfig')) ?></h5>
        <p class="card-text">    
            <table class='table' summary="Other Devices" >
                <tr ng-repeat="item in other_devices">
                    <td><a name='od{{$index}}'></a><span class="badge badge-primary badge-pill">{{$index+1}}</span></td>
                    <td><h6><strong class='badge badge-secondary'>{{item.name}}</strong></h6>
                    <table class='table table-striped' summary="Roles" >
                        <tr>
                            <td scope="col"><strong><? print(lang('USE','ezconfig')) ?></strong></td>
                            <td scope="col"><a name='od'></a><strong><? print(lang('FUNCTION','datalogedit')) ?> (<a ng-click='setOtherFn(3);' href='#od'>INSTANTANEOUS</a> - <a ng-click='setOtherFn(0);' href='#od'>AVERAGE</a>)</strong></td>
                            <td scope="col"><strong><? print(lang('VARIABLE','ezconfig')) ?></strong></td>
                            <td scope="col"><strong><? print(lang('DESCRIPTION','ezconfig')) ?></strong></td>
                        </tr>
                        <tr ng-repeat="role in item.roles">
                            <td><input type='checkbox' class='form-control' ng-model='role.selected'></td>
                            <td>
                                <select ng-model="role.logfn" class='form-control' >
                                    <option value='0'><? print(lang('AVERAGE','datalogedit')) ?></option>
                                    <option value='1'><? print(lang('MIN','datalogedit')) ?></option>
                                    <option value='2'><? print(lang('MAX','datalogedit')) ?></option>            
                                    <option value='3'><? print(lang('INSTANTANEOUS','datalogedit')) ?></option>            
                                </select>
                            </td>
                            <td><strong><input type='text' class='form-control' ng-model='role.role_name'></input></strong></td>
                            <td><i>{{role.role_desc}}</i></td>
                        </tr>
                    </table>
                </td>            
            </tr>
        </table> 
    </div>
</div> 
            
 
</form>

<script>
<?

?>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

function EZConfigWidget($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   //4028,4099,4098,4024,4023
   $scope.power_meter_types=[<? 
   $pm_types=ini_get('/config/EZConfigTypes.ini',"config",'pm_types','');
   $done=0;
   $cnt=2;
   while (!$done) {
    $pm_types2=ini_get('/config/EZConfigTypes.ini',"config",'pm_types'.$cnt,'');
    if ($pm_types2) {
        $pm_types.=",".$pm_types2;
        $cnt++;
    } else $done=1;
   }
   if (!$pm_types) {
        $pm_types=$default_pm_types;
        ini_set('/config/EZConfigTypes.ini',"config",'pm_types',$default_pm_types);
   };
   print($pm_types); ?>]; 
   //2900,2901,4580,4134,4133,3360,4789,4790
   $scope.inverter_types=[<? $inv_types=ini_get('/config/EZConfigTypes.ini',"config",'inv_types','');
   $done=0;
   $cnt=2;
   while (!$done) {
    $pm_types2=ini_get('/config/EZConfigTypes.ini',"config",'inv_types'.$cnt,'');
    if ($pm_types2) {
        $inv_types.=",".$pm_types2;
        $cnt++;
    } else $done=1;
   }
   if (!$inv_types) {
        $inv_types=$default_inv_types;
        ini_set('/config/EZConfigTypes.ini',"config",'inv_types',$default_inv_types);
   };
   print($inv_types); ?>];
   $scope.pm=[<?
       $num_pm=ini_get('/config/EZConfig.ini',"config",'pm_count',0);
     //  $pm_used=array();
        $pm_arr=explode($pm_types,',');
        
       $pm_used=indexed_array(1,sizeof($pm_arr));
       $prefix='';
       for ($d=0;$d<$num_pm;$d++) {
            $addr=ini_get("/config/EZConfig.ini","config","pm".$d."_id",0);
            $bus=ini_get("/config/EZConfig.ini","config","pm".$d."_bus",0);
            $name=ini_get("/config/EZConfig.ini","config","pm".$d."_device_name","");
            $idx=ini_get("/config/EZConfig.ini","config","pm".$d."_device_idx",0);
            
            $pm_used[$idx]=1;
            $st=$prefix."{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="bus:".$bus.",";
            $st.="name:\"".$name."\"}";
            $prefix=',';
            print($st);
            
       }
   ?>];
   <?
   //print_r($pm_used); 
   ?>
    $scope.inv=[<?
       $num_pm=ini_get('/config/EZConfig.ini',"config",'inv_count',0);
      $inv_arr=explode($inv_types,',');
       $inv_used=indexed_array(1,sizeof($inv_arr));
       
       $prefix='';
       for ($d=0;$d<$num_pm;$d++) {
            $addr=ini_get("/config/EZConfig.ini","config","inv".$d."_id",0);
            $bus=ini_get("/config/EZConfig.ini","config","inv".$d."_bus",0);
            $name=ini_get("/config/EZConfig.ini","config","inv".$d."_device_name","");
            $idx=ini_get("/config/EZConfig.ini","config","inv".$d."_device_idx",0);
            $inv_used[$idx]=1;
            $st=$prefix."{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="bus:".$bus.",";
            $st.="name:\"".$name."\"}";
            $prefix=',';

            print($st);
            
       }
   ?>];
    
   $scope.power_meters=[<?
        $pm_arr=explode($pm_types,',');
        
       $prefix2="";
       for ($d=0;$d<sizeof($pm_arr);$d++) {
            if ($pm_used[$d]==1) {
                $pm_roles_str=ini_get("/config/EZConfig.ini","config","dev".$pm_arr[$d]."_roles","");
                $pm_logfn_str=ini_get("/config/EZConfig.ini","config","dev".$pm_arr[$d]."_logfn","");
                if ($pm_logfn_str) {
                    $pm_logfn=explode($pm_logfn_str,',');
                } else $pm_logfn=array();
                
                if ($pm_roles_str) {
                    $pm_roles=explode($pm_roles_str,',');
                } else $pm_roles=array();
                
                $st=$prefix2."{device_type_id:".$pm_arr[$d].",";
                $st.="device_idx:".$d.",";
                $st.="name:\"".ini_get("/dev/dev".$pm_arr[$d].".ini","config","name","")." (".$pm_arr[$d].")\"";
                $num_roles=ini_get("/dev/dev".$pm_arr[$d].".ini","config","num_roles",0);
                $st.=",roles:[";
                 $prefix="";
                for ($r=0;$r<$num_roles;$r++) {
                    // role_var_0=
                    $rt=ini_get("/dev/dev".$pm_arr[$d].".ini","config","role_type_".$r,0);
                    $ri=ini_get("/dev/dev".$pm_arr[$d].".ini","config","role_idx_".$r,0);
                    
                    if ($rt==0) $var="do_desc_".$ri;
                    if ($rt==1) $var="di_desc_".$ri;
                    if ($rt==2) $var="ro_desc_".$ri;
                    if ($rt==3) $var="rw_desc_".$ri;
                    if ($rt==22) $var="ro_desc_".$ri;
                    if ($rt==23) $var="rw_desc_".$ri;
                    if (($rt>=24) && ($rt<=28)) $var="ro_desc_".$ri;
                    if ($rt==29) $var="rw_desc_".$ri;
                    if ($rt==30) $var="rw_desc_".$ri;
                    //print("r=".$r."\r\nrt=".$rt."\r\nri=".$ri."\r\nvar=".$var);
                    $role_desc=ini_get("/dev/dev".$pm_arr[$d].".ini","config",$var,"");
                    if (in_array($pm_roles, $r)) 
                        $sel="true";
                    else $sel="false";
                    $st.=$prefix."{role_idx:".$r.",role_name:\"".ini_get("/dev/dev".$pm_arr[$d].".ini","config","role_var_".$r,"")."\",\"role_desc\":\"".$role_desc."\",\"selected\":".$sel.",'logfn':".intval($pm_logfn[$r])."}"; //
                    $prefix=",";
                }
                 
                $st.="] }";
                $prefix2=",";
                print($st);
            }
            
       }
   ?>];
   $scope.other=[<?
       $num_other=ini_get('/config/EZConfig.ini',"config",'other_count',0);
       $other_arr=array();
       for ($d=0;$d<$num_other;$d++) {
            $addr=ini_get("/config/EZConfig.ini","config","other".$d."_id",0);
            $bus=ini_get("/config/EZConfig.ini","config","other".$d."_bus",0);
            $device_type_id=ini_get("/config/EZConfig.ini","config","other".$d."_device_type_id",0);
            $name=ini_get("/config/EZConfig.ini","config","other".$d."_device_name","");
            $idx=ini_get("/config/EZConfig.ini","config","other".$d."_idx",0);
            $found=0;
            for ($i=0;$i<sizeof($other_arr);$i++) {
                if ($other_arr[$i]==$device_type_id)
                    $found=1;
            }
            if (!$found)
                $other_arr[]=$device_type_id;

            $st="{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="device_type_id:".$device_type_id.",";
            $st.="bus:".$bus.",";
            $st.="name:\"".$name."\"},";
            print($st);
            
       }
   ?>];
   $scope.other_devices=[<?

       $prefix2="";
       for ($d=0;$d<sizeof($other_arr);$d++) {
                $other_roles_str=ini_get("/config/EZConfig.ini","config","dev".$other_arr[$d]."_roles","");
                $other_logfn_str=ini_get("/config/EZConfig.ini","config","dev".$other_arr[$d]."_logfn","");
                $other_names_str=ini_get("/config/EZConfig.ini","config","dev".$other_arr[$d]."_names","");
                if ($other_logfn_str) {
                    $other_logfn=explode($other_logfn_str,',');
                } else $other_logfn=array();
                
                if ($other_roles_str) {
                    $other_roles=explode($other_roles_str,',');
                } else $other_roles=array();
                
                if ($other_names_str) {
                    $other_names=explode($other_names_str,',');
                } else $other_names=array();
                
                $st=$prefix2."{device_type_id:".$other_arr[$d].",";
                $st.="device_idx:".$d.",";
                $st.="name:\"".ini_get("/dev/dev".$other_arr[$d].".ini","config","name","")." (".$other_arr[$d].")\"";
                $num_roles=ini_get("/dev/dev".$other_arr[$d].".ini","config","num_roles",0);
                $st.=",roles:[";
                 $prefix="";
                for ($r=0;$r<$num_roles;$r++) {
                    // role_var_0=
                    $rt=ini_get("/dev/dev".$other_arr[$d].".ini","config","role_type_".$r,0);
                    $ri=ini_get("/dev/dev".$other_arr[$d].".ini","config","role_idx_".$r,0);
                    
                    if ($rt==0) $var="do_desc_".$ri;
                    if ($rt==1) $var="di_desc_".$ri;
                    if ($rt==2) $var="ro_desc_".$ri;
                    if ($rt==3) $var="rw_desc_".$ri;
                    if ($rt==22) $var="ro_desc_".$ri;
                    if ($rt==23) $var="rw_desc_".$ri;
                    if (($rt>=24) && ($rt<=28)) $var="ro_desc_".$ri;
                    if ($rt==29) $var="rw_desc_".$ri;
                    if ($rt==30) $var="rw_desc_".$ri;
                    //print("r=".$r."\r\nrt=".$rt."\r\nri=".$ri."\r\nvar=".$var);
                    $role_desc=ini_get("/dev/dev".$other_arr[$d].".ini","config",$var,"");
                    if (in_array($other_roles, $r)) 
                        $sel="true";
                    else $sel="false";
                    $n=$other_names[$r];
                    if (!$n) 
                        $n=ini_get("/dev/dev".$other_arr[$d].".ini","config","role_var_".$r,"");
                    $st.=$prefix."{role_idx:".$r.",role_name:\"".$n."\",\"role_desc\":\"".$role_desc."\",\"selected\":".$sel.",'logfn':".intval($other_logfn[$r])."}"; //
                    $prefix=",";
                }
                 
                $st.="] }";
                $prefix2=",";
                print($st);
            
            
       }
   ?>];
   
   $scope.inverters=[<?
        $inv_arr=explode($inv_types,',');
        
      $prefix2="";
       for ($d=0;$d<sizeof($inv_arr);$d++) {
            if ($inv_used[$d]) {
                $inv_roles_str=ini_get("/config/EZConfig.ini","config","dev".$inv_arr[$d]."_roles","");
                if ($inv_roles_str) {
                    $inv_roles=explode($inv_roles_str,',');
                } else $inv_roles=array();
                
                $inv_logfn_str=ini_get("/config/EZConfig.ini","config","dev".$inv_arr[$d]."_logfn","");
                if ($inv_logfn_str) {
                    $inv_logfn=explode($inv_logfn_str,',');
                } else $inv_logfn=array();
            
                $st=$prefix2."{device_type_id:".$inv_arr[$d].",";
                $st.="device_idx:".$d.",";
                $st.="name:\"".ini_get("/dev/dev".$inv_arr[$d].".ini","config","name","")." (".$inv_arr[$d].")\"";
                $num_roles=ini_get("/dev/dev".$inv_arr[$d].".ini","config","num_roles",0);
                $st.=",roles:[";
                $prefix="";
                if ($inv_arr[$d]==7000) {       // Delta Inverter - Special Case
                    $st.=$prefix."{role_idx:0,role_name:\"AC_Voltage_AN\",\"role_desc\":\"AC Voltage Phase A to Neutral\",\"selected\":".(in_array($inv_roles,0)?"true":"false").",\"logfn\":".intval($inv_logfn[0])."},";
                    $st.=$prefix."{role_idx:1,role_name:\"AC_Voltage_BN\",\"role_desc\":\"AC Voltage Phase B to Neutral\",\"selected\":".(in_array($inv_roles,1)?"true":"false").",\"logfn\":".intval($inv_logfn[1])."},";
                    $st.=$prefix."{role_idx:2,role_name:\"AC_Voltage_CN\",\"role_desc\":\"AC Voltage Phase C to Neutral\",\"selected\":".(in_array($inv_roles,2)?"true":"false").",\"logfn\":".intval($inv_logfn[2])."},";
                    $st.=$prefix."{role_idx:3,role_name:\"AC_Current_A\",\"role_desc\":\"AC Current Phase A\",\"selected\":".(in_array($inv_roles,3)?"true":"false").",\"logfn\":".intval($inv_logfn[3])."},";
                    $st.=$prefix."{role_idx:4,role_name:\"AC_Current_B\",\"role_desc\":\"AC Current Phase B\",\"selected\":".(in_array($inv_roles,4)?"true":"false").",\"logfn\":".intval($inv_logfn[4])."},";
                    $st.=$prefix."{role_idx:5,role_name:\"AC_Current_C\",\"role_desc\":\"AC Current Phase C\",\"selected\":".(in_array($inv_roles,5)?"true":"false").",\"logfn\":".intval($inv_logfn[5])."},";
                    $st.=$prefix."{role_idx:6,role_name:\"AC_Active_Power_A\",\"role_desc\":\"AC Active Power Phase A\",\"selected\":".(in_array($inv_roles,6)?"true":"false").",\"logfn\":".intval($inv_logfn[6])."},";
                    $st.=$prefix."{role_idx:7,role_name:\"AC_Active_Power_B\",\"role_desc\":\"AC Active Power Phase B\",\"selected\":".(in_array($inv_roles,7)?"true":"false").",\"logfn\":".intval($inv_logfn[7])."},";
                    $st.=$prefix."{role_idx:8,role_name:\"AC_Active_Power_C\",\"role_desc\":\"AC Active Power Phase C\",\"selected\":".(in_array($inv_roles,8)?"true":"false").",\"logfn\":".intval($inv_logfn[8])."},";
                    $st.=$prefix."{role_idx:9,role_name:\"AC_Frequency_A\",\"role_desc\":\"AC Frequency Phase A\",\"selected\":".(in_array($inv_roles,9)?"true":"false").",\"logfn\":".intval($inv_logfn[9])."},";
                    $st.=$prefix."{role_idx:10,role_name:\"AC_Frequency_B\",\"role_desc\":\"AC Frequency Phase B\",\"selected\":".(in_array($inv_roles,10)?"true":"false").",\"logfn\":".intval($inv_logfn[10])."},";
                    $st.=$prefix."{role_idx:11,role_name:\"AC_Frequency_C\",\"role_desc\":\"AC Frequency Phase C\",\"selected\":".(in_array($inv_roles,11)?"true":"false").",\"logfn\":".intval($inv_logfn[11])."},";
                    print($st);
                    $st="";
                    $st.=$prefix."{role_idx:12,role_name:\"AC_Active_Power\",\"role_desc\":\"Total AC Active Power\",\"selected\":".(in_array($inv_roles,12)?"true":"false").",\"logfn\":".intval($inv_logfn[12])."},";
                    $st.=$prefix."{role_idx:13,role_name:\"DC_Power\",\"role_desc\":\"Total DC Power\",\"selected\":".(in_array($inv_roles,13)?"true":"false").",\"logfn\":".intval($inv_logfn[13])."},";
                    $st.=$prefix."{role_idx:14,role_name:\"DC_Current\",\"role_desc\":\"Total DC Current\",\"selected\":".(in_array($inv_roles,14)?"true":"false").",\"logfn\":".intval($inv_logfn[14])."},";
                    
                    $st.=$prefix."{role_idx:15,role_name:\"kWh_Total_Active\",\"role_desc\":\"Lifetime Generation\",\"selected\":".(in_array($inv_roles,15)?"true":"false").",\"logfn\":".intval($inv_logfn[15])."},";
                    $st.=$prefix."{role_idx:16,role_name:\"kWh_Day_Active\",\"role_desc\":\"Daily Generation\",\"selected\":".(in_array($inv_roles,16)?"true":"false").",\"logfn\":".intval($inv_logfn[16])."},";
                    $st.=$prefix."{role_idx:17,role_name:\"Status_Code\",\"role_desc\":\"Vendor-defined Operating State\",\"selected\":".(in_array($inv_roles,17)?"true":"false").",\"logfn\":".intval($inv_logfn[17])."},";
                
                    $st.=$prefix."{role_idx:18,role_name:\"Event_Code\",\"role_desc\":\"Vendor-defined Events & Errors\",\"selected\":".(in_array($inv_roles,18)?"true":"false").",\"logfn\":".intval($inv_logfn[18])."},";
                    $st.=$prefix."{role_idx:19,role_name:\"Power_Limit_Percent\",\"role_desc\":\"Power Limit Percent\",\"selected\":".(in_array($inv_roles,19)?"true":"false").",\"logfn\":".intval($inv_logfn[19])."}";
                } else {
                    for ($r=0;$r<$num_roles;$r++) {
                        // role_var_0=
                    $rt=ini_get("/dev/dev".$inv_arr[$d].".ini","config","role_type_".$r,0);
                    $ri=ini_get("/dev/dev".$inv_arr[$d].".ini","config","role_idx_".$r,0);
                    
                    if ($rt==0) $var="do_desc_".$ri;
                    if ($rt==1) $var="di_desc_".$ri;
                    if ($rt==2) $var="ro_desc_".$ri;
                    if ($rt==31) $var="ro_desc_".$ri;
                    if ($rt==3) $var="rw_desc_".$ri;
                    if ($rt==22) $var="ro_desc_".$ri;
                    if ($rt==23) $var="rw_desc_".$ri;
                    if (($rt>=24) && ($rt<=28)) $var="ro_desc_".$ri;
                    if ($rt==29) $var="rw_desc_".$ri;
                    if ($rt==30) $var="rw_desc_".$ri;
                    //print("r=".$r."\r\nrt=".$rt."\r\nri=".$ri."\r\nvar=".$var);
                    if (in_array($inv_roles, $r)) 
                        $sel="true";
                    else $sel="false";
                    $role_desc=ini_get("/dev/dev".$inv_arr[$d].".ini","config",$var,"");                        
                        $st.=$prefix."{role_idx:".$r.",role_name:\"".
                            ini_get("/dev/dev".$inv_arr[$d].".ini","config","role_var_".$r,"")."\",\"role_desc\":\"".
                            $role_desc."\",\"selected\":".$sel.",\"logfn\":".intval($inv_logfn[$r])."}"; /**/
                        $prefix=",";
                    }
                }
                
                $st.="] }";
                $prefix2=",";
                print($st);
            }
            
       } ?>
   ];

   $scope.loading=0;
   $gscope=$scope;


    $scope.setMeterFn=function(fntype) {
        for (i=0;i<$scope.power_meters.length;i++) {
            for (j=0;j<$scope.power_meters[i].roles.length;j++) {
                $scope.power_meters[i].roles[j].logfn=fntype;
            }
        }
    }
    $scope.setOtherFn=function(fntype) {
        for (i=0;i<$scope.other_devices.length;i++) {
            for (j=0;j<$scope.other_devices[i].roles.length;j++) {
                $scope.other_devices[i].roles[j].logfn=fntype;
            }
        }
    }
    
    $scope.setInvFn=function(fntype) {
        for (i=0;i<$scope.inverters.length;i++) {
            for (j=0;j<$scope.inverters[i].roles.length;j++) {
                $scope.inverters[i].roles[j].logfn=fntype;
            }
        }
    }
    $scope.makeRole=function(itemid) {
        str='';
        switch (Number(itemid)) {
        <? //for ($i=0;$i<$roles['num_roles'];$i++) { 
            $nr=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($i=0;$i<$nr;$i++) { 
            //print("<option value='"+$i+"'>"+ini_get("/config/roles.ini","roles",'role'+$i)+"</option>");
            print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
            }
            
            //}
            ?>
      } 

      return str;

  }

   $scope.prev=function() {
        document.location='/app/ezconfig_lite.cgi?stage=1';
   }

   $scope.saveSettings=function(moveNext) {
       post_data="";
        //alert('save ');
        for (i=0;i<$scope.power_meters.length;i++) {
            //alert($scope.power_meters[i].roles.length);
            roles="";
            fn="";
            prefix="";
            fnprefix="";
            for (r=0;r<$scope.power_meters[i].roles.length;r++) {
                //alert($scope.power_meters[i].roles[r].selected);
                fn=fn+(fnprefix+$scope.power_meters[i].roles[r].logfn);
                fnprefix=",";
                if ($scope.power_meters[i].roles[r].selected) {
                    //alert("selected "+r);
                    roles=roles+prefix+r;
                    
                    prefix=",";
                }
            }
            if (post_data.length) post_data=post_data+"&";
            post_data+="dev"+$scope.power_meters[i].device_type_id+"_roles="+roles;
            post_data+="&dev"+$scope.power_meters[i].device_type_id+"_logfn="+fn;

        }
        for (i=0;i<$scope.other_devices.length;i++) {
            roles="";
            fn="";
            prefix="";
            fnprefix="";
            names="";
            for (r=0;r<$scope.other_devices[i].roles.length;r++) {
                //alert($scope.power_meters[i].roles[r].selected);
                fn=fn+(fnprefix+$scope.other_devices[i].roles[r].logfn);
                names=names+fnprefix+$scope.other_devices[i].roles[r].role_name;
                fnprefix=",";
                
                if ($scope.other_devices[i].roles[r].selected) {
                    //alert("selected "+r);
                    roles=roles+prefix+r;
                    
                    prefix=",";
                }
                
            }
            if (post_data.length) post_data=post_data+"&";
            post_data+="dev"+$scope.other_devices[i].device_type_id+"_roles="+roles;
            post_data+="&dev"+$scope.other_devices[i].device_type_id+"_logfn="+fn;
            post_data+="&dev"+$scope.other_devices[i].device_type_id+"_names="+names;

        }
        for (i=0;i<$scope.inverters.length;i++) {
            roles="";
            fn="";
            prefix="";
            fnprefix="";
            for (r=0;r<$scope.inverters[i].roles.length;r++) {
                //alert($scope.power_meters[i].roles[r].selected);
                fn=fn+fnprefix+$scope.inverters[i].roles[r].logfn;
                fnprefix=",";
                if ($scope.inverters[i].roles[r].selected) {
                    //alert("selected "+r);
                    roles=roles+prefix+r;
                    
                    prefix=",";
                }
            }
            if (post_data.length) post_data=post_data+"&";
            post_data+="dev"+$scope.inverters[i].device_type_id+"_roles="+roles;
            post_data+="&dev"+$scope.inverters[i].device_type_id+"_logfn="+fn;
        }
       post_config="EZConfig.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          if (moveNext) {
            document.location='/app/ezconfig_lite.cgi?stage=3';
          }
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
</script>
<? } // stage=2

/********************************************************************************************************* STAGE 3 */        
if ($_GET['stage']==3) { ?>


<!-- NAVBAR -->
<h4><i class="icon-cog"></i>&nbsp;EZConfigLite Stage 2: R</h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
        <? print(lang('HELP','ezconfig')) ?>   
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','ezconfig')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link " ng-hide='loading==1' ng-click="prev()" ><i class="icon-back"></i> <? print(lang('PREVIOUS','ezconfig')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link " ng-hide='loading==1' ng-click="generate()" ><i class="icon-cog"></i> <? print(lang('GENERATE','ezconfig')) ?></a>
  </li>

</ul>

<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','ezconfig')) ?></div>
<form name="form" class="css-form form-horizontal" novalidate>

<!-- VARIABLES -->
<? 
    $inv_cnt=ini_get("/config/EZConfig.ini","config",'inv_count',0);
    $pm_cnt=ini_get("/config/EZConfig.ini","config",'pm_count',0);
    $ez_arr = ini_get_array("/config/EZConfig.ini","config");
?>            

<div ng-init="inv_count=<? print($inv_cnt); ?>;">
<div ng-init="pm_count=<? print($pm_cnt); ?>;">

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('S3_TITLE','ezconfig')) ?></h5>
        <p class="card-text">    
            <? print(lang('S3_2','ezconfig')) ?>
            <div class='alert alert-danger'><div class='row-fluid'><div class='pull-left'><i class="icon-warning-sign icon-4x"></i></div>
            <div style='margin-left:5em'><? print(lang('S3_3','ezconfig')) ?><br>
            <button class="btn btn-outline-secondary btn-large " ng-click="makeBackup()"><i class="icon-check"></i> <? print(lang('BACKUP_NOW','ezconfig')) ?></button></div></div>            
        </p>
    </div>
</div>
<br/>
<div class="card" >
    <div class="card-body">
        <h5 class="card-title"><? print(lang('REVIEW','ezconfig')) ?></h5>
        <h6 class="card-subtitle mb-2 text-muted"><? print(lang('REVIEW_SUB','ezconfig')) ?></h6>
        <p class="card-text">
            <div class="card" ng-hide='pm.length==0'>
                <div class="card-body">
                    <h5 class="card-title text-danger"><? print(lang('POWER_METERS','ezconfig')) ?></h5>
                    <p class="card-text">
                        <table class='table' summary="Inverters" >
                            <tr ng-repeat="item in pm">
                                <td><a name='pm{{$index}}'></a><span class="badge badge-danger badge-pill">{{item.id}}</span></td>
                                
                                <td><h5 class='badge badge-secondary'><strong>{{item.name}} on {{makeBus(item.bus)}}</strong></h5></td>
                                <td><strong>{{power_meters[item.device_idx].name}}</strong>
                                <table class='table table-striped' summary="Roles" >
                                    <tr>
                                    <td scope="col"><strong>Role</strong></td>
                                    <td scope="col"><strong>Description</strong></td>
                                    </tr>
                                    <tr ng-repeat="role in power_meters[item.device_idx].roles" ng-show='role.selected==true'>
                                        <td><strong>{{item.name}}_{{role.role_name}}</strong></td>
                                        <td><i>{{role.role_desc}}</i></td>
                                    </tr>
                                </table>
                                </td>            
                            </tr>
                        </table> 
                    </p>
                </div>
            </div>
            <br/>
            <div class="card" ng-hide='inv.length==0'>
                <div class="card-body">
                    <h5 class="card-title text-danger"><? print(lang('INVERTERS','ezconfig')) ?></h5>
                    <p class="card-text">
                        <table class='table' summary="Inverters" >
                            <tr ng-repeat="item in inv">
                                <td><a name='inv{{$index}}'></a><span class="badge badge-success badge-pill">{{item.id}}</span></td>
                                <td><h5 class='badge badge-secondary'><strong>{{item.name}} on {{makeBus(item.bus)}}</strong></h5></td>
                                <td><strong>{{inverters[item.device_idx].name}}</strong>
                                <table class='table table-striped' summary="Roles" >
                                    <tr>
                                    <td scope="col"><strong>Role</strong></td>
                                    <td scope="col"><strong>Description</strong></td>
                                    </tr>
                                    <tr ng-repeat="role in inverters[item.device_idx].roles" ng-show='role.selected==true'>
                                        <td><strong>{{item.name}}_{{role.role_name}}</strong></td>
                                        <td><i>{{role.role_desc}}</i></td>
                                    </tr>
                                </table>
                                </td>            
                            </tr>
                        </table> 
                    </p>
                </div>
            </div>
            <br/>
            <div class="card" ng-hide='other.length==0'>
                <div class="card-body">
                    <h5 class="card-title text-primary"><? print(lang('OTHER_DEVICES','ezconfig')) ?></h5>
                    <p class="card-text">
                        <table class='table' summary="Other Devices" >
                            <tr ng-repeat="item in other">
                                <td><a name='other{{$index}}'></a><span class="badge badge-primary badge-pill">{{item.id}}</span></td>
                                <td><h5 class='badge badge-secondary'><strong>{{item.name}} on {{makeBus(item.bus)}}</strong></h5></td>
                                <td><strong>{{other_devices[$index].name}}</strong>
                                <table class='table table-striped' summary="Roles" >
                                    <tr>
                                    <td scope="col"><strong>Role</strong></td>
                                    <td scope="col"><strong>Description</strong></td>
                                    </tr>
                                    <tr ng-repeat="role in other_devices[$index].roles" ng-show='role.selected==true'>
                                        <td><strong>{{makeOtherPrefix(item)}}{{role.role_name}}</strong></td>
                                        <td><i>{{role.role_desc}}</i></td>
                                    </tr>
                                </table>
                                </td>            
                            </tr>
                        </table> 
                    </p>
                </div>
            </div>
            
        </p>
    </div>
</div>

</form>
<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

function EZConfigWidget($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   //4028,4099,4098,4024,4023
    $scope.power_meter_types=[<? 
   $pm_types=ini_get('/config/EZConfigTypes.ini',"config",'pm_types','');
   $done=0;
   $cnt=2;
   while (!$done) {
    $pm_types2=ini_get('/config/EZConfigTypes.ini',"config",'pm_types'.$cnt,'');
    if ($pm_types2) {
        $pm_types.=",".$pm_types2;
        $cnt++;
    } else $done=1;
   }
   if (!$pm_types) {
        $pm_types=$default_pm_types;
        ini_set('/config/EZConfigTypes.ini',"config",'pm_types',$default_pm_types);
   };
   print($pm_types); ?>]; 
   //2900,2901,4580,4134,4133,3360,4789,4790
   $scope.inverter_types=[<? $inv_types=ini_get('/config/EZConfigTypes.ini',"config",'inv_types','');
   $done=0;
   $cnt=2;
   while (!$done) {
    $pm_types2=ini_get('/config/EZConfigTypes.ini',"config",'inv_types'.$cnt,'');
    if ($pm_types2) {
        $inv_types.=",".$pm_types2;
        $cnt++;
    } else $done=1;
   }
   if (!$inv_types) {
        $inv_types=$default_inv_types;
        ini_set('/config/EZConfigTypes.ini',"config",'inv_types',$default_inv_types);
   };
   print($inv_types); ?>];
   $scope.pm=[<?
       $num_pm=ini_get('/config/EZConfig.ini',"config",'pm_count',0);
     //  $pm_used=array();
        $pm_arr=explode($pm_types,',');
        
       $pm_used=indexed_array(1,sizeof($pm_arr));
       $prefix='';
       for ($d=0;$d<$num_pm;$d++) {
            $addr=ini_get("/config/EZConfig.ini","config","pm".$d."_id",0);
            $bus=ini_get("/config/EZConfig.ini","config","pm".$d."_bus",0);
            $name=ini_get("/config/EZConfig.ini","config","pm".$d."_device_name","");
            $idx=ini_get("/config/EZConfig.ini","config","pm".$d."_device_idx",0);
            
            $pm_used[$idx]=1;
            $st=$prefix."{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="bus:".$bus.",";
            $st.="name:\"".$name."\"}";
            $prefix=',';
            print($st);
            
       }
   ?>];
   <?
   //print_r($pm_used); 
   ?>
    $scope.inv=[<?
       $num_pm=ini_get('/config/EZConfig.ini',"config",'inv_count',0);
      $inv_arr=explode($inv_types,',');
       $inv_used=indexed_array(1,sizeof($inv_arr));
       
       $prefix='';
       for ($d=0;$d<$num_pm;$d++) {
            $addr=ini_get("/config/EZConfig.ini","config","inv".$d."_id",0);
            $bus=ini_get("/config/EZConfig.ini","config","inv".$d."_bus",0);
            $name=ini_get("/config/EZConfig.ini","config","inv".$d."_device_name","");
            $idx=ini_get("/config/EZConfig.ini","config","inv".$d."_device_idx",0);
            $inv_used[$idx]=1;
            $st=$prefix."{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="bus:".$bus.",";
            $st.="name:\"".$name."\"}";
            $prefix=',';

            print($st);
            
       }
   ?>];

   $scope.power_meters=[<?
        $pm_arr=explode($pm_types,',');
        
       $prefix2="";
       for ($d=0;$d<sizeof($pm_arr);$d++) {
            if ($pm_used[$d]==1) {
                $pm_roles_str=ini_get("/config/EZConfig.ini","config","dev".$pm_arr[$d]."_roles","");
                if ($pm_roles_str) {
                    $pm_roles=explode($pm_roles_str,',');
                } else $pm_roles=array();
                
                $st=$prefix2."{device_type_id:".$pm_arr[$d].",";
                $st.="device_idx:".$d.",";
                $st.="name:\"".ini_get("/dev/dev".$pm_arr[$d].".ini","config","name","")." (".$pm_arr[$d].")\"";
                $num_roles=ini_get("/dev/dev".$pm_arr[$d].".ini","config","num_roles",0);
                $st.=",roles:[";
                 $prefix="";
                for ($r=0;$r<$num_roles;$r++) {
                    // role_var_0=
                    $rt=ini_get("/dev/dev".$pm_arr[$d].".ini","config","role_type_".$r,0);
                    $ri=ini_get("/dev/dev".$pm_arr[$d].".ini","config","role_idx_".$r,0);
                    
                    if ($rt==0) $var="do_desc_".$ri;
                    if ($rt==1) $var="di_desc_".$ri;
                    if ($rt==31) $var="ro_desc_".$ri;
                    if ($rt==2) $var="ro_desc_".$ri;
                    if ($rt==3) $var="rw_desc_".$ri;
                    if ($rt==22) $var="ro_desc_".$ri;
                    if ($rt==23) $var="rw_desc_".$ri;
                    if (($rt>=24) && ($rt<=28)) $var="ro_desc_".$ri;
                    if ($rt==29) $var="rw_desc_".$ri;
                    if ($rt==30) $var="rw_desc_".$ri;
                    //print("r=".$r."\r\nrt=".$rt."\r\nri=".$ri."\r\nvar=".$var);
                    $role_desc=ini_get("/dev/dev".$pm_arr[$d].".ini","config",$var,"");
                    if (in_array($pm_roles, $r)) 
                        $sel="true";
                    else $sel="false";
                    $st.=$prefix."{role_idx:".$r.",role_name:\"".ini_get("/dev/dev".$pm_arr[$d].".ini","config","role_var_".$r,"")."\",\"role_desc\":\"".$role_desc."\",\"selected\":".$sel."}"; //
                    $prefix=",";
                }
                 
                $st.="] }\r\n";
                $prefix2=",";
                print($st);
            }  else {
                $st=$prefix2."{device_type_id:".$pm_arr[$d]."}\r\n";
                $prefix2=",";
                print($st); 
            }
            
       }
   ?>];
    $scope.other=[<?
       $num_other=ini_get('/config/EZConfig.ini',"config",'other_count',0);
       $other_arr=array();
       for ($d=0;$d<$num_other;$d++) {
            $addr=ini_get("/config/EZConfig.ini","config","other".$d."_id",0);
            $bus=ini_get("/config/EZConfig.ini","config","other".$d."_bus",0);
            $device_type_id=ini_get("/config/EZConfig.ini","config","other".$d."_device_type_id",0);
            $name=ini_get("/config/EZConfig.ini","config","other".$d."_device_name","");
            $idx=ini_get("/config/EZConfig.ini","config","other".$d."_idx",0);
            $found=0;
            for ($i=0;$i<sizeof($other_arr);$i++) {
                if ($other_arr[$i]==$device_type_id)
                    $found=1;
            }
            if (!$found)
                $other_arr[]=$device_type_id;

            $st="{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="device_type_id:".$device_type_id.",";
            $st.="bus:".$bus.",";
            $st.="name:\"".$name."\"},";
            print($st);
            
       }
   ?>];
   $scope.other_devices=[<?

       $prefix2="";
       for ($d=0;$d<sizeof($other_arr);$d++) {
                $other_roles_str=ini_get("/config/EZConfig.ini","config","dev".$other_arr[$d]."_roles","");
                $other_logfn_str=ini_get("/config/EZConfig.ini","config","dev".$other_arr[$d]."_logfn","");
                $other_names_str=ini_get("/config/EZConfig.ini","config","dev".$other_arr[$d]."_names","");
                if ($other_logfn_str) {
                    $other_logfn=explode($other_logfn_str,',');
                } else $other_logfn=array();
                
                if ($other_roles_str) {
                    $other_roles=explode($other_roles_str,',');
                } else $other_roles=array();
                
                if ($other_names_str) {
                    $other_names=explode($other_names_str,',');
                } else $other_names=array();
                
                $st=$prefix2."{device_type_id:".$other_arr[$d].",";
                $st.="device_idx:".$d.",";
                $st.="name:\"".ini_get("/dev/dev".$other_arr[$d].".ini","config","name","")." (".$other_arr[$d].")\"";
                $num_roles=ini_get("/dev/dev".$other_arr[$d].".ini","config","num_roles",0);
                $st.=",roles:[";
                 $prefix="";
                for ($r=0;$r<$num_roles;$r++) {
                    // role_var_0=
                    $rt=ini_get("/dev/dev".$other_arr[$d].".ini","config","role_type_".$r,0);
                    $ri=ini_get("/dev/dev".$other_arr[$d].".ini","config","role_idx_".$r,0);
                    
                    if ($rt==0) $var="do_desc_".$ri;
                    if ($rt==1) $var="di_desc_".$ri;
                    if ($rt==2) $var="ro_desc_".$ri;
                    if ($rt==3) $var="rw_desc_".$ri;
                    if ($rt==22) $var="ro_desc_".$ri;
                    if ($rt==23) $var="rw_desc_".$ri;
                    if (($rt>=24) && ($rt<=28)) $var="ro_desc_".$ri;
                    if ($rt==29) $var="rw_desc_".$ri;
                    if ($rt==30) $var="rw_desc_".$ri;
                    //print("r=".$r."\r\nrt=".$rt."\r\nri=".$ri."\r\nvar=".$var);
                    $role_desc=ini_get("/dev/dev".$other_arr[$d].".ini","config",$var,"");
                    if (in_array($other_roles, $r)) 
                        $sel="true";
                    else $sel="false";
                    $n=$other_names[$r];
                    if (!$n) 
                        $n=ini_get("/dev/dev".$other_arr[$d].".ini","config","role_var_".$r,"");
                    $st.=$prefix."{role_idx:".$r.",role_name:\"".$n."\",\"role_desc\":\"".$role_desc."\",\"selected\":".$sel.",'logfn':".intval($other_logfn[$r])."}"; //
                    $prefix=",";
                }
                 
                $st.="] }";
                $prefix2=",";
                print($st);
            
            
       }
   ?>];
   $scope.inverters=[<?
        $inv_arr=explode($inv_types,',');
        
      $prefix2="";
       $module_power_control=ini_get("/config/EZConfig.ini","config","module_power_control",0);
       for ($d=0;$d<sizeof($inv_arr);$d++) {
            if ($inv_used[$d]) {
                $inv_roles_str=ini_get("/config/EZConfig.ini","config","dev".$inv_arr[$d]."_roles","");
                if ($inv_roles_str) {
                    $inv_roles=explode($inv_roles_str,',');
                } else $inv_roles=array();
            
                $st=$prefix2."{device_type_id:".$inv_arr[$d].",";
                $st.="device_idx:".$d.",";
                $st.="name:\"".ini_get("/dev/dev".$inv_arr[$d].".ini","config","name","")." (".$inv_arr[$d].")\"";
                $num_roles=ini_get("/dev/dev".$inv_arr[$d].".ini","config","num_roles",0);
                $st.=",roles:[";
                $prefix="";
                if ($inv_arr[$d]==7000) {       // Delta Inverter - Special Case
                    $st.=$prefix."{role_idx:0,role_name:\"AC_Voltage_AN\",\"role_desc\":\"AC Voltage Phase A to Neutral\",\"selected\":".(in_array($inv_roles,0)?"true":"false")."},";
                    $st.=$prefix."{role_idx:1,role_name:\"AC_Voltage_BN\",\"role_desc\":\"AC Voltage Phase B to Neutral\",\"selected\":".(in_array($inv_roles,1)?"true":"false")."},";
                    $st.=$prefix."{role_idx:2,role_name:\"AC_Voltage_CN\",\"role_desc\":\"AC Voltage Phase C to Neutral\",\"selected\":".(in_array($inv_roles,2)?"true":"false")."},";
                    $st.=$prefix."{role_idx:3,role_name:\"AC_Current_A\",\"role_desc\":\"AC Current Phase A\",\"selected\":".(in_array($inv_roles,3)?"true":"false")."},";
                    $st.=$prefix."{role_idx:4,role_name:\"AC_Current_B\",\"role_desc\":\"AC Current Phase B\",\"selected\":".(in_array($inv_roles,4)?"true":"false")."},";
                    $st.=$prefix."{role_idx:5,role_name:\"AC_Current_C\",\"role_desc\":\"AC Current Phase C\",\"selected\":".(in_array($inv_roles,5)?"true":"false")."},";
                    $st.=$prefix."{role_idx:6,role_name:\"AC_Active_Power_A\",\"role_desc\":\"AC Active Power Phase A\",\"selected\":".(in_array($inv_roles,6)?"true":"false")."},";
                    $st.=$prefix."{role_idx:7,role_name:\"AC_Active_Power_B\",\"role_desc\":\"AC Active Power Phase B\",\"selected\":".(in_array($inv_roles,7)?"true":"false")."},";
                    $st.=$prefix."{role_idx:8,role_name:\"AC_Active_Power_C\",\"role_desc\":\"AC Active Power Phase C\",\"selected\":".(in_array($inv_roles,8)?"true":"false")."},";
                    $st.=$prefix."{role_idx:9,role_name:\"AC_Frequency_A\",\"role_desc\":\"AC Frequency Phase A\",\"selected\":".(in_array($inv_roles,9)?"true":"false")."},";
                    $st.=$prefix."{role_idx:10,role_name:\"AC_Frequency_B\",\"role_desc\":\"AC Frequency Phase B\",\"selected\":".(in_array($inv_roles,10)?"true":"false")."},";
                    $st.=$prefix."{role_idx:11,role_name:\"AC_Frequency_C\",\"role_desc\":\"AC Frequency Phase C\",\"selected\":".(in_array($inv_roles,11)?"true":"false")."},";
                    print($st);
                    $st="";
                    $st.=$prefix."{role_idx:12,role_name:\"AC_Active_Power\",\"role_desc\":\"Total AC Active Power\",\"selected\":".(in_array($inv_roles,12)?"true":"false")."},";
                    $st.=$prefix."{role_idx:13,role_name:\"DC_Power\",\"role_desc\":\"Total DC Power\",\"selected\":".(in_array($inv_roles,13)?"true":"false")."},";
                    $st.=$prefix."{role_idx:14,role_name:\"DC_Current\",\"role_desc\":\"Total DC Current\",\"selected\":".(in_array($inv_roles,14)?"true":"false")."},";
                    
                    $st.=$prefix."{role_idx:15,role_name:\"kWh_Total_Active\",\"role_desc\":\"Lifetime Generation\",\"selected\":".(in_array($inv_roles,15)?"true":"false")."},";
                    $st.=$prefix."{role_idx:16,role_name:\"kWh_Day_Active\",\"role_desc\":\"Daily Generation\",\"selected\":".(in_array($inv_roles,16)?"true":"false")."},";
                    $st.=$prefix."{role_idx:17,role_name:\"Status_Code\",\"role_desc\":\"Vendor-defined Operating State\",\"selected\":".(in_array($inv_roles,17)?"true":"false")."},";
                
                    $st.=$prefix."{role_idx:18,role_name:\"Event_Code\",\"role_desc\":\"Vendor-defined Events & Errors\",\"selected\":".(in_array($inv_roles,18)?"true":"false")."},";
                    $st.=$prefix."{role_idx:19,role_name:\"Power_Limit_Percent\",\"role_desc\":\"Power Limit Percent\",\"selected\":".(in_array($inv_roles,19)?"true":"false")."}";
                } else {
                    for ($r=0;$r<$num_roles;$r++) {
                        // role_var_0=
                    $rt=ini_get("/dev/dev".$inv_arr[$d].".ini","config","role_type_".$r,0);
                    $ri=ini_get("/dev/dev".$inv_arr[$d].".ini","config","role_idx_".$r,0);
                    
                    if ($rt==0) $var="do_desc_".$ri;
                    if ($rt==1) $var="di_desc_".$ri;
                    if ($rt==2) $var="ro_desc_".$ri;
                    if ($rt==31) $var="ro_desc_".$ri;
                    if ($rt==3) $var="rw_desc_".$ri;
                    if ($rt==22) $var="ro_desc_".$ri;
                    if ($rt==23) $var="rw_desc_".$ri;
                    if (($rt>=24) && ($rt<=28)) $var="ro_desc_".$ri;
                    if ($rt==29) $var="rw_desc_".$ri;
                    if ($rt==30) $var="rw_desc_".$ri;
                    //print("r=".$r."\r\nrt=".$rt."\r\nri=".$ri."\r\nvar=".$var);
                    if (in_array($inv_roles, $r)) 
                        $sel="true";
                    else $sel="false";
                    $role_desc=ini_get("/dev/dev".$inv_arr[$d].".ini","config",$var,"");                        
                        $st.=$prefix."{role_idx:".$r.",role_name:\"".
                            ini_get("/dev/dev".$inv_arr[$d].".ini","config","role_var_".$r,"")."\",\"role_desc\":\"".
                            $role_desc."\",\"selected\":".$sel."}"; /**/
                        $prefix=",";
                    }
                    if ($module_power_control) {
                        $st.=$prefix."{role_idx:".$r.",role_name:\"percent\",\"role_desc\":\"Active Power Limit Percent\",\"selected\":true}"; /**/
                    }

                }
                
                $st.="] }";
                $prefix2=",";
                print($st);
            }  else {
                $st=$prefix2."{device_type_id:".$inv_arr[$d]."}\r\n";
                $prefix2=",";
                print($st); 
            }
            
       } ?>
   ];

    $scope.bus=[{idx:0,name:"Modbus RTU (RS-485)"},
<? if ($_SERVER['HW_PLATFORM']==11 || $_SERVER['HW_PLATFORM']>=20) { ?>
   
        {idx:1,name:"Modbus RTU 2 (RS-485)"},
<? } ?>        
        {idx:2,name:"Modbus TCP Channel 1"},
        {idx:3,name:"Modbus TCP Channel 2"},
        {idx:4,name:"Modbus TCP Channel 3"},
        {idx:5,name:"Modbus TCP Channel 4"},
        {idx:6,name:"Modbus TCP Channel 5"},
        {idx:7,name:"Modbus TCP Channel 6"},
        {idx:8,name:"Modbus TCP Channel 7"},
        {idx:9,name:"Modbus TCP Channel 8"},
        {idx:10,name:"Modbus TCP Channel 9"},
        {idx:11,name:"Modbus TCP Channel 10"},
        {idx:100,name:"Virtual"},
        
    ];
    $scope.makeBus=function(bus_num) {
        for (i=0;i<$scope.bus.length;i++) {
            if ($scope.bus[i].idx==bus_num) return $scope.bus[i].name;
        }
        return "unknown";
    }
   $scope.loading=0;
   $gscope=$scope;



    $scope.makeRole=function(itemid) {
        str='';
        switch (Number(itemid)) {
        <? //for ($i=0;$i<$roles['num_roles'];$i++) { 
            $nr=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($i=0;$i<$nr;$i++) { 
            //print("<option value='"+$i+"'>"+ini_get("/config/roles.ini","roles",'role'+$i)+"</option>");
            print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
            }
            
            //}
            ?>
      } 

      return str;

  }
  $scope.makeOtherPrefix=function(item) {
    if (item.device_type_id==8010) return "";
    return item.name+"_";
  }
  $scope.makeBackup=function() {
     window.open("/app/backuprun.cgi?folder=/config/","_blank","scrollbars=yes");
     return true;
  }

   $scope.prev=function() {
        document.location='/app/ezconfig_lite.cgi?stage=2';
   }

   $scope.generate=function() {
     document.location='/app/ezconfig_lite.cgi?stage=4';
   }
}
   </script>
</div> 
<? } // stage=3


/********************************************************************************************************* STAGE 4 */        
if ($_GET['stage']==4) { ?>
<h4><i class="icon-cog"></i>&nbsp;EZConfigLite Stage 2: Generate Data</h4>

<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','ezconfig')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','ezconfig')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link " ng-hide='loading==1' ng-click="reboot()" ><i class="icon-check"></i> <? print(lang('REBOOT','ezconfig')) ?></a>
  </li>

</ul>

<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','ezconfig')) ?></div>
<form name="form" class="css-form form-horizontal" novalidate>
        <? 
            max_execution_time(60);

if ($_SERVER['HW_PLATFORM']>=20) {
    define("NUM_TCP_CHANNELS",20);
} else {
    define("NUM_TCP_CHANNELS",10);
}            
            $inv_cnt=ini_get("/config/EZConfig.ini","config",'inv_count',0);
            $pm_cnt=ini_get("/config/EZConfig.ini","config",'pm_count',0);
            $other_cnt=ini_get("/config/EZConfig.ini","config",'other_count',0);
            $ez_arr = ini_get_array("/config/EZConfig.ini","config");

    $plant_size=0;
    for ($n=0;$n<$ez_arr['inv_count'];$n++) {
        $plant_size += floatval($ez_arr['inv'.$n."_rating"]);
    }
            
            if (!$ez_arr['poll_interval']) $ez_arr['poll_interval']=1000;
            if (!$ez_arr['baud_rate']) $ez_arr['baud_rate']=9600;
            if (!$ez_arr['parity']) $ez_arr['parity']=0;
            
            if (($_SERVER['HW_PLATFORM']==11) || ($_SERVER['HW_PLATFORM']>=20)) {
                if (!$ez_arr['baud_rate2']) $ez_arr['baud_rate2']=9600;
                if (!$ez_arr['parity2']) $ez_arr['parity2']=0;
                
            }
            
            $f_csv_headers=fopen("/config/csv_headers.txt","w");
            $f_datalog=fopen("/config/datalog.ini","w");    
            $f_roles=fopen("/config/roles.ini","w");
            
            // the first role is a dummy
            $num_roles=1;
            
            $role_st="[roles]\r\n".
                "role0=Undefined\r\n".
                "role0_type=0\r\n";
            
            fwrite($f_roles,$role_st);
            
            fwrite($f_csv_headers,"ts");
            $static_header=intval($ez_arr['static_header']);
            
            ini_set("/config/dataexport.ini","export","static_header",$static_header);
            
            $datalog_st="[data]\r\nnum_groups=1\r\ngroup0name=Datalog\r\ngroup0type=0\r\ngroup0status=1\r\ngroup0interval=".$ez_arr['log_interval']."\r\ngroup0mins=".$ez_arr['log_write_interval']."\r\n";
            fwrite($f_datalog,$datalog_st);

            $st_devices="[general]
num_devices=".($inv_cnt+$pm_cnt+$other_cnt)+"
delay=".$ez_arr['interval']."
tcp_delay=".$ez_arr['tcp_interval']."
retry=".$ez_arr['timeout']."
tcp_retry=".$ez_arr['tcp_timeout']."
max_retries=".$ez_arr['retries']."
short_timeout=".$ez_arr['short_timeout']."
tcp_max_retries=".$ez_arr['tcp_retries']."
parity=".$ez_arr['parity']."
baud=".$ez_arr['baud_rate']."
timeout=".$ez_arr['timeout']."
tcp_timeout=".$ez_arr['tcp_timeout']."
modbus_tcp_enabled=".intval($ez_arr['tcp_enabled'])."
enabled=1
tcp_auto_close=0
";
if ($_SERVER['HW_PLATFORM']==11 || $_SERVER['HW_PLATFORM']>=20) {
    $st_devices.="parity2=".$ez_arr['parity2']."
baud2=".$ez_arr['baud_rate2']."
delay2=".$ez_arr['interval2']."
retry2=".$ez_arr['timeout2']."
timeout2=".$ez_arr['timeout2']."
enabled2=1
";
}
set_buffering(0);
for ($i=0;$i<NUM_TCP_CHANNELS;$i++) {
    $st_devices.="modbus_tcp_port".$i."=".$ez_arr['tcp'.$i.'_port']."\r\nmodbus_tcp_ip_address".$i."=".$ez_arr['tcp'.$i.'_ip'] ."\r\nmodbus_tcp_server".$i."=".$ez_arr['tcp'.$i.'_s']. "\r\n";

}
// stage 1 - generate the devices map
            $cur_device_id=0;
            setpriority(1);
            $f_device=fopen("/config/device.ini","w");
            $ts_start=microtime();
            print("Generating inverter data... free=".freemem()."<br>");
            $inverter_indexes=array();
            if ($use_qos) {
                // qos has 5 headers
                $headers1='DEVICE_TYPE';
                $headers2='DEVICE_NAME';
                $headers3='DEVICE_UUID';
                $headers4='SIGNAL_NAME';
                $headers5='SIGNAL_UNIT';
            }
            
            
            for ($i=0;$i<$inv_cnt;$i++) {
                
                //print("inverter ".$i);
                $st_devices.='[Device'.$cur_device_id."]\r\n";
                $st_devices.='name='.$ez_arr['inv'.$i.'_device_name']."\r\n";
                $st_devices.='address='.$ez_arr['inv'.$i.'_id']."\r\n";
                $st_devices.='params='.$ez_arr['inv'.$i.'_bus']."\r\n";
                $st_devices.='poll_interval='.$ez_arr['poll_interval']."\r\n";
                $st_devices.="status=1\r\n";
                $st_devices.='device_type_id='.$ez_arr['inv'.$i.'_device_type_id']."\r\n";
                $inverter_indexes[$i]=$cur_device_id;
                $inv_logfn_str=ini_get("/config/EZConfig.ini","config","dev".$ez_arr['inv'.$i.'_device_type_id']."_logfn","");
                if ($inv_logfn_str) {
                    $inv_logfn=explode($inv_logfn_str,',');
                } else $inv_logfn=array();

                
                if ($ez_arr['inv'.$i.'_device_type_id']!=7000) {        // delta gets special privileges
                    $roles=explode($ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_roles"],",");
                    if (!sizeof($roles)) 
                        $roles=array(intval($ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_roles"]));
                    //print("roles: ".$ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_roles"]);
                    //print_r($roles);
                    if ($use_qos) {
                        $qos_string=$ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_qostype"];
                        $cnt=1;
                        while (strlen($ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_qostype".$cnt])) {
                            $qos_string.=",".$ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_qostype".$cnt];
                            $cnt++;
                        }
                        $qostypes=explode($qos_string,",");
                        $qosdatatypes=explode($ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_qosdatatype"],",");
                        $qos_string=''; // free memory
                    }
                    if (!$use_fourth) {
                        for ($r=0;$r<sizeof($roles);$r++) {
                            // get the role name.
                            $rn=intval($roles[$r]);
                            $role_name=$ez_arr['inv'.$i.'_device_name']."_".ini_get("/dev/dev".$ez_arr['inv'.$i.'_device_type_id'].".ini","config","role_var_".$rn,"");
                            $rt=ini_get("/dev/dev".$ez_arr['inv'.$i.'_device_type_id'].".ini","config","role_type_".$rn,0);
                            if ($rt==0) $role_type=0;
                            if ($rt==1) $role_type=1;
                            if ($rt==2) $role_type=2;
                            if ($rt==31) $role_type=2;
                            if ($rt==3) $role_type=3;
                            if ($rt==22) $role_type=2;
                            if ($rt==23) $role_type=3;
                            if (($rt>=24) && ($rt<=28)) $role_type=2;
                            if ($rt==29) $role_type=3;
                            if ($rt==30) $role_type=3;
                            if ($rt==34) $role_type=3;
                            if ($rt==35) $role_type=3;
    
                            $st_devices.="role".$rn."_id=".$num_roles."\r\n";
                            $role_ids=$ez_arr['inv'.$i.'_device_type_id'];
                            $role_fn=$inv_logfn[$roles[$r]];
                            if (strpos($role_name,'AC_Active_Power')>=0) {
                                $role_grp=3;
                            } else $role_grp=0;
                            if ($use_qos) {
                                // add qos category
                                $headers1.=','.$ez_arr['inv'.$i.'_category'];
                                $headers2.=','.$ez_arr['inv'.$i.'_device_name'];
                                $headers3.=','.$cur_device_id;//cur_device;
                                $headers4.=','.$qostypes[$rn];
                                $headers5.=','.$qosdatatypes[$rn];
                            }
    
                            log_role($num_roles,$role_name,$role_type,$role_ids,$role_fn,$role_grp);
                            $num_roles++;
    
                        }
                    }
                } else {
                    $roles=explode($ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_roles"],",");
                    if (!sizeof($roles)) 
                        $roles=array(intval($ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_roles"]));
//                    print("roles: ".$ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_roles"]);
  //                  print_r($roles);
                    
                    for ($r=0;$r<sizeof($roles);$r++) {
                        // get the role name.
                        $rn=intval($roles[$r]);
                        if ($rn==0) $role_name="AC_Voltage_AN";
                        if ($rn==1) $role_name="AC_Voltage_BN";
                        if ($rn==2) $role_name="AC_Voltage_CN";
                        if ($rn==3) $role_name="AC_Current_A";
                        if ($rn==4) $role_name="AC_Current_B";
                        if ($rn==5) $role_name="AC_Current_C";
                        if ($rn==6) $role_name="AC_Active_Power_A";
                        if ($rn==7) $role_name="AC_Active_Power_B";
                        if ($rn==8) $role_name="AC_Active_Power_C";
                        if ($rn==9) $role_name="AC_Frequency_A";
                        if ($rn==10) $role_name="AC_Frequency_B";
                        if ($rn==11) $role_name="AC_Frequency_C";
                        if ($rn==12) $role_name="AC_Active_Power";
                        if ($rn==13) $role_name="DC_Power";
                        if ($rn==14) $role_name="DC_Current";
                        if ($rn==15) $role_name="kWh_Total_Active";
                        if ($rn==16) $role_name="kWh_Day_Active";
                        if ($rn==17) $role_name="Status_Code";
                        if ($rn==18) $role_name="Event_Code";
                        if ($rn==19) $role_name="Power_Limit_Percent";
                        $role_name=$ez_arr['inv'.$i.'_device_name']."_".$role_name;
                        $role_type=5;//$inv_logfn[$r];
                        //$role_ids=4580;
                        $role_ids=$ez_arr['inv'.$i.'_device_type_id'];
                        $role_fn=$inv_logfn[$roles[$r]];
                        $role_def=0;
                        if (strpos($role_name,'AC_Active_Power')>=0) {
                            $role_grp=3;
                            $role_def=7;
                        } else $role_grp=0;
                        log_role($num_roles,$role_name,$role_type,$role_ids,$role_fn,$role_grp,$role_def);
                        $num_roles++;

                }
                print("Inv ".$i."... free=".freemem()."<br>");
                //break;
            }
            fwrite($f_device,$st_devices);
            $st_devices='';
            
            if ($ez_arr['module_power_control'] && !$use_fourth) {
                //$role_name='inverter'.($i+1).'_percent';
                $role_name=$ez_arr['inv'.$i.'_device_name']."_percent";
                $role_type=5;
                $role_ids=0;
                $role_grp=0;
                $role_fn=2; // instantaneous
                if ($use_qos) {
                    $headers1.=','.$ez_arr['inv'.$i.'_category'];
                    $headers2.=','.$ez_arr['inv'.$i.'_device_name'];
                    $headers3.=','.$cur_device_id;
                    $headers4.=','.'POWER_LIMIT';
                    $headers5.=','.'%';
                }
                
                log_role($num_roles,$role_name,$role_type,$role_ids,$role_fn,$role_grp);
                $num_roles++;
                
            }
            $cur_device_id++;
        }
        print("Done in ".(microtime()-$ts_start)."ms free=".freemem()."<br>");
        $ts=microtime();
        
        print("Generating power meter data...");
        
        if ($use_fourth) {
            $pm_indexes=array();
        }
        for ($i=0;$i<$pm_cnt;$i++) {
                //print("inverter ".$i);
                $st_devices.='[Device'.$cur_device_id."]\r\n";
                $st_devices.='name='.$ez_arr['pm'.$i.'_device_name']."\r\n";
                $st_devices.='address='.$ez_arr['pm'.$i.'_id']."\r\n";
                $st_devices.='params='.$ez_arr['pm'.$i.'_bus']."\r\n";
                $st_devices.='poll_interval='.$ez_arr['poll_interval']."\r\n";
                $st_devices.="status=1\r\n";
                $st_devices.='device_type_id='.$ez_arr['pm'.$i.'_device_type_id']."\r\n";
                if ($use_fourth) {
                    $pm_indexes[]=$cur_device_id;
                }
                $roles=explode($ez_arr['dev'.$ez_arr['pm'.$i.'_device_type_id']."_roles"],",");
                if (!sizeof($roles)) 
                    $roles=array(intval($ez_arr['dev'.$ez_arr['pm'.$i.'_device_type_id']."_roles"]));
                $pm_logfn_str=ini_get("/config/EZConfig.ini","config","dev".$ez_arr['pm'.$i.'_device_type_id']."_logfn","");
                if ($pm_logfn_str) {
                    $pm_logfn=explode($pm_logfn_str,',');
                } else $pm_logfn=array();
                if ($use_qos) {
                    $qos_string=$ez_arr['dev'.$ez_arr['pm'.$i.'_device_type_id']."_qostype"];
                    $cnt=1;
                    while (strlen($ez_arr['dev'.$ez_arr['pm'.$i.'_device_type_id']."_qostype".$cnt])) {
                        $qos_string.=",".$ez_arr['dev'.$ez_arr['pm'.$i.'_device_type_id']."_qostype".$cnt];
                        $cnt++;
                    }
                    $qostypes=explode($qos_string,",");
                    $qos_string=''; // free memory
                    $qosdatatypes=explode($ez_arr['dev'.$ez_arr['pm'.$i.'_device_type_id']."_qosdatatype"],",");
                }
                if (!$use_fourth) {
                    for ($r=0;$r<sizeof($roles);$r++) {
                        // get the role name.
                        $rn=intval($roles[$r]);
                        $role_name=$ez_arr['pm'.$i.'_device_name']."_".ini_get("/dev/dev".$ez_arr['pm'.$i.'_device_type_id'].".ini","config","role_var_".$rn,"");
                        $rt=ini_get("/dev/dev".$ez_arr['pm'.$i.'_device_type_id'].".ini","config","role_type_".$rn,0);
                        if ($rt==0) $role_type=0;
                        if ($rt==1) $role_type=1;
                        if ($rt==2) $role_type=2;
                        if ($rt==31) $role_type=2;
                        if ($rt==3) $role_type=3;
                        if ($rt==22) $role_type=2;
                        if ($rt==23) $role_type=3;
                        if (($rt>=24) && ($rt<=28)) $role_type=2;
                        if ($rt==29) $role_type=3;
                        if ($rt==30) $role_type=3;
                        if ($rt==34) $role_type=3;
                        if ($rt==35) $role_type=3;
    
                        $st_devices.="role".$rn."_id=".$num_roles."\r\n";
                        $role_ids=$ez_arr['pm'.$i.'_device_type_id'];
                        $role_fn=$pm_logfn[$roles[$r]];
                        $role_grp=0;
                        fwrite($f_device,$st_devices);
     					$headers1.=','.$ez_arr['pm'.$i.'_category'];
                        $headers2.=','.$ez_arr['pm'.$i.'_device_name'];
                        $headers3.=','.$cur_device_id;
                        $headers4.=','.$qostypes[$rn];
                         $headers5.=','.$qosdatatypes[$rn];
                        
                        log_role($num_roles,$role_name,$role_type,$role_ids,$role_fn,$role_grp);
                        $num_roles++;
                        $st_devices='';
                    }
                }
           
            
            $cur_device_id++;
        }
        print("Done in ".(microtime()-$ts_start)."ms free=".freemem()."<br>");
        $ts=microtime();
        print("Generating other device data...");
        
        for ($i=0;$i<$other_cnt;$i++) {
                //print("inverter ".$i);
                $st_devices.='[Device'.$cur_device_id."]\r\n";
                $st_devices.='name='.$ez_arr['other'.$i.'_device_name']."\r\n";
                $st_devices.='address='.$ez_arr['other'.$i.'_id']."\r\n";
                $st_devices.='params='.$ez_arr['other'.$i.'_bus']."\r\n";
                $st_devices.='poll_interval='.$ez_arr['poll_interval']."\r\n";
                $st_devices.="status=1\r\n";
                $st_devices.='device_type_id='.$ez_arr['other'.$i.'_device_type_id']."\r\n";

                $roles=explode($ez_arr['dev'.$ez_arr['other'.$i.'_device_type_id']."_roles"],",");
                if (!sizeof($roles)) 
                    $roles=array(intval($ez_arr['dev'.$ez_arr['other'.$i.'_device_type_id']."_roles"]));
                $other_logfn_str=ini_get("/config/EZConfig.ini","config","dev".$ez_arr['other'.$i.'_device_type_id']."_logfn","");
                if ($other_logfn_str) {
                    $other_logfn=explode($other_logfn_str,',');
                } else $other_logfn=array();
                $other_names_str=ini_get("/config/EZConfig.ini","config","dev".$ez_arr['other'.$i.'_device_type_id']."_names","");
                if ($other_names_str) {
                    $other_names=explode($other_names_str,',');
                } else $other_names=array();
                
                if (intval($ez_arr['other'.$i.'_device_type_id'])==8010) {
                    
                    ini_set("/config/EZConfig.ini","config","pyra_role_id",$num_roles);
                }
                if ($use_qos) {
                     $qos_string=$ez_arr['dev'.$ez_arr['other'.$i.'_device_type_id']."_qostype"];
                    $cnt=1;
                    while (strlen($ez_arr['dev'.$ez_arr['other'.$i.'_device_type_id']."_qostype".$cnt])) {
                        $qos_string.=",".$ez_arr['dev'.$ez_arr['other'.$i.'_device_type_id']."_qostype".$cnt];
                        $cnt++;
                    }
                    $qostypes=explode($qos_string,",");
                    $qos_string=''; // free memory
                    $qosdatatypes=explode($ez_arr['dev'.$ez_arr['other'.$i.'_device_type_id']."_qosdatatype"],",");

                }
                if (!$use_fourth) {
                    
                    for ($r=0;$r<sizeof($roles);$r++) {
                        
                        // get the role name.
                        $rn=intval($roles[$r]);
                        $role_name=$other_names[$rn];
    //                    print($role_name.'---'.$ez_arr['other'.$i.'_device_type_id']."\r\n");
                        if (!$role_name) {
                        
                            if (intval($ez_arr['other'.$i.'_device_type_id'])==8010) {
                                $role_name=ini_get("/dev/dev".$ez_arr['other'.$i.'_device_type_id'].".ini","config","role_var_".$rn,"");
                            } else
                                $role_name=$ez_arr['other'.$i.'_device_name']."_".ini_get("/dev/dev".$ez_arr['other'.$i.'_device_type_id'].".ini","config","role_var_".$rn,"");
                        } else {
                            if (intval($ez_arr['other'.$i.'_device_type_id'])!=8010) {
                                if ($role_name=='Active_Irradiance') {
                                    ini_set("/config/Pyranometer.ini","config","scale",1);
                                    ini_set("/config/Pyranometer.ini","config","plant_size",$ez_arr['dc_plant_size']);
                                    ini_set("/config/Pyranometer.ini","config","pr_ratio",$ez_arr['fixed_pr']);
                                    ini_set("/config/Pyranometer.ini","config","pyra_role",$num_roles);
                                }
                                $role_name=$ez_arr['other'.$i.'_device_name']."_".$role_name;
                                
                            } else {
                                //$role_name=$ez_arr['other'.$i.'_device_name']."_".$role_name;
                            }
                        }
                        
                        $rt=ini_get("/dev/dev".$ez_arr['other'.$i.'_device_type_id'].".ini","config","role_type_".$rn,0);
                        if ($rt==0) $role_type=0;
                        if ($rt==1) $role_type=1;
                        if ($rt==2) $role_type=2;
                        if ($rt==31) $role_type=2;
                        if ($rt==3) $role_type=3;
                        if ($rt==22) $role_type=2;
                        if ($rt==23) $role_type=3;
                        if (($rt>=24) && ($rt<=28)) $role_type=2;
                        if ($rt==29) $role_type=3;
                        if ($rt==30) $role_type=3;
                        if ($rt==34) $role_type=3;
                        if ($rt==35) $role_type=3;
    
                        $st_devices.="role".$rn."_id=".$num_roles."\r\n";
                        //$role_types=$role_type;
                        $role_ids=$ez_arr['other'.$i.'_device_type_id'];
                        $role_fn=$other_logfn[$roles[$r]];
                        $role_grp=0;
                        
                        if ($use_qos) {
        					$headers1.=','.$ez_arr['other'.$i.'_category'];
                            $headers2.=','.$ez_arr['other'.$i.'_device_name'];
                            $headers3.=','.$cur_device_id;
                            $headers4.=','.$qostypes[$rn];
                            $headers5.=','.$qosdatatypes[$rn];
                        }
    
                        log_role($num_roles,$role_name,$role_type,$role_ids,$role_fn,$role_grp);
                        $num_roles++;
                        fwrite($f_device,$st_devices);
                        $st_devices='';
                    }
                }
                
            $cur_device_id++;
        }
        print("Done in ".(microtime()-$ts_start)."ms free=".freemem()."<br>");

        /*if ($ez_arr['pyranometer']) {
            $role_array[]="Active_Irradiance";
            $role_types[]=2;
            $role_ids[]=8010;
            $role_fn[]=3;
            $role_grp[]=0;
            $pyra_role_id=sizeof($role_array)-1;
            ini_set("/config/EZConfig.ini","config","pyra_role_id",$pyra_role_id);

            $role_array[]="kWh_Day_Irradiance";
            $role_types[]=2;
            $role_ids[]=8010;
            $role_fn[]=3;
            $role_grp[]=0;
            $pyra_role_id2=sizeof($role_array)-1;
        }*/
        
        if ($ez_arr['ws102'] && !$use_fourth) {
            $role_name="Wind_Speed";
            $role_type=2;
            $role_ids=8011;
            $role_fn=3;
            $role_grp=0;
            $ws102_role_id=$num_roles;
            if ($use_qos) {
                $headers1.=','.'WEATHER_STATION';
                $headers2.=','.'WATTMON';
                $headers3.=','.'VIRTUAL1';
                $headers4.=','.'WIND_SPEED';
                 $headers5.=','.'m/s';
            }

            log_role($num_roles,$role_name,$role_type,$role_ids,$role_fn,$role_grp);
            $num_roles++;            
            ini_set("/config/EZConfig.ini","config","ws102_role_id",$ws102_role_id);
        }
        /*if (ini_get('/config/PC.ini',"config",'eb_on',0)) {
            $role_name="eb_state";
            $role_type=5;
            $role_ids=0;
            $role_fn=3;
            $role_grp=0;
            log_role($num_roles,$role_name,$role_type,$role_ids,$role_fn,$role_grp);
            $num_roles++;
        }*/
        
        $logged_str=ini_get("/config/EZConfig.ini","config","logged_vars","");
        $logged_variables=explode($logged_str,','); 
        if (!$use_fourth) {
            for ($n=0;$n<sizeof($logged_variables);$n++) {
                $role_name=$logged_variables[$n];
                $role_type=5;
                $role_ids=0;
                $role_fn=3;
                $role_grp=0;
                if ($use_qos) {
                            $headers1.=','.'WEATHER_STATION';
                            $headers2.=','.'WATTMON';
                            $headers3.=','.'VIRTUAL2';
                            $headers4.=','.'VAR'.$n;
                            $headers5.=','.'';
                        }
                log_role($num_roles,$role_name,$role_type,$role_ids,$role_fn,$role_grp);
                $num_roles++;
            }
            
            if ($ez_arr['use_temp']) {
                    for ($i=0;$i<$ez_arr['num_temp'];$i++) {
                        $role_name=$ez_arr['ow'.$i."_name"];//Temperature".($i+1);
                        $role_type=4;
                        $role_ids=0;
                        $role_fn=3;
                        $role_grp=0;
                        if ($use_qos) {
                            $headers1.=','.'WEATHER_STATION';
                            $headers2.=','.'WATTMON';
                            $headers3.=','.'VIRTUAL2';
                            $headers4.=','.'TEMPERATURE';
                            $headers5.=','.'degree';
                        }
    
                        log_role($num_roles,$role_name,$role_type,$role_ids,$role_fn,$role_grp);
                        $ow_addr=$ez_arr['ow'.$i."_device_address"];
                        $num_ow=ini_get("/config/onewire.ini","general","num_devices",0);
                        
                        // add the matching role in the onewire.ini file
                        for ($k=0;$k<$num_ow;$k++) {
                            $add=ini_get("/config/onewire.ini","Device".$k,"address",'');
                            if ($add==$ow_addr) {
                                ini_set("/config/onewire.ini","Device".$k,"role0_id",$num_roles);
                                break;
                            }
                        }
                        $num_roles++;
                    }
            }
            
            
            }

            fwrite($f_datalog,"group0numvar=".($num_roles-1)."\r\n");
            fwrite($f_roles,"num_roles=".($num_roles)."\r\n");
            
        /*    print("<pre>");
            print_r($role_grp);
            print_r($role_array);
            
            print($st_devices);
            
            print($datalog_st);
            print($role_st);
            
            print("</p7re>");*/
            fwrite($f_device,$st_devices);
            
            fclose($f_device);
            
            
            fclose($f_roles);
            
            
            fclose($f_datalog);
            fclose($f_csv_headers);
            
            $f_package=fopen("/config/packages.ini","w");
            fwrite($f_package,"[packages]\r\n");
            $packages=explode($ez_arr['packages'],',');
            //print_r($packages);
            for ($k=0;$k<sizeof($packages);$k++) {
                
                if (file_exists("/package/".$packages[$k].".cgi")) {
                    fwrite($f_package,$packages[$k]."=2\r\n");
                }
/*            fwrite($f_package,"EZDisplay=2\r\n");
            if ($ez_arr['module_power_control']) {
                
                if (file_exists("/package/PC.cgi")) {
                    fwrite($f_package,"PC=2\r\n");
                }*/
            
				
            }
            if ($use_qos) {
                fwrite($f_package,"QOS=2\r\n");
            }

           fclose($f_package);
           // free up
           $packages=0;
           if ($use_qos) {
               //$headers=implode($headers1,',');
               
                $f=fopen("/config/qos_header.txt",'w');
                fwrite($f,$headers1);
                $headers1='';
                fwrite($f,"\r\n");
                //$headers='';
                //$headers=implode($headers2,',');
                
                fwrite($f,$headers2);
                $headers2='';
                //$headers='';
                fwrite($f,"\r\n");
                //$headers=implode($headers3,',');
                //$headers3='';
                fwrite($f,$headers3);
                $headers3='';
                fwrite($f,"\r\n");
                //$headers=implode($headers4,',');
                //$headers4='';
                fwrite($f,$headers4);
                $headers4='';
                fwrite($f,"\r\n");
                //$headers=implode($headers5,',');
                //$headers5='';
                fwrite($f,$headers5);
                $headers5='';
                fwrite($f,"\r\n");
                fclose($f);
                
                ini_set("/config/QOS.ini","config","QOS_sitename",$ez_arr['qos_prefix']);
                ini_set("/config/QOS.ini","config","QOS_path",$ez_arr['qos_path']);
                ini_set("/config/QOS.ini","config","QOS_url",$ez_arr['qos_server']);
                ini_set("/config/QOS.ini","config","QOS_username",$ez_arr['qos_username']);
                ini_set("/config/QOS.ini","config","QOS_password",str_replace('"','',$ez_arr['qos_password']));

           }


            $f_widget=fopen("/config/widget.ini","w");
            fwrite($f_widget,"[loggedin.main]\r\nnum_widgets=1\r\nw0_width=12\r\nw0_template=/package/EZDisplay.inc\r\nw0_title=Live Energy Overview\r\nw0_icon=icon-play");
            fclose($f_widget);
            ini_set("/config/setup.ini","setup","newsetup",0);
            ini_set("/config/runonce.ini","config","file","/app/ezconfig_boot.inc");
           
            // Sync power control
            ini_set("/config/license.ini","config","key1",$ez_arr['license_key']);

            
            
            
            if (file_exists("/config/PC.ini")) {
                
                
                $ts=microtime();
                print("Updating Power Control...<br>");
                
               
   $inv_cnt=ini_get("/config/EZConfig.ini","config",'inv_count',0);
   $pm_cnt=ini_get("/config/EZConfig.ini","config",'pm_count',0);

   $pc_arr = ini_get_array("/config/PC.ini","config");
   $num_dev=ini_get("/config/device.ini","general","num_devices",0);
   
   for ($i=0; $i < $pc_arr['pm_count']; $i++) {
       $pm_name=$pc_arr['pm'.$i.'_name'];
       
       for ($j=0;$j < $num_dev;$j++) {
            $dev_name=ini_get("/config/device.ini","Device".$j,"name","");
            if ($dev_name==$pm_name) {
                ini_set("/config/PC.ini","config",'pm'.$i.'_device_idx',$j);
                ini_set("/config/PC.ini","config",'pm'.$i.'_plant_size',$plant_size);
                //ini_set("/config/PC.ini","config",'pm'.$i.'_min',$ez_arr['pm'.$i.'_min']);
                //ini_set("/config/PC.ini","config",'pm'.$i.'_max',$ez_arr['pm'.$i.'_max']);
                
            }
       }
       
   }
   
                $inv_id=$pc_arr['inv'.$i.'_id'];
                
                for ($i=0; $i < $pc_arr['inv_count']; $i++) {
                   $inv_id=$pc_arr['inv'.$i.'_id'];
                   ini_set("/config/PC.ini","config",'inv'.$i.'_default_pc',$pc_arr['inv0_default_pc']);
                   for ($j=0;$j < $num_dev;$j++) {
                        $dev_id=ini_get("/config/device.ini","Device".$j,"address",0);
                        if ($dev_id==$inv_id) {
                            ini_set("/config/PC.ini","config",'inv'.$i.'_device_idx',$j);
                            
                        }
                   }
               }
               //if ($pc_arr['inv_count']<$inv_cnt) {
                   for ($i=0;$i<$inv_cnt;$i++) {
                       ini_set("/config/PC.ini","config",'inv'.$i.'_device_idx',$inverter_indexes[$i]);
                       ini_set("/config/PC.ini","config",'inv'.$i.'_device_type_id',$ez_arr['inv'.$i.'_device_type_id']);
                       ini_set("/config/PC.ini","config",'inv'.$i.'_id',$ez_arr['inv'.$i.'_id']);
                       ini_set("/config/PC.ini","config",'inv'.$i.'_bus',$ez_arr['inv'.$i.'_bus']); 
                       ini_set("/config/PC.ini","config",'inv'.$i.'_device_name',$ez_arr['inv'.$i.'_device_name']);
                       ini_set("/config/PC.ini","config",'inv'.$i.'_rating',$ez_arr['inv'.$i.'_rating']);
                       ini_set("/config/PC.ini","config",'inv'.$i.'_default_pc',$pc_arr['inv0_default_pc']);
                   }
               //}
               ini_set('/config/PC.ini',"config",'inv_count',$inv_cnt);
               print("Done in ".(microtime()-$ts_start)."ms<br>");
               $ts=microtime();
            //        print("Updating Power Control...");
               

                $inv_id=$pc_arr['inv'.$i.'_id'];
                

/* ez
inv1_device_type_id=7969
inv1_id=3
inv1_bus=2
inv1_device_name=inverter2
inv1_rating=11
inv1_device_idx=97

pc
inv0_name=inverter1
inv0_device_type_id=7092
inv0_id=2
inv0_bus=2
inv0_device_name=inverter1
inv0_device_idx=0
inv0_rating=33
inv0_pf=1
inv0_default_pc=100
inv0_group=0
*/

               
               print("Done in ".(microtime()-$ts_start)."ms<br>");
               $ts=microtime();
            //        print("Updating Power Control...");
               
                
            }
        
        
        print("Done in ".(microtime()-$ts_start)."ms<br>");
        $ts=microtime();
function log_role($role_num,$role_name,$role_type,$role_ids,$role_fn,$role_grp,$role_def) {
    global $f_csv_headers;
    global $f_datalog;
    global $f_roles;
    $datalog_st="group0var".($role_num-1)."vartype=2\r\ngroup0var".($role_num-1)."varval=".$role_num."\r\ngroup0var".($role_num-1)."varscale=1\r\ngroup0var".($role_num-1)."varfn=". $role_fn."\r\n";
    fwrite($f_datalog,$datalog_st);
    fwrite($f_csv_headers,",".$role_name);
    
    $role_st="role".$role_num."=".$role_name."\r\n";
    $role_st.="role".$role_num."ids=".$role_ids."\r\n";
    $role_st.="role".$role_num."type=".$role_type."\r\n";
    if ($role_grp) 
        $role_st.="role".$role_num."group=".$role_grp."\r\n";
    if ($role_def) 
        $role_st.="role".$role_num."def=".$role_def."\r\n";
        

    fwrite($f_roles,$role_st);

}        
//        print("Updating Power Control...");
   


        // generate static headers    
/*        $ini = ini_get_array("/config/dataexport.ini","export");

        $num_groups = ini_get("/config/datalog.ini","data","num_groups",0);
        $data='"ts",';
        for ($i=0;$i<$num_groups;$i++) {
            $s=ini_get("/config/datalog.ini","data",'group'+$i+'status',0);
            
            if ($s==1) {
    
                $logfile2 = "/logs/log_"+$i+".ini";
                //$arr=ini_get_array($logfile2);
                
                $grpnvar=ini_get("/config/datalog.ini","data",'group'+$i+"numvar",0);
                for ($j=0;$j<$grpnvar;$j++) {
                    $vt=ini_get("/config/datalog.ini","data",'group'+$i+'var'+$j+'vartype',0);
                    $vfn=ini_get("/config/datalog.ini","data",'group'+$i+'var'+$j+'varfn',0);
                    $vval=ini_get("/config/datalog.ini","data",'group'+$i+'var'+$j+'varval',0);
                    if ($vt==1) {  // system
                        $varst=ini_get("/config/sysvars.ini","sysvars","sysvar".$vval."name","");
                        $varr=explode($varst,';');
                        if ($varr[0]=='V') {
                            $varst=$varr[1];
                        } else {
                            if ($varr[0]=='G') {
                                $varst=$varr[2].$varr[1];
                            }
                        }
                    } else {
                        if ($vt==2) {  // device
                            $varst=ini_get("/config/roles.ini","roles","role".$vval,"");
                        }
                        if ($vt==3) {  // global
                            //$varst=$vval;
                             $varst=ini_get("/config/datalog.ini","data",'group'+$i+'var'+$j+'varval','');
                        }                
                    }
                    //$data.="\"".$varst."\":\"".$arr['data']['p'.$j]."\"";
                    $data.='"'.$varst.'"';
                    if ($j<($grpnvar-1)) $data.=",";
                }
    
            }
        }
        $fc=fopen("/config/csv_headers.txt","w");
        fwrite($fc,$data);
        $data='';
        fclose($fc);*/
        
            $f_widget=fopen("/config/widget.ini","w");
            fwrite($f_widget,"[loggedin.main]\r\nnum_widgets=1\r\nw0_width=12\r\nw0_template=/package/ezDisplay.inc\r\nw0_title=Live Energy Overview\r\nw0_icon=icon-play");
            fclose($f_widget);
            ini_set("/config/setup.ini","setup","newsetup",0);
            ini_set("/config/runonce.ini","config","file","/app/ezconfig_boot.inc");
           
            
        ?>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('SUCCESS','ezconfig')) ?></h5>
        <p class="card-text">    
            <? print(lang('S4_1','ezconfig')) ?><br>
            <strong><? print(($cur_device_id)); ?> <? print(lang('DEVICES','ezconfig')) ?></strong> <? print(lang('WERE_CREATED','ezconfig')) ?>.<p>
            <strong><? print(sizeof($role_array)); ?> <? print(lang('ROLES','ezconfig')) ?></strong> <? print(lang('WERE_CREATED','ezconfig')) ?>.<p>
            <? if ($ez_arr['ws102']) { ?>
                <strong> <? print(lang('WS102','ezconfig')) ?></strong> <? print(lang('WAS_INSTALLED','ezconfig')) ?>.<p>
            <? }
                if ($ez_arr['pyranometer']) { ?>
                <strong> <? print(lang('PYRA300','ezconfig')) ?></strong> <? print(lang('WAS_INSTALLED','ezconfig')) ?>.<p>
            <? } 
              if ($ez_arr['module_power_control']) { ?>
                <strong> <? print(lang('POWER_CONTROL','ezconfig')) ?></strong> <? print(lang('WAS_INSTALLED','ezconfig')) ?>.<p>
            <? }
                if ($ez_arr['module_devices']) { ?>
                <strong> <? print(lang('DEVICE_INFO','ezconfig')) ?></strong> <? print(lang('WAS_INSTALLED','ezconfig')) ?>.<p>
            <? }?>
                
            
        </p>
    </div>
</div>

</form>
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

function EZConfigWidget($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   //4028,4099,4098,4024,4023
   

   $scope.loading=0;
   $gscope=$scope;


   $scope.reboot=function() {
     document.location='/app/task.cgi?action=reboot';
   }
}
 </script>
<? } // stage=4
include("/app/footer.inc");
?>




