<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : devicetypes.cgi
 * 
 *  Description: Device Type manager page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *                      06/10/20    Added legacy uncompress option
 ********************************************************************/
include("/app/config.inc");
$angular_controller="DeviceTypeEditCtrl"; 
$title=lang('PAGE_TITLE','devicetypes');

include("/app/header.inc");

print('<script src="'.$url_prefix.'/js/devctrl.js"></script>'); 
?>
<style>
    /* GLOBAL STYLES
    -------------------------------------------------- */
table {
    font: 90%/140% Verdana,Arial,Helvetica,sans-serif;
}
    
.enabled0 td{
    background-color:#CCC!important;
    color:#333;
}
</style>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','devicetypes')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-sitemap"></i> <? print(lang('PAGE_TITLE','devicetypes')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="btn btn-primary" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','roles')) ?>
  </a>
  </li>
   <li ng-hide='settings_locked' class="nav-item">
    <a class="btn btn-primary" ng-click="doLegacy()"><i class="icon-suitcase"></i>
    <? print("LEGACY DRIVERS") ?>
  </a>
  </li>
  <li ng-hide='settings_locked' class="nav-item">
    <a class="btn btn-primary" ng-click="doAdd()"><i class="icon-plus"></i>
    <? print(lang('ADD_DEVICE','devicetypes')) ?>
  </a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  <? print(lang('HELP1','devicetypes')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<? if($_GET['legacy']) {
    chdir("/dev/");
    print("<h5>Uncompressing drivers</h5>");
    print("<pre>");
    untar("legacy_dev.tar");
    print("</pre>");
} ?>
<!-- VARIABLES -->

<div class='clearfix'></div>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('DEVICE_TYPE_LIST','devicetypes')) ?></h5>
        <p class="card-text">     
            <div ><? print(lang('FILTER','devicetypes')) ?>: <input ng-type='text' class='form-control input-small' ng-model='search'  placeholder="<? print(lang('FILTER_TEXT','devicetypes')) ?>"/>&nbsp;</div><br>

            <table class='table table-striped' summary="Device Type List">
                <tr>
                    <th scope="col"></th>
                    <th scope="col"><a href="" ng-click="predicate = 'device_type_id'; reverse=!reverse"><? print(lang('DEVICE_TYPE','devicetypes')) ?></a></th>
                    <th scope="col"><a href="" ng-click="predicate = 'name'; reverse=!reverse"><? print(lang('NAME','devicetypes')) ?></a></th>
                    <th scope="col"><a href="" ng-click="predicate = 'device_category'; reverse=!reverse"><? print(lang('CATEGORY','devicetypes')) ?></a></th>
                    <th scope="col"><? print(lang('OPTIONS','devicetypes')) ?></th>
                </tr>
                <tr ng-repeat="item in devices | filter:search | orderBy:predicate:reverse" class="enabled{{item.status}}">
                    <td></td>
                    <td><span class="badge badge-pill badge-dark">{{item.device_type_id}}<td><strong>{{item.name}}</strong></td>
                    <td><strong>{{item.device_category}}</strong></td>
                    <td><div class="pull-right btn-group">
                            <a class="btn" href="/app/devicetypeedit.cgi?device_type_id={{item.device_type_id}}">Edit</a>
                        </div>
                    </td>
                </tr>
            </table>
        </p>
	</div>
</div>

<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Warning</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>{{question}}</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><? print(lang('CANCEL','roles')) ?></button>
        <button type="button" class="btn btn-primary" ng-click="doModal()"><? print(lang('CONTINUE','roles')) ?></button>
      </div>
    </div>
  </div>
</div>

<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.factory('dataService', function($http, $q,$timeout) {
  
  this.async = function(devid) {
    return $http.get('/app/role_ajax.cgi?action=get&index='+devid)
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
        alert('Failed: ' + reason);
        $timeout(poll, 100);  // try again
    });
    
  };
  
  return this;
});



function DeviceTypeEditCtrl(dataService,$scope, $timeout,$http) {
  var self = this;
  $scope.infomsg="";
    $scope.settings_locked=settings_locked;
    if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
  
  $scope.devices=[<?
  
  $curdir=getcwd();
  $maxid=0;
 chdir("/dev/");  
 $arr=findfirst("*.ini",255-8);
 $dev_arr=array();
 while ($arr) {
    $devname=ini_get('/dev/'.$arr['filename'],'config','name');
    $devtype=ini_get('/dev/'.$arr['filename'],'config','device_type_id',0);
    $devcat=ini_get('/dev/'.$arr['filename'],'config','dev_category',0);
    if ($devcat==0) $devcatname="Inverter";
    if ($devcat==1) $devcatname="Power Meter";
    if ($devcat==2) $devcatname="Charge Controller";
    if ($devcat==3) $devcatname="Sensor";
    if ($devcat==4) $devcatname="Other";
    if ($devcat==5) $devcatname="Wattmon Master";
    
  
    if ($devtype>$maxid) $maxid=$devtype;
    if ($devtype>0) {
        print("{index:".$i.',name:"'.$devname.'",device_type_id:'.$devtype.",device_category:\"".$devcatname."\"},");
    }
    $arr=findnext();
}
      
  ?>];
 
  
  $scope.doAdd=function() {
    document.location='/app/devicetypeedit.cgi?device_type_id=<? print($maxid+1); ?>';
  }
   $scope.doLegacy=function() {
        if (confirm("Are you sure you wish to uncompress the legacy drivers?")) {
            document.location='/app/devicetypes.cgi?legacy=1';
        }
  }
  $scope.doEdit=function(item) {
    document.location='/app/devicetypeedit.cgi?device_type_id='+item.device_type_id;
  }
  
  
}
</script>
<? include("/app/footer.inc"); ?>      

