<?
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : calibvoltage.cgi
 * 
 *  Description: Voltage calibration setting page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 ********************************************************************/


include("/app/config.inc");
$angular_controller="CalibVoltageCtrl"; 
$title='Calibrate Internal Voltage';
include("/app/header.inc");

print('<script src="'.$url_prefix.'/js/calibctrl.js"></script>'); 

/**
 * linear regression function
 * @param $x array x-coords
 * @param $y array y-coords
 * @returns array() m=>slope, b=>intercept
 */
 
function array_sum($arr) {
    $res=0;
    for ($i=0;$i<sizeof($arr);$i++) {
        $res=$res+floatval($arr[$i]);
    }
    return $res;
}

function linear_regression($x, $y) {
  // calculate number points
  $n = sizeof($x);
  
  // ensure both arrays of points are the same size
  if ($n != sizeof($y)) {

    print("linear_regression(): Number of elements in coordinate arrays do not match.");
  
  }
  if ($n<2)  {
     $arr=array($_GLOBALS['v_adc_mul'],$_GLOBALS['v_adc_offset']);
    return $arr;
  }

  // calculate sums
  $x_sum=0;
  
  $x_sum = array_sum($x);
  $y_sum = array_sum($y);
  $xx_sum = 0;
  $xy_sum = 0;
  for($i = 0; $i < $n; $i++) {
    $xy_sum=$xy_sum+(floatval($x[$i])*floatval($y[$i]));
    $xx_sum=$xx_sum+(floatval($x[$i])*floatval($x[$i]));
  }
  // calculate slope
  $m = (floatval($n * $xy_sum) - floatval($x_sum * $y_sum)) / (floatval($n * $xx_sum) - floatval($x_sum * $x_sum));
  
  // calculate intercept
  $b = ($y_sum - ($m * $x_sum)) / $n;
    
  // return result
  return array($m, ($b/$m));

}
?>
      <div class="row-fluid">
        <div class='span2' >    
<? displayLeftWidgets(); ?>               
        </div>
        <?
  
?>
        <div class="span10">
        <ul class="breadcrumb">
  <li><a href="/">Home</a> <span class="divider">/</span></li>
  <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
  <li class="active">Calibrate Voltage Sensor</li>
</ul>
<h2> Calibrate Voltage Sensor</h2>
    <div class="well"> 
    <a ng-cloak class="btn pull-right" href="#" ng-click="helpvisible=!helpvisible"><div ng-show='helpvisible'><i class="icon-chevron-up"></i> Less</div><div ng-hide='helpvisible'><i class="icon-chevron-down"></i> More</div></a>
    When setting up a new device, you will need to calibrate the internal voltage sensor here.  Click More for info on how to do this.
    
    <div ng-cloak ng-show='helpvisible'>Use a variable voltage source and multimeter.  Set voltage source to lower range (i.e between 10 and 15V). Click Add.  Now increase the voltage and each time enter the multimeter reading,
    i.e 25.7, and each time click add.  Once you have a minimum of 2 points, click the Save button to write values to disk.  The more values you enter the more precise the calibration, as this uses a linear regression algorithm to find the best match.<br></div>
    </div>
    <div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{successmsg}}</div><div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{errormsg}}</div>
    <div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
    <form method="post" action="/app/calibvoltage.cgi">
<? 
//print_r($_SESSION);
$adc=$_SESSION['calibadc'];
if (($_POST['clear']=='on') ||!$adc) $adc=array();
$varr=$_SESSION['calibv'];
if (($_POST['clear']=='on') || !$varr) $varr=array();
$v=adc_read(0);

if($_POST['v']) {
    
    $varr[sizeof($varr)]=$_POST['v'];
    $adc[sizeof($adc)]=$v;
}
$_SESSION['calibadc']=$adc;
$_SESSION['calibv']=$varr;
print("<h3>Current Calibration Values</h3>");

$vals=linear_regression($adc,$varr);
if ($_POST['vcalib']) $_GLOBALS['v_adc_mul']=$_POST['vcalib'];
    if ($_POST['voffset']) $_GLOBALS['v_adc_offset']=$_POST['voffset'];
if ($_POST['action']=='Save') {
    ini_set("/config/battery.ini","battery","v_adc_mul",$vals[0]);
    ini_set("/config/battery.ini","battery","v_adc_offset",$vals[1]);
    
   
    
    print("<div ng-init="+'"'+"successmsg='Saved the calibration constant to disk.';"+'"></div>');
}
?>
<div class="row-fluid">
        <div class='span6' >
<?
print("<pre>");
if (sizeof($adc)) {
for ($i=0;$i<sizeof($adc);$i++) {
    print("<div>ADC:"+$adc[$i]+" VOLTAGE: "+$varr[$i]+"</div>");
}
} else {
    print("No calibration points defined yet. \nEnter a voltage and click add.");
}
print("</pre>");
?>
<div class="row-fluid">
        <div class='span4' >
            Enter Current Voltage </div>
        <div class='span8'><input type='text' ng-model="v"  class='span3' name='v'></div>
 </div>
 <div class="row-fluid">
        <div class='span12' >
<input type='checkbox' name='clear'> Clear saved values and add above value as a new item
    </div>
 </div>
 <input type='submit' value='Add' class='btn btn-large btn-primary' name="action">
    </div>
    <div class='span6' >
        <div class="row-fluid">
            <div class='span6' >
                Multiplier
            </div><div class='span6' >
                <input type='text' name='vcalib' value="<? print($vals[0]); ?>">
            </div>
        </div>
        <div class="row-fluid">
            <div class='span6' >
                Offset
            </div>
            <div class='span6' ><input type='text' name='voffset' value="<? print($vals[1]); ?>">
            </div>
        </div>
        <div class="row-fluid">
            <div class='span6' >
                Voltage </div>
            <div class='span6' >
                <?   $org=$v; $v=floatval($vals[0]) * ($org + floatval($vals[1])); print("V is "+$v+" and adc val is "+$org);?>
            </div>
        </div>
                
        <br><input type='submit' value='Save' class='btn btn-large btn-primary' name="action">
    </div>
</div>


 
</form>
</div><!--/span-->
      </div><!--/row-->

<? include("/app/footer.inc"); ?>
