<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : uphp.cgi
 * 
 *  Description: App settings page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *                      29/01/14    v1.1 new layout
 *						25/04/15	added role_timeout
 *						28/06/18	WattmonOS 3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="uPHPEditCtrl"; 
$title='App Settings';
include("/app/header.inc");
?>


<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('UPHP_SETTINGS','uphp')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-cog"></i>&nbsp;Wattmon App Settings</h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','uphp')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','uphp')) ?></a>
  </li>
  <li ng-hide='settings_locked' class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','uphp')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','uphp')) ?></div>
<form name="form" class="css-form form-horizontal" novalidate>
<!-- VARIABLES -->

<? 
$app = ini_get("/config/uphp.ini","debug","app",0);
?>
<form name="form" class="css-form form-horizontal" novalidate>
<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print("You will need to reboot the device for changes to take effect."); ?>';"></div>
<div ng-init="app=<? print($app); ?>;"></div>

<div class="card">
    <div class="card-body">
        <h5 class="card-title">App Settings</h5>
        <p class="card-text">    
            <div class="form-group">
                <label for="method">App connectivity support</label>
                <select ng-model="app" name='app' class="custom-select custom-select-sm">
                    <option value='0'>Disable</option>
                    <option value='1'>Enable</option>
                </select>
                <small id="langH" class="form-text text-muted">This needs to be enabled in order for the Wattmon App to connect</small>
            </div>

        </p>
    </div>
</div>
<br/>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">App Connect</h5>
        <p class="card-text">    

    <style>
        body, header {
          display: flex;
          flex-direction: column;
          justify-content: center;
          align-items: center;
        }
    </style>
    <script src=
"https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js">
    </script>
        <h4>Scan this QR Code from the Wattmon App to connect</h4>
        <br/>
        <div style='margin-left:50px' id="qrcode"></div>

    <script>
        var qrcode = new QRCode("qrcode",
        "<? 
        $stat=mqttstat();
        print(getmac()."|".ini_get("/config/user.ini","user","device","Wattmon").'|'.$stat['TOKEN3']); ?>");
    </script>
		 </p>
	</div>
</div>

<br/>
</form>

     <script>
var app = angular.module('myApp', []);         
function uPHPEditCtrl($scope,$http) {
   var self = this;
    $scope.settings_locked=settings_locked;
    if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
   
   $scope.infomsg="";
   $scope.viewLog=function () {
        window.open($scope.errorlog,'_blank');
   }
   $scope.editScript=function () {
        var path=$scope.start_script;
        var pos = path.lastIndexOf( "/" ); 
        if (pos<0) {
            var filename = path;
            var path="/";
        } else {
            var filename=path.substring( pos+1);
            path=path.substring( 0,pos+1)
        }
        alert( "path="+path+" and filename="+ filename );
        window.open("/app/edit.cgi?dir="+path+"&fn="+filename,'_blank');
   }
   
   $scope.saveSettings=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       //alert();
       //
       $http.post('/app/configsave.cgi?config=uphp.ini&section=debug',"app="+$scope.app
)
        .then(function (response) {
          var data = response.data;      
          $scope.successmsg=(data.status==1)?"Saved Settings.  You will need to reboot for the app connectivity to be enabled":"";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

}</script>
<? include("/app/footer.inc"); ?>







