<?
/**
 * @package EZDisplay
 * @author Akash Heimlich
 * @description Ajax generation script
 */
    $debug=intval($_GLOBALS['ez']['sim']);
    $num_pc_inverters=$_GLOBALS['pc_inv_cnt'];
    $num_pc_pm=$_GLOBALS['pc_pm_cnt'];
    $meter_scale=ini_get("/config/PC.ini","config","meter_scale",1);
    /*
    sim_mode 0 = solar on 100%, no zero feed
    sim mode 1 = zero export
    sim mode 2 = dg protection
    */
    $st='';
    if ($_GLOBALS['pyra_idx']) {
        $s=mb_get_dev_by_id($_GLOBALS['pyra_id']);
        $st.=',"solar_irradiation":'.$s['roleval0'];
    }    
    if ($_GLOBALS['ws_idx']) {
        $s=mb_get_dev_by_index($_GLOBALS['ws_idx']);
        $st.=',"wind_speed":'.$s['roleval0'];
    }    
    
    print('"ez":{"num_groups":'.sizeof($_GLOBALS['pc_group']).',"sim":'.$debug.',"sim_irradiation":'.$_GLOBALS['sim_irradiation'].',"sim_mode":'.intval($_GLOBALS['sim_mode']).$st.',"potential_active":'.$_GLOBALS['kW_Potential_Active'].',"inv":[');
    
    $time=time();
    $total=0;
    
    for ($i=0;$i<sizeof($_GLOBALS['ez']['inv']);$i++) {
        if ($i) print(",");
        $dev=mb_get_dev_by_id($_GLOBALS['ez']['inv'][$i]['id'],$_GLOBALS['ez']['inv'][$i]['bus']);
        
        $found=0;
        for ($j=0; $j < $num_pc_inverters; $j++) {
    	    //$inv=mb_get_dev_by_index($_GLOBALS['pc_inv'][$j]['device_idx']);
    	    $inv_id=$_GLOBALS['pc_inv'][$j]['device_id'];
    	    if (($dev['slave_id']==$inv_id) && ($_GLOBALS['ez']['inv'][$i]['bus']==$dev['params'])) {
    	        print('{"has_pc":1,"rating":'+intval($_GLOBALS['pc_inv'][$j]['rating'])+',"pc":'.intval($_GLOBALS['pc_inv'][$j]['cur_percent'])+',"group":'.intval($_GLOBALS['pc_inv'][$j]['cur_group']));
    	        $rating=$_GLOBALS['pc_inv'][$j]['rating'];
    	        $power=$_GLOBALS['pc_inv'][$j]['sim_power'];
    	        if ($_GLOBALS['pc_inv'][$j]['pf']==1 && $_GLOBALS['pc_inv'][$j]['reactive_role']>0) {
    	            print(',"reactive_power":'.$dev['roleval'.$_GLOBALS['pc_inv'][$j]['reactive_role']]);
    	        } else print(',"reactive_power":0');
    	        $found=1;
    	        break;
    	    }
        }
        if (!$found) {
            print('{"has_pc":1,"pc":100');
            $power=25000*$_GLOBALS['sim_irradiation']/1000;
        }
        if ($dev['device_type_id']==7000) { // Delta
            $dev['roleval0']=$_GLOBALS['inverter'.($i+1)."_AC_Active_Power"];
		}/* else if($dev['device_type_id']==7086) { // solaredge has a scaling
			$dev['roleval0'] = $dev['roleval0']*power(10,$dev['AC_Active_Power_SF']); // AC_Active_Power;
		
        }*/
        if ($debug) {
            $dev['last_response']=time();
            $dev['roleval0']=$power;
            $total+=$dev['roleval0'];
            
            
        }
        
        print(',"id":"'.$_GLOBALS['ez']['inv'][$i]['id'].'",');
        if (($time - $dev['last_response']) <= 60) {
            print('"status":1,');
        } else
            print('"status":0,');
            
        print('"power":'.($dev['roleval0']>0?$dev['roleval0']:0));
        print(',"pc_now":'.intval(100*$dev['roleval0']/($rating*1000)));
        
        if ($_GLOBALS['track_curtailment']) {
            $potential_kw=$_GLOBALS['kW_Potential_Active']*$rating/$_GLOBALS['pc_this_plant_size'];
            print(',"pc_potential":'.intval(100*$potential_kw/$rating));
        }
        //print_r($dev);

        print("}");
    }
    print('],"pm":[');
    if (is_array($_GLOBALS['pc_pm'])) {
        for ($i=0;$i<sizeof($_GLOBALS['pc_pm']);$i++) {
            if ($_GLOBALS['pc_pm'][$i]['device_id']>0) {
                //$dev=mb_get_dev_by_id($_GLOBALS['pc_pm'][$i]['device_id']);
				$dev=mb_get_dev_by_index($_GLOBALS['pc_pm'][$i]['device_idx']);
                
                if ($i) print(",");
                print('{"id":"'.$_GLOBALS['pc_pm'][$i]['device_id'].'","bus":"'.$dev['params'].'","group":'.$_GLOBALS['pc_pm'][$i]['group'].',');
                if ((($_GLOBALS['pc_pm'][$i]['type']>2) || $_GLOBALS['pc_pm'][$i]['active']) && (($time - $dev['last_response']) <= 60)) {
                    
                    print('"status":1,');
                    print('"power":'.($dev['roleval0']*$meter_scale).'');
                    if ($_GLOBALS['power_mode']==1) {
                        print(',"pa":'.($dev['roleval'.$_GLOBALS['pc_pm'][$i]['role_a']]));
                        print(',"pb":'.($dev['roleval'.$_GLOBALS['pc_pm'][$i]['role_b']]));
                        print(',"pc":'.($dev['roleval'.$_GLOBALS['pc_pm'][$i]['role_c']]));
                    }
                    if ($_GLOBALS['pc_pm'][$i]['reactive_role']==1)
					    print(',"reactive_power":'.($dev['roleval1']).'');
					else print(',"reactive_power":0');
                } else {
                    print('"status":0,');
                    print('"power":0');
                    if ($_GLOBALS['power_mode']==1) {
                        print(',"pa":0,"pb":0,"pc":0');
                    }
                }
               
                
                print("}");
            }
        }
    } else {
    for ($i=0;$i<sizeof($_GLOBALS['ez']['pm']);$i++) {
        $dev=mb_get_dev_by_id($_GLOBALS['ez']['pm'][$i]['id'],$_GLOBALS['ez']['pm'][$i]['bus']);
        if ($debug) {
            $found=0;
            for ($j=0; $j < $num_pc_pm; $j++) {
        	    //$inv=mb_get_dev_by_index($_GLOBALS['pc_inv'][$j]['device_idx']);
        	    $inv_id=$_GLOBALS['pc_pm'][$j]['device_id'];
        	    if ($dev['slave_id']==$inv_id) {
            
                    
                    if ($_GLOBALS['pc_pm'][$j]['sim_active']) {
                        $dev['last_response']=time();
                        $dev['roleval0']=$_GLOBALS['pc_pm'][$j]['sim_power'];//rand(0,1000);
                    }
                    else $dev['last_response']=0;
        	    }
            }
//                if ($i<3) $dev['last_response']=time();
        }
        if ($i) print(",");
        print('{"id":"'.$_GLOBALS['ez']['pm'][$i]['id'].'",');
        if (($time - $dev['last_response']) <= 60) {
            print('"status":1,');
        } else
            print('"status":0,');
        print('"power":'.($dev['roleval0']*$meter_scale).'');
       
        
        print("}");
    }
    }
    
    print(']},');
    
?>



