<?

function is_smtp_command_ok($cmd) {
    if ($cmd==200) return 1;// 	(nonstandard success response, see rfc876)
    if ($cmd==211) return 1;//211 	System status, or system help reply
    if ($cmd==214) return 1;//214 	Help message
    if ($cmd==220) return 1;//220 	<domain> Service ready
    if ($cmd==221) return 1;//221 	<domain> Service closing transmission channel
    if ($cmd==235) return 1;//235
    if ($cmd==250) return 1;//250 	Requested mail action okay, completed
    if ($cmd==251) return 1;//251 	User not local; will forward to <forward-path>
    if ($cmd==252) return 1;//252 	Cannot VRFY user, but will accept message and attempt delivery
    if ($cmd==334) return 1;//354 	Start mail input; end with <CRLF>.<CRLF>
    if ($cmd==354) return 1;//354 	Start mail input; end with <CRLF>.<CRLF>
    if ($cmd==421) return 0;//421 	<domain> Service not available, closing transmission channel
    if ($cmd==450) return 0;//450 	Requested mail action not taken: mailbox unavailable
    if ($cmd==451) return 0;//451 	Requested action aborted: local error in processing
    if ($cmd==452) return 0;//452 	Requested action not taken: insufficient system storage
    if ($cmd==500) return 0;//500 	Syntax error, command unrecognised
    if ($cmd==501) return 0;//501 	Syntax error in parameters or arguments
    if ($cmd==502) return 0;//502 	Command not implemented
    if ($cmd==503) return 0;//503 	Bad sequence of commands
    if ($cmd==504) return 0;//504 	Command parameter not implemented
    if ($cmd==521) return 0;//521 	<domain> does not accept mail (see rfc1846)
    if ($cmd==530) return 0;//530 	Access denied (???a Sendmailism)
    if ($cmd==550) return 0;//550 	Requested action not taken: mailbox unavailable
    if ($cmd==551) return 0;//551 	User not local; please try <forward-path>
    if ($cmd==552) return 0;//552 	Requested mail action aborted: exceeded storage allocation
    if ($cmd==553) return 0;//553 	Requested action not taken: mailbox name not allowed
    if ($cmd==554) return 0;//554 	Transaction failed
}

 /**
 * Connect to an SMTP and send the given message
 * @param $to - To Email Address (i.e john@doe.com)
 * @param $from - Sender Name (i.e. Jane Doe)
 * @param $message - base64 encoded message
 * @param $user - SMTP username (yourname@gmail.com)
 * @param $pass - SMTP pasword
 * @param $host - host name (ssl://smtp.gmail.com) - include ssl:// prefix for TLS/SSL
 * @param $port - SMTP port (465)
 */

function smtp_mail($to, $from, $subject,$message, $user, $pass, $host, $port)
{
    if ($h = fsockopen($host, $port)) { 
	    print("socket opened!\r\n");
	    max_execution_time(20);
	    if (substr($host,0,3)=='ssl')
	       $host=substr($host,6,strlen($host)-6);
	    print("host=".$host."\r\n");
	   
        if (!is_array($to))	{
            $main_to=$to;
        } else $main_to=$to[0];
	   
	   $message_content= "Subject: =?UTF-8?B?".base64_encode($subject)."==?=\r\n"
            ."To: <".$main_to.">\r\n"
            ."From: ".$user."\r\n"
            ."MIME-Version: 1.0\r\n"
            ."Content-Type: text/html; charset=utf-8\r\n"
            ."Content-Transfer-Encoding: base64\r\n\r\n"
            .base64_encode($message)."\r\n.";

		$data = array(
			0,
			
			"EHLO ".$host,
			'AUTH LOGIN',
			base64_encode($user),
			base64_encode($pass),
			"MAIL FROM: <".$from.">");
			
		if (!is_array($to))	{
			$data[]="RCPT TO: <".$to.">";
		} else {
		    for ($i=0;$i<sizeof($to);$i++) {
		        $data[]="RCPT TO: <".$to[$i].">";
		    }
		}
		$data[]='DATA';
		$data[]=$message_content;
		$response_code=0;
		
		for ($i=0; $i < sizeof($data); $i++) {
			$c=($data[$i]);
			
			if ($c) {
			    print("Send: ".$c."\r\n");
			    fwrite($h, $c."\r\n");
			}
			flush($h);
			$done=0;
			while (!$done) {
		        while (!filesize($h)) {
		            print(".");
		        }
		        $len=filesize($h);
		        print("\r\n".$len." bytes available.\r\n");
		 
		        $st=fread($h,$len);
		       
		        if ($st) {
		            print("RX: ".$st."\r\n");
		            $response_code=substr($st,0,3);
		            if (!is_smtp_command_ok(intval($response_code)))  {
		                fwrite($h, "QUIT\r\n");
		                fclose($h);
		                return intval($response_code);
		            }
		        }
		        $done=1;
		    }
		}
		
		fwrite($h, "QUIT\r\n");
		fclose($h);
		return $response_code;
	}
}

 /**
 * Check if an email address is valid
 * @param $email - Email address
 * @return $res - 1 for valid, 0 for invalid
 */
function is_email_valid($mail) {
    //print("MAIL=".$mail);
    if($mail != "") {
        if (!ereg("^[A-Za-z0-9|_|-]*[@]{1}[A-Za-z0-9|_|-]*[.]{1}[a-z]{2,5}$", $mail)) {
            print("wrong Input for E-Mail");
            $mail ="";
            return 0;
        } else {
            return 1;
        }
    }
} 
?>

