<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : widgetedit.cgi
 * 
 *  Description: Widget edit page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       18/12/13    v1.0
 * Akash Heimlich       21/06/18    v2.0 WattmonOS 3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="WidgetEditCtrl"; 
$title='Widget Settings';
include("/app/header.inc");
?>
<?
  
  $widget_id=$_GET['widget_idx'];
  $widget_ini='/config/widget.ini';
  $widget_section='loggedin.main';
  
  if ($_GET['new']==1) {
      $widget_id=ini_get($widget_ini,$widget_section,'num_widgets',0);
  }
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/widgets.cgi"><? print(lang('WIDGETS','widgetedit')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','widgetedit')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-group"></i> <? print(lang('PAGE_TITLE','widgetedit')) ?>  <? print(ini_get($widget_ini,$widget_section,'w'.$widget_id."_title",lang('NEW_WIDGET','widgetedit'))); ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','widgetedit')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/widgets.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','widgetedit')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','widgetedit')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  <? print(lang('HELP1','widgetedit')) ?><br>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

<!--VARIABLES-->
<div ng-init="widget_id=<? print($widget_id); ?>;"></div>
<div ng-init="widget_title='<? print(ini_get($widget_ini,$widget_section,'w'.$widget_id+"_title","New Widget")); ?>';"></div>
<div ng-init="widget_template='<? print(ini_get($widget_ini,$widget_section,'w'.$widget_id+"_template","/widget/yourwidget.inc")); ?>';"></div>
<div ng-init="widget_width=<? print(ini_get($widget_ini,$widget_section,'w'.$widget_id+"_width",4)); ?>;"></div>
<div ng-init="widget_show=<? print(ini_get($widget_ini,$widget_section,'w'.$widget_id+"_show",0)); ?>;"></div>
<div ng-init="widget_icon='<? print(ini_get($widget_ini,$widget_section,'w'.$widget_id+"_icon","icon-eye")); ?>';"></div>


<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <p class="card-text">    
            <div class="form-group">
                <label for="widget_id"><? print(lang('WIDGET_ID','widgetedit')) ?></label>
                <input class="form-control" type='number' ng-model="widget_id"  readonly="true" class='span12' name='group_id' required size='3' min="-1" max="254" integer aria-describedby="diHelp" placeholder="<? print(lang('WIDGET_ID','widgetedit')) ?>">
                <small id="diHelp" class="form-text text-muted"><? print(lang('WIDGET_ID_HELP','widgetedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.widget_id.$invalid"><? print(lang('WIDGET_ID_INVALID','widgetedit')) ?></small>
            </div>

	        <div class="form-group">
                <label for="widget_title"><? print(lang('WIDGET_TITLE','widgetedit')) ?></label>
                <input type="text" class="form-control" ng-model="widget_title"  class='span12' name='widget_title' required aria-describedby="tdnHelp" my-directive placeholder="<? print(lang('WIDGET_TITLE','widgetedit')) ?>">
                <small id="tdnHelp" class="form-text text-muted"><? print(lang('WIDGET_TITLE_HELP','widgetedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.widget_title.$invalid"><? print(lang('WIDGET_TITLE_INVALID','widgetedit')) ?></small>
            </div>

            <div class="form-group">
                <label for="widget_width"><? print(lang('WIDGET_WIDTH','widgetedit')) ?></label>
                <input class="form-control" type='number' ng-model="widget_width"  class='span12' name='widget_width' required size='3' min="1" max="12" integer aria-describedby="diHelp" placeholder="<? print(lang('WIDGET_WIDTH','widgetedit')) ?>">
                <small id="diHelp" class="form-text text-muted"><? print(lang('WIDGET_WIDTH_HELP','widgetedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.widget_width.$invalid"><? print(lang('WIDGET_WIDTH_INVALID','widgetedit')) ?></small>
            </div>
            <div class="form-group">
                <label for="widget_show"><? print(lang('VISIBILITY','widgetedit')) ?></label>
                <select ng-model="widget_show" name='widget_show' class="custom-select custom-select-sm">
		                    <option value='0'>Visible</option>
		                    <option value='1'>Invisible</option>
		                    <option value='2'>Hidden on phones</option>
		                    <option value='3'>Hidden on phones and tablets</option>
		                    <option value='4'>Hidden on desktops </option>
                  </select>
                <small id="langs" class="form-text text-muted"><? print(lang('VISIBILITY_HELP','widgetedit')) ?></small>
            </div>
            
            <div class="form-group">
                <label for="widget_template"><? print(lang('WIDGET_TEMPLATE','widgetedit')) ?></label>
                <input type="text" class="form-control" ng-model="widget_template"  class='span12' name='widget_template' required aria-describedby="tdnHelp" my-directive placeholder="<? print(lang('WIDGET_TEMPLATE','widgetedit')) ?>">
                <small id="tdnHelp" class="form-text text-muted"><? print(lang('WIDGET_TEMPLATE_HELP','widgetedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.widget_template.$invalid"><? print(lang('WIDGET_TEMPLATE_INVALID','widgetedit')) ?></small>
            </div>  
            
            <div class="form-group">
                <label for="widget_icon"><? print(lang('WIDGET_ICON','widgetedit')) ?></label>
                <input type="text" class="form-control" ng-model="widget_icon"  class='span12' name='widget_icon' required aria-describedby="tdnHelp" my-directive placeholder="<? print(lang('WIDGET_ICON','widgetedit')) ?>">
                <small id="tdnHelp" class="form-text text-muted"><? print(lang('WIDGET_ICON_HELP','widgetedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.widget_icon.$invalid"><? print(lang('WIDGET_ICON_INVALID','widgetedit')) ?></small>
                <br><i class='{{widget_icon}}'></i><br>
            </div>  
            
        </p>
    </div>
</div>		        
		      
</form>

<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);


function WidgetEditCtrl($scope, $timeout,$http) {
  var self = this;
  $scope.infomsg="";
  

  $scope.saveSettings=function () {
      $scope.successmsg="";
      $scope.errormsg="";
      $scope.infomsg="";
      widget_url='/app/widget_ajax.cgi?action=save&widget_id='+$scope.widget_id;
      widget_params="widget_title="+$scope.widget_title+"&widget_template="+$scope.widget_template+"&widget_icon="+$scope.widget_icon+"&widget_width="+$scope.widget_width+"&widget_show="+$scope.widget_show;
      
      //alert(role_params);
      //return;
      $http.post(widget_url,widget_params)
        .then(function (response) {
        //alert(response.data);
          var data = response.data;
          //alert(data);
          if (data.status)
            $scope.successmsg="Settings saved.";
            if ($scope.widget_id==-1)
                document.location='/app/widgets.cgi';
          else {
            $scope.errormsg=data.error;
          }
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
    $scope.selIcon=function(fn) {
        $scope.widget_icon=fn;
    }
}


</script>
<? include("/app/footer.inc"); ?>      
