<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : roles.cgi
 * 
 *  Description: Role management in control panel
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       18/12/13    v1.0
 * Ruchir Sharma        17/10/17    v1.1
 * Akash Heimlich       21/06/18    v2.0 WattmonOS 3
  ********************************************************************/

include("/app/config.inc");
$angular_controller="RoleCtrl"; 
$title='Roles';
include("/app/header.inc");
?>

<style>
    /* GLOBAL STYLES
    -------------------------------------------------- */
table {
    font: 90%/140% Verdana,Arial,Helvetica,sans-serif;
}
    
.enabled0 td{
    background-color:#CCC!important;
    color:#333;
}
</style>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','roles')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-sitemap"></i> <? print(lang('PAGE_TITLE','roles')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="btn btn-primary" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','roles')) ?>
  </a>
  </li>
  <li ng-hide='settings_locked' class="nav-item">
    <a class="btn btn-primary" ng-click="addRole()"><i class="icon-plus"></i>
    <? print(lang('ADD_ROLE','roles')) ?>
  </a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  <? print(lang('HELP1','roles')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

<!-- VARIABLES -->
        
<div class='clearfix'></div>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('SYSTEM_ROLES','roles')) ?></h5>
        <p class="card-text">   
            <div class="table-responsive">					
                <table class='table table-striped'>
                    <tr>
                        <th scope="col">ID</th>
                        <th scope="col"><? print(lang('ROLE_NAME','roles')) ?></th></th>
                        <th scope="col"><? print(lang('TYPE','roles')) ?></th>
                        <th scope="col"><? print(lang('GROUP','roles')) ?></th>
                        <th scope="col"><? print(lang('DEVICES','roles')) ?></th>
                        <th scope="col"><? print(lang('OPTIONS','roles')) ?></th>
                    </tr>
                    <tr ng-repeat="item in roles" ng-show='item.status!=2'>
                        <td><span class="badge badge-pill badge-dark">{{item.id}}</span></td>
                        <td><strong>{{item.name}}</strong></td>    
                        <td><strong>{{roleType(item)}}</strong></td>    
                        <td><strong>{{item.group}}</strong></td>
                        <td><strong>{{item.devices}}</strong></td>
                        <td>
                        <a ng-click='edit(item.id)' class="btn btn-outline-secondary">
                        <? print(lang('EDIT','roles')) ?>
                        
                        </a>
                        </td>
                    </tr>
                </table>
            </div>
        </p>
    </div><!--/span-->
 </div><!--/row-->

<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Warning</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>{{question}}</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><? print(lang('CANCEL','roles')) ?></button>
        <button type="button" class="btn btn-primary" ng-click="doModal()"><? print(lang('CONTINUE','roles')) ?></button>
      </div>
    </div>
  </div>
</div>

<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.factory('dataService', function($http) {
  
  this.async = function() {
    return $http.get('/app/role_ajax.cgi?action=list')
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
    });
    
  };
  
  return this;
});

function RoleCtrl(dataService, $scope, $timeout, $http) {
	var self = this;
	var pc = 100;
	$scope.scanning = 0;
	$scope.refresh = 0;
	$scope.helpvisible = 0;
	$scope.items = [];
    $scope.settings_locked=settings_locked;
    if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";

	$scope.asyncData = dataService.async();
	$scope.poll = function() {
		$scope.asyncData = dataService.async();

	};
	$scope.edit = function(idx) {
		document.location = "/app/roleedit.cgi?role_idx=" + idx;
	}

	$scope.addRole = function() {
		document.location = "/app/roleedit.cgi?new=1";
	}

	$scope.hideModal = function() {
		$('#myModal').modal('hide');
	}

	$scope.doModal = function() {

		$scope.delGroup();

	}
	$scope.roleType = function(item) {
		if (item.type == 0)
			return "<? print(lang('DIGITAL_OUTPUT','roles')) ?>";
		if (item.type == 1)
			return "<? print(lang('DIGITAL_INPUT','roles')) ?>";
		if (item.type == 2)
			return "<? print(lang('READ_ONLY','roles')) ?>";
		if (item.type == 3)
			return "<? print(lang('READ_WRITE','roles')) ?>";
		if (item.type == 4)
			return "<? print(lang('ONEWIRE','roles')) ?>";
		if (item.type == 5)
			return "<? print(lang('GLOBAL','roles')) ?>";


	}
	$scope.isDisabled = function(item) {
		if (item.status == 0) return 1;
		return 0;
	}
	$scope.isError = function(item) {
		if (item.status != 0 && item.last_response >= 2) return 1;
		return 0;
	}

	$scope.$watch('refresh', function(ref) {
		if (ref) poll();
	});
	$scope.$watch('scanning', function(ref) {
		if (ref) poll();
	});
	$scope.$watch('asyncData', function(asyncData) {
		if (angular.isDefined(asyncData)) {
			$scope.connectstatus = asyncData.loggedin ? "loggedin" : "loggedout";
			$scope.roles = asyncData.roles;

			pc = 0;
		}
	});


}

</script>    
<? include("/app/footer.inc"); ?>
