<?    
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : dev_ajax.cgi
 * 
 *  Description: Ajax used for communication of device settings
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *                      29/11/13    v1.1 - lower memory footprint using
 *                                  optimized ini_get
 ********************************************************************/

    print("{");
    /**
     * list all devices in the system in json encoded format
     * @param action list
     * @param verbose 1=output verbose details, 0=output minimal details
     */
    if ($_GET['action']=='list') {
            
            print('"loggedin": '+$_SESSION['logged_in']+',\n');
            
            /**
            * get the number of devices
            */
            $num_dev=ini_get("/config/onewire.ini","general","num_devices",0);
            print('"count":'+$num_dev+",\n");

            print('"devices": [');
            
            /**
            * iterate through all devices and output json encoded device information
            */            
            for ($i=0;$i<$num_dev;$i++) {
                print('{');
                
                $device_type_id=ini_get("/config/onewire.ini","Device".$i,"device_type_id",0);
                
                /**
                * load device config file into array $info
                */
                $info=0;
                $dev_ini="/dev/onewire/dev"+$device_type_id+".ini";
                //$info=ini_get_array("/dev/dev"+$dev['device_type_id']+".ini","config");
                
                {
                    /**
                    * id of modbus or wireless device
                    */
                    print('"id": "'+ini_get("/config/onewire.ini","Device".$i,"address")+'",\n');
                    /**
                    * type id of modbus or wireless device
                    */
                    print('"type_id": "'+$device_type_id+'",\n');
                    /**
                    * device name
                    */
                    print('"name": "'+ini_get("/config/onewire.ini","Device".$i,"name")+'",\n');
                    /**
                    * description of device
                    */
                    print('"description": "'+ini_get($dev_ini,"config","name","")+'",\n');
                    /**
                    * status of device (1=active, 0= disables)
                    */
                    print('"status": "'+ini_get("/config/onewire.ini","Device".$i,'status',0)+'",\n');

                    $nroles=intval(ini_get($dev_ini,"config","num_roles",0));
                    print('"num_roles": '+$nroles+',\n');
                    print('"roles":[');
                    /**
                    * iterate through the different roles this device handles
                    */                    
                    for ($c=0;$c<$nroles;$c++) {
                        print('{"var":"'+ini_get($dev_ini,"config",'role_var_'+$c)+'", "idx": '+ini_get($dev_ini,"config",'role_idx_'+$c)+',"type":'+ini_get($dev_ini,"config",'role_type_'+$c));
                        $role_id=ini_get("/config/onewire.ini","Device".$i,"role"+$c+"_id");
                        print(',"role_id":'+$role_id);
                        
                        print(',"desc":"'+ini_get($dev_ini,"config","role_desc_"+$c)+'",');    

                        print('"role": "'+ini_get("/config/roles.ini","roles",'role'+$role_id)+'"}\n');
                        if ($c<($nroles-1)) print(", ");

                    }
                    print("]");
                }
                print('}');
                if ($i<($num_dev-1)) print(",");
            }
            print(']');
        } else {
            /**
             * scan start command
             * @param max - maximum ID to scan until
             * @param bus - bus ID to scan (0=wired, 1= wireless)
             */            
            if ($_GET['action']=='scan') {
                $dev=array();
                $arr=ow_first();
                $cnt=0;
                if ($arr) {
                    //print_r($arr);
                    $dev[0]=$arr;
                    $cnt++;
                    while ($arr=ow_next()) {
                        //print_r($arr);
                        $dev[$cnt]=$arr;
                        $cnt++;
                    }
                }
                //print("Found a total of "+$cnt+" devices!\r\n");
                
                for ($i=0;$i<sizeof($dev);$i++) {
                    $devname=sprintf("%02X%02X%02X%02X%02X%02X%02X%02X",$dev[$i][0],$dev[$i][1],$dev[$i][2],$dev[$i][3],$dev[$i][4],$dev[$i][5],$dev[$i][6],$dev[$i][7]);
                    $nbdev=ini_get("/config/onewire.ini","general","num_devices",0);
                    $found=0;
                    $idx=0;
                    for ($j=0;$j<$nbdev;$j++) {
                        $tmpname=ini_get("/config/onewire.ini","Device".$j,"address","");
                        if ($tmpname==$devname) {
                            $found=1;
                            $idx=$j;
                        }
                    }
                    if (!$found) {
                        $_GLOBALS['need_reboot']=1;
                        ini_set("/config/onewire.ini","Device".$nbdev,"address",$devname);
                        ini_set("/config/onewire.ini","Device".$nbdev,"name","onewire".$nbdev);
                        ini_set("/config/onewire.ini","Device".$nbdev,"device_type_id",$dev[$i][0]);
                        ini_set("/config/onewire.ini","Device".$nbdev,"status",1);
                        ini_set("/config/onewire.ini","Device".$nbdev,"poll_interval",300);
                        $nbdev++;
                        ini_set("/config/onewire.ini","general","num_devices",$nbdev);
                        
                        $_GLOBALS['needreboot']=1;
                    } else {
                        ini_set("/config/onewire.ini","Device".$idx,"status",1); // re-enable it
                       // print("Re-activing device ".$idx);
                    }
                }
                if (!$_GLOBALS['needreboot']) {
                    print('"status":1');
                } else
                    print('"status":1,"sysmsg":"You will need to reboot the device for changes to take effect!"');
            }
            
            /**
             * update device status command
             * @param id - device ID
             * @param status - active=1, inactive=0
             */            
            if ($_GET['action']=='update') {
                $id=intval($_GET['id']);
                $errors=0;
                if ($id>=0) {                    
                    ini_set("/config/onewire.ini","Device".$id,"status",$_GET['status']);
                    if (!$errors) {
                        print('"status":1');
                    }
                } else {
                    print('"status":0');
                }
            }
            
            /**
            * delete device command
            @param device_idx - index of device to delete (NOT device ID)
            */
            if ($_GET['action']=='delete') {
                $device_idx=intval($_GET['device_idx']);
                //$arr = mb_get_dev_by_index($_GET['device_idx']);
                $errors=0;
                $status=ini_get("/config/onewire.ini","Device".$device_idx,"status",0);
                if (($status<2)) {                    
                    ini_set("/config/onewire.ini","Device".$device_idx,"status",2);
                    print('"status":1');                
                } else {
                    print('"status":0');
                }
            }
            
            /**
            * save settings command.  Parameters are posted via ajax
            * @param device_idx - index of device (NOT device id)
            * @param slave_id - POST - device id
            * @param poll_interval - POST - poll interval in milliseconds
            * @param status - POST - device status
            * @param device_name - POST - device name
            */
            if ($_GET['action']=='save') {
                $id=intval($_GET['id']);
                $error="";
                $device_idx=$_GET['device_idx'];
                
                if (ini_get("/config/onewire.ini","Device".$device_idx,"address","") != $_POST['address']) { 
                    if (strlen($_POST['address'])!=16) {
                        $error = $error+"Unable to set address-make sure it is 16 digits! ";
                    } else {
                        ini_set("/config/onewire.ini","Device".$device_idx,"address",$_POST['address']);
                    }
                }
                if (intval($_POST['poll_interval']) != ini_get("/config/onewire.ini","Device".$device_idx,'poll_interval',0)) {
                     ini_set("/config/onewire.ini","Device".$device_idx,"poll_interval",$_POST['poll_interval']);
                }
                $device_type_id=ini_get("/config/onewire.ini","Device".$device_idx,"device_type_id",0);
                $info=ini_get_array("/dev/onewire/dev"+$device_type_id+".ini","config");
                for ($r=0;$r<$info['num_roles'];$r++) {
                    if ($_POST['role'+$r] != $arr['role'+$r]) {
                         ini_set("/config/onewire.ini","Device".$device_idx,"role"+$r+"_id",$_POST['role'+$r]);
                       
                    }    
                }
                if ($_POST['status'] != ini_get("/config/onewire.ini","Device".$device_idx,'status')) {
                   ini_set("/config/onewire.ini","Device".$device_idx,"status",$_POST['status']);
                }
                if ($_POST['device_name'] != ini_get("/config/onewire.ini","Device".$device_idx,'name')) {
                    if (strlen($_POST['device_name'])>2) {
                       ini_set("/config/onewire.ini","Device".$device_idx,"name",$_POST['device_name']); 
                    } else {
                        $error = $error+"Device name too short. ";
                    }
                }
                
                if ($error!="") {
                    
                    print('"status":0, "error":"'+$error+'"');
                } else {
                    print('"status":1,"sysmsg":"You will need to reboot the device for changes to take effect!"');
                    $_GLOBALS['needreboot']=1;
                    //print('"status":1');
                }
            }
        }
    ?>
}       
