<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : modbustest.cgi
 * 
 *  Description: Modbus tester
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Ruchir Sharma        17/10/17    v1.1
 ********************************************************************/
 include("/app/config.inc");
$angular_controller="UserEditCtrl"; 
$title='Modbus Tester';
$mb_tcp_connected=0;
include("/app/header.inc");
?>
<style type='text/css'>
.legend .row:nth-of-type(odd) div {
background-color:#EEEEEE;
}
.legend .row:nth-of-type(even) div {
background: #FFFFFF;
}
</style>
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/devices.cgi"><? print(lang('MODBUS_DEVICES','modbustest')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('MODBUS_TITLE','modbustest')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-cog"></i> <? print(lang('MODBUS_TITLE','modbustest')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/devices.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','modbustest')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="run()" ><i class="icon-check"></i> <? print(lang('APPLY','modbustest')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','modbustest')) ?>
    <? print(lang('HELP2','modbustest')) ?>
    <? print(lang('HELP3','modbustest')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<!-- VARIABLES -->
<? 
      $baud=ini_get("/config/device.ini","general","baud",9600);
      $parity=ini_get("/config/device.ini","general","parity",0);
      $id=1;
?>
<div ng-init="baud=<? print($baud); ?>;"></div><div ng-init="parity='<? print($parity); ?>';"></div>
<div ng-init="id=<? print($id); ?>;"></div>
<div ng-init="bus=0;"></div>
<div ng-init="value=0;"></div>
<div ng-init="register=1;"></div>
<div ng-init="count=1;"></div>
<div ng-init="type=1;"></div>
<div ng-init="func=3;"></div>

<div class="card-deck">
    <div class="card">
        <div class="card-body">
            <h5 class="card-title"><? print(lang('MODBUS_SUBTITLE','modbustest')) ?></h5>
            <p class="card-text"> 
<?             
if (function_exists("getmbstat")) {
    $arr=getmbstat();
    $mb_tcp_enabled=$arr['TCP_ENABLED'];
    $mb_tcp_connected=$arr['TCP_STATE']==2;
}
$has_dual_rs485 = ($_SERVER['HW_PLATFORM']>=20 || $_SERVER['HW_PLATFORM']==11);
if ($mb_tcp_enabled || $has_dual_rs485) { ?>
            <div class="form-group">
                <label for="bus"><? print(lang('BUS','modbustest')) ?></label>
                <select ng-model="bus" required name='bus' class="form-control">
                    <option value='0'>Modbus RTU (RS-485)</option>
<? 			        
      $is_mega = $_SERVER['HW_PLATFORM']>=8;
      
      if (($_SERVER['HW_PLATFORM']==11)|| ($_SERVER['HW_PLATFORM']>=20)) {
          print("<option value='1'>Modbus RTU 2 (RS-485)</option>");
      }
      $modbus_tcp_port=array();
      $modbus_tcp_ip_address=array();
      // single modbus TCP for non-mega
      if (!$is_mega) {
            $max_tcp=1;
            $modbus_tcp_port[0]=ini_get("/config/device.ini","general","modbus_tcp_port",502);
            $modbus_tcp_ip_address[0]=ini_get("/config/device.ini","general","modbus_tcp_ip_address","0.0.0.0");
      } else {
            $max_tcp = intval($arr['TCP_COUNT']);
            for ($i=0;$i<$max_tcp;$i++) {
                $modbus_tcp_port[$i]=ini_get("/config/device.ini","general","modbus_tcp_port".$i,502);
                $modbus_tcp_ip_address[$i]=ini_get("/config/device.ini","general","modbus_tcp_ip_address".$i,"0.0.0.0");
            }
          
      }
      if ($mb_tcp_enabled) {
          for ($i=0;$i<$max_tcp;$i++) {
              print("<option value='"+(2+$i)+"'>TCP Channel "+(1+$i)." - ".$modbus_tcp_ip_address[$i].":".$modbus_tcp_port[$i].($arr['TCP_STATE'.$i]==2?" - CONNECTED":"")."</option>");
              //if ($mb_tcp_connected) print("- CONNECTED"); ?>);
          }
      }
?>
                </select>
            </div>
<? } ?>


            <div class="form-group" ng-show='bus<2'>
                <label for="baud"><? print(lang('BAUD','modbustest')) ?></label>
                <input class="form-control" type='number' ng-model="baud"  class='span12' name='baud' required min="1200" max="115200" integer aria-describedby="bHelp" placeholder="<? print(lang('BAUD','modbustest')) ?>">
                <small id="bHelp" class="form-text text-muted"><? print(lang('BAUD_HELP','modbustest')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.baud.$invalid"><? print(lang('BAUD_INVALID','modbustest')) ?></small>
            </div>
            
            <div class="form-group" ng-show='bus<2'>
                <label for="parity"><small class='text-muted'><? print(lang('PARITY','modbustest')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="parity" id="parity0" value="0">
                  <label class="form-check-label" for="parity0">
                    &nbsp;<? print(lang('PARITY_NONE','modbustest')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="parity" id="parity1" value="1">
                  <label class="form-check-label" for="parity1">
                    &nbsp;<? print(lang('PARITY_EVEN','modbustest')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="parity" id="parity2" value="2">
                  <label class="form-check-label" for="parity2">
                    &nbsp;<? print(lang('PARITY_ODD','modbustest')) ?>
                  </label>
                </div>  
                
                <small id="pHelp" class="form-text text-muted"><? print(lang('PARITY_HELP','modbustest')) ?></small>
            </div>

            <div class="form-group">
                <label for="register"><? print(lang('START_REG','modbustest')) ?></label>
                <input class="form-control" type='number' ng-model="register"  class='span12' name='register' required min="0" max="65535" integer aria-describedby="rHelp" placeholder="<? print(lang('START_REG','modbustest')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('START_REG_HELP','modbustest')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.register.$invalid"><? print(lang('START_REG_INVALID','modbustest')) ?></small>
            </div>
            <div class="form-group" ng-show='func<6'>
                <label for="count"><? print(lang('NUM_REG','modbustest')) ?></label>
                <input class="form-control" type='number' ng-model="count"  class='span12' name='count' required min="1" max="128" integer aria-describedby="cHelp" placeholder="<? print(lang('NUM_REG','modbustest')) ?>">
                <small id="cHelp" class="form-text text-muted"><? print(lang('NUM_REG_HELP','modbustest')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.count.$invalid"><? print(lang('NUM_REG_INVALID','modbustest')) ?></small>
            </div>
            <div class="form-group">
                <label for="id"><? print(lang('DEVICE_ID','modbustest')) ?></label>
                <input class="form-control" type='number' ng-model="id"  class='span12' name='id' required min="1" max="255" integer aria-describedby="idHelp" placeholder="<? print(lang('DEVICE_ID','modbustest')) ?>">
                <small id="idHelp" class="form-text text-muted"><? print(lang('DEVICE_ID_HELP','modbustest')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.id.$invalid"><? print(lang('DEVICE_ID_INVALID','modbustest')) ?></small>
            </div>
	
		    <div class="form-group">
                <label for="bus"><? print(lang('FUNC','modbustest')) ?></label>
                <select ng-model="func" required name='func' class="form-control">
                    <option value="1">01 - Read Coil Status</option>
                    <option value="2">02 - Read Digital Input Status</option>
                    <option value="3">03 - Read Holding Registers</option>
                    <option value="4">04 - Read Input Registers</option>
                    <option value="6">06 - Write Single Register</option>
                    <option value="16">16 - Write Multiple Register</option>
           
                 </select>
                <small id="fHelp" class="form-text text-muted"><? print(lang('FUNC_HELP','modbustest')) ?></small>
		    </div>
		     <div class="form-group" ng-show='func>=6'>
                <label for="value"><? print(lang('VALUE_REG','modbustest')) ?></label>
                <input class="form-control" type='number' ng-model="value"  class='span12' name='value' required integer aria-describedby="vHelp" placeholder="<? print(lang('VALUE_REG_REG','modbustest')) ?>">
                <small id="vHelp" class="form-text text-muted"><? print(lang('VALUE_REG_HELP','modbustest')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.value.$invalid"><? print(lang('VALUE_REG_INVALID','modbustest')) ?></small>
            </div>
            
	        <div class="form-group" ng-show='func<6'>
                <label for="type"><? print(lang('DATA_TYPE','modbustest')) ?></label>
                <select ng-model="type" required name='type' class="form-control">
                    <option value="0">No processing</option>
                    <option value="1">Signed 16-bit</option>
                    <option value="2">Unsigned 16-bit</option>
                    <option value="3">Signed 32-bit int (Big endian)</option>
                    <option value="4">Signed 32-bit int (Little endian)</option>
                    <option value="5">Unsigned 32-bit int (Big endian)</option>
                    <option value="6">Unsigned 32-bit int (Little endian)</option>
                    <option value="7">Float (Big endian)</option>
                    <option value="8">Float (Little endian)</option>
                    <option value="9">Float 64 (Big endian)</option>
                    <option value="10">Float 64 (Little endian)</option>
                    <option value="11">Unsigned 64-bit int (Big endian)</option>
                    <option value="12">Unsigned 64-bit int (Little endian)</option>
                    
                    
                </select>
                <small id="tfHelp" class="form-text text-muted"><? print(lang('DATA_TYPE_HELP','modbustest')) ?></small>
            </div>
            </p>
        </div>        
    </div>
    <div class="card">
        <div class="card-body">
            <h5 class="card-title"><? print(lang('RESULTS_TITLE','modbustest')) ?> <div class='pull-right' ng-cloak ng-show='loading==1'><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i></div></h5>
            <p class="card-text"> 
		        
		        <span style='size:1.2em' ng-bind-html-unsafe="resultarea"></span>
            </p>		    
		</div>
	</div>
</div>
		
</form>

<script>
var app = angular.module('myApp', []);

app.controller('UserEditCtrl', function UserEditCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";
   $scope.run=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       if ($scope.baud < 300) {
            $scope.errormsg="Invalid baud rate";
            return;
       }
       $scope.loading=1;
       $scope.resultarea="<b>Loading...</b>";
       $http.post('/app/modbus_ajax.cgi','baud='+$scope.baud+"&parity="+$scope.parity+"&register="+$scope.register+"&count="+$scope.count+"&func="+$scope.func+"&start="+$scope.id+"&end="+($scope.id+1)+"&vtype="+$scope.type+"&bus="+$scope.bus+"&value="+$scope.value)
        .then(function (response) {
          var data = response.data; 
          $scope.result=response.data;
          var st="TX: <pre class='text-uppercase'>";
          console.log($scope.result.tx.length);
          for (i=0;i<$scope.result.tx.length;i++) {
            var v=("00" + (Number($scope.result.tx[i])).toString(16)).substr(-2);
            var txtclass='badge-dark';
            if (i==0) txtclass='badge-secondary';
            if (i==1) txtclass='badge-warning';
            if ((i==2) ||(i==3)) txtclass='badge-success';
            
            st=st+"<span class='badge "+txtclass+"'>"+v+"</span> ";
          }
          st=st+"</pre><p>";
          if ($scope.result.result==1) {
            //$scope.resultarea=.toString();
            st=st+"<span class='text-success'><i class='icon icon-check'></i> Reply received in "+$scope.result.time+"ms</span><p/>RX: <pre class='text-uppercase' >";
            for (i=0;i<$scope.result.rx.length;i++) {
                var v=("00" + (Number($scope.result.rx[i])).toString(16)).substr(-2);
                var txtclass='badge-dark';
                if (i==0) txtclass='badge-secondary';
                if (i==1) txtclass='badge-warning';
                if (i==2) txtclass='badge-success';
                if (i >= $scope.result.rx.length-2) 
                    txtclass='badge-primary';
                st=st+"<span class='badge "+txtclass+"'>"+v+"</span> ";
            }
            st=st+"</pre><p>";
            if (($scope.result.rx[1] & 0x80)==0) {
                st=st+"<h5>Registers</h5><div class='legend'>";
                st=st+"<div class='row row-fluid font-weight-bold'><div class='col-md-4'>Register (Hex)</div><div class='col-md-4'>Register (Dec)</div><div class='col-md-4 text-right'>Value</div></div>";
                for (i=0;i<$scope.result.registers.length;i++) {
                    var v=("0000" + (Number($scope.result.registers[i].reg)).toString(16)).substr(-4);
                    var txtclass='text-dark';
                    
                    st=st+"<div class='row row-fluid text-uppercase'><div class='col-md-4'>"+v+"</div><div class='col-md-4'>"+$scope.result.registers[i].reg+"</div><div class='col-md-4 text-right'>"+$scope.result.registers[i].val+"</div></div>";
                }
                st=st+"</div><p>";
            } else {
                st=st+"<h4 class='text-danger'>Device returned a Modbus exception.</h4>";
            }
            
          } else {
            st=st+"<h4 class='text-danger'>No response from device in "+$scope.result.time+"ms.</h4>";
            
          }
          $scope.resultarea=st;
          $scope.loading=0;
          return data;
        }, function(reason) {
            $scope.errormsg="Error running";
            $scope.successmsg="";
            $scope.resultarea="Failled";
            $scope.loading=0;
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

});
</script>
<? include("/app/footer.inc"); ?>

